<?php


use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Digipluskaveh extends Widget_Base
{

    public function get_name()
    {
        return 'digipluskaveh';
    }

    public function get_title()
    {
        return esc_html__('المان دیجی پلاس', 'kaveh-core');
    }

    public function get_icon()
    {
        return 'eicon-archive-posts';
    }

    public function get_categories()
    {
        return ['kavehelements'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'contentdigipluskaveh',
            [
                'label' => esc_html__('محتوای عنوان', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'titledigipluskaveh',
            [
                'label' => esc_html__('عنوان اصلی', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('خدمات ویژه برای اعضای دیجی‌پلاس', 'kaveh-core'),

            ]
        );
        $this->add_control(
            'tagheadingdigipluskaveh',
            [
                'label' => esc_html__('تگ عنوان اصلی', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'H3',
                'options' => [
                    'H1' => esc_html__('H1', 'kaveh-core'),
                    'H2' => esc_html__('H2', 'kaveh-core'),
                    'H3' => esc_html__('H3', 'kaveh-core'),
                    'H4' => esc_html__('H4', 'kaveh-core'),
                    'H5' => esc_html__('H5', 'kaveh-core'),
                    'H6' => esc_html__('H6', 'kaveh-core'),
                    'p' => esc_html__('p', 'kaveh-core'),
                    'div' => esc_html__('div', 'kaveh-core'),
                    'span' => esc_html__('span', 'kaveh-core'),
                ],
            ]
        );

        $this->add_control(
            'titleboxproductdigipluskaveh',
            [
                'label' => esc_html__('عنوان باکس محصولات', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__(' ارسال فوری رایگان', 'kaveh-core'),

            ]
        );
        $this->add_control(
            'tagheadingboxproductdigipluskaveh',
            [
                'label' => esc_html__('تگ عنوان باکس محصولات', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'H3',
                'options' => [
                    'H1' => esc_html__('H1', 'kaveh-core'),
                    'H2' => esc_html__('H2', 'kaveh-core'),
                    'H3' => esc_html__('H3', 'kaveh-core'),
                    'H4' => esc_html__('H4', 'kaveh-core'),
                    'H5' => esc_html__('H5', 'kaveh-core'),
                    'H6' => esc_html__('H6', 'kaveh-core'),
                    'p' => esc_html__('p', 'kaveh-core'),
                    'div' => esc_html__('div', 'kaveh-core'),
                    'span' => esc_html__('span', 'kaveh-core'),
                ],
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'content2digipluskaveh',
            [
                'label' => esc_html__('تنظیمات محصولات', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'displayproductsdigipluskaveh',
            [
                'label' => esc_html__('نمایش محصولات', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'custom',
                'options' => [
                    'custom' => esc_html__('حالت سفاشی', 'kaveh-core'),
                    'cat' => esc_html__('حالت دسته بندی', 'kaveh-core'),

                ],
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'imgproductdigipluskaveh',
            [
                'label' => esc_html__('تصویر محصول', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
            'linkproductdigipluskaveh',
            [
                'label' => esc_html__('لینک محصول', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('#', 'kaveh-core'),

            ]
        );
        $this->add_control(
            'listproductdigipluskaveh',
            [
                'label' => esc_html__('محصولات', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'condition' => [
                    'displayproductsdigipluskaveh' => 'custom',
                ],
                'default' => [
                    [
                        'linkproductdigipluskaveh' => esc_html__('#', 'kaveh-core'),
                    ],
                ]
            ]

        );

        $options2 = array();
        $orderby = 'name';
        $order = 'asc';
        $hide_empty = true;
        $cat_args = array(
            'orderby' => $orderby,
            'order' => $order,
            'hide_empty' => $hide_empty,
        );

        $product_categories = get_terms('product_cat', $cat_args);

        foreach ($product_categories as $key => $category) {
            $options2[$category->term_id] = $category->name;
        }
        $this->add_control(
            'catproductsdigipluskaveh',
            [
                'label' => esc_html__('انتخاب دسته بندی', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $options2,
                'condition' => [
                    'displayproductsdigipluskaveh' => 'cat',
                ],
            ]
        );
        $this->add_control(
            'numberproductsdigipluskaveh',
            [
                'label' => esc_html__('تعداد محصولات نمایش داده شده', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 20,
                'step' => 1,
                'default' => 12,
                'condition' => [
                    'displayproductsdigipluskaveh' => 'cat',
                ],
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'content3digipluskaveh',
            [
                'label' => esc_html__('دکمه ها', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'buttondigipluskaveh',
            [
                'label' => esc_html__('عنوان دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('عضویت', 'kaveh-core'),
            ]
        );
        $this->add_control(
            'iconbuttondigipluskaveh',
            [
                'label' => esc_html__('آیکون', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'skin' => 'inline',
                'exclude_inline_options' => ['svg'],
                'default' => [
                    'value' => 'fas fa-arrow-left',
                ],
            ]
        );
        $this->add_control(
            'buttonlinkdigipluskaveh',
            [
                'label' => esc_html__('لینک دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('#', 'kaveh-core'),

            ]
        );

        $this->add_control(
            'buttonseealldigipluskaveh',
            [
                'label' => esc_html__('عنوان دکمه مشاهده بیشتر', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('مشاهده همه', 'kaveh-core'),
            ]
        );
        $this->add_control(
            'iconbuttonseealldigipluskaveh',
            [
                'label' => esc_html__('آیکون دکمه مشاهده بیشتر', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'skin' => 'inline',
                'exclude_inline_options' => ['svg'],
                'default' => [
                    'value' => 'fas fa-arrow-left',
                ],
            ]
        );
        $this->add_control(
            'buttonlinkseealldigipluskaveh',
            [
                'label' => esc_html__('لینک دکمه مشاهده بیشتر', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('#', 'kaveh-core'),

            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'content4digipluskaveh',
            [
                'label' => esc_html__('تصویر', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'imgtoptitledigipluskaveh',
            [
                'label' => esc_html__('تصویر بالای عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'bgunderbuttondigipluskaveh',
            [
                'label' => esc_html__('تصویر پایین دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'selectors' => [
                    '{{WRAPPER}} .send-instantaneous-right' =>
                        'background-image: url({{URL}})',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_digipluskaveh',
            [
                'label' => esc_html__('استایل عناوین', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'textcolor1digipluskaveh',
            [
                'label' => esc_html__('رنگ عنوان اصلی', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .send-instantaneous-right .sub-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_digipluskaveh',
                'label' => esc_html__('تایپوگرافی عنوان اصلی', 'kaveh-core'),
                'selector' => '{{WRAPPER}} .send-instantaneous-right .sub-title',
            ]
        );

        $this->add_control(
            'textcolor2digipluskaveh',
            [
                'label' => esc_html__('رنگ عنوان باکس محصولات', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .send-instantaneous-left .title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title2_digipluskaveh',
                'label' => esc_html__('تایپوگرافی عنوان باکس محصولات', 'kaveh-core'),
                'selector' => '{{WRAPPER}} .send-instantaneous-left .title',
            ]
        );

        $this->add_control(
            'iconcolordigipluskaveh',
            [
                'label' => esc_html__('رنگ آیکون کنار عنوان باکس محصولات', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .send-instantaneous-left .title svg' => 'fill: {{VALUE}} !important',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style2_digipluskaveh',
            [
                'label' => esc_html__('استایل دکمه اول', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'button1_digipluskaveh',
                'label' => esc_html__('تایپوگرافی متن دکمه', 'kaveh-core'),
                'selector' => '{{WRAPPER}} .send-instantaneous-right .btn',
            ]
        );
        $this->add_control(
            'iconsizebutton1digipluskaveh',
            [
                'label' => esc_html__('سایز آیکون', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'selectors' => [
                    '{{WRAPPER}} .send-instantaneous-right .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'textbutton1colordigipluskaveh',
            [
                'label' => esc_html__('رنگ نوشته دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .send-instantaneous-right .btn' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'iconbutton1colordigipluskaveh',
            [
                'label' => esc_html__('رنگ آیکون', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .send-instantaneous-right .btn i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button1colordigipluskaveh',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .send-instantaneous-right .btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'button1radiusdigipluskaveh',
            [
                'label' => esc_html__('گوشه خمیده دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .send-instantaneous-right .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border1digipluskaveh',
                'label' => esc_html__('حاشیه', 'kaveh-core'),
                'selector' => '{{WRAPPER}} .send-instantaneous-right .btn',
            ]
        );

        $this->add_control(
            'button1paddingdigipluskaveh',
            [
                'label' => esc_html__('فاصله داخلی', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .send-instantaneous-right .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'style3_digipluskaveh',
            [
                'label' => esc_html__('استایل دکمه مشاهده بیشتر', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'button2_digipluskaveh',
                'label' => esc_html__('تایپوگرافی متن دکمه', 'kaveh-core'),
                'selector' => '{{WRAPPER}} .send-instantaneous-left .link-more',
            ]
        );
        $this->add_control(
            'iconsizebutton2digipluskaveh',
            [
                'label' => esc_html__('سایز آیکون', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 2000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'selectors' => [
                    '{{WRAPPER}} .send-instantaneous-left .link-more i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'textbutton2colordigipluskaveh',
            [
                'label' => esc_html__('رنگ نوشته دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .send-instantaneous-left .link-more' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'iconbutton2colordigipluskaveh',
            [
                'label' => esc_html__('رنگ آیکون', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .send-instantaneous-left .link-more i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style4_digipluskaveh',
            [
                'label' => esc_html__('استایل تصویر بالای عنوان', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'imagewidthdigipluskaveh',
            [
                'label' => esc_html__('عرض تصویر', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 2000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 100,
                ],
                'selectors' => [
                    '{{WRAPPER}} .send-instantaneous-right img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'imageheightdigipluskaveh',
            [
                'label' => esc_html__('ارتفاع تصویر', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 2000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .send-instantaneous-right img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'style4_boxdigipluskaveh',
            [
                'label' => esc_html__('استایل باکس اصلی', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'bgcolordigipluskaveh',
            [
                'label' => esc_html__('رنگ پس زمینه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .send-instantaneous-wrapper' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'boxbgradiusdigipluskaveh',
            [
                'label' => esc_html__('گوشه خمیده', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .send-instantaneous-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'style5_boxproductdigipluskaveh',
            [
                'label' => esc_html__('استایل باکس محصولات', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'bgcolorboxproductdigipluskaveh',
            [
                'label' => esc_html__('رنگ پس زمینه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .send-instantaneous-left' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'boxproductradiusdigipluskaveh',
            [
                'label' => esc_html__('گوشه خمیده', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .send-instantaneous-left' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $clsid = $this->get_id();
        ?>


        <!-- Start Digiplus -->
        <section class="send-instantaneous"">
        <div class="container">
            <div class="send-instantaneous-wrapper d-flex p-3 flex-column flex-lg-row">
                <div class="send-instantaneous-right w-100 pt-3 pt-lg-4 pr-4 mb-4 mb-lg-0">
                    <a href="<?php echo esc_url($settings['buttonlinkdigipluskaveh']); ?>" class="d-block">
                        <img src="<?php echo esc_url($settings['imgtoptitledigipluskaveh']['url']); ?>"
                             alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt($settings['imgtoptitledigipluskaveh'])); ?>">
                    </a>
                    <<?php echo esc_attr($settings['tagheadingdigipluskaveh']); ?> class="sub-title
                    mt-1"><?php echo esc_html($settings['titledigipluskaveh']); ?>
                </<?php echo esc_attr($settings['tagheadingdigipluskaveh']); ?>>
                <a href="<?php echo esc_url($settings['buttonlinkdigipluskaveh']); ?>"
                   class="btn d-flex align-items-center justify-content-center">
                    <?php echo esc_html($settings['buttondigipluskaveh']); ?>
                    <i class="<?php echo esc_attr($settings['iconbuttondigipluskaveh']['value']); ?> ms-1"></i>
                </a>
            </div>
            <div class="send-instantaneous-left w-100 pt-3 px-3">
                <div class="d-flex align-items-center justify-content-between mb-3">
                    <<?php echo esc_attr($settings['tagheadingboxproductdigipluskaveh']); ?> class="title mb-0">
                    <svg class="me-2">
                        <path fill-rule="evenodd"
                              d="M11.539 1.083l.224-.054a1 1 0 01.452-.006A6.098 6.098 0 0117 6.98v2.486l2.555 1.703a1 1 0 01.394.516l2 6a1 1 0 01-1.145 1.297L15.9 18H8.099l-4.903.98a1 1 0 01-1.145-1.296l2-6a1 1 0 01.394-.516L7 9.465V6.979a6.104 6.104 0 014.539-5.896zM7 11.868v4.312l-2.507.501 1.346-4.039L7 11.868zM15 10v6H9V6.979a4.099 4.099 0 012.839-3.9L12 3.03l.178.054A4.099 4.099 0 0115 6.98V10zm2 6.18l2.506.501-1.346-4.039-1.16-.773v4.311zM10 9a2 2 0 114 0 2 2 0 01-4 0zm0 13v-3H8v3h2zm6-3v3h-2v-3h2zm-3 4v-4h-2v4h2z"
                              clip-rule="evenodd"></path>
                    </svg>
                    <?php echo esc_html($settings['titleboxproductdigipluskaveh']); ?>
                </<?php echo esc_attr($settings['tagheadingboxproductdigipluskaveh']); ?>>
                <a href="<?php echo esc_url($settings['buttonlinkseealldigipluskaveh']); ?>"
                   class="link-more d-flex align-items-center ">
                    <?php echo esc_html($settings['buttonseealldigipluskaveh']); ?>
                    <i class="<?php echo esc_attr($settings['iconbuttonseealldigipluskaveh']['value']); ?> ms-1"></i>
                </a>
            </div>
            <ul class="send-instantaneous-items d-flex align-items-center flex-wrap">
                <?php if ('cat' === $settings['displayproductsdigipluskaveh']) : ?>
                    <?php

                    // WP_Query args
                    $cat_query_args = array(
                        'post_type' => array('product'),
'post_status' => array('publish'),
                        'posts_per_page' => $settings['numberproductsdigipluskaveh'],
                        'order' => 'DESC',
                        'orderby' => 'date',
                        'tax_query' => array(
                            array(
                                "taxonomy" => "product_cat",
                                "field" => "term_id",
                                "terms" => $settings['catproductsdigipluskaveh'],
                            ),
                        ),
                        'meta_query' => array(
                            array(
                                'key' => '_stock_status',
                                'value' => 'outofstock',
                                'compare' => 'NOT IN',
                            ),
                        ),
                    );

                    // The Query
                    $pcat_query = new \WP_Query($cat_query_args);

                    // The Loop
                    if ($pcat_query->have_posts()) :?>
                        <?php while ($pcat_query->have_posts()) :
                            $pcat_query->the_post(); ?>
                            <li class="w-100">
                                <a href="<?php the_permalink(); ?>" class="d-block">
                                    <img src="<?php the_post_thumbnail_url('full'); ?>"
                                         alt="<?php the_title(); ?>"
                                         width="116"
                                         height="116"
                                         class="d-block w-100">
                                </a>
                            </li>
                        <?php
                        endwhile;
                        // Reset Original Post Data
                        wp_reset_postdata();
                        ?>
                    <?php endif; ?>
                <?php elseif ('custom' === $settings['displayproductsdigipluskaveh']) : ?>
                    <?php if ($settings['listproductdigipluskaveh']) : ?>
                        <?php foreach ($settings['listproductdigipluskaveh'] as $item) : ?>
                            <li class="w-100">
                                <a href="<?php echo esc_url($item['linkproductdigipluskaveh']); ?>" class="d-block">
                                    <img src="<?php echo esc_url($item['imgproductdigipluskaveh']['url']); ?>"
                                         alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt($item['imgproductdigipluskaveh'])); ?>"
                                         width="116"
                                         height="116"
                                         class="d-block w-100">
                                </a>
                            </li>
                        <?php endforeach; ?>
                    <?php endif; ?>
                <?php endif; ?>
            </ul>
        </div>
        </div>
        </div>
        </section>

        <style>
            @media only screen and (max-width: 575px) {
            <?php echo '.elementor-element-' . $clsid . ''; ?>  .send-instantaneous-right {
                background: unset !important;
            }
            }
        </style>

        <!-- End Digiplus -->
        <?php
    }


}
