<?php


use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Digikalatopsellingcarouselkaveh extends Widget_Base
{

    public function get_name()
    {
        return 'digikalatopsellingcarouselkaveh';
    }

    public function get_title()
    {
        return esc_html__('المان کاروسل پرفروش ‌ترین کالاها - دیجی کالا', 'kaveh-core');
    }

    public function get_icon()
    {
        return 'eicon-archive-posts';
    }

    public function get_categories()
    {
        return ['kavehelements'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content1digikalatopsellingcarouselkaveh',
            [
                'label' => esc_html__('تنظیمات محصولات', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $options = array();
        $orderby = 'name';
        $order = 'asc';
        $hide_empty = true;
        $cat_args = array(
            'orderby' => $orderby,
            'order' => $order,
            'hide_empty' => $hide_empty,
        );

        $product_categories = get_terms('product_cat', $cat_args);

        foreach ($product_categories as $key => $category) {
            $options[$category->term_id] = $category->name;
        }
        $this->add_control(
            'catproductsdigikalatopsellingcarouselkaveh',
            [
                'label' => esc_html__('انتخاب دسته بندی', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $options,
            ]
        );
        $this->add_control(
            'numberproductsdigikalatopsellingcarouselkaveh',
            [
                'label' => esc_html__('تعداد محصولات نمایش داده شده', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 18,
                'step' => 1,
                'default' => 18,
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'content2digikalatopsellingcarouselkaveh',
            [
                'label' => esc_html__('محتوای عنوان', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'buttonicodigikalatopsellingcarouselkaveh',
            [
              'label' => esc_html__( 'آیکون', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::ICONS,
              'skin' => 'inline',
              'exclude_inline_options' => [ 'svg' ],
              'default' => [
                'value' => 'icon-stars',
              ],
            ]
          ); 
        $this->add_control(
            'titledigikalatopsellingcarouselkaveh',
            [
                'label' => esc_html__('عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__(' محبوب‌ترین برندها', 'kaveh-core'),

            ]
        );
        $this->add_control(
            'tagheadingdigikalatopsellingcarouselkaveh',
            [
                'label' => esc_html__('تگ عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'H2',
                'options' => [
                    'H1' => esc_html__('H1', 'kaveh-core'),
                    'H2' => esc_html__('H2', 'kaveh-core'),
                    'H3' => esc_html__('H3', 'kaveh-core'),
                    'H4' => esc_html__('H4', 'kaveh-core'),
                    'H5' => esc_html__('H5', 'kaveh-core'),
                    'H6' => esc_html__('H6', 'kaveh-core'),
                    'p' => esc_html__('p', 'kaveh-core'),
                    'div' => esc_html__('div', 'kaveh-core'),
                    'span' => esc_html__('span', 'kaveh-core'),
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'content3digikalatopsellingcarouselkaveh',
            [
                'label' => esc_html__('دکمه ها', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'buttonseealldigikalatopsellingcarouselkaveh',
            [
                'label' => esc_html__('عنوان دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('مشاهده همه', 'kaveh-core'),
            ]
        );
        $this->add_control(
            'buttonlinkseealldigikalatopsellingcarouselkaveh',
            [
                'label' => esc_html__('لینک دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('#', 'kaveh-core'),

            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'style1_digikalatopsellingcarouselkaveh',
            [
                'label' => esc_html__('استایل عنوان', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'iconcolordigikalatopsellingcarouselkaveh',
            [
                'label' => esc_html__('رنگ آیکون', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#f9bc00',
                'selectors' => [
                    '{{WRAPPER}} .topseldk' => 'color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_control(
            'iconsizedigikalatopsellingcarouselkaveh',
            [
              'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::SLIDER,
              'size_units' => [ 'px' ],
              'range' => [
                'px' => [
                  'min' => 0,
                  'max' => 300,
                  'step' => 1,
                ],
              ],
              'selectors' => [
                '{{WRAPPER}} .topseldk' => 'font-size: {{SIZE}}{{UNIT}};',
              ],
            ]
          );
        $this->add_control(
            'titlecolordigikalatopsellingcarouselkaveh',
            [
                'label' => esc_html__('رنگ عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#080a38',
                'selectors' => [
                    '{{WRAPPER}} .top-selling-products-kala-title' => 'color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_digikalatopsellingcarouselkaveh',
                'label' => esc_html__('تایپوگرافی عنوان', 'kaveh-core'),
                'selector' => '{{WRAPPER}} .top-selling-products-kala-title',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'style2_digikalatopsellingcarouselkaveh',
            [
                'label' => esc_html__('استایل دکمه', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'button1_digikalatopsellingcarouselkaveh',
                'label' => esc_html__('تایپوگرافی متن دکمه', 'kaveh-core'),
                'selector' => '{{WRAPPER}} .top-selling-products-kala-link',
            ]
        );

        $this->add_control(
            'textbutton1colordigikalatopsellingcarouselkaveh',
            [
                'label' => esc_html__('رنگ نوشته دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#19bfd3',
                'selectors' => [
                    '{{WRAPPER}} .top-selling-products-kala-link' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .top-selling-products-kala-link:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style3_digikalatopsellingcarouselkaveh',
            [
                'label' => esc_html__('استایل محصولات', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'titleproductcolordigikalatopsellingcarouselkaveh',
            [
                'label' => esc_html__('رنگ عنوان محصولات', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#3f4064',
                'selectors' => [
                    '{{WRAPPER}} .product-eighteen .title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'numproductcolordigikalatopsellingcarouselkaveh',
            [
                'label' => esc_html__('رنگ عدد محصولات', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#19bfd3',
                'selectors' => [
                    '{{WRAPPER}} .product-eighteen .number' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style4_digikalatopsellingcarouselkaveh',
            [
                'label' => esc_html__('استایل باکس', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'borderboxdigikalatopsellingcarouselkaveh',
                'selector' => '{{WRAPPER}} .top-selling-products-kala-wrapper'
            ]
        );
        $this->add_control(
            'boxradiusdigikalatopsellingcarouselkaveh',
            [
                'label' => esc_html__('گوشه خمیده', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .top-selling-products-kala-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'style5_digikalatopsellingcarouselkaveh',
            [
                'label' => esc_html__('استایل جهت های کاروسل', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'arrowscolordigikalatopsellingcarouselkaveh',
            [
                'label' => esc_html__('رنگ  بکگراند جهت های کاروسل', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-next' => 'background-color: {{VALUE}} !important;',
                    '{{WRAPPER}}  .swiper-button-prev' => 'background-color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_control(
            'arrowscoloricondigikalatopsellingcarouselkaveh',
            [
                'label' => esc_html__('رنگ  آیکن جهت های کاروسل', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#3f4064',
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-next::after' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .swiper-button-prev::after' => 'color: {{VALUE}} !important;',
                ]
            ]
        );

        $this->add_control(
            'title1_options',
            [
                'label' => esc_html__('حاشیه جهت قبل', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'borderarrowprevdigikalatopsellingcarouselkaveh',
                'selector' => '{{WRAPPER}} .swiper-button-prev'
            ]
        );

        $this->add_control(
            'title2_options',
            [
                'label' => esc_html__('حاشیه جهت بعد', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'borderarrownextdigikalatopsellingcarouselkaveh',
                'selector' => '{{WRAPPER}} .swiper-button-next'
            ]
        );
        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $clsid = $this->get_id();
        ?>
        <!-- Start Top Selling Products -->
        <section class="top-selling-products-kala">
            <div class="container">
                <div class="top-selling-products-kala-wrapper py-3">
                    <!-- Start Heading -->
                    <div class="top-selling-products-kala-heading position-relative">
                        <<?php echo esc_attr($settings['tagheadingdigikalatopsellingcarouselkaveh']); ?>
                        class="top-selling-products-kala-title d-flex align-items-center justify-content-sm-center">
                        <i class="<?php echo  esc_html($settings['buttonicodigikalatopsellingcarouselkaveh']['value']); ?> topseldk"></i>
                        <?php echo esc_html($settings['titledigikalatopsellingcarouselkaveh']); ?>
                    </<?php echo esc_attr($settings['tagheadingdigikalatopsellingcarouselkaveh']); ?>>
                    <a href="<?php echo esc_url($settings['buttonlinkseealldigikalatopsellingcarouselkaveh']); ?>"
                       class="top-selling-products-kala-link position-absolute top-50 translate-middle-y">
                        <?php echo esc_html($settings['buttonseealldigikalatopsellingcarouselkaveh']); ?>
                    </a>
                </div>
                <!-- End Heading -->
                <!-- Start Carousel -->
                <div class="swiper swiper-top-selling-products-kala px-2 overflow-hidden position-relative swiper-kala" data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":1.2,"spaceBetween":12},"400":{"slidesPerView":1.5,"spaceBetween":12},"576":{"slidesPerView":2,"spaceBetween":12},"768":{"slidesPerView":3,"spaceBetween":12},"992":{"slidesPerView":4,"spaceBetween":12},"1200":{"slidesPerView":4,"spaceBetween":20}}}'>
                    <div class="swiper-wrapper">
                        <?php
                        // WP_Query args
                        $cat_query_args = array(
                            'post_type' => array('product'),
'post_status' => array('publish'),
                            'posts_per_page' => $settings['numberproductsdigikalatopsellingcarouselkaveh'],
                            'order' => 'DESC',
                            'orderby' => 'meta_value_num',
                            'meta_key' => 'total_sales',
                            'tax_query' => array(
                                array(
                                    'taxonomy' => 'product_cat',
                                    'field' => 'term_id',
                                    'terms' => $settings['catproductsdigikalatopsellingcarouselkaveh'],
                                ),
                            ),
                        );
                        // The Query
                        $pcat_query = new \WP_Query($cat_query_args);

                        $i = 1;
                        // The Loop
                        if ($pcat_query->have_posts()) :?>
                            <?php while ($pcat_query->have_posts()) : ?>
                                <!-- Start Slide -->
                                <div class="swiper-slide">
                                    <?php $j = 1; ?>
                                    <?php while ($j <= 3) :
                                        $pcat_query->the_post();
                                        ?>
                                        <!-- Start Product -->
                                        <div class="product-eighteen d-flex position-relative">
                                            <a href="<?php the_permalink(); ?>" class="stretched-link"
                                               aria-label="name product"></a>
                                            <img src="<?php the_post_thumbnail_url('thumbnail'); ?>"
                                                 alt="<?php the_title(); ?>">
                                            <div class="number"><?php echo $i; ?></div>
                                            <div class="name position-relative d-flex align-items-center">
                                                <h2 class="title mb-0 fw-normal overflow-hidden">
                                                    <?php the_title(); ?>
                                                </h2>
                                            </div>
                                        </div>
                                        <!-- End Product -->
                                        <?php
                                        $j++;
                                        $i++;
                                    endwhile;
                                    ?>
                                </div>
                                <!-- End Slide -->
                            <?php
                            endwhile;
                            // Reset Original Post Data after the loop
                            wp_reset_postdata();
                            ?>
                        <?php endif; ?>
                    </div>
                    <!-- Start Button -->
                    <div class="swiper-button-next d-flex align-items-center justify-content-center rounded-circle bg-white">
                    </div>
                    <div class="swiper-button-prev d-flex align-items-center justify-content-center rounded-circle bg-white">
                    </div>
                    <!-- End Button -->
                </div>
                <!-- End Carousel -->
            </div>
            </div>
        </section>
        <!-- End Top Selling Products -->
        <style>
            <?php echo '.elementor-element-' . $clsid . ''; ?>
            .product-eighteen img {
                width: 86px !important;
                height: 86px !important;
            }
        </style>
       <?php do_action('kelementor_inline_scripts'); ?>
        <?php
    }

}
