<?php


use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Digikalaquicklinkskaveh extends Widget_Base
{

    public function get_name()
    {
        return 'digikalaquicklinkskaveh';
    }

    public function get_title()
    {
        return esc_html__('المان لینک های سریع دیجی کالا', 'kaveh-core');
    }

    public function get_icon()
    {
        return 'eicon-archive-posts';
    }

    public function get_categories()
    {
        return ['kavehelements'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content1digikalaquicklinkskaveh',
            [
                'label' => esc_html__('محتوای المان', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'tagheadingdigikalaquicklinkskaveh',
            [
                'label' => esc_html__('تگ عنوان ها', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'H2',
                'options' => [
                    'H1' => esc_html__('H1', 'kaveh-core'),
                    'H2' => esc_html__('H2', 'kaveh-core'),
                    'H3' => esc_html__('H3', 'kaveh-core'),
                    'H4' => esc_html__('H4', 'kaveh-core'),
                    'H5' => esc_html__('H5', 'kaveh-core'),
                    'H6' => esc_html__('H6', 'kaveh-core'),
                    'p' => esc_html__('p', 'kaveh-core'),
                    'div' => esc_html__('div', 'kaveh-core'),
                    'span' => esc_html__('span', 'kaveh-core'),
                ],
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'imgdigikalaquicklinkskaveh',
            [
                'label' => esc_html__('تصویر', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'devices' => ['desktop', 'tablet', 'mobile'],
            ]
        );
        $repeater->add_control(
            'titledigikalaquicklinkskaveh',
            [
                'label' => esc_html__('عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('دیجی‌کالا جت', 'kaveh-core')
            ]
        );

        $repeater->add_control(
            'linkdigikalaquicklinkskaveh',
            [
                'label' => esc_html__('لینک', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('#', 'kaveh-core'),

            ]
        );
        $this->add_control(
            'listdigikalaquicklinkskaveh',
            [
                'label' => esc_html__('محتوا', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'linkdigikalaquicklinkskaveh' => esc_html__('#', 'kaveh-core'),
                        'titledigikalaquicklinkskaveh' => esc_html__('دیجی‌کالا جت', 'kaveh-core'),
                    ],
                ]
            ]

        );
        $this->end_controls_section();

        $this->start_controls_section(
            'content2digikalaquicklinkskaveh',
            [
                'label' => esc_html__('دکمه', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'buttonicodigikalaquicklinkskaveh',
            [
              'label' => esc_html__( 'آیکون', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::ICONS,
              'skin' => 'inline',
              'exclude_inline_options' => [ 'svg' ],
              'default' => [
                'value' => 'icon-dots-more',
              ],
            ]
          ); 
        $this->add_control(
            'buttonseealldigikalaquicklinkskaveh',
            [
                'label' => esc_html__('عنوان دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('بیشتر', 'kaveh-core'),
            ]
        );
        $this->add_control(
            'buttonlinkseealldigikalaquicklinkskaveh',
            [
                'label' => esc_html__('لینک دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('#', 'kaveh-core'),

            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style1_digikalaquicklinkskaveh',
            [
                'label' => esc_html__('استایل عنوان ها', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_digikalaquicklinkskaveh',
                'label' => esc_html__('تایپوگرافی عنوان ها', 'kaveh-core'),
                'selector' => '{{WRAPPER}} .other-link-kala-items li .title',
            ]
        );
        $this->add_control(
            'textcolor2digipluskaveh',
            [
                'label' => esc_html__('رنگ عنوان ها', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .other-link-kala-items li .title' => 'color: {{VALUE}} !important',
                ],
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'styleimag_digikalaquicklinkskaveh',
            [
              'label' => esc_html__( 'استایل تصویر دسته بندی', 'kaveh-core' ),
              'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
          );
          $this->add_control(
            'catimg1widthdigikalaquicklinkskaveh',
            [
              'label' => esc_html__( 'عرض تصاویر دسته بندی', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::SLIDER,
              'size_units' => [ 'px' ],
              'range' => [
                'px' => [
                  'min' => 0,
                  'max' => 300,
                  'step' => 1,
                ],
              ],
              'selectors' => [
                '{{WRAPPER}} .other-link-kala-items li img' => 'width: {{SIZE}}{{UNIT}};',
              ],
            ]
          );
          $this->add_control(
            'catimg1height2digikalaquicklinkskaveh',
            [
              'label' => esc_html__( 'ارتفاع تصاویر', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::SLIDER,
              'size_units' => [ 'px' ],
              'range' => [
                'px' => [
                  'min' => 0,
                  'max' => 300,
                  'step' => 1,
                ],
              ],
              'selectors' => [
                '{{WRAPPER}} .other-link-kala-items li img, .other-link-kala-items li i' => 'height: {{SIZE}}{{UNIT}};',
              ],
            ]
          );
          $this->end_controls_section();
        $this->start_controls_section(
            'style2_digikalaquicklinkskaveh',
            [
                'label' => esc_html__('استایل دکمه', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'butimg1widthdigikalaquicklinkskaveh',
            [
              'label' => esc_html__( 'عرض پس زمینه', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::SLIDER,
              'size_units' => [ 'px' ],
              'range' => [
                'px' => [
                  'min' => 0,
                  'max' => 300,
                  'step' => 1,
                ],
              ],
              'selectors' => [
                '{{WRAPPER}} .other-link-kala-items li i' => 'width: {{SIZE}}{{UNIT}};',
              ],
            ]
          );
          $this->add_control(
            'butimg1height2digikalaquicklinkskaveh',
            [
              'label' => esc_html__( 'ارتفاع پس زمینه', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::SLIDER,
              'size_units' => [ 'px' ],
              'range' => [
                'px' => [
                  'min' => 0,
                  'max' => 300,
                  'step' => 1,
                ],
              ],
              'selectors' => [
                '{{WRAPPER}} .other-link-kala-items li i, .other-link-kala-items li i' => 'height: {{SIZE}}{{UNIT}};',
              ],
            ]
          );
          $this->start_controls_tabs(
            'style_tabs2digikalaquicklinkskaveh'
          );
          
          $this->start_controls_tab(
            'style_normal_tab2digikalaquicklinkskaveh',
            [
              'label' => esc_html__( 'عادی', 'kaveh-core' ),
            ]
          );
        $this->add_control(
            'bgcoloricondigikalaquicklinkskaveh',
            [
                'label' => esc_html__('رنگ  پس زمینه آیکن', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#f1f2f4',
                'selectors' => [
                    '{{WRAPPER}} .other-link-kala-items li i' => 'background-color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_control(
            'buttoniconradius2digikalaquicklinkskaveh',
            [
              'label' => esc_html__( 'گوشه خمیده پس زمینه آیکون', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::DIMENSIONS,
              'size_units' => [ 'px' ],
              'selectors' => [
                '{{WRAPPER}} .other-link-kala-items li i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
              ],
            ]
          );
        $this->add_control(
            'iconsize1widthdigikalaquicklinkskaveh',
            [
              'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::SLIDER,
              'size_units' => [ 'px' ],
              'range' => [
                'px' => [
                  'min' => 0,
                  'max' => 300,
                  'step' => 1,
                ],
              ],
              'selectors' => [
                '{{WRAPPER}} .other-link-kala-items li i' => 'font-size: {{SIZE}}{{UNIT}};',
              ],
            ]
          );
        $this->add_control(
            'coloricondigikalaquicklinkskaveh',
            [
                'label' => esc_html__('رنگ آیکن', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#9e9fb1',
                'selectors' => [
                    '{{WRAPPER}} .other-link-kala-items li i' => 'color: {{VALUE}} !important;',
                ]
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
          'style_hove_tab2digikalaquicklinkskaveh',
          [
            'label' => esc_html__( 'هاور', 'kaveh-core' ),
          ]
        );
        $this->add_control(
            'bgcolorhovericondigikalaquicklinkskaveh',
            [
                'label' => esc_html__('رنگ  پس زمینه آیکن', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#f1f2f4',
                'selectors' => [
                    '{{WRAPPER}} .other-link-kala-items li:hover i' => 'background-color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_control(
            'buttoniconradiushover2digikalaquicklinkskaveh',
            [
              'label' => esc_html__( 'گوشه خمیده پس زمینه آیکون', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::DIMENSIONS,
              'size_units' => [ 'px' ],
              'selectors' => [
                '{{WRAPPER}} .other-link-kala-items li:hover i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
              ],
            ]
          );
        $this->add_control(
            'iconsizehover1widthdigikalaquicklinkskaveh',
            [
              'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::SLIDER,
              'size_units' => [ 'px' ],
              'range' => [
                'px' => [
                  'min' => 0,
                  'max' => 300,
                  'step' => 1,
                ],
              ],
              'selectors' => [
                '{{WRAPPER}} .other-link-kala-items li:hover i' => 'font-size: {{SIZE}}{{UNIT}};',
              ],
            ]
          );
        $this->add_control(
            'colorihovercondigikalaquicklinkskaveh',
            [
                'label' => esc_html__('رنگ آیکن', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#9e9fb1',
                'selectors' => [
                    '{{WRAPPER}} .other-link-kala-items li:hover i' => 'color: {{VALUE}} !important;',
                ]
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $clsid = $this->get_id();
        ?>
        <section class="other-link-kala">
            <div class="container">
                <ul class="other-link-kala-items d-flex align-items-center justify-content-between flex-wrap">
                    <?php if ($settings['listdigikalaquicklinkskaveh']) : ?>
                        <?php foreach ($settings['listdigikalaquicklinkskaveh'] as $item) : ?>
                            <li class="position-relative w-100 px-2">
                            <a href="<?php echo esc_url($item['linkdigikalaquicklinkskaveh']); ?>"
                               class="stretched-link" aria-label="link"></a>
                            <img src="<?php echo esc_url($item['imgdigikalaquicklinkskaveh']['url']); ?>"
                                 alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt($item['imgdigikalaquicklinkskaveh'])); ?>"
                                 width="52" height="52"
                                 class="d-block mx-auto">
                            <<?php echo esc_attr($settings['tagheadingdigikalaquicklinkskaveh']); ?>
                            class="title mb-0 text-center mt-1 text-truncate">
                            <?php echo esc_html($item['titledigikalaquicklinkskaveh']); ?>
                            </<?php echo esc_attr($settings['tagheadingdigikalaquicklinkskaveh']); ?>>
                            </li>
                        <?php endforeach; ?>
                    <?php endif; ?>
                    <li class="position-relative w-100 px-2">
                        <a href="<?php echo esc_url($settings['buttonlinkseealldigikalaquicklinkskaveh']); ?>"
                           class="stretched-link" aria-label="link"></a>
                        <i class="<?php echo  esc_html($settings['buttonicodigikalaquicklinkskaveh']['value']); ?> d-flex align-items-center justify-content-center rounded-pill mx-auto"></i>
                        <<?php echo esc_attr($settings['tagheadingdigikalaquicklinkskaveh']); ?>
                        class="title mb-0 text-center mt-1 text-truncate">
                        <?php echo esc_html($settings['buttonseealldigikalaquicklinkskaveh']); ?>
                    </<?php echo esc_attr($settings['tagheadingdigikalaquicklinkskaveh']); ?>>
                    </li>
                </ul>
            </div>
        </section>
<style>
    .other-link-kala-items li img{
        object-fit: contain !important;
    }
</style>
        <?php
    }

}
