<?php


use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Digikalaproductscategorytwokaveh extends Widget_Base
{

    public function get_name()
    {
        return 'digikalaproductscategorytwokaveh';
    }

    public function get_title()
    {
        return esc_html__('المان دسته بندی سبک دو دیجی کالا', 'kaveh-core');
    }

    public function get_icon()
    {
        return 'eicon-archive-posts';
    }

    public function get_categories()
    {
        return ['kavehelements'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content1digikalaproductscategorytwokaveh',
            [
                'label' => esc_html__('محتوای المان', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'tagheadingdigikalaproductscategorytwokaveh',
            [
                'label' => esc_html__('تگ عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'H2',
                'options' => [
                    'H1' => esc_html__('H1', 'kaveh-core'),
                    'H2' => esc_html__('H2', 'kaveh-core'),
                    'H3' => esc_html__('H3', 'kaveh-core'),
                    'H4' => esc_html__('H4', 'kaveh-core'),
                    'H5' => esc_html__('H5', 'kaveh-core'),
                    'H6' => esc_html__('H6', 'kaveh-core'),
                    'p' => esc_html__('p', 'kaveh-core'),
                    'div' => esc_html__('div', 'kaveh-core'),
                    'span' => esc_html__('span', 'kaveh-core'),
                ],
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'imgdigikalaproductscategorytwokaveh',
            [
                'label' => esc_html__('تصویر', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'devices' => ['desktop', 'tablet', 'mobile'],
            ]
        );
        $repeater->add_control(
            'titledigikalaproductscategorytwokaveh',
            [
                'label' => esc_html__('عنوان(نام دسته بندی)', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('گوشی موبایل', 'kaveh-core'),

            ]
        );
        $repeater->add_control(
            'linkdigikalaproductscategorytwokaveh',
            [
                'label' => esc_html__('لینک', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('#', 'kaveh-core'),

            ]
        );
        $this->add_control(
            'listdigikalaproductscategorytwokaveh',
            [
                'label' => esc_html__('تصاویر', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'linkdigikalaproductscategorytwokaveh' => esc_html__('#', 'kaveh-core'),
                        'titledigikalaproductscategorytwokaveh' => esc_html__('گوشی موبایل', 'kaveh-core'),
                    ],
                ]
            ]

        );
        $this->end_controls_section();

        $this->start_controls_section(
            'style1_digikalaproductscategorytwokaveh',
            [
                'label' => esc_html__('استایل عنوان', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'titlecolordigikalaproductscategorytwokaveh',
            [
                'label' => esc_html__('رنگ عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#080a38',
                'selectors' => [
                    '{{WRAPPER}} .proposal-kala-item .title' => 'color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_digikalaproductscategorytwokaveh',
                'label' => esc_html__('تایپوگرافی عنوان', 'kaveh-core'),
                'selector' => '{{WRAPPER}} .proposal-kala-item .title',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'style2_digikalaproductscategorytwokaveh',
            [
                'label' => esc_html__('استایل باکس', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'borderboxdigikalaproductscategorytwokaveh',
                'selector' => '{{WRAPPER}} .proposal-kala-wrapper'
            ]
        );
        $this->add_control(
            'boxradiusdigikalaproductscategorytwokaveh',
            [
                'label' => esc_html__('گوشه خمیده', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .proposal-kala-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'colorborderdigikalaproductscategorytwokaveh',
            [
                'label' => esc_html__('رنگ جدا کننده ستون ها', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#f1f2f4',
                'selectors' => [
                    '{{WRAPPER}} .proposal-kala .swiper-slide:not(:first-child, .two-one) > *' => 'border-right: 1px solid {{VALUE}}',
                    '{{WRAPPER}} .proposal-kala-item.two' => 'border-top: 1px solid {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $clsid = $this->get_id();
        ?>
        <!-- Start Proposal -->
        <section class="proposal-kala">
            <div class="container">
                <div class="proposal-kala-wrapper">
                    <!-- Start Carousel -->
                    <div class="swiper swiper-proposal-kala overflow-hidden position-relative swiper-kala">
                        <div class="swiper-wrapper">
                            <?php if ($settings['listdigikalaproductscategorytwokaveh']) : ?>
                            <?php foreach ($settings['listdigikalaproductscategorytwokaveh'] as $item) : ?>
                            <!-- Start Slide -->
                            <div class="swiper-slide">
                                <div class="proposal-kala-item position-relative d-flex align-items-center justify-content-center flex-column py-3 px-1">
                                    <a href="<?php echo esc_url($item['linkdigikalaproductscategorytwokaveh']); ?>"
                                       class="stretched-link" aria-label="product name"></a>
                                    <div class="image position-relative rounded-circle overflow-hidden">
                                        <img src="<?php echo esc_url($item['imgdigikalaproductscategorytwokaveh']['url']); ?>"
                                             alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt($item['imgdigikalaproductscategorytwokaveh'])); ?>">
                                    </div>
                                    <<?php echo esc_attr($settings['tagheadingdigikalaproductscategorytwokaveh']); ?>
                                    class="title mb-0 fw-normal mt-2 text-truncate mx-auto text-center">
                                    <?php echo esc_html($item['titledigikalaproductscategorytwokaveh']); ?>
                                </<?php echo esc_attr($settings['tagheadingdigikalaproductscategorytwokaveh']); ?>>
                            </div>
                        </div>
                        <!-- End Slide -->
                        <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
                <!-- End Carousel -->
            </div>
            </div>
        </section>
        <!-- End Proposal -->
        <style>
            <?php echo '.elementor-element-' . $clsid . ''; ?>
            .proposal-kala-item .image img {
                width: 60px !important;
                height: 60px !important;
            }
        </style>
        <?php if (\Elementor\Plugin::$instance->editor->is_edit_mode()) { ?>
        <script>
            new Swiper(".swiper-proposal-kala", {
                spaceBetween: 0,
                breakpoints: {
                    320: {
                        slidesPerView: 2,
                        grid: {
                            fill: "row",
                            rows: 2,
                        },
                    },
                    400: {
                        slidesPerView: 3,
                        grid: {
                            fill: "row",
                            rows: 2,
                        },
                    },
                    500: {
                        slidesPerView: 4,
                        grid: {
                            fill: "row",
                            rows: 2,
                        },
                    },
                    576: {
                        slidesPerView: 4,
                        grid: {
                            fill: "row",
                            rows: 2,
                        },
                    },
                    768: {
                        slidesPerView: 5,
                        grid: {
                            fill: "row",
                            rows: 2,
                        },
                    },
                    992: {
                        slidesPerView: 7,
                        grid: {
                            fill: "row",
                            rows: 2,
                        },
                    },
                },
                on: {
                    init: (swiper) => {
                        swiper.slides.forEach((item, index) => {
                            const thisIndex = index + 1,
                                allSlides = swiper.slides.length / 2;

                            if (thisIndex === allSlides + 1) {
                                item.classList.add("two-one");
                            }

                            if (thisIndex > allSlides) {
                                item.firstElementChild.classList.add("two");
                            }
                        });
                    },
                },
            });
        </script>
    <?php } ?>
        <?php
    }

}
