<?php


use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Digikalaproductscategoryonekaveh extends Widget_Base
{

    public function get_name()
    {
        return 'digikalaproductscategoryonekaveh';
    }

    public function get_title()
    {
        return esc_html__('المان دسته بندی سبک یک دیجی کالا', 'kaveh-core');
    }

    public function get_icon()
    {
        return 'eicon-archive-posts';
    }

    public function get_categories()
    {
        return ['kavehelements'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content1digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('محتوای ستون اول', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title1digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('عنوان(نام دسته بندی)', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('گوشی موبایل', 'kaveh-core'),

            ]
        );
        $this->add_control(
            'tagheading1digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('تگ عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'div',
                'options' => [
                    'H1' => esc_html__('H1', 'kaveh-core'),
                    'H2' => esc_html__('H2', 'kaveh-core'),
                    'H3' => esc_html__('H3', 'kaveh-core'),
                    'H4' => esc_html__('H4', 'kaveh-core'),
                    'H5' => esc_html__('H5', 'kaveh-core'),
                    'H6' => esc_html__('H6', 'kaveh-core'),
                    'p' => esc_html__('p', 'kaveh-core'),
                    'div' => esc_html__('div', 'kaveh-core'),
                    'span' => esc_html__('span', 'kaveh-core'),
                ],
            ]
        );

        $this->add_control(
            'subtitle1digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('زیر عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('بر اساس بازدیدهای شما', 'kaveh-core'),

            ]
        );

        $options = array();
        $orderby = 'name';
        $order = 'asc';
        $hide_empty = true;
        $cat_args = array(
            'orderby' => $orderby,
            'order' => $order,
            'hide_empty' => $hide_empty,
        );

        $product_categories = get_terms('product_cat', $cat_args);

        foreach ($product_categories as $key => $category) {
            $options[$category->term_id] = $category->name;
        }
        $this->add_control(
            'catproducts1digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('انتخاب دسته بندی', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $options,
            ]
        );

        $this->add_control(
            'button1digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('عنوان دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('مشاهده', 'kaveh-core'),
            ]
        );

        $this->add_control(
            'buttonlink1digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('لینک دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('#', 'kaveh-core'),

            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content2digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('محتوای ستون دوم', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title2digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('عنوان(نام دسته بندی)', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('گوشی موبایل', 'kaveh-core'),

            ]
        );
        $this->add_control(
            'tagheading2digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('تگ عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'div',
                'options' => [
                    'H1' => esc_html__('H1', 'kaveh-core'),
                    'H2' => esc_html__('H2', 'kaveh-core'),
                    'H3' => esc_html__('H3', 'kaveh-core'),
                    'H4' => esc_html__('H4', 'kaveh-core'),
                    'H5' => esc_html__('H5', 'kaveh-core'),
                    'H6' => esc_html__('H6', 'kaveh-core'),
                    'p' => esc_html__('p', 'kaveh-core'),
                    'div' => esc_html__('div', 'kaveh-core'),
                    'span' => esc_html__('span', 'kaveh-core'),
                ],
            ]
        );

        $this->add_control(
            'subtitle2digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('زیر عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('بر اساس بازدیدهای شما', 'kaveh-core'),

            ]
        );

        $options = array();
        $orderby = 'name';
        $order = 'asc';
        $hide_empty = true;
        $cat_args = array(
            'orderby' => $orderby,
            'order' => $order,
            'hide_empty' => $hide_empty,
        );


        foreach ($product_categories as $key => $category) {
            $options[$category->term_id] = $category->name;
        }
        $this->add_control(
            'catproducts2digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('انتخاب دسته بندی', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $options,
            ]
        );

        $this->add_control(
            'button2digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('عنوان دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('مشاهده', 'kaveh-core'),
            ]
        );

        $this->add_control(
            'buttonlink2digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('لینک دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('#', 'kaveh-core'),

            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content3digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('محتوای ستون سوم', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title3digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('عنوان(نام دسته بندی)', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('گوشی موبایل', 'kaveh-core'),

            ]
        );
        $this->add_control(
            'tagheading3digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('تگ عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'div',
                'options' => [
                    'H1' => esc_html__('H1', 'kaveh-core'),
                    'H2' => esc_html__('H2', 'kaveh-core'),
                    'H3' => esc_html__('H3', 'kaveh-core'),
                    'H4' => esc_html__('H4', 'kaveh-core'),
                    'H5' => esc_html__('H5', 'kaveh-core'),
                    'H6' => esc_html__('H6', 'kaveh-core'),
                    'p' => esc_html__('p', 'kaveh-core'),
                    'div' => esc_html__('div', 'kaveh-core'),
                    'span' => esc_html__('span', 'kaveh-core'),
                ],
            ]
        );

        $this->add_control(
            'subtitle3digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('زیر عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('بر اساس بازدیدهای شما', 'kaveh-core'),

            ]
        );

        $options = array();
        $orderby = 'name';
        $order = 'asc';
        $hide_empty = true;
        $cat_args = array(
            'orderby' => $orderby,
            'order' => $order,
            'hide_empty' => $hide_empty,
        );


        foreach ($product_categories as $key => $category) {
            $options[$category->term_id] = $category->name;
        }
        $this->add_control(
            'catproducts3digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('انتخاب دسته بندی', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $options,
            ]
        );

        $this->add_control(
            'button3digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('عنوان دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('مشاهده', 'kaveh-core'),
            ]
        );

        $this->add_control(
            'buttonlink3digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('لینک دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('#', 'kaveh-core'),

            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content4digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('محتوای ستون چهارم', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title4digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('عنوان(نام دسته بندی)', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('گوشی موبایل', 'kaveh-core'),

            ]
        );
        $this->add_control(
            'tagheading4digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('تگ عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'div',
                'options' => [
                    'H1' => esc_html__('H1', 'kaveh-core'),
                    'H2' => esc_html__('H2', 'kaveh-core'),
                    'H3' => esc_html__('H3', 'kaveh-core'),
                    'H4' => esc_html__('H4', 'kaveh-core'),
                    'H5' => esc_html__('H5', 'kaveh-core'),
                    'H6' => esc_html__('H6', 'kaveh-core'),
                    'p' => esc_html__('p', 'kaveh-core'),
                    'div' => esc_html__('div', 'kaveh-core'),
                    'span' => esc_html__('span', 'kaveh-core'),
                ],
            ]
        );

        $this->add_control(
            'subtitle4digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('زیر عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('بر اساس بازدیدهای شما', 'kaveh-core'),

            ]
        );

        $options = array();
        $orderby = 'name';
        $order = 'asc';
        $hide_empty = true;
        $cat_args = array(
            'orderby' => $orderby,
            'order' => $order,
            'hide_empty' => $hide_empty,
        );


        foreach ($product_categories as $key => $category) {
            $options[$category->term_id] = $category->name;
        }
        $this->add_control(
            'catproducts4digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('انتخاب دسته بندی', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $options,
            ]
        );

        $this->add_control(
            'button4digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('عنوان دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('مشاهده', 'kaveh-core'),
            ]
        );

        $this->add_control(
            'buttonlink4digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('لینک دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('#', 'kaveh-core'),

            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('استایل عناوین', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'titlecolordigikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('رنگ عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#23254e',
                'selectors' => [
                    '{{WRAPPER}} .products-category-kala-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_digikalaproductscategoryonekaveh',
                'label' => esc_html__('تایپوگرافی عنوان', 'kaveh-core'),
                'selector' => '{{WRAPPER}} .products-category-kala-title',
            ]
        );

        $this->add_control(
            'subtitlecolordigikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('رنگ زیر عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#767790',
                'selectors' => [
                    '{{WRAPPER}} .products-category-kala-sub-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title2_digikalaproductscategoryonekaveh',
                'label' => esc_html__('تایپوگرافی زیر عنوان', 'kaveh-core'),
                'selector' => '{{WRAPPER}} .products-category-kala-sub-title',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'style2_digikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('استایل دکمه', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'button_digikalaproductscategoryonekaveh',
                'label' => esc_html__('تایپوگرافی متن دکمه', 'kaveh-core'),
                'selector' => '{{WRAPPER}} .products-category-kala .link-more',
            ]
        );

        $this->add_control(
            'buttoncolordigikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('رنگ نوشته دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#19bfd3',
                'selectors' => [
                    '{{WRAPPER}} .products-category-kala .link-more' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'style4_boxdigikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('استایل باکس اصلی', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'borderboxdigikalaproductscategoryonekavehveh',
                'selector' => '{{WRAPPER}} .products-category-kala-wrapper'
            ]
        );
        $this->add_control(
            'boxradiusdigikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('گوشه خمیده', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .products-category-kala-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'colorborderdigikalaproductscategoryonekaveh',
            [
                'label' => esc_html__('رنگ جدا کننده ستون ها و تصاویر', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#f1f2f4',
                'selectors' => [
                    '{{WRAPPER}} .products-category-kala-wrapper>.row>*:not(:last-child)' => 'border-left: 1px solid {{VALUE}}',
                    '{{WRAPPER}} .products-category-kala-wrapper>.row>*>.row>*:nth-child(1)' => 'border-left: 1px solid {{VALUE}}',
                    '{{WRAPPER}} .products-category-kala-wrapper>.row>*>.row>*:nth-child(3)' => 'border-left: 1px solid {{VALUE}}',
                    '{{WRAPPER}} .products-category-kala-wrapper>.row>*>.row>*:nth-child(n+3)' => 'border-top: 1px solid {{VALUE}}',
                ],
            ]
        );


        $this->end_controls_section();

    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $clsid = $this->get_id();
        ?>


        <!-- Start Products Category -->
        <section class="products-category-kala">
            <div class="container">
                <div class="products-category-kala-wrapper">
                    <div class="row m-0">
                        <div class="col-sm-6 col-lg-3">
                            <<?php echo esc_attr($settings['tagheading1digikalaproductscategoryonekaveh']); ?>
                            class="products-category-kala-title ">
                            <?php echo esc_html($settings['title1digikalaproductscategoryonekaveh']); ?>
                        </<?php echo esc_attr($settings['tagheading1digikalaproductscategoryonekaveh']); ?>>
                        <div class="products-category-kala-sub-title mb-2"><?php echo esc_html($settings['subtitle1digikalaproductscategoryonekaveh']); ?></div>
                        <div class="row m-0">
                            <?php

                            // WP_Query args
                            $cat_query_args = array(
                                'post_type' => array('product'),
'post_status' => array('publish'),
                                'posts_per_page' => 4,
                                'order' => 'DESC',
                                'orderby' => 'date',
                                'tax_query' => array(
                                    array(
                                        "taxonomy" => "product_cat",
                                        "field" => "term_id",
                                        "terms" => $settings['catproducts1digikalaproductscategoryonekaveh'],
                                    ),
                                ),
                                'meta_query' => array(
                                    array(
                                        'key' => '_stock_status',
                                        'value' => 'outofstock',
                                        'compare' => 'NOT IN',
                                    ),
                                ),
                            );

                            // The Query
                            $pcat_query = new \WP_Query($cat_query_args);

                            // The Loop
                            if ($pcat_query->have_posts()) :?>
                                <?php while ($pcat_query->have_posts()) :
                                    $pcat_query->the_post(); ?>
                                    <div class="col-6 p-0">
                                        <a href="<?php the_permalink(); ?>"
                                           class="products-category-kala-item d-block p-2">
                                            <img src="<?php the_post_thumbnail_url('thumbnail'); ?>"
                                                 alt="<?php the_title(); ?>"
                                                 width="126"
                                                 height="126" class="d-block w-100">
                                        </a>
                                    </div>
                                <?php
                                endwhile;
                                // Reset Original Post Data
                                wp_reset_postdata();
                                ?>
                            <?php endif; ?>
                        </div>
                        <a href="<?php echo esc_url($settings['buttonlink1digikalaproductscategoryonekaveh']); ?>"
                           class="link-more d-flex align-items-center justify-content-center">
                            <?php echo esc_html($settings['button1digikalaproductscategoryonekaveh']); ?>
                            <i class="icon-angle-left ms-2"></i>
                        </a>
                    </div>
                    <div class="col-sm-6 col-lg-3">
                        <<?php echo esc_attr($settings['tagheading2digikalaproductscategoryonekaveh']); ?>
                        class="products-category-kala-title ">
                        <?php echo esc_html($settings['title2digikalaproductscategoryonekaveh']); ?>
                    </<?php echo esc_attr($settings['tagheading2digikalaproductscategoryonekaveh']); ?>>
                    <div class="products-category-kala-sub-title mb-2"><?php echo esc_html($settings['subtitle2digikalaproductscategoryonekaveh']); ?></div>
                    <div class="row m-0">
                        <?php

                        // WP_Query args
                        $cat_query_args = array(
                            'post_type' => array('product'),
'post_status' => array('publish'),
                            'posts_per_page' => 4,
                            'order' => 'DESC',
                            'orderby' => 'date',
                            'tax_query' => array(
                                array(
                                    "taxonomy" => "product_cat",
                                    "field" => "term_id",
                                    "terms" => $settings['catproducts2digikalaproductscategoryonekaveh'],
                                ),
                            ),
                            'meta_query' => array(
                                array(
                                    'key' => '_stock_status',
                                    'value' => 'outofstock',
                                    'compare' => 'NOT IN',
                                ),
                            ),
                        );

                        // The Query
                        $pcat_query = new \WP_Query($cat_query_args);

                        // The Loop
                        if ($pcat_query->have_posts()) :?>
                            <?php while ($pcat_query->have_posts()) :
                                $pcat_query->the_post(); ?>
                                <div class="col-6 p-0">
                                    <a href="<?php the_permalink(); ?>"
                                       class="products-category-kala-item d-block p-2">
                                        <img src="<?php the_post_thumbnail_url('thumbnail'); ?>"
                                             alt="<?php the_title(); ?>"
                                             width="126"
                                             height="126" class="d-block w-100">
                                    </a>
                                </div>
                            <?php
                            endwhile;
                            // Reset Original Post Data
                            wp_reset_postdata();
                            ?>
                        <?php endif; ?>
                    </div>
                    <a href="<?php echo esc_url($settings['buttonlink2digikalaproductscategoryonekaveh']); ?>"
                       class="link-more d-flex align-items-center justify-content-center">
                        <?php echo esc_html($settings['button2digikalaproductscategoryonekaveh']); ?>
                        <i class="icon-angle-left ms-2"></i>
                    </a>
                </div>
                <div class="col-sm-6 col-lg-3">
                    <<?php echo esc_attr($settings['tagheading3digikalaproductscategoryonekaveh']); ?>
                    class="products-category-kala-title ">
                    <?php echo esc_html($settings['title3digikalaproductscategoryonekaveh']); ?>
                </<?php echo esc_attr($settings['tagheading3digikalaproductscategoryonekaveh']); ?>>
                <div class="products-category-kala-sub-title mb-2"><?php echo esc_html($settings['subtitle3digikalaproductscategoryonekaveh']); ?></div>
                <div class="row m-0">
                    <?php

                    // WP_Query args
                    $cat_query_args = array(
                        'post_type' => array('product'),
'post_status' => array('publish'),
                        'posts_per_page' => 4,
                        'order' => 'DESC',
                        'orderby' => 'date',
                        'tax_query' => array(
                            array(
                                "taxonomy" => "product_cat",
                                "field" => "term_id",
                                "terms" => $settings['catproducts3digikalaproductscategoryonekaveh'],
                            ),
                        ),
                        'meta_query' => array(
                            array(
                                'key' => '_stock_status',
                                'value' => 'outofstock',
                                'compare' => 'NOT IN',
                            ),
                        ),
                    );

                    // The Query
                    $pcat_query = new \WP_Query($cat_query_args);

                    // The Loop
                    if ($pcat_query->have_posts()) :?>
                        <?php while ($pcat_query->have_posts()) :
                            $pcat_query->the_post(); ?>
                            <div class="col-6 p-0">
                                <a href="<?php the_permalink(); ?>"
                                   class="products-category-kala-item d-block p-2">
                                    <img src="<?php the_post_thumbnail_url('thumbnail'); ?>"
                                         alt="<?php the_title(); ?>"
                                         width="126"
                                         height="126" class="d-block w-100">
                                </a>
                            </div>
                        <?php
                        endwhile;
                        // Reset Original Post Data
                        wp_reset_postdata();
                        ?>
                    <?php endif; ?>
                </div>
                <a href="<?php echo esc_url($settings['buttonlink3digikalaproductscategoryonekaveh']); ?>"
                   class="link-more d-flex align-items-center justify-content-center">
                    <?php echo esc_html($settings['button3digikalaproductscategoryonekaveh']); ?>
                    <i class="icon-angle-left ms-2"></i>
                </a>
            </div>
            <div class="col-sm-6 col-lg-3">
                <<?php echo esc_attr($settings['tagheading4digikalaproductscategoryonekaveh']); ?>
                class="products-category-kala-title ">
                <?php echo esc_html($settings['title4digikalaproductscategoryonekaveh']); ?>
            </<?php echo esc_attr($settings['tagheading4digikalaproductscategoryonekaveh']); ?>>
            <div class="products-category-kala-sub-title mb-2"><?php echo esc_html($settings['subtitle4digikalaproductscategoryonekaveh']); ?></div>
            <div class="row m-0">
                <?php

                // WP_Query args
                $cat_query_args = array(
                    'post_type' => array('product'),
'post_status' => array('publish'),
                    'posts_per_page' => 4,
                    'order' => 'DESC',
                    'orderby' => 'date',
                    'tax_query' => array(
                        array(
                            "taxonomy" => "product_cat",
                            "field" => "term_id",
                            "terms" => $settings['catproducts4digikalaproductscategoryonekaveh'],
                        ),
                    ),
                    'meta_query' => array(
                        array(
                            'key' => '_stock_status',
                            'value' => 'outofstock',
                            'compare' => 'NOT IN',
                        ),
                    ),
                );

                // The Query
                $pcat_query = new \WP_Query($cat_query_args);

                // The Loop
                if ($pcat_query->have_posts()) :?>
                    <?php while ($pcat_query->have_posts()) :
                        $pcat_query->the_post(); ?>
                        <div class="col-6 p-0">
                            <a href="<?php the_permalink(); ?>"
                               class="products-category-kala-item d-block p-2">
                                <img src="<?php the_post_thumbnail_url('thumbnail'); ?>"
                                     alt="<?php the_title(); ?>"
                                     width="126"
                                     height="126" class="d-block w-100">
                            </a>
                        </div>
                    <?php
                    endwhile;
                    // Reset Original Post Data
                    wp_reset_postdata();
                    ?>
                <?php endif; ?>
            </div>
            <a href="<?php echo esc_url($settings['buttonlink4digikalaproductscategoryonekaveh']); ?>"
               class="link-more d-flex align-items-center justify-content-center">
                <?php echo esc_html($settings['button4digikalaproductscategoryonekaveh']); ?>
                <i class="icon-angle-left ms-2"></i>
            </a>
            </div>
            </div>
            </div>
            </div>
        </section>
        <!-- End Products Category -->
        <?php
    }
}
