<?php


use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Digikalabrandscarouselkaveh extends Widget_Base
{

    public function get_name()
    {
        return 'digikalabrandscarouselkaveh';
    }

    public function get_title()
    {
        return esc_html__('المان کاروسل برند دیجی کالا', 'kaveh-core');
    }

    public function get_icon()
    {
        return 'eicon-archive-posts';
    }

    public function get_categories()
    {
        return ['kavehelements'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content1digikalabrandscarouselkaveh',
            [
                'label' => esc_html__('محتوای المان', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'imgdigikalabrandscarouselkaveh',
            [
                'label' => esc_html__('تصویر', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'devices' => ['desktop', 'tablet', 'mobile'],
            ]
        );

        $repeater->add_control(
            'linkdigikalabrandscarouselkaveh',
            [
                'label' => esc_html__('لینک', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('#', 'kaveh-core'),

            ]
        );
        $this->add_control(
            'listdigikalabrandscarouselkaveh',
            [
                'label' => esc_html__('تصاویر', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'linkdigikalabrandscarouselkaveh' => esc_html__('#', 'kaveh-core'),
                    ],
                ]
            ]

        );
        $this->end_controls_section();
        $this->start_controls_section(
            'content2digikalabrandscarouselkaveh',
            [
                'label' => esc_html__('محتوای عنوان', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'buttonicodigikalabrandscarouselkaveh',
            [
              'label' => esc_html__( 'آیکون', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::ICONS,
              'skin' => 'inline',
              'exclude_inline_options' => [ 'svg' ],
              'default' => [
                'value' => 'icon-stars',
              ],
            ]
          ); 
        $this->add_control(
            'titledigikalabrandscarouselkaveh',
            [
                'label' => esc_html__('عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__(' محبوب‌ترین برندها', 'kaveh-core'),

            ]
        );
        $this->add_control(
            'tagheadingdigikalabrandscarouselkaveh',
            [
                'label' => esc_html__('تگ عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'H2',
                'options' => [
                    'H1' => esc_html__('H1', 'kaveh-core'),
                    'H2' => esc_html__('H2', 'kaveh-core'),
                    'H3' => esc_html__('H3', 'kaveh-core'),
                    'H4' => esc_html__('H4', 'kaveh-core'),
                    'H5' => esc_html__('H5', 'kaveh-core'),
                    'H6' => esc_html__('H6', 'kaveh-core'),
                    'p' => esc_html__('p', 'kaveh-core'),
                    'div' => esc_html__('div', 'kaveh-core'),
                    'span' => esc_html__('span', 'kaveh-core'),
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'style1_digikalabrandscarouselkaveh',
            [
                'label' => esc_html__('استایل عنوان', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'titlecolordigikalabrandscarouselkaveh',
            [
                'label' => esc_html__('رنگ عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#080a38',
                'selectors' => [
                    '{{WRAPPER}} .brands-kala-title' => 'color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_digikalabrandscarouselkaveh',
                'label' => esc_html__('تایپوگرافی عنوان', 'kaveh-core'),
                'selector' => '{{WRAPPER}} .brands-kala-title',
            ]
        );
        $this->add_control(
            'iconcolordigikalabrandscarouselkaveh',
            [
                'label' => esc_html__('رنگ آیکون', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#f9bc00',
                'selectors' => [
                    '{{WRAPPER}} .brands-kala-title i' => 'color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_control(
            'iconsizedigikalabrandscarouselkaveh',
            [
              'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::SLIDER,
              'size_units' => [ 'px' ],
              'range' => [
                'px' => [
                  'min' => 0,
                  'max' => 300,
                  'step' => 1,
                ],
              ],
              'selectors' => [
                '{{WRAPPER}} .brands-kala-title i' => 'font-size: {{SIZE}}{{UNIT}};',
              ],
            ]
          );
        $this->end_controls_section();
        $this->start_controls_section(
            'style2_digikalabrandscarouselkaveh',
            [
                'label' => esc_html__('استایل باکس', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'borderboxdigikalabrandscarouselkaveh',
                'selector' => '{{WRAPPER}} .brands-kala-wrapper'
            ]
        );
        $this->add_control(
            'boxradiusdigikalabrandscarouselkaveh',
            [
                'label' => esc_html__('گوشه خمیده', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .brands-kala-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'style3_digikalabrandscarouselkaveh',
            [
                'label' => esc_html__('استایل جهت های کاروسل', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'arrowscolordigikalabrandscarouselkaveh',
            [
                'label' => esc_html__('رنگ  بکگراند جهت های کاروسل', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-next' => 'background-color: {{VALUE}} !important;',
                    '{{WRAPPER}}  .swiper-button-prev' => 'background-color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_control(
            'arrowscoloricondigikalabrandscarouselkaveh',
            [
                'label' => esc_html__('رنگ  آیکن جهت های کاروسل', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#3f4064',
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-next::after' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .swiper-button-prev::after' => 'color: {{VALUE}} !important;',
                ]
            ]
        );

        $this->add_control(
            'title1_options',
            [
                'label' => esc_html__('حاشیه جهت قبل', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'borderarrowprevdigikalabrandscarouselkaveh',
                'selector' => '{{WRAPPER}} .swiper-button-prev'
            ]
        );

        $this->add_control(
            'title2_options',
            [
                'label' => esc_html__('حاشیه جهت بعد', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'borderarrownextdigikalabrandscarouselkaveh',
                'selector' => '{{WRAPPER}} .swiper-button-next'
            ]
        );
        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $clsid = $this->get_id();
        ?>
        <!-- Start Brands -->
        <section class="brands-kala">
            <div class="container">
                <div class="brands-kala-wrapper py-4">
                    <<?php echo esc_attr($settings['tagheadingdigikalabrandscarouselkaveh']); ?>
                    class="brands-kala-title d-flex align-items-center justify-content-center">
                    <i class="<?php echo  esc_html($settings['buttonicodigikalabrandscarouselkaveh']['value']); ?>"></i>
                    <?php echo esc_html($settings['titledigikalabrandscarouselkaveh']); ?>
                </<?php echo esc_attr($settings['tagheadingdigikalabrandscarouselkaveh']); ?>>
                <!-- Start Carousel -->
                <div class="swiper swiper-brands-kala overflow-hidden position-relative swiper-kala" data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"spaceBetween":0,"breakpoints":{"320":{"slidesPerView":2},"400":{"slidesPerView":3},"500":{"slidesPerView":4},"576":{"slidesPerView":5},"768":{"slidesPerView":7},"992":{"slidesPerView":9}}}'>
                    <div class="swiper-wrapper">
                        <?php if ($settings['listdigikalabrandscarouselkaveh']) : ?>
                            <?php foreach ($settings['listdigikalabrandscarouselkaveh'] as $item) : ?>
                                <!-- Start Slide -->
                                <div class="swiper-slide h-auto">
                                    <a href="<?php echo esc_url($item['linkdigikalabrandscarouselkaveh']); ?>"
                                       class="d-flex align-items-center justify-content-center h-100 py-1 px-3">
                                        <img src="<?php echo esc_url($item['imgdigikalabrandscarouselkaveh']['url']); ?>"
                                             alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt($item['imgdigikalabrandscarouselkaveh'])); ?>"
                                             width="110"
                                             height="110" class="d-block mx-auto">
                                    </a>
                                </div>
                                <!-- End Slide -->
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                    <!-- Start Button -->
                    <div class="swiper-button-next d-flex align-items-center justify-content-center rounded-circle bg-white">
                    </div>
                    <div class="swiper-button-prev d-flex align-items-center justify-content-center rounded-circle bg-white">
                    </div>
                    <!-- End Button -->
                </div>
                <!-- End Carousel -->
            </div>
            </div>
        </section>
        <!-- End Brands -->
        <?php do_action('kelementor_inline_scripts'); ?>                        
        <?php
    }

}
