<?php


use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Digikalabannercarouselkaveh extends Widget_Base
{

    public function get_name()
    {
        return 'digikalabannercarouselkaveh';
    }

    public function get_title()
    {
        return esc_html__('المان اسلایدر دیجی کالا', 'kaveh-core');
    }

    public function get_icon()
    {
        return 'eicon-archive-posts';
    }

    public function get_categories()
    {
        return ['kavehelements'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content1digikalabannercarouselkaveh',
            [
                'label' => esc_html__('محتوای المان', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_responsive_control(
            'imgdigikalabannercarouselkaveh',
            [
                'label' => esc_html__('تصویر', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'devices' => ['desktop', 'tablet', 'mobile'],
            ]
        );

        $repeater->add_control(
            'linkdigikalabannercarouselkaveh',
            [
                'label' => esc_html__('لینک', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('#', 'kaveh-core'),

            ]
        );
        $this->add_control(
            'listdigikalabannercarouselkaveh',
            [
                'label' => esc_html__('تصاویر', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'linkdigikalabannercarouselkaveh' => esc_html__('#', 'kaveh-core'),
                    ],
                ]
            ]

        );
        $this->end_controls_section();


        $this->start_controls_section(
            'style1_digikalabannercarouselkaveh',
            [
                'label' => esc_html__('استایل تصویر', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'imageheightdigikalabannercarouselkaveh',
            [
                'label' => esc_html__('ارتفاع تصویر', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 2000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'selectors' => [
                    '{{WRAPPER}} .carousel-home-kala img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'imageradiusdigikalabannercarouselkaveh',
            [
                'label' => esc_html__('گوشه خمیده', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .carousel-home-kala' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'style2_digikalabannercarouselkaveh',
            [
                'label' => esc_html__('استایل کاروسل', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'arrowscolordigikalabannercarouselkaveh',
            [
                'label' => esc_html__('رنگ  بکگراند جهت های کاروسل', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-next' => 'background-color: {{VALUE}} !important;',
                    '{{WRAPPER}}  .swiper-button-prev' => 'background-color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_control(
            'arrowscoloricondigikalabannercarouselkaveh',
            [
                'label' => esc_html__('رنگ  آیکن جهت های کاروسل', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#3f4064',
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-next::after' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .swiper-button-prev::after' => 'color: {{VALUE}} !important;',
                ]
            ]
        );

        $this->add_control(
            'title1_options',
            [
                'label' => esc_html__('حاشیه جهت قبل', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'borderarrowprevdigikalabannercarouselkaveh',
                'selector' => '{{WRAPPER}} .swiper-button-prev'
            ]
        );

        $this->add_control(
            'title2_options',
            [
                'label' => esc_html__('حاشیه جهت بعد', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'borderarrownextdigikalabannercarouselkaveh',
                'selector' => '{{WRAPPER}} .swiper-button-next'
            ]
        );

        $this->add_control(
            'hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'paginationdeactivecoloricondigikalabannercarouselkaveh',
            [
                'label' => esc_html__('رنگ pagination غیر فعال', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#080a38',
                'selectors' => [
                    '{{WRAPPER}} .carousel-home-kala .swiper-pagination-bullet' => 'background-color: {{VALUE}} !important;',
                ]
            ]
        );

        $this->add_control(
            'paginationactivecoloricondigikalabannercarouselkaveh',
            [
                'label' => esc_html__('رنگ pagination فعال', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .carousel-home-kala .swiper-pagination-bullet-active' => 'background-color: {{VALUE}} !important;',
                ]
            ]
        );
        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $clsid = $this->get_id();
        ?>
        <!-- Start Carousel Home -->
        <section class="carousel-home-kala overflow-hidden">
            <!-- Start Carousel -->
            <div class="swiper swiper-carousel-home-kala overflow-hidden position-relative" data-swiper='{"autoplay":{"delay":5000,"disableOnInteraction":false},"effect":"fade","fadeEffect":{"crossFade":true},"loop":true,"slidesPerView":1,"spaceBetween":0,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"pagination":{"el":".swiper-pagination","type":"bullets","clickable":true}}'>
                <div class="swiper-wrapper">
                    <?php if ($settings['listdigikalabannercarouselkaveh']) : ?>
                        <?php foreach ($settings['listdigikalabannercarouselkaveh'] as $item) : ?>
                            <!-- Start Slide -->
                            <div class="swiper-slide">
                                <a href="<?php echo esc_url($item['linkdigikalabannercarouselkaveh']); ?>"
                                   class="d-block">
                                    <img src="<?php

                                    if (wp_is_mobile()) {
                                        if (isset($item['imgdigikalabannercarouselkaveh_tablet']['url'])) {
                                            echo esc_url($item['imgdigikalabannercarouselkaveh_tablet']['url']);
                                        } else {
                                            echo esc_url($item['imgdigikalabannercarouselkaveh']['url']);
                                        }
                                    } else if (wp_is_mobile()) {
                                        if (isset($item['imgdigikalabannercarouselkaveh_mobile']['url'])) {
                                            echo esc_url($item['imgdigikalabannercarouselkaveh_mobile']['url']);
                                        } elseif (isset($item['imgdigikalabannercarouselkaveh_tablet']['url'])) {
                                            echo esc_url($item['imgdigikalabannercarouselkaveh_tablet']['url']);
                                        } else {
                                            echo esc_url($item['imgdigikalabannercarouselkaveh']['url']);
                                        }
                                    } else {
                                        echo esc_url($item['imgdigikalabannercarouselkaveh']['url']);
                                    }
                                    ?>"
                                         alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt($item['imgdigikalabannercarouselkaveh'])); ?>"
                                         class="w-100 d-block">
                                </a>
                            </div>
                            <!-- End Slide -->
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
                <!-- Start Button -->
                <div class="swiper-button-next rounded-circle d-flex align-items-center justify-content-center fw-bold"></div>
                <div class="swiper-button-prev rounded-circle d-flex align-items-center justify-content-center fw-bold"></div>
                <!-- End Button -->
                <!-- Start Pagination -->
                <div class="swiper-pagination"></div>
                <!-- End Pagination -->
            </div>
            <!-- End Carousel -->
        </section>
        <style>
            <?php echo '.elementor-element-' . $clsid . ''; ?>
            .carousel-home-kala img {
                object-fit: cover;
                object-position: center;
            }
        </style>
        <?php do_action('kelementor_inline_scripts'); ?>
        <?php
    }

}
