<?php


use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Digikalaamazingofferonekaveh extends Widget_Base
{

    public function get_name()
    {
        return 'digikalaamazingofferonelkaveh';
    }

    public function get_title()
    {
        return esc_html__('المان پیشنهاد شگفت انگیز سبک یک - دیجی کالا', 'kaveh-core');
    }

    public function get_icon()
    {
        return 'eicon-archive-posts';
    }

    public function get_categories()
    {
        return ['kavehelements'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content1digikalaamazingofferonelkaveh',
            [
                'label' => esc_html__('تصاویر', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'img1digikalaamazingofferonelkaveh',
            [
                'label' => esc_html__('تصویر 1', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'img2digikalaamazingofferonelkaveh',
            [
                'label' => esc_html__('تصویر 2', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'content2digikalaamazingofferonelkaveh',
            [
                'label' => esc_html__('تنظیمات محصولات', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $options = array();
        $orderby = 'name';
        $order = 'asc';
        $hide_empty = true;
        $cat_args = array(
            'orderby' => $orderby,
            'order' => $order,
            'hide_empty' => $hide_empty,
        );

        $product_categories = get_terms('product_cat', $cat_args);

        foreach ($product_categories as $key => $category) {
            $options[$category->term_id] = $category->name;
        }
        $this->add_control(
            'catproductsdigikalaamazingofferonelkaveh',
            [
                'label' => esc_html__('انتخاب دسته بندی', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $options,
            ]
        );

        $this->add_control(
            'numberproductsdigikalaamazingofferonelkaveh',
            [
                'label' => esc_html__('تعداد محصولات نمایش داده شده', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 20,
                'step' => 1,
                'default' => 18,
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'content3digikalaamazingofferonelkaveh',
            [
                'label' => esc_html__('دکمه ها', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'button1digikalaamazingofferonelkaveh',
            [
                'label' => esc_html__('عنوان دکمه 1', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('مشاهده همه', 'kaveh-core'),
            ]
        );
        $this->add_control(
            'buttonlink1digikalaamazingofferonelkaveh',
            [
                'label' => esc_html__('لینک دکمه 1', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('#', 'kaveh-core'),

            ]
        );

        $this->add_control(
            'button2digikalaamazingofferonelkaveh',
            [
                'label' => esc_html__('عنوان دکمه مشاهده بیشتر', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('مشاهده همه', 'kaveh-core'),
            ]
        );
        $this->add_control(
            'buttonlink2digikalaamazingofferonelkaveh',
            [
                'label' => esc_html__('لینک دکمه مشاهده بیشتر', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('#', 'kaveh-core'),

            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style1_digikalaamazingofferonelkaveh',
            [
                'label' => esc_html__('استایل دکمه ها', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'button1_digikalaamazingofferonelkaveh',
                'label' => esc_html__('تایپوگرافی متن دکمه 1', 'kaveh-core'),
                'selector' => '{{WRAPPER}} .amazing-offer-kala-title a span',
            ]
        );

        $this->add_control(
            'textbutton1colordigikalaamazingofferonelkaveh',
            [
                'label' => esc_html__('رنگ نوشته دکمه 1', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .amazing-offer-kala-title a span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'button2_digikalaamazingofferonelkaveh',
                'label' => esc_html__('تایپوگرافی متن دکمه مشاهده بیشتر', 'kaveh-core'),
                'selector' => '{{WRAPPER}} .amazing-offer-kala-more span',
            ]
        );

        $this->add_control(
            'textbutton2colordigikalaamazingofferonelkaveh',
            [
                'label' => esc_html__('رنگ نوشته دکمه مشاهده بیشتر', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .amazing-offer-kala-more span' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icon2colordigikalaamazingofferonelkaveh',
            [
                'label' => esc_html__('رنگ آیکون دکمه مشاهده بیشتر', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#19bfd3',
                'selectors' => [
                    '{{WRAPPER}} .amazing-offer-kala-more i' => 'color: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_control(
            'iconborder2colordigikalaamazingofferonelkaveh',
            [
                'label' => esc_html__('رنگ حاشیه آیکون دکمه مشاهده بیشتر', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#19bfd3',
                'selectors' => [
                    '{{WRAPPER}} .amazing-offer-kala-more i' => 'border:1px solid  {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'style2_digikalaamazingoffertwokaveh',
            [
                'label' => esc_html__('استایل محصولات', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'bglableoffercolordigikalaamazingofferonelkaveh',
            [
                'label' => esc_html__('رنگ بکگراند لیبل تخفیف', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ef394e',
                'selectors' => [
                    '{{WRAPPER}} .product-nineteen .offer' => 'background-color: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_control(
            'lableoffercolordigikalaamazingofferonelkaveh',
            [
                'label' => esc_html__('رنگ متن لیبل تخفیف', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .product-nineteen .offer' => 'color: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_control(
            'bgprogresscolordigikalaamazingofferonelkaveh',
            [
                'label' => esc_html__('رنگ progress زمان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ef394e',
                'selectors' => [
                    '{{WRAPPER}} .product-nineteen .progress-time span' => 'background-color: {{VALUE}} !important',
                ],
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'style3_digikalaamazingofferonelkaveh',
            [
                'label' => esc_html__('استایل باکس', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'boxbgcolordigikalaamazingofferonelkaveh',
                'types' => ['gradient'],
                'selector' => '{{WRAPPER}} .amazing-offer-kala-wrapper',
            ]
        );

        $this->add_control(
            'boxradiusdigikalaamazingofferonelkaveh',
            [
                'label' => esc_html__('گوشه خمیده', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .amazing-offer-kala-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'style3_digikalaamazingofferonelkaveh',
            [
                'label' => esc_html__('استایل جهت های کاروسل', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'arrowscolordigikalaamazingofferonelkaveh',
            [
                'label' => esc_html__('رنگ  بکگراند جهت های کاروسل', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-next' => 'background-color: {{VALUE}} !important;',
                    '{{WRAPPER}}  .swiper-button-prev' => 'background-color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_control(
            'arrowscoloricondigikalaamazingofferonelkaveh',
            [
                'label' => esc_html__('رنگ  آیکن جهت های کاروسل', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#3f4064',
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-next::after' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .swiper-button-prev::after' => 'color: {{VALUE}} !important;',
                ]
            ]
        );

        $this->add_control(
            'title1_options',
            [
                'label' => esc_html__('حاشیه جهت قبل', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'borderarrowprevdigikalaamazingofferonelkaveh',
                'selector' => '{{WRAPPER}} .swiper-button-prev'
            ]
        );

        $this->add_control(
            'title2_options',
            [
                'label' => esc_html__('حاشیه جهت بعد', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'borderarrownextdigikalaamazingofferonelkaveh',
                'selector' => '{{WRAPPER}} .swiper-button-next'
            ]
        );
        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $clsid = $this->get_id();
        ?>
        <!-- Start Amazing Offer -->
        <section class="amazing-offer-kala">
            <div class="container">
                <div class="amazing-offer-kala-wrapper">
                    <!-- Start Carousel -->
                    <div class="swiper swiper-amazing-offer-kala position-relative overflow-hidden swiper-kala" data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":1.8,"spaceBetween":2},"400":{"slidesPerView":2.3,"spaceBetween":2},"500":{"slidesPerView":2.8,"spaceBetween":2},"576":{"slidesPerView":3.1,"spaceBetween":2},"768":{"slidesPerView":4.1,"spaceBetween":2},"992":{"slidesPerView":5.5,"spaceBetween":2},"1200":{"slidesPerView":6.1,"spaceBetween":2},"1400":{"slidesPerView":7.1,"spaceBetween":2}}}'>
                        <div class="swiper-wrapper">
                            <!-- Start Slide -->
                            <div class="swiper-slide">
                                <div class="amazing-offer-kala-title d-flex flex-column justify-content-center">
                                    <a href="<?php echo esc_url($settings['buttonlink1digikalaamazingofferonelkaveh']); ?>"
                                       class="d-block w-100">
                                        <img src="<?php echo esc_url($settings['img1digikalaamazingofferonelkaveh']['url']); ?>"
                                             alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt($settings['img1digikalaamazingofferonelkaveh'])); ?>"
                                             width="92"
                                             height="77" class="d-block mx-auto">
                                        <img src="<?php echo esc_url($settings['img2digikalaamazingofferonelkaveh']['url']); ?>"
                                             alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt($settings['img2digikalaamazingofferonelkaveh'])); ?>"
                                             width="145"
                                             height="115" class="mt-2 d-block mx-auto">
                                        <span class="d-flex align-items-center justify-content-center mt-1">
                                            <?php echo esc_html($settings['button1digikalaamazingofferonelkaveh']); ?>
                  <i class="icon-angle-left ms-1"></i>
                </span>
                                    </a>
                                </div>
                            </div>
                            <!-- End Slide -->
                            <?php
                            // WP_Query args
                            $cat_query_args = array(
                                'post_type' => array('product'),
'post_status' => array('publish'),
                                'posts_per_page' => $settings['numberproductsdigikalaamazingofferonelkaveh'],
                                'order' => 'DESC',
                                'orderby' => 'date',
                                'tax_query' => array(
                                    array(
                                        'taxonomy' => 'product_cat',
                                        'field' => 'term_id',
                                        'terms' => $settings['catproductsdigikalaamazingofferonelkaveh'],
                                    ),
                                ),
                                'meta_query' => array(
                                    array(
                                        'key' => '_stock_status',
                                        'value' => 'outofstock',
                                        'compare' => 'NOT IN',
                                    ),
                                ),
                            );
                            $cat_query_args['post__in'] = array_merge(array(0), wc_get_product_ids_on_sale());
                            // The Query
                            $pcat_query = new \WP_Query($cat_query_args);

                            // The Loop
                            if ($pcat_query->have_posts()) :?>
                                <?php while ($pcat_query->have_posts()) :
                                    $pcat_query->the_post();
                                    $product = wc_get_product(get_the_ID());
                                    $sale_price = $product->get_sale_price();
                                    $normal_price = $product->get_regular_price();
                                    ?>
                                    <!-- Start Slide -->
                                    <div class="swiper-slide h-auto">
                                        <div class="product-nineteen d-flex flex-column position-relative bg-white h-100">
                                            <a href="<?php the_permalink(); ?>" class="stretched-link"
                                               aria-label="name product"></a>
                                            <img src="<?php the_post_thumbnail_url('thumbnail'); ?>"
                                                 alt="<?php the_title(); ?>"
                                                 width="150"
                                                 height="150" class="d-block mx-auto">
                                            <div class="d-flex align-items-center justify-content-between mt-3">
                                                <span class="offer d-flex align-items-center justify-content-center rounded-4 fw-bold">
                                                    <?php if (class_exists('kavehWoo')) {
                                                        $offer_percentage = kavehWoo::showofferpercentage($product);
                                                        echo $offer_percentage;
                                                    } ?>
                                                </span>
                                                <div class="price d-flex align-items-center fw-bold">
                                                    <?php
                                                    if ($product->is_type('simple')) {
                                                        echo number_format($sale_price, 0, '.', ',');
                                                    } elseif ($product->is_type('variable')) {
                                                        $max_percentage = 0;
                                                        $child_id_with_max_discount = 0;
                                                        foreach ($product->get_children() as $child_id) {
                                                            $variation = wc_get_product($child_id);
                                                            $price = (float)$variation->get_regular_price();
                                                            $sale = (float)$variation->get_sale_price();
                                                            if ($price != 0 && !empty($sale)) $percentage = ($price - $sale) / $price * 100;
                                                            if ($percentage > $max_percentage) {
                                                                $max_percentage = $percentage;
                                                                $child_id_with_max_discount = $child_id;
                                                            }
                                                        }
                                                        $sale_price_v = (float)wc_get_product($child_id_with_max_discount)->get_sale_price();
                                                        echo number_format($sale_price_v, 0, '.', ',');
                                                    }
                                                    ?>
                                                    <i class="icon-toman-2"></i>
                                                </div>
                                            </div>
                                            <del class="last-price text-end d-block">
                                                <?php
                                                if ($product->is_type('simple')) {
                                                    echo number_format($normal_price, 0, '.', ',');
                                                } elseif ($product->is_type('variable')) {
                                                    $max_percentage = 0;
                                                    $child_id_with_max_discount = 0;
                                                    foreach ($product->get_children() as $child_id) {
                                                        $variation = wc_get_product($child_id);
                                                        $price = (float)$variation->get_regular_price();
                                                        $sale = (float)$variation->get_sale_price();
                                                        if ($price != 0 && !empty($sale)) $percentage = ($price - $sale) / $price * 100;
                                                        if ($percentage > $max_percentage) {
                                                            $max_percentage = $percentage;
                                                            $child_id_with_max_discount = $child_id;
                                                        }
                                                    }
                                                    $normal_price_v = (float)wc_get_product($child_id_with_max_discount)->get_regular_price();
                                                    echo number_format($normal_price_v, 0, '.', ',');
                                                }
                                                ?>
                                            </del>
                                            <?php
                                            if ($product->is_type('simple')) {
                                                $product_id = $product->get_id();

                                                $sale_start_date = get_post_meta($product_id, '_sale_price_dates_from', true);
                                                $sale_end_date = get_post_meta($product_id, '_sale_price_dates_to', true);

                                                if (!empty($sale_start_date) && !empty($sale_end_date)) { ?>
                                                    <div class="progress-time position-relative mt-2 overflow-hidden rounded-pill">
                                                    <span class="position-absolute top-0 end-0 rounded-pill h-100"
                                                          style="width:<?php
                                                          $current_time = current_time('timestamp');
                                                          $total_time = $sale_end_date - $sale_start_date;
                                                          $time_remaining = $sale_end_date - $current_time;
                                                          if ($time_remaining >= 0 && $total_time > 0) {
                                                              $percentage_remaining = ($time_remaining / $total_time) * 100;
                                                              echo round($percentage_remaining, 2);
                                                          }
                                                          ?>%"></span>
                                                    </div>
                                                    <?php
                                                } else {
                                                }
                                            } elseif ($product->is_type('variable')) {
                                                $max_percentage = 0;
                                                $child_id_with_max_discount = 0;
                                                foreach ($product->get_children() as $child_id) {
                                                    $variation = wc_get_product($child_id);
                                                    $price = (float)$variation->get_regular_price();
                                                    $sale = (float)$variation->get_sale_price();
                                                    if ($price != 0 && !empty($sale)) $percentage = ($price - $sale) / $price * 100;
                                                    if ($percentage > $max_percentage) {
                                                        $max_percentage = $percentage;
                                                        $child_id_with_max_discount = $child_id;
                                                    }
                                                }
                                                $sale_start_date = get_post_meta($child_id_with_max_discount, '_sale_price_dates_from', true);
                                                $sale_end_date = get_post_meta($child_id_with_max_discount, '_sale_price_dates_to', true);
                                                if (!empty($sale_start_date) && !empty($sale_end_date)) { ?>
                                                    <div class="progress-time position-relative mt-2 overflow-hidden rounded-pill">
                                                    <span class="position-absolute top-0 end-0 rounded-pill h-100"
                                                          style="width:<?php
                                                          $current_time = current_time('timestamp');
                                                          $total_time = $sale_end_date - $sale_start_date;
                                                          $time_remaining = $sale_end_date - $current_time;
                                                          if ($time_remaining >= 0 && $total_time > 0) {
                                                              $percentage_remaining = ($time_remaining / $total_time) * 100;
                                                              echo round($percentage_remaining, 2);
                                                          }
                                                          ?>%"></span>
                                                    </div>
                                                    <?php
                                                } else {
                                                }
                                            }
                                            ?>
                                        </div>
                                    </div>
                                    <!-- End Slide -->
                                <?php
                                endwhile;
                                // Reset Original Post Data after the loop
                                wp_reset_postdata();
                                ?>
                            <?php endif; ?>
                            <!-- Start Slide -->
                            <div class="swiper-slide h-auto">
                                <a href="<?php echo esc_url($settings['buttonlink2digikalaamazingofferonelkaveh']); ?>"
                                   class="amazing-offer-kala-more bg-white d-flex align-items-center justify-content-center flex-column h-100">
                                    <i class="icon-arrow-left-4 rounded-circle d-flex align-items-center justify-content-center fs-5"></i>
                                    <span><?php echo esc_html($settings['button2digikalaamazingofferonelkaveh']); ?></span>
                                </a>
                            </div>
                            <!-- End Slide -->
                        </div>
                        <!-- Start Button -->
                        <div class="swiper-button-next d-none d-sm-flex align-items-center justify-content-center rounded-circle bg-white">
                        </div>
                        <div class="swiper-button-prev d-none d-sm-flex align-items-center justify-content-center rounded-circle bg-white">
                        </div>
                        <!-- End Button -->
                    </div>
                    <!-- End Carousel -->
                </div>
            </div>
        </section>
        <?php do_action('kelementor_inline_scripts'); ?>
        <?php
    }

}
