<?php


use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Digikalaamazingoffermarketkaveh extends Widget_Base
{

    public function get_name()
    {
        return 'digikalaamazingoffermarketkaveh';
    }

    public function get_title()
    {
        return esc_html__('المان پیشنهاد شگفت انگیز سوپرمارکتی دیجی کالا', 'kaveh-core');
    }

    public function get_icon()
    {
        return 'eicon-archive-posts';
    }

    public function get_categories()
    {
        return ['kavehelements'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'contentdigikalaamazingoffermarketkaveh',
            [
                'label' => esc_html__('تصاویر', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'img1digikalaamazingoffermarketkaveh',
            [
                'label' => esc_html__('تصویر 1', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'img2digikalaamazingoffermarketkaveh',
            [
                'label' => esc_html__('تصویر 2', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'bgimgdigikalaamazingoffermarketkaveh',
            [
                'label' => esc_html__('تصویر بکگراند', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'selectors' => [
                    '{{WRAPPER}} .amazing-market-kala-wrapper' =>
                        'background: url({{URL}}) left center no-repeat !important',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content1digikalaamazingoffermarketkaveh',
            [
                'label' => esc_html__('محتوای لیبل تخفیف', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'textofferdigikalaamazingoffermarketkaveh',
            [
                'label' => esc_html__('محتوا', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('تا ۴۷٪ تخفیف', 'kaveh-core'),

            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content2digikalaamazingoffermarketkaveh',
            [
                'label' => esc_html__('تنظیمات محصولات', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $options = array();
        $orderby = 'name';
        $order = 'asc';
        $hide_empty = true;
        $cat_args = array(
            'orderby' => $orderby,
            'order' => $order,
            'hide_empty' => $hide_empty,
        );

        $product_categories = get_terms('product_cat', $cat_args);

        foreach ($product_categories as $key => $category) {
            $options[$category->term_id] = $category->name;
        }
        $this->add_control(
            'catproductsdigikalaamazingoffermarketkaveh',
            [
                'label' => esc_html__('انتخاب دسته بندی', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $options,
            ]
        );
        $this->add_control(
            'numberproductsdigikalaamazingoffermarketkaveh',
            [
                'label' => esc_html__('تعداد محصولات نمایش داده شده', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 20,
                'step' => 1,
                'default' => 12,
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'content3digikalaamazingoffermarketkaveh',
            [
                'label' => esc_html__('دکمه ها', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'buttondigikalaamazingoffermarketkaveh',
            [
                'label' => esc_html__('عنوان دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('بیش از ۹۰ کالا', 'kaveh-core'),
            ]
        );
        $this->add_control(
            'iconbuttondigikalaamazingoffermarketkaveh',
            [
                'label' => esc_html__('آیکون', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'skin' => 'inline',
                'exclude_inline_options' => ['svg'],
                'default' => [
                    'value' => 'fas fa-arrow-left',
                ],
            ]
        );
        $this->add_control(
            'buttonlinkdigikalaamazingoffermarketkaveh',
            [
                'label' => esc_html__('لینک دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('#', 'kaveh-core'),

            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_digikalaamazingoffermarketkaveh',
            [
                'label' => esc_html__('استایل لیبل تخفیف', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'textcolor1digikalaamazingoffermarketkaveh',
            [
                'label' => esc_html__('رنگ متن', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .amazing-market-kala-wrapper .right span' => 'color: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_control(
            'textcolor2digikalaamazingoffermarketkaveh',
            [
                'label' => esc_html__('رنگ بکگراند', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#39ae00',
                'selectors' => [
                    '{{WRAPPER}} .amazing-market-kala-wrapper .right span' => 'background-color: {{VALUE}} !important',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style2_digikalaamazingoffermarketkaveh',
            [
                'label' => esc_html__('استایل دکمه', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'textbutton1colordigikalaamazingoffermarketkaveh',
            [
                'label' => esc_html__('رنگ نوشته دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#39ae00',
                'selectors' => [
                    '{{WRAPPER}} .amazing-market-kala-wrapper .left .btn' => 'color: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_control(
            'button1colordigikalaamazingoffermarketkaveh',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .amazing-market-kala-wrapper .left .btn' => 'background-color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'buttoniconradius2digikalaamazingoffermarketkaveh',
            [
              'label' => esc_html__( 'گوشه خمیده پس زمینه دکمه', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::DIMENSIONS,
              'size_units' => [ 'px' ],
              'selectors' => [
                '{{WRAPPER}} .amazing-market-kala-wrapper .right span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
              ],
            ]
          );
        $this->end_controls_section();

        $this->start_controls_section(
            'style3_digikalaamazingoffermarketkaveh',
            [
                'label' => esc_html__('استایل لیبل تخفیف روی محصول', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'textoffercolordigikalaamazingoffermarketkaveh',
            [
                'label' => esc_html__('رنگ نوشته', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .amazing-market-kala-item span' => 'color: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_control(
            'offercolordigikalaamazingoffermarketkaveh',
            [
                'label' => esc_html__('رنگ پس زمینه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ef394e',
                'selectors' => [
                    '{{WRAPPER}} .amazing-market-kala-item span' => 'background-color: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'style4_boxdigikalaamazingoffermarketkaveh',
            [
                'label' => esc_html__('استایل باکس اصلی', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'bgcolordigikalaamazingoffermarketkaveh',
            [
                'label' => esc_html__('رنگ پس زمینه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#f1f2f4',
                'selectors' => [
                    '{{WRAPPER}} .amazing-market-kala-wrapper' => 'background-color: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_responsive_control(
            'boxbgradiusdigikalaamazingoffermarketkaveh',
            [
                'label' => esc_html__('گوشه خمیده', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .amazing-market-kala-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $clsid = $this->get_id();
        ?>

        <!-- Start Amazing Market -->
        <section class="amazing-market-kala">
            <div class="container">
                <div class="amazing-market-kala-wrapper d-flex align-items-lg-center justify-content-lg-between position-relative flex-column flex-lg-row gap-4 gap-lg-0">
                    <div class="right d-flex align-items-center">
                        <img src="<?php echo esc_url($settings['img1digikalaamazingoffermarketkaveh']['url']); ?>"
                             alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt($settings['img1digikalaamazingoffermarketkaveh'])); ?>"
                             width="66" height="62">
                        <img src="<?php echo esc_url($settings['img2digikalaamazingoffermarketkaveh']['url']); ?>"
                             alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt($settings['img2digikalaamazingoffermarketkaveh'])); ?>"
                             width="250" height="28">
                        <span class="fw-bold rounded-pill"><?php echo esc_html($settings['textofferdigikalaamazingoffermarketkaveh']); ?></span>
                    </div>
                    <div class="left d-flex align-items-center w-100 flex-column flex-sm-row gap-4 gap-sm-0">
                        <!-- Start Carousel -->
                        <div class="swiper swiper-amazing-market-kala overflow-hidden me-2 w-100" data-swiper='{"breakpoints":{"320":{"slidesPerView":3,"spaceBetween":12},"400":{"slidesPerView":4,"spaceBetween":12},"500":{"slidesPerView":5,"spaceBetween":12},"576":{"slidesPerView":5,"spaceBetween":12},"768":{"slidesPerView":6,"spaceBetween":12}}}'>
                            <div class="swiper-wrapper">
                                <?php
                                // WP_Query args
                                $cat_query_args = array(
                                    'post_type' => array('product'),
'post_status' => array('publish'),
                                    'posts_per_page' => $settings['numberproductsdigikalaamazingoffermarketkaveh'],
                                    'order' => 'DESC',
                                    'orderby' => 'date',
                                    'tax_query' => array(
                                        array(
                                            'taxonomy' => 'product_cat',
                                            'field' => 'term_id',
                                            'terms' => $settings['catproductsdigikalaamazingoffermarketkaveh'],
                                        ),
                                    ),
                                    'meta_query' => array(
                                        array(
                                            'key' => '_stock_status',
                                            'value' => 'outofstock',
                                            'compare' => 'NOT IN',
                                        ),
                                    ),
                                );
                                $cat_query_args['post__in'] = array_merge(array(0), wc_get_product_ids_on_sale());
                                // The Query
                                $pcat_query = new \WP_Query($cat_query_args);

                                // The Loop
                                if ($pcat_query->have_posts()) :?>
                                    <?php while ($pcat_query->have_posts()) :
                                        $pcat_query->the_post();
                                        $product = wc_get_product(get_the_ID());
                                        ?>
                                        <div class="swiper-slide">
                                            <a href="<?php the_permalink(); ?>"
                                               class="amazing-market-kala-item position-relative rounded-circle bg-white p-2 d-flex align-items-center justify-content-center fw-bold">
                                                <img src="<?php the_post_thumbnail_url('thumbnail'); ?>"
                                                     alt="<?php the_title(); ?>" class="rounded-circle">
                                                <span class="position-absolute rounded-pill d-flex align-items-center justify-content-center px-1 start-0 bottom-0">
                                                    <?php if (class_exists('kavehWoo')) {
                                                        $offer_percentage = kavehWoo::showofferpercentage($product);
                                                        echo $offer_percentage;
                                                    } ?>
                                                </span>
                                            </a>
                                        </div>
                                    <?php
                                    endwhile;
                                    // Reset Original Post Data after the loop
                                    wp_reset_postdata();
                                    ?>
                                <?php endif; ?>
                            </div>
                        </div>
                        <!-- End Carousel -->
                        <a href="<?php echo esc_url($settings['buttonlinkdigikalaamazingoffermarketkaveh']); ?>"
                           class="btn d-flex align-items-center justify-content-center rounded-pill text-nowrap fw-bold">
                            <?php echo esc_html($settings['buttondigikalaamazingoffermarketkaveh']); ?>
                            <i class="<?php echo esc_attr($settings['iconbuttondigikalaamazingoffermarketkaveh']['value']); ?> ms-2"></i>
                        </a>
                    </div>
                </div>
            </div>
        </section>

        <style>
            <?php echo '.elementor-element-' . $clsid . ''; ?>
            .amazing-market-kala-item img {
                width: 58px !important;
                height: 58px !important;
            }
        </style>
       <?php do_action('kelementor_inline_scripts'); ?>
        <?php
    }

}
