<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Customerreviewlkaveh extends Widget_Base{

  public function get_name(){
    return 'customerreviewlkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل نظرات مشتریان', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentcustomerreviewlkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'titlecustomerreviewlkaveh',
        [
          'label' => esc_html__( 'عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => ' نظرات جدید ',
  
        ]
      ); 
      $this->add_control(
        'tagheadingtacustomerreviewlkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H5',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
      'title1customerreviewlkaveh',
      [
        'label' => esc_html__( 'نام مشتری', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'احمد یوسفوند',

      ]
    );
    $repeater->add_control(
      'title2customerreviewlkaveh',
      [
        'label' => esc_html__( 'عنوان جایگاه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'شغل',

      ]
    ); 
    $repeater->add_control(
      'title3customerreviewlkaveh',
      [
        'label' => esc_html__( 'جایگاه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'طراح گرافیست',

      ]
    );
    $repeater->add_control(
      'datecustomerreviewlkaveh',
      [
        'label' => esc_html__( 'تاریخ', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '۱۴۰۰/۰۶/۱۳',

      ]
    );
    $repeater->add_control(
      'desccustomerreviewlkaveh',
      [
        'label' => esc_html__( 'نظر', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => ' این مجموعه کالا های خود را بدون واسطه و از طریق شرکت های اصلی سازنده کیف پول های سخت افزاری به صورت مستقیم تامین می کند و همچنین ضمانت اصالت و سلامت کالا را به تمام مشتریان ارائه می دهد.',
      ]
    );
    $this->add_control(
      'listcustomerreviewlkaveh',
      [
        'label' => esc_html__( 'نظرات مشتریان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'title1customerreviewlkaveh' => esc_html__( 'احمد یوسفوند', 'kaveh-core' ),
            'title2customerreviewlkaveh' => esc_html__( 'شغل', 'kaveh-core' ),
            'title3customerreviewlkaveh' => esc_html__( 'طراح گرافیست', 'kaveh-core' ),
            'datecustomerreviewlkaveh' => esc_html__( '۱۴۰۰/۰۶/۱۳', 'kaveh-core' ),
            'desccustomerreviewlkaveh' => esc_html__( ' این مجموعه کالا های خود را بدون واسطه و از طریق شرکت های اصلی سازنده کیف پول های سخت افزاری به صورت مستقیم تامین می کند و همچنین ضمانت اصالت و سلامت کالا را به تمام مشتریان ارائه می دهد.', 'kaveh-core' ),
          ],
      ]
      ]
    
    );
       $this->end_controls_section();
       $this->start_controls_section(
        'style1_customerreviewlkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'titlestcustomerreviewlkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-comments-title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_customerreviewlkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-comments-title',
        ]
      );

      $this->end_controls_section();
      $this->start_controls_section(
        'style2_customerreviewlkaveh',
        [
          'label' => esc_html__( 'استایل نظر', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'title1stcustomerreviewlkaveh',
        [
          'label' => esc_html__( 'رنگ نام مشتری', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-comments-item .name' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title1_customerreviewlkaveh',
          'label' => esc_html__( 'تایپوگرافی نام مشتری', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-comments-item .name',
        ]
      );
      $this->add_control(
        'title2stcustomerreviewlkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان جایگاه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-comments-item .position ' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title2_customerreviewlkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان جایگاه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-comments-item .position ',
        ]
      );
      $this->add_control(
        'title3stcustomerreviewlkaveh',
        [
          'label' => esc_html__( 'رنگ جایگاه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-comments-item .position b i' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title3_customerreviewlkaveh',
          'label' => esc_html__( 'تایپوگرافی جایگاه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-comments-item .position b i',
        ]
      );
      $this->add_control(
        'title4stcustomerreviewlkaveh',
        [
          'label' => esc_html__( 'رنگ تاریخ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-comments-item .time' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title4_customerreviewlkaveh',
          'label' => esc_html__( 'تایپوگرافی تاریخ', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-comments-item .time',
        ]
      );
      $this->add_control(
        'datewidthcustomerreviewlkaveh',
        [
          'label' => esc_html__( 'عرض دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 480,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .new-comments-item .time' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'buttonpaddingtcustomerreviewlkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .new-comments-item .time' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'buttonradiustcustomerreviewlkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .new-comments-item .time' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'bgcolortcustomerreviewlkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-comments-item .time' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'title5stcustomerreviewlkaveh',
        [
          'label' => esc_html__( 'رنگ پیام', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-comments-item p' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title5_customerreviewlkaveh',
          'label' => esc_html__( 'تایپوگرافی پیام', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-comments-item p',
        ]
      );
      $this->add_control(
        'bgcolort2customerreviewlkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه باکس اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-comments' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonpadding2tcustomerreviewlkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی باکس اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .new-comments' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();

          
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
<section class="new-comments position-relative">
    <div class="container">
      <<?php echo  esc_html($settings['tagheadingtacustomerreviewlkaveh']); ?> class="new-comments-title mx-auto position-relative"> <?php echo  esc_html($settings['titlecustomerreviewlkaveh']); ?> </<?php echo  esc_html($settings['tagheadingtacustomerreviewlkaveh']); ?>>
      <div class="swiper swiper-new-comments overflow-hidden" data-swiper='{"slidesPerView":1,"spaceBetween":0,"autoplay":{"delay":5000,"disableOnInteraction":false,"pauseOnMouseEnter":true},"loop":true}'>
        <div class="swiper-wrapper">
            <?php
            if ( $settings['listcustomerreviewlkaveh'] ) {
            foreach (  $settings['listcustomerreviewlkaveh'] as $item ) {
            ?>
          <div class="swiper-slide">
            <div class="new-comments-item">
              <i class="icon-user"></i>
              <div class="name"> <?php echo  esc_html($item['title1customerreviewlkaveh']); ?> </div>
              <div class="position">
                <b>
                    <?php echo  esc_html($item['title2customerreviewlkaveh']); ?>
                  <i>  <?php echo  esc_html($item['title3customerreviewlkaveh']); ?> </i>
                </b>
              </div>
              <div class="time"> <?php echo  esc_html($item['datecustomerreviewlkaveh']); ?> </div>
              <p> <?php echo  esc_html($item['desccustomerreviewlkaveh']); ?></p>
            </div>
          </div>
          <?php 
        }
          }
        ?>
        </div>
      </div>
    </div>
  </section>
  <?php do_action('kelementor_inline_scripts'); ?>       
    <?php
  }


}
