<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Counterkaveh extends Widget_Base{

  public function get_name(){
    return 'counterkaveh';
  }

  public function get_title(){
    return esc_html__( 'المان شمارنده', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentcounterkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'iconcounterkaveh',
        [
          'label' => esc_html__( 'آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::ICONS,
          'skin' => 'inline',
          'exclude_inline_options' => [ 'svg' ],
          'default' => [
            'value' => 'icon-phone',
          ],
        ]
      ); 
        $this->add_control(
          'beforetitlecounterkaveh',
          [
              'label' => esc_html__( 'عنوان', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'شماره تماس', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'countcounterkaveh',
        [
            'label' => esc_html__( 'عدد', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'min' => 2,
            'step' => 1,
            'default' => 50,    
        ]
    ); 

        $this->end_controls_section();
        $this->start_controls_section(
          'style_counterkaveh',
          [
            'label' => esc_html__( 'استایل', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          ]
        );
        $this->add_control(
          'iconsize1counterkaveh',
          [
            'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 200,
                'step' => 1,
              ],
              '%' => [
                'min' => 0,
                'max' => 100,
              ],
            ],
            'selectors' => [
              '{{WRAPPER}} .about-us-statistics-item i' => 'font-size: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
        $this->add_control(
          'iconbgwidthcounterkaveh',
          [
            'label' => esc_html__( 'عرض پس زمینه آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 200,
                'step' => 1,
              ],
              '%' => [
                'min' => 0,
                'max' => 100,
              ],
            ],
            'selectors' => [
              '{{WRAPPER}} .about-us-statistics-item i' => 'width: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
        $this->add_control(
          'iconbgheightcounterkaveh',
          [
            'label' => esc_html__( 'ارتفاع پس زمینه آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 200,
                'step' => 1,
              ],
              '%' => [
                'min' => 0,
                'max' => 100,
              ],
            ],
            'selectors' => [
              '{{WRAPPER}} .about-us-statistics-item i' => 'height: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
        $this->start_controls_tabs(
          'stylebox2_tabscounterkaveh'
        );
        
        $this->start_controls_tab(
          'stylebox2_tabcounterkaveh',
          [
            'label' => esc_html__( 'عادی', 'kaveh-core' ),
          ]
        );
        $this->add_control(
                'iconcolor1counterkaveh',
                [
                  'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
                  'type' => \Elementor\Controls_Manager::COLOR,
                  'selectors' => [
                    '{{WRAPPER}} .about-us-statistics-item i' => 'color: {{VALUE}}',
                  ],
                ]
              );
              $this->add_control(
                'iconbg1counterkaveh',
                [
                  'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
                  'type' => \Elementor\Controls_Manager::COLOR,
                  'selectors' => [
                    '{{WRAPPER}} .about-us-statistics-item i' => 'background-color: {{VALUE}}',
                  ],
                ]
              );
        
        $this->end_controls_tab();
        $this->start_controls_tab(
          'styleboxhove2_tabcounterkaveh',
          [
            'label' => esc_html__( 'هاور', 'kaveh-core' ),
          ]
        );
        $this->add_control(
                'iconcolorhover1counterkaveh',
                [
                  'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
                  'type' => \Elementor\Controls_Manager::COLOR,
                  'selectors' => [
                    '{{WRAPPER}} .about-us-statistics-item:hover i' => 'color: {{VALUE}}',
                  ],
                ]
              );
              $this->add_control(
                'iconbghover1counterkaveh',
                [
                  'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
                  'type' => \Elementor\Controls_Manager::COLOR,
                  'selectors' => [
                    '{{WRAPPER}} .about-us-statistics-item:hover i' => 'background-color: {{VALUE}}',
                  ],
                ]
              );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
          'hr',
          [
            'type' => \Elementor\Controls_Manager::DIVIDER,
          ]
        );
        $this->add_control(
          'countstcolor1counterkaveh',
          [
            'label' => esc_html__( 'رنگ عدد', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .about-us-statistics-item .count' => 'color: {{VALUE}}',
            ],
          ]
        );
        $this->add_group_control(
          \Elementor\Group_Control_Typography::get_type(),
          [
            'name' => 'countsttypecounterkaveh',
            'label' => esc_html__( 'تایپوگرافی عدد', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .about-us-statistics-item .count',
          ]
        );
        $this->add_control(
          'titlecolor1counterkaveh',
          [
            'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .about-us-statistics-item .title' => 'color: {{VALUE}}',
            ],
          ]
        );
        $this->add_group_control(
          \Elementor\Group_Control_Typography::get_type(),
          [
            'name' => 'titletypecounterkaveh',
            'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .about-us-statistics-item .title',
          ]
        );
        $this->end_controls_section();
          
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
  
?>
            <div class="about-us-statistics-item text-center">
              <i class="<?php echo  esc_attr($settings['iconcounterkaveh']['value']); ?> d-flex align-items-center justify-content-center rounded-circle mx-auto"></i>
              <div class="count"> <?php echo  esc_html($settings['countcounterkaveh']); ?> </div>
              <div class="title mt-1"> <?php echo  esc_html($settings['beforetitlecounterkaveh']); ?> </div>
            </div>
    <?php
  }


}
