<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
  exit; // Exit if accessed directly

class class__landing__slider__kaveh extends Widget_Base
{

  public function get_name()
  {
    return 'class__landing__slider__kaveh';
  }

  public function get_title()
  {
    return esc_html__('سکشن لندیگ', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['kavehelements'];
  }

  protected function register_controls()
  {
    $this->start_controls_section(
      'Cat__item',
      [
        'label' => esc_html__('اسلایدر سکشن لندینگ', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $repeater = new \Elementor\Repeater();
    $repeater->add_control(
      'Cat__loop__image',
      [
        'label' => esc_html__('تصویر اسلایدر', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
          'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $this->add_control(
      'Cat__loop',
      [
        'label' => esc_html__('تصاویر اسلایدر', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'landing__section__details',
      [
        'label' => esc_html__('اطلاعات بخش لندینگ', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'subtitle',
      [
        'label' => esc_html__('عنوان فرعی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('All kinds of studio laptops', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'main__title',
      [
        'label' => esc_html__('عنوان اصلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('انواع شیرابه های زینتی و زیبای اخوان', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'main__title__format',
      [
        'label' => esc_html__('تگ HTML عنوان اصلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H3',
        'options' => [
          'H1' => esc_html__('H1', 'kaveh-core'),
          'H2' => esc_html__('H2', 'kaveh-core'),
          'H3' => esc_html__('H3', 'kaveh-core'),
          'H4' => esc_html__('H4', 'kaveh-core'),
          'H5' => esc_html__('H5', 'kaveh-core'),
          'H6' => esc_html__('H6', 'kaveh-core'),
          'p' => esc_html__('p', 'kaveh-core'),
          'div' => esc_html__('div', 'kaveh-core'),
        ],
      ]
    );
    $this->add_control(
      'section__details',
      [
        'label' => esc_html__('متن', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => esc_html__('متن مورد نظر شما', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'btn__more',
      [
        'label' => esc_html__('متن دکمه بیشتر', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('اطلاعات بیشتر', 'kaveh-core'),
      ]
    );
    $this->add_control(
      'link__btn__more',
      [
        'label' => esc_html__('متن دکمه بیشتر', 'textdomain'),
        'type' => \Elementor\Controls_Manager::URL,
        'options' => ['url', 'is_external', 'nofollow'],
        'default' => [
          'url' => '#',
          'is_external' => true,
          'nofollow' => true,
          // 'custom_attributes' => '',
        ],
        'label_block' => true,
      ]
    );
    $this->add_control(
      'btn__contact',
      [
        'label' => esc_html__('متن دکمه تماس', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('تماس با پشتیبانی', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'link__btn__contact',
      [
        'label' => esc_html__('لینک دکمه تماس', 'textdomain'),
        'type' => \Elementor\Controls_Manager::URL,
        'options' => ['url', 'is_external', 'nofollow'],
        'default' => [
          'url' => '#',
          'is_external' => true,
          'nofollow' => true,
          // 'custom_attributes' => '',
        ],
        'label_block' => true,
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style',
      [
        'label' => esc_html__('استایل', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'slider__bg',
      [
        'label' => esc_html__('رنگ پس زمینه آیتم', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'description' => 'رنگ سکشن لندیگ',
        'selectors' => [
          '{{WRAPPER}} .landing-seventeen::before' =>
            'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'subtitle__style',
        'label' => esc_html__('تایپوگرافی عنوان فرعی', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .landing-seventeen .sup-title',
      ]
    );
    $this->add_control(
      'subtitle__color',
      [
        'label' => esc_html__('رنگ عنوان فرعی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .landing-seventeen .sup-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'main__title__style',
        'label' => esc_html__('تایپوگرافی عنوان اصلی', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .landing-seventeen .title',
      ]
    );
    $this->add_control(
      'main__title__color',
      [
        'label' => esc_html__('رنگ عنوان اصلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .landing-seventeen .title' => 'color: {{VALUE}} !important',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'section__details__style',
        'label' => esc_html__('تایپوگرافی متن', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .landing-seventeen p',
      ]
    );
    $this->add_control(
      'section__details__color',
      [
        'label' => esc_html__('رنگ عنوان متن', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .landing-seventeen p' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'btn__style',
      [
        'label' => esc_html__('تنظیمات دکمه ها', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'btn__more__style',
        'label' => esc_html__('تایپوگرافی دکمه بیشتر', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .landing-seventeen .btns .btn:first-child',
      ]
    );
    $this->add_control(
      'btn__more__color',
      [
        'label' => esc_html__('رنگ عنوان دکمه بیشتر', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .landing-seventeen .btns .btn:first-child' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn__more__style__padding',
      [
        'label' => esc_html__('فاصله داخلی', 'textdomain'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'default' => [
          'top' => 13,
          'right' => 26,
          'bottom' => 13,
          'left' => 26,
          'unit' => 'px',
          'isLinked' => false,
        ],
        'selectors' => [
          '{{WRAPPER}} .landing-seventeen .btns .btn:first-child' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'btn__more__style__margin',
      [
        'label' => esc_html__('فاصله بیرونی', 'textdomain'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'default' => [
          'top' => 0,
          'right' => 0,
          'bottom' => 0,
          'left' => 0,
          'unit' => 'px',
          'isLinked' => false,
        ],
        'selectors' => [
          '{{WRAPPER}} .landing-seventeen .btns .btn:first-child' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'btn__contact__style',
        'label' => esc_html__('تایپوگرافی دکمه تماس', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .landing-seventeen .btns .btn:nth-child(2)',
      ]
    );
    $this->add_control(
      'btn__contact__color',
      [
        'label' => esc_html__('رنگ دکمه تماس', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .landing-seventeen .btns .btn:nth-child(2)' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn__contact__border__color',
      [
        'label' => esc_html__('رنگ بردار دکمه تماس', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .landing-seventeen .btns .btn:nth-child(2)' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn__contact__style__padding',
      [
        'label' => esc_html__('فاصله داخلی', 'textdomain'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'default' => [
          'top' => 13,
          'right' => 26,
          'bottom' => 13,
          'left' => 26,
          'unit' => 'px',
          'isLinked' => false,
        ],
        'selectors' => [
          '{{WRAPPER}} .landing-seventeen .btns .btn:nth-child(2)' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'btn__contact__style__margin',
      [
        'label' => esc_html__('فاصله بیرونی', 'textdomain'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'default' => [
          'top' => 0,
          'right' => 0,
          'bottom' => 0,
          'left' => 0,
          'unit' => 'px',
          'isLinked' => false,
        ],
        'selectors' => [
          '{{WRAPPER}} .landing-seventeen .btns .btn:nth-child(2)' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }
  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>

    <section class="landing-seventeen position-relative">
      <div class="container">
        <div class="row align-items-center">
          <div class="col-lg-6">
            <!-- Start Carousel -->
            <div class="swiper swiper-landing-seventeen position-relative mb-5 mb-lg-0">
              <div class="swiper-wrapper">
                <?php
                if ($settings['Cat__loop']) {
                  foreach ($settings['Cat__loop'] as $item) {
                    ?>
                    <!-- Start Slide -->
                    <div class="swiper-slide">
                      <div class="image position-relative mx-auto">
                        <div class="img">
                          <img src="<?php echo esc_url($item['Cat__loop__image']['url']); ?>" alt="image" width="442"
                            height="543">
                        </div>
                      </div>
                    </div>
                    <!-- End Slide -->
                    <?php
                  }
                }
                ?>
              </div>
              <!-- Start Pagination -->
              <div class="swiper-bottom position-absolute d-flex align-items-center start-50 translate-middle-x">
                <i class="icon-play"></i>
                <div class="swiper-pagination position-relative top-0 start-0 bottom-0 end-0"></div>
              </div>
              <!-- End Pagination -->
            </div>
            <!-- End Carousel -->
          </div>
          <div class="col-lg-6">
            <div class="sup-title overflow-hidden">
              <?php echo esc_attr($settings['subtitle']); ?>
            </div>
            <<?php echo esc_attr($settings['main__title__format']); ?> style="color:#fff" class="title">
              <?php echo esc_html($settings['main__title']); ?>
            </<?php echo esc_attr($settings['main__title__format']); ?>>
            <p class="mb-0">
              <?php echo esc_html($settings['section__details']); ?>
            </p>
            <div class="btns d-flex align-items-center justify-content-center justify-content-lg-start">
              <a href="<?php echo $settings['link__btn__more']['url']; ?>"
                class="btn d-flex align-items-center rounded-pill">
                <?php echo esc_attr($settings['btn__more']); ?>
                <i class="icon-angle-left d-flex align-items-center justify-content-center bg-white rounded-circle"></i>
              </a>
              <a href="<?php echo $settings['link__btn__contact']['url']; ?>"
                class="btn d-flex align-items-center rounded-pill">
                <?php echo esc_attr($settings['btn__contact']); ?>
                <i class="icon-angle-left d-flex align-items-center justify-content-center bg-white rounded-circle"></i>
              </a>
            </div>
          </div>
        </div>
      </div>
    </section>
<script>
      function init<?php echo $clsid; ?>() {

    // Swiper Landing Seventeen
    const landingSevenTeen = document.querySelector(".landing-seventeen");

if (landingSevenTeen) {
  let timeSwiper = 0,
    timearSwiper;

  const swiperLandingSevenTeen = new Swiper(".swiper-landing-seventeen", {
    slidesPerView: 1,
    spaceBetween: 0,
    effect: "fade",
    fadeEffect: {
      crossFade: true,
    },
    pagination: {
      el: ".swiper-pagination",
      type: "bullets",
      clickable: true,
      disableOnInteraction: false,
      pauseOnMouseEnter: true,
    },
    on: {
      init: () => {
        document.documentElement.style.setProperty(
          "--time-landing-seventeen",
          "5000ms"
        );
      },

      slideChange: () => {
        timeSwiper = 0;
      },
    },
  });

  const itemsPaginations = landingSevenTeen.querySelectorAll(
    ".swiper-pagination-bullet"
  );

  const startLandingSevenTeen = () => {
    timearSwiper = setInterval(() => {
      timeSwiper += 1000;

      if (timeSwiper >= 5000) {
        timeSwiper = 0;
        swiperLandingSevenTeen.slideNext(300);
      }
    }, 1 * 1000);
  };

  startLandingSevenTeen();
}
}
      if (window.Swiper) {
    // Swiper library already loaded, initialize Swiper instance
    init<?php echo $clsid; ?>();
  } else {
    // Swiper library not yet loaded, wait for it to load
    window.addEventListener("load", function() {
      init<?php echo $clsid; ?>();
    });
  }
</script>
    <?php
  }

}