<?php


use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Categoryverticalsecondstcolkaveh extends Widget_Base{

  public function get_name(){
    return 'categoryverticalsecondstcolkaveh';
  }

  public function get_title(){
    return esc_html__( 'ستون دسته بندی ها عمودی سبک دو', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentcategoryverticalsecondstcolkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );

      $repeater = new \Elementor\Repeater();
    $repeater->add_control(
      'titleccategoryverticalsecondstcolkaveh',
      [
        'label' => esc_html__( 'نوشته', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'تجهیزات کوهنوردی',
      ]
    );
    $repeater->add_control(
      'img1categoryverticalsecondstcolkaveh',
      [
        'label' => esc_html__( 'تصویر دسته بندی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
          'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $repeater->add_control(
      'linkcategoryverticalsecondstcolkaveh',
      [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
      ]
    );
    $this->add_control(
      'listcategoryverticalsecondstcolkaveh',
      [
        'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'titleccategoryverticalsecondstcolkaveh' => esc_html__( 'تجهیزات کوهنوردی', 'kaveh-core' ),
            'linkcategoryverticalsecondstcolkaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    ); 
       $this->end_controls_section();
      $this->start_controls_section(
        'style2_ccategoryverticalsecondstcolkaveh',
        [
          'label' => esc_html__( 'استایل دسته بندی ها', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcatcolorcategoryverticalsecondstcolkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .list-category li' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'textcatcolorhovercategoryverticalsecondstcolkaveh',
        [
          'label' => esc_html__( 'رنگ هاور عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .list-category li:hover' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlecat_ccategoryverticalsecondstcolkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .list-category li',
        ]
      );
      $this->add_control(
        'bgcatcolorcategoryverticalsecondstcolkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .list-category' => 'background-color: {{VALUE}} !important',
          ],
        ]
      );
      $this->add_control(
        'borderradiustkhatcategoryverticalsecondstcolkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .list-category' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'paddingtkhatcategoryverticalsecondstcolkaveh',
        [
          'label' => esc_html__( 'پدینگ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .list-category' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow2categoryverticalsecondstcolkaveh',
          'label' => esc_html__( 'سایه باکس', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .list-category',
        ]
      );
      $this->add_control(
        'catbox1widthcategoryverticalsecondstcolkaveh',
        [
          'label' => esc_html__( 'عرض تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
        ]
      );
      $this->add_control(
        'catbox1height2categoryverticalsecondstcolkaveh',
        [
          'label' => esc_html__( 'فاصله تصویر از چپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .list-category li .image' => 'margin-left: {{SIZE}}{{UNIT}};',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
        ]
      );
      $this->end_controls_section();

        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <div class="container">
      <ul class="list-category w-100 bg-white">
        <?php
        if ( $settings['listcategoryverticalsecondstcolkaveh'] ) {
        foreach (  $settings['listcategoryverticalsecondstcolkaveh'] as $item ) {
        ?>
        <li class="d-flex align-items-center position-relative">
          <a href="<?php echo  esc_url($item['linkcategoryverticalsecondstcolkaveh']); ?>" class="stretched-link" aria-label="category"></a>
          <div class="image">
            <img src="<?php echo esc_url($item['img1categoryverticalsecondstcolkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['img1categoryverticalsecondstcolkaveh'] )); ?>" width="<?php echo  esc_attr($settings['catbox1widthcategoryverticalsecondstcolkaveh']['size']); ?>" class="d-block mx-auto">
          </div>
          <?php echo  esc_html($item['titleccategoryverticalsecondstcolkaveh']); ?>
        </li>
        <?php 
            }
              }
            ?>
      </ul>
    </div>
    <style>
      .list-category {
    max-width: unset !important;
}
    </style>
    <?php
  }


}
