<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Categorycarouseltwentytwothstkaveh extends Widget_Base{

  public function get_name(){
    return 'categorycarouseltwentytwothstkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل دسته بندی ها سبک بیست و دو', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentcategorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'showticategorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'نمایش عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'tagti1categorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'div',
          'condition' => [
            'showticategorycarouseltwentytwothstkaveh' => 'yes',
          ],
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
      $this->add_control(
        'widgticategorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'عنوان بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'showticategorycarouseltwentytwothstkaveh' => 'yes',
          ],
          'default' => 'دسته بندی های',
  
        ]
      );
      $this->add_control(
        'wigti2categorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'showticategorycarouseltwentytwothstkaveh' => 'yes',
          ],
          'default' => 'پر فروش',
        ]
      );
      $this->add_control(
        'wigp2categorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'توضیحات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXTAREA,
          'condition' => [
            'showticategorycarouseltwentytwothstkaveh' => 'yes',
          ],
          'default' => 'همواره، قرار گرفتن در شرایطی که برای اولین بار تجربه‌اش می‌کنیم، در ما ایجاد استرس و اضطراب می‌کند؛ بنابراین اگر تلاش کنیم شرایطی را که می‌خواهیم در آن قرار بگیریم، از قبل به',
  
        ]
      );
      $this->add_control(
        'befimgcategorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'تصویر اول', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'selectors' => [
            '{{WRAPPER}} .section-heading-seven::after' =>
                'background: url({{URL}}) 0 0 no-repeat',
                '{{WRAPPER}} .section-heading-seven::before' =>
                'background: url({{URL}}) 0 0 no-repeat',
        ],
        ]
      );
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
        'img1categorycarouselkaveh',
        [
          'label' => esc_html__( 'تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
          ],
        ]
      );

      $repeater->add_control(
      'title1categorycarouseltwentytwothstkaveh',
      [
        'label' => esc_html__( 'عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'ریمل چشم',

      ]
    );
    $repeater->add_control(
      'tagheading1categorycarouseltwentytwothstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'title2categorycarouseltwentytwothstkaveh',
      [
        'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Apple Iphone',

      ]
    );
    $repeater->add_control(
      'tagheading2categorycarouseltwentytwothstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H4',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'linkcategorycarouseltwentytwothstkaveh',
      [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
      ]
    );
    $repeater->add_control(
      'title3categorycarouseltwentytwothstkaveh',
      [
        'label' => esc_html__( 'تعداد محصول', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '۹۲ محصول',

      ]
    );
    $repeater->add_control(
      'bgcolortbolcategorycarouseltwentytwothstkaveh',
      [
        'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
      ]
    );
    $repeater->add_control(
      'img3categorycarouseltwentytwothstkaveh',
      [
        'label' => esc_html__( 'تصویر پس زمینه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::MEDIA,
      ]
    );
    $this->add_control(
      'listcategorycarouseltwentytwothstkaveh',
      [
        'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'title1categorycarouseltwentytwothstkaveh' => esc_html__( 'عنوان', 'kaveh-core' ),
            'title2categorycarouseltwentytwothstkaveh' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
            'linkcategorycarouseltwentytwothstkaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );

    
       $this->end_controls_section();
       $this->start_controls_section(
        'content3categorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'productcolumncategorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در دسکتاپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 8,
          'step' => 1,
          'default' => 4,
      
        ]
      );
      $this->add_control(
        'productcolumn2categorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در تبلت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 3,
      
        ]
      );
      $this->add_control(
        'productcolumn3categorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در موبایل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => .2,
          'default' => 1.2,
      
        ]
      );
       $this->end_controls_section();
       $this->start_controls_section(
        'stylet_categorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showticategorycarouseltwentytwothstkaveh' => 'yes',
          ],
        ]
      );
      $this->add_control(
        'textcolortbolcategorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-seven .title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletyt2_categorycarouseltwentytwothstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان بولد', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-seven .title',
        ]
      );
      $this->add_control(
        'bgcolorboldbolcategorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه عنوان بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-seven .title::before' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'textcolortcategorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-seven .title span' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletyt_categorycarouseltwentytwothstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-seven .title span',
        ]
      );
      $this->add_control(
        'textcolortpcategorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'رنگ توضیحات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-seven p' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletytp_categorycarouseltwentytwothstkaveh',
          'label' => esc_html__( 'تایپوگرافی توضیحات', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-seven p',
        ]
      );
      $this->add_control(
        'befcatimg1widthcategorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'عرض تصویر کناره ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-seven::before' => 'width: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .section-heading-seven::after' => 'width: {{SIZE}}{{UNIT}};',

          ],
        ]
      );
      $this->add_control(
        'befcatimg1height2categorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر کناره ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-seven::before' => 'height: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .section-heading-seven::after' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();

      $this->start_controls_section(
        'style2_categorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'استایل عنوان دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor1categorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .best-category-five-item .content .title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlety1_categorycarouseltwentytwothstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان دسته بندی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .best-category-five-item .content .title',
        ]
      );
      $this->add_control(
        'textcolor21categorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .best-category-five-item .content .sub-title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlety2_categorycarouseltwentytwothstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی دسته بندی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .best-category-five-item .content .sub-title',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style21_categorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'استایل دکمه تعداد محصولات', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showticategorycarouseltwentytwothstkaveh' => 'yes',
          ],
        ]
      );
      
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_categorycarouseltwentytwothstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .best-category-five-item .content .quantity b',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowcategorycarouseltwentytwothstkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .best-category-five-item .content .quantity b',
        ]
      );
      $this->start_controls_tabs(
        'style_tabscategorycarouseltwentytwothstkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tabcategorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorcategorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .best-category-five-item .content .quantity b' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorcategorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .best-category-five-item .content .quantity' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiuscategorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .best-category-five-item .content .quantity' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'bordercategorycarouseltwentytwothstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .best-category-five-item .content .quantity',
        ]
      );
      $this->add_control(
        'buttonborderscategorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'bordercategorycarouseltwentytwothstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .best-category-five-item .content .quantity' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabcategorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhovercategorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .best-category-five-item .content .quantity b:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhovercategorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .best-category-five-item .content .quantity:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushovercategorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .best-category-five-item .content .quantity:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhovercategorycarouseltwentytwothstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .best-category-five-item .content .quantity:hover',
        ]
      );
      $this->add_control(
        'buttonbordershovercategorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhovercategorycarouseltwentytwothstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .best-category-five-item .content .quantity:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowcategorycarouseltwentytwothstkavehh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .best-category-five-item .content .quantity',
        ]
      );
      $this->add_control(
        'hr1categorycarouseltwentytwothstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingcategorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .best-category-five-item .content .quantity' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_categorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'استایل باکس دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'borderradiustcategorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده باکس داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [ 
            '{{WRAPPER}} .best-category-five-item .content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

          ],
        ]
      );
      $this->add_control(
        'borderradius2tcategorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده باکس خارجی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [ 
            '{{WRAPPER}} .best-category-five-item .content::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

          ],
        ]
      );
      $this->add_control(
        'bordercolor21categorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'رنگ بردر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .best-category-five-item .content::before' => 'border: 1px solid {{VALUE}}',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'styleimag_categorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'استایل تصویر دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'catimg1widthcategorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'عرض تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .best-category-five-item img' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catimg1height2categorycarouseltwentytwothstkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .best-category-five-item img' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();

        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="best-category-five">
      <div class="container">
        <?php if("yes"===$settings['showticategorycarouseltwentytwothstkaveh']){?>
        <!-- Start Heading -->
        <div class="section-heading-seven position-relative w-100 mx-auto text-center">
          <<?php echo  esc_attr($settings['tagti1categorycarouseltwentytwothstkaveh']); ?> class="title position-relative mx-auto">
          <?php echo esc_html($settings['widgticategorycarouseltwentytwothstkaveh']); ?>
            <span> <?php echo esc_html($settings['wigti2categorycarouseltwentytwothstkaveh']); ?></span>
          </<?php echo  esc_attr($settings['tagti1categorycarouseltwentytwothstkaveh']); ?>>
          <p class="mb-0"> <?php echo esc_html($settings['wigp2categorycarouseltwentytwothstkaveh']); ?></p>
        </div>
        <!-- End Heading -->
        <?php } ?>
        <!-- Start Carousel -->
        <div class="swiper swiper-best-category-five" data-swiper='{"watchSlidesProgress":true,"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3categorycarouseltwentytwothstkaveh']); ?>,"spaceBetween":12},"400":{"slidesPerView":<?php echo esc_html($settings['productcolumn3categorycarouseltwentytwothstkaveh']); ?>,"spaceBetween":12},"500":{"slidesPerView":<?php echo esc_html($settings['productcolumn3categorycarouseltwentytwothstkaveh']); ?>,"spaceBetween":12},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2categorycarouseltwentytwothstkaveh']); ?>,"spaceBetween":12},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumncategorycarouseltwentytwothstkaveh']); ?>,"spaceBetween":12},"1200":{"slidesPerView":<?php echo esc_html($settings['productcolumncategorycarouseltwentytwothstkaveh']); ?>,"spaceBetween":20}}}'>
          <div class="swiper-wrapper">
            <?php
              $e=1;
              if ( $settings['listcategorycarouseltwentytwothstkaveh'] ) {
              foreach (  $settings['listcategorycarouseltwentytwothstkaveh'] as $item ) {
              ?>
            <!-- Start Slide -->
            <div class="swiper-slide">
              <div class="best-category-five-item position-relative cat-st-tt<?php echo $e;?>">
                <a href="<?php echo  esc_url($item['linkcategorycarouseltwentytwothstkaveh']); ?>" class="stretched-link" aria-label="category"></a>
                <img src="<?php echo esc_url($item['img1categorycarouselkaveh']['url']); ?>" alt=""
                  class="position-absolute start-0 bottom-0">
                <div class="content position-relative">
                  <<?php echo  esc_attr($item['tagheading1categorycarouseltwentytwothstkaveh']); ?> class="title"><?php echo  esc_html($item['title1categorycarouseltwentytwothstkaveh']); ?></<?php echo  esc_attr($item['tagheading1categorycarouseltwentytwothstkaveh']); ?>>
                  <<?php echo  esc_attr($item['tagheading2categorycarouseltwentytwothstkaveh']); ?> class="sub-title"> <?php echo  esc_html($item['title2categorycarouseltwentytwothstkaveh']); ?></<?php echo  esc_attr($item['tagheading2categorycarouseltwentytwothstkaveh']); ?>>
                  <span class="quantity position-absolute bottom-0 end-0 text-white">
                    <b> <?php echo  esc_html($item['title3categorycarouseltwentytwothstkaveh']); ?> </b>
                  </span>
                </div>
              </div>
            </div>
            <!-- End Slide -->
            <style>
              <?php echo '.cat-st-tt'. $e ?>.best-category-five-item .content{
              background: url(<?php echo esc_url($item['img3categorycarouseltwentytwothstkaveh']['url']); ?>) 0 0 no-repeat;
              
              } 
              <?php echo '.cat-st-tt'. $e ?>.best-category-five-item .content{
              background-color: <?php echo esc_attr($item['bgcolortbolcategorycarouseltwentytwothstkaveh']); ?> ;
              
              } 
              </style>
            <?php 
              $e++;
              }
                }
              ?>
          </div>
        </div>
        <!-- End Carousel -->
      </div>
    </section>
<style>
  .best-category-five-item img {
    object-fit: contain;
}
.best-category-five-item .content {
    -webkit-background-size: cover !important;
    -moz-background-size: cover !important;
    -o-background-size: cover !important;
    background-size: cover !important;
}
.section-heading-seven::before, .section-heading-seven::after {
    -webkit-background-size: contain !important;
    -moz-background-size: contain !important;
    -o-background-size: contain !important;
    background-size: contain !important;
}
</style>
<?php do_action('kelementor_inline_scripts'); ?>  
    <?php
  }


}
