<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Categorycarouseltwentythstkaveh extends Widget_Base{

  public function get_name(){
    return 'categorycarouseltwentythstkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل دسته بندی ها سبک بیست', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentcategorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'showticategorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'نمایش ستون سمت راست', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'ftagti1categorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H4',
          'condition' => [
            'showticategorycarouseltwentythstkaveh' => 'yes',
          ],
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
      $this->add_control(
        'fwigti2categorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'showticategorycarouseltwentythstkaveh' => 'yes',
          ],
          'default' => 'Our product categories',
        ]
      );
      $this->add_control(
        'tagti1categorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H3',
          'condition' => [
            'showticategorycarouseltwentythstkaveh' => 'yes',
          ],
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
      $this->add_control(
        'widgticategorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'عنوان بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'showticategorycarouseltwentythstkaveh' => 'yes',
          ],
          'default' => 'دسته بندی های',
  
        ]
      );
      $this->add_control(
        'wigti2categorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'showticategorycarouseltwentythstkaveh' => 'yes',
          ],
          'default' => 'پر فروش',
        ]
      );
      $this->add_control(
        'wigp2categorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'توضیحات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXTAREA,
          'condition' => [
            'showticategorycarouseltwentythstkaveh' => 'yes',
          ],
          'default' => 'همواره، قرار گرفتن در شرایطی که برای اولین بار تجربه‌اش می‌کنیم، در ما ایجاد استرس و اضطراب می‌کند؛ بنابراین اگر تلاش کنیم شرایطی را که می‌خواهیم در آن قرار بگیریم، از قبل به',
  
        ]
      );
      $this->add_control(
        'buttoncategorycarouseltwentythstkaveh',
        [
            'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
              'showticategorycarouseltwentythstkaveh' => 'yes',
            ],
            'default' => esc_html__( 'محصولات پیشنهاد ویژه', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'iconbuttcategorycarouseltwentythstkaveh',
      [
        'label' => esc_html__( 'آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'condition' => [
          'showticategorycarouseltwentythstkaveh' => 'yes',
        ],
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'icon-arrow-left-3',
        ],
      ]
    );
    $this->add_control(
      'linkbuttoncategorycarouseltwentythstkaveh',
      [
          'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'showticategorycarouseltwentythstkaveh' => 'yes',
          ],
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
        'img1categorycarouselkaveh',
        [
          'label' => esc_html__( 'تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
          ],
        ]
      );

      $repeater->add_control(
      'title1categorycarouseltwentythstkaveh',
      [
        'label' => esc_html__( 'عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'ریمل چشم',

      ]
    );
    $repeater->add_control(
      'tagheading1categorycarouseltwentythstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'title2categorycarouseltwentythstkaveh',
      [
        'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Apple Iphone',

      ]
    );
    $repeater->add_control(
      'tagheading2categorycarouseltwentythstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H4',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'linkcategorycarouseltwentythstkaveh',
      [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
      ]
    );
    $repeater->add_control(
      'bgcolortbolcategorycarouseltwentythstkaveh',
      [
        'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
      ]
    );
    $this->add_control(
      'listcategorycarouseltwentythstkaveh',
      [
        'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'title1categorycarouseltwentythstkaveh' => esc_html__( 'عنوان', 'kaveh-core' ),
            'title2categorycarouseltwentythstkaveh' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
            'linkcategorycarouseltwentythstkaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );

    
       $this->end_controls_section();
       $this->start_controls_section(
        'content3categorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'showarrowcategorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'نمایش فلش ها؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'productcolumncategorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در دسکتاپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 8,
          'step' => 1,
          'default' => 3,
      
        ]
      );
      $this->add_control(
        'productcolumn2categorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در تبلت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 2,
      
        ]
      );
      $this->add_control(
        'productcolumn3categorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در موبایل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => .1,
          'default' => 1.4,
      
        ]
      );
       $this->end_controls_section();
       $this->start_controls_section(
        'stylet_categorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showticategorycarouseltwentythstkaveh' => 'yes',
          ],
        ]
      );
      $this->add_control(
        'ftextcolortcategorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-my-products-right .title-en' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'ftitletyt_categorycarouseltwentythstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .categories-my-products-right .title-en',
        ]
      );
      $this->add_control(
        'textcolortbolcategorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-my-products-right .title b' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'bgcolorboldbolcategorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه عنوان بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-my-products-right .title::before' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'textcolortcategorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-my-products-right .title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletyt_categorycarouseltwentythstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .categories-my-products-right .title',
        ]
      );
      $this->add_control(
        'textcolortpcategorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'رنگ توضیحات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-my-products-right p' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletytp_categorycarouseltwentythstkaveh',
          'label' => esc_html__( 'تایپوگرافی توضیحات', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .categories-my-products-right p',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style21_categorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showticategorycarouseltwentythstkaveh' => 'yes',
          ],
        ]
      );
      
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_categorycarouseltwentythstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .categories-my-products-right .btn',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowcategorycarouseltwentythstkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .categories-my-products-right .btn',
        ]
      );
      $this->add_control(
        'iconsizenchbcategorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .categories-my-products-right .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->start_controls_tabs(
        'style_tabscategorycarouseltwentythstkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tabcategorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorcategorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-my-products-right .btn' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'textbutton1colorcategorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-my-products-right .btn i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorcategorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-my-products-right .btn' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiuscategorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .categories-my-products-right .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'bordercategorycarouseltwentythstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .categories-my-products-right .btn',
        ]
      );
      $this->add_control(
        'buttonborderscategorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'bordercategorycarouseltwentythstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .categories-my-products-right .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabcategorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhovercategorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-my-products-right .btn:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'textbutton1hovercolorcategorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-my-products-right .btn:hover i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhovercategorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-my-products-right .btn:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushovercategorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .categories-my-products-right .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhovercategorycarouseltwentythstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .categories-my-products-right .btn:hover',
        ]
      );
      $this->add_control(
        'buttonbordershovercategorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhovercategorycarouseltwentythstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .categories-my-products-right .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowcategorycarouseltwentythstkavehh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .categories-my-products-right .btn',
        ]
      );
      $this->add_control(
        'hr1categorycarouseltwentythstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingcategorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .categories-my-products-right .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style2_categorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'استایل عنوان دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor1categorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-my-products-item .title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlety1_categorycarouseltwentythstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان دسته بندی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .categories-my-products-item .title',
        ]
      );
      $this->add_control(
        'textcolor21categorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-my-products-item .title-en' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlety2_categorycarouseltwentythstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی دسته بندی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .categories-my-products-item .title-en',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_categorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'استایل باکس دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'borderradiustcategorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [ 
            '{{WRAPPER}} .categories-my-products-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}}  .categories-my-products-item .image::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

          ],
        ]
      );
      $this->add_control(
        'bordercolor21categorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'رنگ بردر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-my-products-item' => 'border: 1px solid {{VALUE}}',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3arr_categorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'استایل فلش ها', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'arrowcolor1categorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'رنگ فلش ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'showarrowcategorycarouseltwentythstkaveh' => 'yes',
          ],
          'selectors' => [
            '{{WRAPPER}} .categories-my-products-right .swiper-button-next::after' => 'color: {{VALUE}} !important;',
            '{{WRAPPER}} .categories-my-products-right .swiper-button-prev::after' => 'color: {{VALUE}} !important;',

          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'styleimag_categorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'استایل تصویر دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'catimg1widthcategorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'عرض تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .categories-my-products-item .image img' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catimg1height2categorycarouseltwentythstkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .categories-my-products-item .image img' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();

        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="categories-my-products">
      <div class="container d-flex flex-column flex-sm-row gap-4 gap-sm-0">
      <?php if("yes"===$settings['showticategorycarouseltwentythstkaveh']){?>
        <!-- Start Title -->
        <div class="categories-my-products-right w-100 position-relative">
          <<?php echo  esc_attr($settings['ftagti1categorycarouseltwentythstkaveh']); ?> class="title-en">  <?php echo esc_html($settings['fwigti2categorycarouseltwentythstkaveh']); ?> </<?php echo  esc_attr($settings['ftagti1categorycarouseltwentythstkaveh']); ?>>
          <<?php echo  esc_attr($settings['tagti1categorycarouseltwentythstkaveh']); ?> class="title position-relative">
            <b> <?php echo esc_html($settings['widgticategorycarouseltwentythstkaveh']); ?></b>
            <?php echo esc_html($settings['wigti2categorycarouseltwentythstkaveh']); ?>
          </<?php echo  esc_attr($settings['tagti1categorycarouseltwentythstkaveh']); ?>>
          <p> <?php echo esc_html($settings['wigp2categorycarouseltwentythstkaveh']); ?></p>
          <div class="d-flex align-items-center">
            <a href="<?php echo esc_html($settings['linkbuttoncategorycarouseltwentythstkaveh']); ?>" class="btn d-flex align-items-center">
            <?php echo esc_html($settings['buttoncategorycarouseltwentythstkaveh']); ?>
              <i class="<?php echo esc_attr($settings['iconbuttcategorycarouseltwentythstkaveh']['value']); ?>"></i>
            </a>
            <?php if("yes"===$settings['showarrowcategorycarouseltwentythstkaveh']){?>
            <div class="swiper-categories-my-products-button-prev swiper-button-prev w-auto h-auto m-0 position-relative top-0 start-0 bottom-0 end-0 me-3"></div>
            <div class="swiper-categories-my-products-button-next swiper-button-next w-auto h-auto m-0 position-relative top-0 start-0 bottom-0 end-0"></div>
            <?php } ?>
          </div>
        </div>
        <!-- End Title -->
        <?php } ?>
        <!-- Start Categories -->
        <div class="categories-my-products-left w-100">
          <!-- Start Carousel -->
          <div class="swiper swiper-categories-my-products" data-swiper='{"watchSlidesProgress":true,"navigation":{"nextEl":".swiper-categories-my-products-button-next","prevEl":".swiper-categories-my-products-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3categorycarouseltwentythstkaveh']); ?>,"spaceBetween":12},"400":{"slidesPerView":<?php echo esc_html($settings['productcolumn3categorycarouseltwentythstkaveh']); ?>,"spaceBetween":12},"500":{"slidesPerView":<?php echo esc_html($settings['productcolumn3categorycarouseltwentythstkaveh']); ?>,"spaceBetween":12},"576":{"slidesPerView":<?php echo esc_html($settings['productcolumn2categorycarouseltwentythstkaveh']); ?>,"spaceBetween":12},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2categorycarouseltwentythstkaveh']); ?>,"spaceBetween":12},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumncategorycarouseltwentythstkaveh']); ?>,"spaceBetween":12},"1200":{"slidesPerView":<?php echo esc_html($settings['productcolumncategorycarouseltwentythstkaveh']); ?>,"spaceBetween":32}}}'>
            <div class="swiper-wrapper">
            <?php
              $e=1;
              if ( $settings['listcategorycarouseltwentythstkaveh'] ) {
              foreach (  $settings['listcategorycarouseltwentythstkaveh'] as $item ) {
              ?>
              <!-- Start Slide -->
              <div class="swiper-slide">
                <div class="categories-my-products-item position-relative rgt<?php echo $e;?>">
                  <a href="<?php echo esc_html($item['linkcategorycarouseltwentythstkaveh']); ?>" class="stretched-link" aria-label="category"></a>
                  <div class="image position-relative mb-2">
                    <img src="<?php echo esc_url($item['img1categorycarouselkaveh']['url']); ?>" alt="" class="d-block mx-auto">
                  </div>
                  <<?php echo  esc_attr($item['tagheading1categorycarouseltwentythstkaveh']); ?> class="title mb-0 text-center"><?php echo  esc_html($item['title1categorycarouseltwentythstkaveh']); ?></<?php echo  esc_attr($item['tagheading1categorycarouseltwentythstkaveh']); ?>>
                  <<?php echo  esc_attr($item['tagheading2categorycarouseltwentythstkaveh']); ?> class="title-en text-center"> <?php echo  esc_html($item['title2categorycarouseltwentythstkaveh']); ?> </<?php echo  esc_attr($item['tagheading2categorycarouseltwentythstkaveh']); ?>>
                </div>
              </div>
              <!-- End Slide -->
              <style>
              <?php echo '.rgt'. $e ?> .image::before{
              background-image: -webkit-linear-gradient(top, <?php echo esc_attr($item['bgcolortbolcategorycarouseltwentythstkaveh']); ?> -71.81%, rgba(71, 79, 99, 0) 68.19%);
              background-image: -moz-linear-gradient(top, <?php echo esc_attr($item['bgcolortbolcategorycarouseltwentythstkaveh']); ?> -71.81%, rgba(71, 79, 99, 0) 68.19%);
              background-image: -o-linear-gradient(top, <?php echo esc_attr($item['bgcolortbolcategorycarouseltwentythstkaveh']); ?> -71.81%, rgba(71, 79, 99, 0) 68.19%);
              background-image: linear-gradient(180deg, <?php echo esc_attr($item['bgcolortbolcategorycarouseltwentythstkaveh']); ?> -71.81%, rgba(71, 79, 99, 0) 68.19%);
              
              } 
              </style>
              <?php 
              $e++;
              }
                }
              ?>
              
            </div>
          </div>
          <!-- End Carousel -->
        </div>
        <!-- End Categories -->
      </div>
    </section>
<style>
  .categories-my-products-item .image img {
    object-fit: contain;
}
.btn-gradient-blue {
    background-image: unset !important;
}
.btn-gradient-blue:hover {
    background-image: unset !important;
}
</style>
<?php do_action('kelementor_inline_scripts'); ?>  
    <?php
  }


}
