<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Categorycarouseltwentyonethstkaveh extends Widget_Base{

  public function get_name(){
    return 'categorycarouseltwentyonethstkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل دسته بندی ها سبک بیست و یک', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentcategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'showticategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'نمایش ستون سمت راست', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'imgbeforecategorycarouselkaveh',
        [
          'label' => esc_html__( 'تصویر بالای عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'selectors' => [
            '{{WRAPPER}} .categories-products-right::before' =>
                'background: url({{URL}}) 0 0 no-repeat',
        ],
        ]
      );
      $this->add_control(
        'ftagti1categorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'div',
          'condition' => [
            'showticategorycarouseltwentyonethstkaveh' => 'yes',
          ],
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
      $this->add_control(
        'fwigti2categorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'showticategorycarouseltwentyonethstkaveh' => 'yes',
          ],
          'default' => 'Our product categories',
        ]
      );
      $this->add_control(
        'tagti1categorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H3',
          'condition' => [
            'showticategorycarouseltwentyonethstkaveh' => 'yes',
          ],
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
      $this->add_control(
        'widgticategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'عنوان بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'showticategorycarouseltwentyonethstkaveh' => 'yes',
          ],
          'default' => 'دسته بندی های',
  
        ]
      );
      $this->add_control(
        'wigti2categorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'showticategorycarouseltwentyonethstkaveh' => 'yes',
          ],
          'default' => 'پر فروش',
        ]
      );
      $this->add_control(
        'wigp2categorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'توضیحات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXTAREA,
          'condition' => [
            'showticategorycarouseltwentyonethstkaveh' => 'yes',
          ],
          'default' => 'همواره، قرار گرفتن در شرایطی که برای اولین بار تجربه‌اش می‌کنیم، در ما ایجاد استرس و اضطراب می‌کند؛',
  
        ]
      );
      $this->add_control(
        'buttoncategorycarouseltwentyonethstkaveh',
        [
            'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
              'showticategorycarouseltwentyonethstkaveh' => 'yes',
            ],
            'default' => esc_html__( 'محصولات پیشنهاد ویژه', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'iconbuttcategorycarouseltwentyonethstkaveh',
      [
        'label' => esc_html__( 'آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'condition' => [
          'showticategorycarouseltwentyonethstkaveh' => 'yes',
        ],
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'icon-arrow-left-3',
        ],
      ]
    );
    $this->add_control(
      'linkbuttoncategorycarouseltwentyonethstkaveh',
      [
          'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'showticategorycarouseltwentyonethstkaveh' => 'yes',
          ],
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
        'img1categorycarouselkaveh',
        [
          'label' => esc_html__( 'تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
          ],
        ]
      );

      $repeater->add_control(
      'title1categorycarouseltwentyonethstkaveh',
      [
        'label' => esc_html__( 'عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'ریمل چشم',

      ]
    );
    $repeater->add_control(
      'tagheading1categorycarouseltwentyonethstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'div',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'iconbuttwcategorycarouseltwentyonethstkaveh',
      [
        'label' => esc_html__( 'آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'icon-arrow-left-3',
        ],
      ]
    );
    $repeater->add_control(
      'img2categorycarouselkaveh',
      [
        'label' => esc_html__( 'تصویر کنار دسته بندی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::MEDIA,
      ]
    );
    $repeater->add_control(
      'linkcategorycarouseltwentyonethstkaveh',
      [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
      ]
    );
    $repeater->add_control(
      'bgcolortbolcategorycarouseltwentyonethstkaveh',
      [
        'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
      ]
    );
    $this->add_control(
      'listcategorycarouseltwentyonethstkaveh',
      [
        'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'title1categorycarouseltwentyonethstkaveh' => esc_html__( 'عنوان', 'kaveh-core' ),
            'title2categorycarouseltwentyonethstkaveh' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
            'linkcategorycarouseltwentyonethstkaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );

    
       $this->end_controls_section();
       $this->start_controls_section(
        'content3categorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'showarrowcategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'نمایش فلش ها؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'productcolumncategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در دسکتاپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 8,
          'step' => 1,
          'default' => 3,
      
        ]
      );
      $this->add_control(
        'productcolumn2categorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در تبلت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 2,
      
        ]
      );
      $this->add_control(
        'productcolumn3categorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در موبایل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => .1,
          'default' => 1.4,
      
        ]
      );
       $this->end_controls_section();
       $this->start_controls_section(
        'stylet_categorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showticategorycarouseltwentyonethstkaveh' => 'yes',
          ],
        ]
      );
      $this->add_control(
        'ftextcolortcategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-products-right .sup-title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'ftitletyt_categorycarouseltwentyonethstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .categories-products-right .sup-title',
        ]
      );
      $this->add_control(
        'textcolortbolcategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-products-right .title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'btitletyt_categorycarouseltwentyonethstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان بولد', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .categories-products-right .title',
        ]
      );
      $this->add_control(
        'textcolortcategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-products-right .title span' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletyt_categorycarouseltwentyonethstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .categories-products-right .title span',
        ]
      );
      $this->add_control(
        'textcolortpcategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'رنگ توضیحات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-products-right p' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletytp_categorycarouseltwentyonethstkaveh',
          'label' => esc_html__( 'تایپوگرافی توضیحات', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .categories-products-right p',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style21_categorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showticategorycarouseltwentyonethstkaveh' => 'yes',
          ],
        ]
      );
      
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_categorycarouseltwentyonethstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .categories-products .btn-my-products',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowcategorycarouseltwentyonethstkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .categories-products .btn-my-products',
        ]
      );
      $this->add_control(
        'iconsizenchbcategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .categories-products .btn-my-products i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->start_controls_tabs(
        'style_tabscategorycarouseltwentyonethstkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tabcategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorcategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-products .btn-my-products' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'textbutton1colorcategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-products .btn-my-products i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorcategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-products .btn-my-products' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiuscategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .categories-products .btn-my-products' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'bordercategorycarouseltwentyonethstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .categories-products .btn-my-products',
        ]
      );
      $this->add_control(
        'buttonborderscategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'bordercategorycarouseltwentyonethstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .categories-products .btn-my-products' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabcategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhovercategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-products .btn-my-products:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'textbutton1hovercolorcategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-products .btn-my-products:hover i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhovercategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-products .btn-my-products:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushovercategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .categories-products .btn-my-products:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhovercategorycarouseltwentyonethstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .categories-products .btn-my-products:hover',
        ]
      );
      $this->add_control(
        'buttonbordershovercategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhovercategorycarouseltwentyonethstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .categories-products .btn-my-products:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowcategorycarouseltwentyonethstkavehh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .categories-products .btn-my-products',
        ]
      );
      $this->add_control(
        'hr1categorycarouseltwentyonethstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingcategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .categories-products .btn-my-products' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style2_categorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'استایل عنوان دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );

      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_ticategorycarouseltwentyonethstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .categories-products-item .btn',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowticategorycarouseltwentyonethstkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .categories-products-item .btn',
        ]
      );
      $this->add_control(
        'iconsizenchbticategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .categories-products-item .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->start_controls_tabs(
        'style_tabsticategorycarouseltwentyonethstkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tabticategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorticategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-products-item .btn' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'textbutton1colorticategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-products-item .btn i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorticategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-products-item .btn' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiusticategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .categories-products-item .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderticategorycarouseltwentyonethstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .categories-products-item .btn',
        ]
      );
      $this->add_control(
        'buttonbordersticategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderticategorycarouseltwentyonethstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .categories-products-item .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabticategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhoverticategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-products-item .btn:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'textbutton1hovercolorticategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-products-item .btn:hover i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhoverticategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-products-item .btn:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushoverticategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .categories-products-item .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhoverticategorycarouseltwentyonethstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .categories-products-item .btn:hover',
        ]
      );
      $this->add_control(
        'buttonbordershoverticategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhoverticategorycarouseltwentyonethstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .categories-products-item .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowticategorycarouseltwentyonethstkavehh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .categories-products-item .btn',
        ]
      );
      $this->add_control(
        'hr1ticategorycarouseltwentyonethstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingticategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .categories-products-item .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catimg2widthcategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'عرض تصویر قبل عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .categories-products-item .btn::before' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catimg2height2categorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر قبل عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .categories-products-item .btn::before' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_categorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'استایل باکس دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'borderradiustcategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [ 
            '{{WRAPPER}} .categories-products-item .image::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} .categories-products-item .image::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

          ],
        ]
      );
      $this->add_control(
        'bordercolor21categorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'رنگ بردر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-products-item .image::after' => 'border: 1px dashed {{VALUE}}',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3arr_categorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'استایل فلش ها', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'arrowcolor1categorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'رنگ فلش ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'showarrowcategorycarouseltwentyonethstkaveh' => 'yes',
          ],
          'selectors' => [
            '{{WRAPPER}} .categories-products-left .swiper-button-next::after' => 'color: {{VALUE}} !important;',
            '{{WRAPPER}} .categories-products-left .swiper-button-prev::after' => 'color: {{VALUE}} !important;',

          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'styleimag_categorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'استایل تصویر دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'catimg1widthcategorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'عرض تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .categories-products-item .image img' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catimg1height2categorycarouseltwentyonethstkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .categories-products-item .image img' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();

        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
<section class="categories-products">
      <div class="container d-flex position-relative pb-md-5 pb-lg-4 flex-column flex-md-row">
      <?php if("yes"===$settings['showticategorycarouseltwentyonethstkaveh']){?>
        <!-- Start Title -->
        <div class="categories-products-right position-relative w-100">
          <<?php echo  esc_attr($settings['ftagti1categorycarouseltwentyonethstkaveh']); ?> class="sup-title mb-0"> <?php echo esc_html($settings['fwigti2categorycarouseltwentyonethstkaveh']); ?> </<?php echo  esc_attr($settings['ftagti1categorycarouseltwentyonethstkaveh']); ?>>
          <<?php echo  esc_attr($settings['tagti1categorycarouseltwentyonethstkaveh']); ?> class="title position-relative">
          <?php echo esc_html($settings['widgticategorycarouseltwentyonethstkaveh']); ?>
            <span class="d-block"> <?php echo esc_html($settings['wigti2categorycarouseltwentyonethstkaveh']); ?></span>
          </<?php echo  esc_attr($settings['tagti1categorycarouseltwentyonethstkaveh']); ?>>
          <p>  <?php echo esc_html($settings['wigp2categorycarouseltwentyonethstkaveh']); ?></p>
          <a href="<?php echo esc_html($settings['linkbuttoncategorycarouseltwentyonethstkaveh']); ?>" class="btn btn-dark-3 btn-my-products d-none d-md-flex align-items-md-center position-relative">
          <?php echo esc_html($settings['buttoncategorycarouseltwentyonethstkaveh']); ?>
            <i class="<?php echo esc_attr($settings['iconbuttcategorycarouseltwentyonethstkaveh']['value']); ?>"></i>
          </a>
        </div>
        <!-- End Title -->
        <?php } ?>
        <!-- Start Carousel -->
        <div class="categories-products-left w-100">
          <div class="swiper swiper-categories-products" data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"watchSlidesProgress":true,"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3categorycarouseltwentyonethstkaveh']); ?>,"spaceBetween":12},"400":{"slidesPerView":<?php echo esc_html($settings['productcolumn3categorycarouseltwentyonethstkaveh']); ?>,"spaceBetween":35},"576":{"slidesPerView":<?php echo esc_html($settings['productcolumn2categorycarouseltwentyonethstkaveh']); ?>,"spaceBetween":35},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumncategorycarouseltwentyonethstkaveh']); ?>,"spaceBetween":35}}}'>
            <div class="swiper-wrapper">
            <?php
              $e=1;
              if ( $settings['listcategorycarouseltwentyonethstkaveh'] ) {
              foreach (  $settings['listcategorycarouseltwentyonethstkaveh'] as $item ) {
              ?>
              <!-- Start Slide -->
              <div class="swiper-slide">
                <div class="categories-products-item position-relative cat-itemto-<?php echo $e;?>">
                  <div class="image position-relative mx-auto">
                    <img src="<?php echo esc_url($item['img1categorycarouselkaveh']['url']); ?>" alt="" width="219" height="225" class="d-block mx-auto">
                  </div>
                  <a href="<?php echo esc_html($item['linkcategorycarouseltwentyonethstkaveh']); ?>" class="btn btn-warning-3 d-flex align-items-center justify-content-center w-100 ms-auto position-relative">
                    <<?php echo  esc_attr($item['tagheading1categorycarouseltwentyonethstkaveh']); ?> class="cat-title-">
                    <?php echo  esc_html($item['title1categorycarouseltwentyonethstkaveh']); ?>
                    </<?php echo  esc_attr($item['tagheading1categorycarouseltwentyonethstkaveh']); ?>>
                    <i class="<?php echo esc_attr($item['iconbuttwcategorycarouseltwentyonethstkaveh']['value']); ?>"></i>
                  </a>
                </div>
              </div>
              <!-- End Slide -->
              <style>
              <?php echo '.cat-itemto-'. $e ?> .image::before{
              background-color:  <?php echo esc_attr($item['bgcolortbolcategorycarouseltwentyonethstkaveh']); ?>;
              } 
              <?php  if(!empty($item['img2categorycarouselkaveh']['url'])){ ?>
              <?php echo '.cat-itemto-'. $e ?> .btn::before{
              background: url("<?php echo esc_url($item['img2categorycarouselkaveh']['url']); ?>") 0 0 no-repeat;
              }
              <?php }else{ ?>
                <?php echo '.cat-itemto-'. $e ?> .btn::before{
              background: unset;
              }
              <?php } ?>
              </style>
              <?php 
              $e++;
              }
                }
              ?>
              
            </div>
            <?php if("yes"===$settings['showarrowcategorycarouseltwentyonethstkaveh']){?>
            <!-- Start Button -->
            <div class="swiper-button-next bottom-0 start-0 w-auto h-auto"></div>
            <div class="swiper-button-prev bottom-0 start-0 w-auto h-auto"></div>
            <!-- End Button -->
            <?php } ?>
          </div>
        </div>
        <!-- End Carousel -->
      </div>
    </section>
<style>
  .categories-products-item .image img {
    object-fit: contain !important;
}
.categories-products-item .btn::before {
    background-size: contain !important;
}
</style>
<?php do_action('kelementor_inline_scripts'); ?>
    <?php
  }


}
