<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Categorycarouseltwentyfourthstkaveh extends Widget_Base{

  public function get_name(){
    return 'categorycarouseltwentyfourthstkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل دسته بندی ها سبک بیست و چهارم', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentcategorycarouseltwentyfourthstkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );

      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
        'img1categorycarouselkaveh',
        [
          'label' => esc_html__( 'تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
          ],
        ]
      );
      $repeater->add_control(
      'title1categorycarouseltwentyfourthstkaveh',
      [
        'label' => esc_html__( 'عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'محصولات آیفون',

      ]
    );
    $repeater->add_control(
      'tagheading1categorycarouseltwentyfourthstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'linkcategorycarouseltwentyfourthstkaveh',
      [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
      ]
    );
    $this->add_control(
      'listcategorycarouseltwentyfourthstkaveh',
      [
        'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'title1categorycarouseltwentyfourthstkaveh' => esc_html__( 'عنوان', 'kaveh-core' ),
            'linkcategorycarouseltwentyfourthstkaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );

    
       $this->end_controls_section();
       $this->start_controls_section(
        'content3categorycarouseltwentyfourthstkaveh',
        [
          'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'productcolumncategorycarouseltwentyfourthstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در دسکتاپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 12,
          'step' => 1,
          'default' => 10,
      
        ]
      );
      $this->add_control(
        'productcolumn2categorycarouseltwentyfourthstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در تبلت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 8,
          'step' => 1,
          'default' => 6,
      
        ]
      );
      $this->add_control(
        'productcolumn3categorycarouseltwentyfourthstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در موبایل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 8,
          'step' => 1,
          'default' => 3,
      
        ]
      );
       $this->end_controls_section();
      $this->start_controls_section(
        'style2_categorycarouseltwentyfourthstkaveh',
        [
          'label' => esc_html__( 'استایل عنوان دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor1categorycarouseltwentyfourthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-category-nice-item .title' => 'color: {{VALUE}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlety1_categorycarouseltwentyfourthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان دسته بندی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-category-nice-item .title',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'styleimag_categorycarouseltwentyfourthstkaveh',
        [
          'label' => esc_html__( 'استایل تصویر دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'catimg1widthcategorycarouseltwentyfourthstkaveh',
        [
          'label' => esc_html__( 'عرض تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 500,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-category-nice-item img' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catimg1height2categorycarouseltwentyfourthstkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 500,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-category-nice-item img' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="top-category-nice">
      <div class="container">
        <!-- Start Carousel -->
        <div class="swiper swiper-top-category-nice overflow-hidden" data-swiper='{
          "breakpoints": {
            "320": {
              "slidesPerView": 2,
              "spaceBetween": 12
            },
            "400": {
              "slidesPerView": 3,
              "spaceBetween": 12
            },
            "500": {
              "slidesPerView": 4,
              "spaceBetween": 12
            },
            "576": {
              "slidesPerView": 5,
              "spaceBetween": 12
            },
            "768": {
              "slidesPerView": 7,
              "spaceBetween": 12
            },
            "992": {
              "slidesPerView": 9,
              "spaceBetween": 12
            },
            "1200": {
              "slidesPerView": 10,
              "spaceBetween": 12
            }
          }
        }'
        >
          <div class="swiper-wrapper">
          <?php
            if ( $settings['listcategorycarouseltwentyfourthstkaveh'] ) {
            foreach (  $settings['listcategorycarouseltwentyfourthstkaveh'] as $item ) {
            ?>
            <!-- Start Slide -->
            <div class="swiper-slide">
              <div class="top-category-nice-item position-relative">
                <a href="<?php echo esc_html($item['linkcategorycarouseltwentyfourthstkaveh']); ?>" class="stretched-link" aria-label="<?php echo  esc_html($item['title1categorycarouseltwentyfourthstkaveh']); ?>"></a>
                <img src="<?php echo esc_url($item['img1categorycarouselkaveh']['url']); ?>" alt=""
                  class="d-block mx-auto">
                <<?php echo  esc_attr($item['tagheading1categorycarouseltwentyfourthstkaveh']); ?> class="title text-center mb-0 mt-3 fw-bold"> <?php echo  esc_html($item['title1categorycarouseltwentyfourthstkaveh']); ?> </<?php echo  esc_attr($item['tagheading1categorycarouseltwentyfourthstkaveh']); ?>>
              </div>
            </div>
            <!-- End Slide -->
            <?php 
            }
              }
            ?>
          </div>
        </div>
        <!-- End Carousel -->
      </div>
    </section>
    <?php do_action('kelementor_inline_scripts'); ?>
    <?php
  }


}
