<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Categorycarouseltwentyfivethstkaveh extends Widget_Base{

  public function get_name(){
    return 'categorycarouseltwentyfivethstkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل دسته بندی ها سبک بیست و پنج', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentcategorycarouseltwentyfivethstkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'showticategorycarouseltwentyfivethstkaveh',
        [
          'label' => esc_html__( 'نمایش  عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'fwigti2categorycarouseltwentyfivethstkaveh',
        [
          'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'showticategorycarouseltwentyfivethstkaveh' => 'yes',
          ],
          'default' => 'آخرین ها، ',
        ]
      );
      $this->add_control(
        'tagti1categorycarouseltwentyfivethstkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H3',
          'condition' => [
            'showticategorycarouseltwentyfivethstkaveh' => 'yes',
          ],
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );

      $this->add_control(
        'wigti2categorycarouseltwentyfivethstkaveh',
        [
          'label' => esc_html__( 'عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'showticategorycarouseltwentyfivethstkaveh' => 'yes',
          ],
          'default' => 'جدیدترین محصولات اپل',
        ]
      );

      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
        'img1categorycarouselkaveh',
        [
          'label' => esc_html__( 'تصویر پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
        ]
      );
      $repeater->add_control(
        'showdarkcategorycarouseltwentyfivethstkaveh',
        [
          'label' => esc_html__( 'حالت دارک', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'no',
        ]
      );
      $repeater->add_control(
        'beftitle1categorycarouseltwentyfivethstkaveh',
        [
          'label' => esc_html__( 'پیش عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => 'سرفیس',
  
        ]
      );
      $repeater->add_control(
        'beftagheading1categorycarouseltwentyfivethstkaveh',
        [
          'label' => esc_html__( 'تگ پیش عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'div',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
      $repeater->add_control(
      'title1categorycarouseltwentyfivethstkaveh',
      [
        'label' => esc_html__( 'عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'مایکروسافت',

      ]
    );
    $repeater->add_control(
      'tagheading1categorycarouseltwentyfivethstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'div',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'p1categorycarouseltwentyfivethstkaveh',
      [
        'label' => esc_html__( 'توضیحات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => ' مشاهده و خرید سرفیس پرو ۹، سرفیس لپ تاپ و ... ',

      ]
    );
    $repeater->add_control(
      'linkcategorycarouseltwentyfivethstkaveh',
      [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
      ]
    );
    $repeater->add_control(
      'bgcolortbolcategorycarouseltwentyfivethstkaveh',
      [
        'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
      ]
    );
    $this->add_control(
      'listcategorycarouseltwentyfivethstkaveh',
      [
        'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'title1categorycarouseltwentyfivethstkaveh' => esc_html__( 'عنوان', 'kaveh-core' ),
            'title2categorycarouseltwentyfivethstkaveh' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
            'linkcategorycarouseltwentyfivethstkaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );

    
       $this->end_controls_section();
       $this->start_controls_section(
        'content3categorycarouseltwentyfivethstkaveh',
        [
          'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'productcolumncategorycarouseltwentyfivethstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در دسکتاپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 8,
          'step' => 1,
          'default' => 3,
      
        ]
      );
      $this->add_control(
        'productcolumn2categorycarouseltwentyfivethstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در تبلت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 2,
      
        ]
      );
      $this->add_control(
        'productcolumn3categorycarouseltwentyfivethstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در موبایل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => .1,
          'default' => 1.4,
      
        ]
      );
       $this->end_controls_section();
       $this->start_controls_section(
        'stylet_categorycarouseltwentyfivethstkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showticategorycarouseltwentyfivethstkaveh' => 'yes',
          ],
        ]
      );
      $this->add_control(
        'ftextcolortcategorycarouseltwentyfivethstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .last-products-nic-heading' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'ftitletyt_categorycarouseltwentyfivethstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .last-products-nic-heading',
        ]
      );
      $this->add_control(
        'textcolortcategorycarouseltwentyfivethstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .last-products-nic-heading span' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletyt_categorycarouseltwentyfivethstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .last-products-nic-heading span',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'styleo_categorycarouseltwentyfivethstkaveh',
        [
          'label' => esc_html__( 'استایل عنوان دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'befhead1tcategorycarouseltwentyfivethstkaveh',
        [
          'label' => esc_html__( 'رنگ پیش عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .last-products-nic-item .sup-title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'befhead1_categorycarouseltwentyfivethstkaveh',
          'label' => esc_html__( 'تایپوگرافی پیش عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .last-products-nic-item .sup-title',
        ]
      );
      $this->add_control(
        'befhead2tcategorycarouseltwentyfivethstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .last-products-nic-item .title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'befhead2_categorycarouseltwentyfivethstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .last-products-nic-item .title',
        ]
      );
      $this->add_control(
        'befheadptcategorycarouseltwentyfivethstkaveh',
        [
          'label' => esc_html__( 'رنگ متن', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .last-products-nic-item p' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'befheadp_categorycarouseltwentyfivethstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .last-products-nic-item p',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_categorycarouseltwentyfivethstkaveh',
        [
          'label' => esc_html__( 'استایل باکس دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'borderradiustcategorycarouseltwentyfivethstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [ 
            '{{WRAPPER}} .last-products-nic-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catimg1widthcategorycarouseltwentyfivethstkaveh',
        [
          'label' => esc_html__( 'عرض تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .last-products-nic-item' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catimg1height2categorycarouseltwentyfivethstkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .last-products-nic-item' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();

        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="last-products-nic">
      <div class="container">
      <?php if("yes"===$settings['showticategorycarouseltwentyfivethstkaveh']){?>
        <!-- Start Heading -->
        <<?php echo  esc_attr($settings['tagti1categorycarouseltwentyfivethstkaveh']); ?> class="last-products-nic-heading fw-semibold mb-0">
        <?php echo esc_html($settings['fwigti2categorycarouseltwentyfivethstkaveh']); ?>
          <span> <?php echo esc_html($settings['wigti2categorycarouseltwentyfivethstkaveh']); ?></span>
        </<?php echo  esc_attr($settings['tagti1categorycarouseltwentyfivethstkaveh']); ?>>
        <!-- End Heading -->
        <?php } ?>
        <!-- Start Carousel -->
        <div class="swiper swiper-last-products-nic overflow-hidden" data-swiper='{"breakpoints":{"spaceBetween":0,"320":{"slidesPerView":1.1},"576":{"slidesPerView":"auto"}}}'>
          <div class="swiper-wrapper">
          <?php
              $e=1;
              if ( $settings['listcategorycarouseltwentyfivethstkaveh'] ) {
              foreach (  $settings['listcategorycarouseltwentyfivethstkaveh'] as $item ) {
              ?>
            <!-- Start Slide -->
            <div class="swiper-slide">
              <div class="last-products-nic-item position-relative overflow-hidden">
                <a href="<?php echo esc_html($item['linkcategorycarouseltwentyfivethstkaveh']); ?>" class="stretched-link" aria-label="name product"></a>
                <div class="position-absolute top-0 start-0 p-3">
                  <<?php echo  esc_attr($item['beftagheading1categorycarouseltwentyfivethstkaveh']); ?>  class="sup-title mt-1 fw-bold d-block<?php if("yes"===$item['showdarkcategorycarouseltwentyfivethstkaveh']){?> text-white <?php } ?>"> <?php echo  esc_html($item['beftitle1categorycarouseltwentyfivethstkaveh']); ?> </<?php echo  esc_attr($item['beftagheading1categorycarouseltwentyfivethstkaveh']); ?> >
                  <<?php echo  esc_attr($item['tagheading1categorycarouseltwentyfivethstkaveh']); ?>  class="title mt-3 mb-0<?php if("yes"===$item['showdarkcategorycarouseltwentyfivethstkaveh']){?> text-white <?php } ?>"> <?php echo  esc_html($item['title1categorycarouseltwentyfivethstkaveh']); ?></<?php echo  esc_attr($item['tagheading1categorycarouseltwentyfivethstkaveh']); ?>>
                  <p class="mb-0 fw-light<?php if("yes"===$item['showdarkcategorycarouseltwentyfivethstkaveh']){?> text-white <?php } ?>"> <?php echo  esc_html($item['p1categorycarouseltwentyfivethstkaveh']); ?></p>
                </div>
                <img src="<?php echo esc_url($item['img1categorycarouselkaveh']['url']); ?>" alt="" width="360" height="450"
                  class="w-100 d-block">
              </div>
            </div>
            <!-- End Slide -->
            <?php 
              $e++;
              }
                }
              ?>
          </div>
        </div>
        <!-- End Carousel -->
      </div>
    </section>

<style>
  .categories-products-item .image img {
    object-fit: contain !important;
}
.categories-products-item .btn::before {
    background-size: contain !important;
}
</style>
<?php do_action('kelementor_inline_scripts'); ?>
    <?php
  }


}
