<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Categorycarouseltwelvethkaveh extends Widget_Base{

  public function get_name(){
    return 'categorycarouseltwelvethkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل دسته بندی ها سبک دوازده', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    $this->start_controls_section(
      'content00categorycarouseltwelvethkaveh',
      [
        'label' => esc_html__( 'تنظیمات محصولات تخفیف لحظه ای', 'kaveh-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
      $this->add_control(
        'pproductslahzecategorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'نمایش محصولات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'all',
          'options' => [
            'all'  => esc_html__( 'همه', 'kaveh-core' ),
            'cat'  => esc_html__( 'دسته بندی', 'kaveh-core' ),
    
          ],
        ]
        );
        $this->add_control(
          'psortproductslahzecategorycarouseltwelvethkaveh',
          [
            'label' => esc_html__( 'مرتب سازی محصولات براساس', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'date',
            'options' => [
              'date'  => esc_html__( 'تاریخ', 'kaveh-core' ),
              '_price'  => esc_html__( 'قیمت', 'kaveh-core' ),
              '_wc_average_rating'  => esc_html__( 'محبوب ترین', 'kaveh-core' ),
              'total_sales'  => esc_html__( 'میزان فروش', 'kaveh-core' ),
      
            ],
          ]
          );
          $this->add_control(
            'psortiproductslahzecategorycarouseltwelvethkaveh',
            [
              'label' => esc_html__( 'نوع مرتب سازی', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::SELECT,
              'default' => 'desc',
              'options' => [
                'asc'  => esc_html__( 'صعودی', 'kaveh-core' ),
                'desc'  => esc_html__( 'نزولی', 'kaveh-core' ),
              ],
            ]
            );
    $options2 = array();
  $orderby = 'name';
  $order = 'asc';
  $hide_empty = false ;
  $cat_args = array(
      'orderby'    => $orderby,
      'order'      => $order,
      'hide_empty' => $hide_empty,
  );
  
  $product_categories = get_terms( 'product_cat', $cat_args );
  
  foreach ( $product_categories as $key => $category ) {
      $options2[$category->term_id] = $category->name;
  }
  $this->add_control(
      'catproductslahzecategorycarouseltwelvethkaveh',
      [
        'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT2, 
        'multiple' => true,
        'options' => $options2,
        'condition' => [
          'pproductslahzecategorycarouseltwelvethkaveh' => 'cat',
        ],
      ]
  );
  $this->add_control(
    'productnumberproductscategorycarouseltwelvethkaveh',
    [
      'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::NUMBER,
      'min' => 0,
      'max' => 20,
      'step' => 1,
      'default' => 5,
    ]
  );
    $this->end_controls_section();
    $this->start_controls_section(
      'contentcategorycarouseltwelvethkaveh',
      [
        'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'showticategorycarouseltwelvethkaveh',
      [
        'label' => esc_html__( 'نمایش عنوان؟', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'yes' => esc_html__( 'بله', 'kaveh-core' ),
        'no' => esc_html__( 'خیر', 'kaveh-core' ),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'tagti1categorycarouseltwelvethkaveh',
      [
        'label' => esc_html__( 'تگ عنوان اصلی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'condition' => [
          'showticategorycarouseltwelvethkaveh' => 'yes',
        ],
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $this->add_control(
      'wigti1categorycarouseltwelvethkaveh',
      [
        'label' => esc_html__( 'عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'showticategorycarouseltwelvethkaveh' => 'yes',
        ],
        'default' => 'فروش ویژه عیدانه محصولات آرایشی',
      ]
    );
    $this->add_control(
      'tagtif1categorycarouseltwelvethkaveh',
      [
        'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H4',
        'condition' => [
          'showticategorycarouseltwelvethkaveh' => 'yes',
        ],
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $this->add_control(
      'widgti2bolcategorycarouseltwelvethkaveh',
      [
        'label' => esc_html__( 'عنوان فرعی بولد', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'showticategorycarouseltwelvethkaveh' => 'yes',
        ],
        'default' => 'دسته بندی',

      ]
    );
    $this->add_control(
      'widgti2categorycarouseltwelvethkaveh',
      [
        'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'showticategorycarouseltwelvethkaveh' => 'yes',
        ],
        'default' => 'محصولات',

      ]
    );
    $this->add_control(
      'wigp2categorycarouseltwelvethkaveh',
      [
        'label' => esc_html__( 'توضیحات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'condition' => [
          'showticategorycarouseltwelvethkaveh' => 'yes',
        ],
        'default' => 'لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم ',

      ]
    );
    $this->add_control(
      'showbuttoncategorycarouseltwelvethkaveh',
      [
        'label' => esc_html__( 'نمایش دکمه؟', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'yes' => esc_html__( 'بله', 'kaveh-core' ),
        'no' => esc_html__( 'خیر', 'kaveh-core' ),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
      $this->add_control(
        'buttonti2categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'showbuttoncategorycarouseltwelvethkaveh' => 'yes',
          ],
          'default' => 'اطلاعات بیشتر',
  
        ]
      );
      $this->add_control(
        'buttonicocategorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::ICONS,
          'skin' => 'inline',
          'condition' => [
            'showbuttoncategorycarouseltwelvethkaveh' => 'yes',
          ],
          'exclude_inline_options' => [ 'svg' ],
          'default' => [
            'value' => 'icon-angle-circle-top-left',
          ],
        ]
      ); 
      $this->add_control(
        'buttonlinkcategorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'showbuttoncategorycarouseltwelvethkaveh' => 'yes',
          ],
          'default' => '#',
  
        ]
      );
     $this->end_controls_section();
    $this->start_controls_section(
        'content1categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );

      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
        'img1categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
          ],
        ]
      );
      $repeater->add_control(
      'title1categorycarouseltwelvethkaveh',
      [
        'label' => esc_html__( 'عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'محصولات آیفون',

      ]
    );
    $repeater->add_control(
      'tagheading1categorycarouseltwelvethkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'linkcategorycarouseltwelvethkaveh',
      [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
      ]
    );
    $this->add_control(
      'listcategorycarouseltwelvethkaveh',
      [
        'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'title1categorycarouseltwelvethkaveh' => esc_html__( 'عنوان', 'kaveh-core' ),
            'linkcategorycarouseltwelvethkaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );

    
       $this->end_controls_section();
       $this->start_controls_section(
        'content3categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'productcolumncategorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در دسکتاپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 8,
          'step' => 1,
          'default' => 4,
      
        ]
      );
      $this->add_control(
        'productcolumn2categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در تبلت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 3,
      
        ]
      );
      $this->add_control(
        'productcolumn3categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در موبایل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => .5,
          'default' => 1.5,
      
        ]
      );
       $this->end_controls_section();
       $this->start_controls_section(
        'stylet_categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showticategorycarouseltwelvethkaveh' => 'yes',
          ],
        ]
      );
      $this->add_control(
        'textacolortbolcategorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-eight-title-en' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletyta_categorycarouseltwelvethkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-eight-title-en',
        ]
      );
      $this->add_control(
        'textcolortbolcategorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-eight-title b' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletytf_categorycarouseltwelvethkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان بولد', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-eight-title b',
        ]
      );
      $this->add_control(
        'textcolortcategorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-eight-title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletyt_categorycarouseltwelvethkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-eight-title',
        ]
      );
      $this->add_control(
        'textcolortpcategorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'رنگ توضیحات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-eight p' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletytp_categorycarouseltwelvethkaveh',
          'label' => esc_html__( 'تایپوگرافی توضیحات', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-eight p',
        ]
      );
      $this->add_control(
        'hr3procategorycarouseltwelvethkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'txttypomainbutprodt1categorycarouseltwelvethkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-eight .btn',
        ]
      );
      $this->add_control(
        'bficonsize5prodt1categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'سایز آیکون دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 10,
          ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-eight .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->start_controls_tabs(
        'style_tabs5prodt1categorycarouseltwelvethkaveh'
      );
      $this->start_controls_tab(
        'style_normal_tab5prodt1categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'text1color5prodt1categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-eight .btn' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'iconbuttoncolor5prodt1categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-eight .btn i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolor5prodt1categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-eight .btn' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradius5prodt1categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-eight .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border5prodt1categorycarouseltwelvethkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-eight .btn',
        ]
      );
      $this->add_control(
        'buttonborders5prodt1categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border5prodt1categorycarouseltwelvethkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-eight .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tab5prodt1categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'text1colorhover5prodt1categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-eight .btn:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'iconbuttoncolorhover5prodt1categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-eight .btn:hover i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhover5prodt1categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-eight .btn:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushover5prodt1categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-eight .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhover5prodt1categorycarouseltwelvethkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-eight .btn:hover',
        ]
      );
      $this->add_control(
        'buttonbordershover5prodt1categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhover5prodt1categorycarouseltwelvethkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-eight .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_control(
        'hr5prodt1categorycarouseltwelvethkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow5prodt1categorycarouseltwelvethkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-eight .btn',
        ]
      );
      $this->add_control(
        'buttonpadding15prodt1categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-eight .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style2_categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'استایل عنوان دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor1categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-products-three-item .title' => 'color: {{VALUE}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlety1_categorycarouseltwelvethkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان دسته بندی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .categories-products-three-item .title',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'استایل باکس دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'borderradiustcategorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .categories-products-three-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'bgproductboxcolor1categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'رنگ باکس دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-products-three-item' => 'background-color: {{VALUE}} !important;',
          ],
        ]
      );
      $this->add_control(
        'bgproductboxbordercolor1categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'رنگ حاشیه باکس دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-products-three-item::before' => 'background: linear-gradient(64.32deg, {{VALUE}} -7.21%, rgba(231, 231, 231, 0) 85.16%) border-box !important;',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'styleimag_categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'استایل تصویر دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'catimg1widthcategorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'عرض تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .categories-products-three-item img' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catimg1height2categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .categories-products-three-item img' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catimg1lefthcategorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'فاصله تصویر دسته بندی از چپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .categories-products-three-item img' => 'left: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catimg1bottom2categorycarouseltwelvethkaveh',
        [
          'label' => esc_html__( 'فاصله تصویر دسته بندی از پایین', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .categories-products-three-item img' => 'bottom: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();

        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="categories-products-three">
      <div class="container position-relative">
        <!-- Start Heading -->
        <div
          class="section-heading-eight d-flex align-items-sm-center flex-wrap flex-lg-nowrap gap-4 gap-lg-0 flex-column flex-sm-row">
          <?php if("yes"===$settings['showticategorycarouseltwelvethkaveh']){?>
          <div class="text-nowrap">
            <<?php echo  esc_attr($settings['tagti1categorycarouseltwelvethkaveh']); ?> class="section-heading-eight-title-en"><?php echo esc_html($settings['wigti1categorycarouseltwelvethkaveh']); ?> </<?php echo  esc_attr($settings['tagti1categorycarouseltwelvethkaveh']); ?>>
            <<?php echo  esc_attr($settings['tagtif1categorycarouseltwelvethkaveh']); ?> class="section-heading-eight-title">
              <b> <?php echo esc_html($settings['widgti2bolcategorycarouseltwelvethkaveh']); ?></b>
              <?php echo esc_html($settings['widgti2categorycarouseltwelvethkaveh']); ?>
            </<?php echo  esc_attr($settings['tagtif1categorycarouseltwelvethkaveh']); ?>>
          </div>
          <p class="mb-0 d-none d-lg-block">  <?php echo esc_html($settings['wigp2categorycarouseltwelvethkaveh']); ?></p>
          <?php } ?>
          <?php if("yes"===$settings['showbuttoncategorycarouseltwelvethkaveh']){?>
          <a href="<?php echo esc_url($settings['buttonlinkcategorycarouseltwelvethkaveh']); ?>" class="btn btn-purple-2 d-flex align-items-center justify-content-center text-nowrap ms-auto">
          <?php echo esc_html($settings['buttonti2categorycarouseltwelvethkaveh']); ?>
            <i class="<?php echo  esc_html($settings['buttonicocategorycarouseltwelvethkaveh']['value']); ?> ms-2"></i>
          </a>
          <?php } ?>
          <div class="swiper-bottom end-0 d-none d-md-flex align-items-md-center ms-lg-4">
            <div
              class="swiper-categories-products-three-pagination swiper-pagination m-0 position-relative top-0 start-0 bottom-0 end-0 d-flex">
            </div>
            <div
              class="swiper-categories-products-three-button-prev swiper-button-prev m-0 w-auto h-auto position-relative top-0 start-0 bottom-0 end-0 mx-3">
            </div>
            <div
              class="swiper-categories-products-three-button-next swiper-button-next m-0 w-auto h-auto position-relative top-0 start-0 bottom-0 end-0">
            </div>
          </div>
        </div>
        <!-- ENd Heading -->
        <div class="row">
          <div class="col-md-5 col-lg-4 col-xl-3">
            <!-- Start Carousel -->
            <div class="swiper swiper-discount-product-special position-relative overflow-hidden swiper-visibled swiper-visibled-mobile">
              <div class="swiper-wrapper">
              <?php if('cat'===$settings['pproductslahzecategorycarouseltwelvethkaveh']){ ?>
              <?php 
                  
                  // WP_Query args
                  $q_pc2_query_args = array(
                    'post_type' => array('product'),
'post_status' => array('publish'),
                    'posts_per_page' => $settings['productnumberproductscategorycarouseltwelvethkaveh'],
                    'order' => 'DESC',
                    'orderby' => 'date',
                    'tax_query' => array(
                      array(
                        "taxonomy" => "product_cat",
                        "field"    => "tag_ID",
                        "terms"    => $settings['catproductslahzecategorycarouseltwelvethkaveh'],
                      ),
                    ),
                    'meta_query' => WC()->query->get_meta_query(),
                    'post__in' => array_merge(array(0), wc_get_product_ids_on_sale())
                    
                  );

                  // The Query
                  $pc2_query = new \WP_Query($q_pc2_query_args);
                  
                  // The Loop
                  if ( $pc2_query->have_posts() ) {
                    while ( $pc2_query->have_posts() ) {
                      $pc2_query->the_post();
                      global $product;
                      $sale_price = $product->get_sale_price();
                      $normal_price = $product->get_regular_price();
                    
                      $pr_id = get_the_ID();
                    $stocka = $product->get_stock_status(); ?>
                <!-- Start Slide -->
                <div class="swiper-slide">
                  <div class="product-eight product-eight-offer">
                    <div class="image">
                      <a href="<?php the_permalink(); ?>">
                        <img src="<?php the_post_thumbnail_url('full'); ?>" alt="<?php the_title(); ?>" width="266" height="266">
                      </a>
                      <?php if("instock"==$stocka){ 
                      if(!empty($sale_price) ) { ?>
                      <div class="offer"> <?php $percentage = round( ( ( $product->get_regular_price() - $product->get_sale_price() ) / $product->get_regular_price() ) * 100 );
                      echo $percentage;
                      ?>% </div>
                      <?php }
                      } ?>
                      <?php
                      $stocka = $product->get_stock_status();
                      if("instock"!=$stocka){ ?>
                      <div class="status position-absolute top-0 text-center rounded-pill">
                        ناموجود
                      </div>
                      <?php }elseif("instock"===$stocka){ ?>
                        <div class="status position-absolute top-0 text-center rounded-pill stinsto">
                        موجود
                      </div>
                      <?php }else{} ?>
                    </div>
                    <div class="content">
                      <h2 class="product-name">
                        <a href="<?php the_permalink(); ?>"> <?php the_title(); ?></a>
                      </h2>
                      <div class="d-flex align-items-center justify-content-between">
                      <?php if("instock"==$stocka){ ?>
                  <?php if ( !$product->is_type( 'variable' ) ) { ?>
                    <?php if(!empty($sale_price) ) { ?>
                    <div class="price">
                      <del> <?php echo number_format($normal_price, 0, '.', ',');; ?> </del>
                      <span> <?php echo number_format($sale_price, 0, '.', ','); ?> </span>
                      <?php echo get_woocommerce_currency_symbol(); ?>
                    </div>
                    <?php }else{ ?>
                      <div class="price">
                      <span> <?php echo number_format($normal_price, 0, '.', ',');; ?> </span>
                      <?php echo get_woocommerce_currency_symbol(); ?>
                    </div>
                    <?php } ?>
                    <?php }else{ 
                  $price_v = $product->get_price_html(); 
                  echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v);
                } 
              }
            
                      
                      if("instock"==$stocka ){ ?>
                      <?php if ( !$product->is_type( 'variable' ) ) { ?>
                      <a type="submit" name="add-to-cart" value="<?php echo $pr_id ?>" class="btn btn-success-2 shadow-none single_add_to_cart_button"><span> + خرید </span></a>
                      <?php }else{ ?>
                      <?php } 
                      }else{?>
                      <span class="btn btn-notstock rounded-pill"> ناموجود</span>
                      <?php } ?>
                    </div>
                    <a href="<?php the_permalink(); ?>" class="btn btn-secondary rounded-pill"> مشاهده محصول </a>
                    </div>
                  </div>
                </div>
                <!-- End Slide -->
                <?php
                // Reset Original Post Data
                  wp_reset_postdata();
                }
              }
                  
                  ?>
              <?php }elseif('all'===$settings['pproductslahzecategorycarouseltwelvethkaveh']){
                // WP_Query args
            $ordvalue = $settings['psortproductslahzecategorycarouseltwelvethkaveh'];
            $ordi = $settings['psortiproductslahzecategorycarouseltwelvethkaveh'];
            $q_pc2_query_args = array(
              'post_type' => array('product'),
'post_status' => array('publish'),
              'posts_per_page' => $settings['productnumberproductscategorycarouseltwelvethkaveh'],
              'order' => $ordi,
              'orderby' => 'meta_value_num',
              'meta_key'       => $ordvalue,
              'meta_query' => WC()->query->get_meta_query(),
              'post__in' => array_merge(array(0), wc_get_product_ids_on_sale())

             
            ); 

            // The Query
            $pc2_query = new \WP_Query($q_pc2_query_args);

            // The Loop
            if ( $pc2_query->have_posts() ) {
              while ( $pc2_query->have_posts() ) {
                $pc2_query->the_post(); 
                global $product;
                $sale_price = $product->get_sale_price();
                $normal_price = $product->get_regular_price();
              
                $pr_id = get_the_ID();
              $stocka = $product->get_stock_status();?>
                <!-- Start Slide -->
                <div class="swiper-slide">
                  <div class="product-eight product-eight-offer">
                    <div class="image full-width">
                      <a href="<?php the_permalink(); ?>">
                        <img src="<?php the_post_thumbnail_url('full'); ?>" alt="<?php the_title(); ?>" width="266" height="266">
                      </a>
                      <?php if("instock"==$stocka){ 
                      if(!empty($sale_price) ) { ?>
                      <div class="offer"> <?php $percentage = round( ( ( $product->get_regular_price() - $product->get_sale_price() ) / $product->get_regular_price() ) * 100 );
                      echo $percentage;
                      ?>% </div>
                      <?php }
                      } ?>
                      <?php
                      $stocka = $product->get_stock_status();
                      if("instock"!=$stocka){ ?>
                      <div class="status position-absolute top-0 text-center rounded-pill">
                        ناموجود
                      </div>
                      <?php } ?>
                    </div>
                    <div class="content">
                      <h2 class="product-name">
                        <a href="<?php the_permalink(); ?>"> <?php the_title(); ?></a>
                      </h2>
                      <div class="d-flex align-items-center justify-content-between">
                      <?php if("instock"==$stocka){ ?>
                  <?php if ( !$product->is_type( 'variable' ) ) { ?>
                    <?php if(!empty($sale_price) ) { ?>
                    <div class="price">
                      <del> <?php echo number_format($normal_price, 0, '.', ',');; ?> </del>
                      <span> <?php echo number_format($sale_price, 0, '.', ','); ?> </span>
                      <?php echo get_woocommerce_currency_symbol(); ?>
                    </div>
                    <?php }else{ ?>
                      <div class="price">
                      <span> <?php echo number_format($normal_price, 0, '.', ',');; ?> </span>
                      <?php echo get_woocommerce_currency_symbol(); ?>
                    </div>
                    <?php } ?>
                    <?php }else{ 
                  $price_v = $product->get_price_html(); 
                  echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v);
                } 
              }
            
                      
                      if("instock"==$stocka ){ ?>
                      <?php if ( !$product->is_type( 'variable' ) ) { ?>
                      <a type="submit" name="add-to-cart" value="<?php echo $pr_id ?>" class="btn btn-success-2 shadow-none single_add_to_cart_button"><span> + خرید </span></a>
                      <?php }else{ ?>
                      <?php } 
                      }else{?>
                      <span class="btn btn-notstock rounded-pill"> ناموجود</span>
                      <?php } ?>
                    </div>
                    <a href="<?php the_permalink(); ?>" class="btn btn-secondary rounded-pill"> مشاهده محصول </a>
                    </div>
                  </div>
                </div>
                <!-- End Slide -->
                <?php
                // Reset Original Post Data
                  wp_reset_postdata();
                }
              }
                  
                  ?>
                <?php } ?>
              </div>
              <!-- Start Pagination -->
              <div class="swiper-pagination end-0"></div>
              <!-- End Pagination -->
            </div>
            <!-- End Carousel -->
          </div>
          <div class="col-md-7 col-lg-8 col-xl-9">
            <!-- Start Carousel -->
            <div class="swiper swiper-categories-products-three overflow-hidden swiper-button-arrow">
              <div class="swiper-wrapper">
              <?php
              if ( $settings['listcategorycarouseltwelvethkaveh'] ) {
              foreach (  $settings['listcategorycarouseltwelvethkaveh'] as $item ) {
              ?>
                <!-- Start Slide -->
                <div class="swiper-slide">
                  <div class="categories-products-three-item position-relative">
                    <a href="<?php echo esc_html($item['linkcategorycarouseltwelvethkaveh']); ?>" class="stretched-link" aria-label="category"></a>
                    <<?php echo  esc_attr($item['tagheading1categorycarouseltwelvethkaveh']); ?> class="title"><?php echo  esc_html($item['title1categorycarouseltwelvethkaveh']); ?></<?php echo  esc_attr($item['tagheading1categorycarouseltwelvethkaveh']); ?>>
                    <img src="<?php echo esc_url($item['img1categorycarouseltwelvethkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['img1categorycarouseltwelvethkaveh'] )); ?>" width="99" height="171"
                      class="position-absolute">
                  </div>
                </div>
                <!-- End Slide -->
                <?php 
                  }
                    }
                  ?>
              </div>
              <div
                class="swiper-bottom position-absolute start-50 translate-middle-x d-flex align-items-center justify-content-center d-md-none mt-5 flex-column flex-sm-row w-100 cat9pag">
                <div class="swiper-pagination m-0 w-auto h-auto position-relative top-0 start-0 bottom-0 end-0"></div>
                <div class="my-3 my-sm-0 d-flex align-items-center cat9pag">
                  <div
                    class="swiper-button-prev m-0 w-auto h-auto position-relative top-0 start-0 bottom-0 end-0 ms-sm-3 me-3">
                  </div>
                  <div class="swiper-button-next m-0 w-auto h-auto position-relative top-0 start-0 bottom-0 end-0">
                  </div>
                </div>
              </div>
            </div>
            <!-- End Carousel -->
          </div>
        </div>
      </div>
    </section>
    <script>
        function init<?php echo $clsid; ?>() {
        // Swiper Discount Product Special
        new Swiper(".swiper-discount-product-special", {
          watchSlidesProgress: true,
          pagination: {
            el: ".swiper-pagination",
            type: "bullets",
            clickable: true,
          },
          autoplay: {
            delay: 3000,
          },
          loop: true,
          breakpoints: {
            320: {
              slidesPerView: 2,
              spaceBetween: 12,
            },
            768: {
              slidesPerView: 1,
              spaceBetween: 20,
              effect: "fade",
              fadeEffect: {
                crossFade: true,
              },
            },
          }
        });

        let categoriesProductsThreeNext =
            ".swiper-categories-products-three-button-next",
          categoriesProductsThreePrev =
            ".swiper-categories-products-three-button-prev",
          categoriesProductsThreePagination =
            ".swiper-categories-products-three-pagination";

        if (window.outerWidth < 768) {
          categoriesProductsThreeNext = ".swiper-button-next";
          categoriesProductsThreePrev = ".swiper-button-prev";
          categoriesProductsThreePagination = ".swiper-pagination";
        }
        // Swiper Category Product Three
        new Swiper(".swiper-categories-products-three", {
          watchSlidesProgress: true,
          navigation: {
            nextEl: categoriesProductsThreeNext,
            prevEl: categoriesProductsThreePrev,
          },
          pagination: {
            el: categoriesProductsThreePagination,
            type: "bullets",
            clickable: true,
          },
          grid: {
            fill: "row",
            rows: 2,
          },
          breakpoints: {
            320: {
              slidesPerView: <?php echo  esc_html($settings['productcolumn3categorycarouseltwelvethkaveh']); ?>,
              spaceBetween: 8,
            },
            420: {
              slidesPerView: <?php echo  esc_html($settings['productcolumn3categorycarouseltwelvethkaveh']); ?>,
              spaceBetween: 12,
            },
            768: {
              slidesPerView: <?php echo  esc_html($settings['productcolumn3categorycarouseltwelvethkaveh']); ?>,
              spaceBetween: 20,
            },
            992: {
              slidesPerView: <?php echo  esc_html($settings['productcolumn2categorycarouseltwelvethkaveh']); ?>,
              spaceBetween: 20,
            },
            1200: {
              slidesPerView: <?php echo  esc_html($settings['productcolumncategorycarouseltwelvethkaveh']); ?>,
              spaceBetween: 32,
            },
            1400: {
              slidesPerView: <?php echo  esc_html($settings['productcolumncategorycarouseltwelvethkaveh']); ?>,
              spaceBetween: 55,
            },
          },
          on: {
            init: (swiper) => {
              const { currentBreakpoint, passedParams } = swiper,
                { slidesPerView } = passedParams.breakpoints[currentBreakpoint];
              
              swiper.slides.forEach((item, index) => {
                const thisIndex = index + 1,
                  allSlides = swiper.slides.length / 2;

                if (thisIndex > allSlides && swiper.slides.length > slidesPerView && thisIndex > slidesPerView) {
                  item.classList.add("two");
                }
              });
            },
            beforeResize: (swiper) => {
              swiper.update();
            },
          },
        });

        let direction = "vertical";

        if (window.outerWidth < 992) {
          direction = "horizontal";
        }
        }
        if (window.Swiper) {
            // Swiper library already loaded, initialize Swiper instance
            init<?php echo $clsid; ?>();
          } else {
            // Swiper library not yet loaded, wait for it to load
            window.addEventListener("load", function() {
              init<?php echo $clsid; ?>();
            });
          }
    </script>
    <style>
      .categories-products-three-item img {
    object-fit: contain !important;
}
.product-eight-offer .image .status.stinsto {
    background-color: #edf5e6;
    color: #00867d;
}
@media only screen and (max-width: 575px){
.swiper-categories-products-three{
margin-top:110px;
}
}
@media only screen and (max-width: 575px){
.cat9pag{
  display:none !important;
}
}
@media only screen and (max-width: 575px){
.swiper-categories-products-three {
    margin-top: 20px !important;
}
}
@media only screen and (max-width: 575px){
.swiper-discount-product-special .swiper-pagination {
    display: none !important;
}
}
@media only screen and (max-width: 575px){
.section-heading-eight {
    margin-bottom: 30px;
}
}
		@media only screen and (max-width: 575px){
.top-selling-products .swiper-button-next, .top-selling-products .swiper-button-prev {
    top: 30px;
}
}
@media only screen and (max-width: 575px){
	.section-heading-eight-title-en {
    font-size: 16px;
    text-align: center;
}
}


@media only screen and (max-width: 575px){
	.section-heading-eight-title {
    font-size: 16px;
    text-align: center;
}
}
    </style>
    <?php
  }


}
