<?php


use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class categorycarouselthirteenthstkaveh extends Widget_Base{

  public function get_name(){
    return 'categorycarouselthirteenthstkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل دسته بندی ها سبک سیزده', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentcategorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'هدینگ المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'showbeforetiacarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'نمایش تصویر قبل عنوان؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'imgbeforeticarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'تصویر قبل عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'condition' => [
            'showbeforetiacarouselthirteenthstkaveh' => 'yes',
          ],
        ]
      );
      $this->add_control(
        'showticategorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'نمایش عنوان؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'tagtifcategorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H4',
          'condition' => [
            'showticategorycarouselthirteenthstkaveh' => 'yes',
          ],
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
      $this->add_control(
        'wigtifcategorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'showticategorycarouselthirteenthstkaveh' => 'yes',
          ],
          'default' => 'Our product categories',
        ]
      );
      $this->add_control(
        'tagti1categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'تگ عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H2',
          'condition' => [
            'showticategorycarouselthirteenthstkaveh' => 'yes',
          ],
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
      $this->add_control(
        'widgticategorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'عنوان بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'showticategorycarouselthirteenthstkaveh' => 'yes',
          ],
          'default' => 'دسته بندی های',
  
        ]
      );
      $this->add_control(
        'wigti2categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'showticategorycarouselthirteenthstkaveh' => 'yes',
          ],
          'default' => 'پر فروش',
        ]
      );
      $this->add_control(
        'wigp2categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'توضیحات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXTAREA,
          'condition' => [
            'showticategorycarouselthirteenthstkaveh' => 'yes',
          ],
          'default' => 'همواره، قرار گرفتن در شرایطی که برای اولین بار تجربه‌اش می‌کنیم، در ما ایجاد استرس و اضطراب می‌کند؛ بنابراین اگر تلاش کنیم شرایطی را که می‌خواهیم در آن قرار بگیریم، از قبل به',
  
        ]
      );
      $this->add_control(
        'showbuttoncategorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'نمایش دکمه؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
        $this->add_control(
          'buttonti2categorycarouselthirteenthstkaveh',
          [
            'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
              'showbuttoncategorycarouselthirteenthstkaveh' => 'yes',
            ],
            'default' => 'تخفیف دار',
    
          ]
        );
        $this->add_control(
          'buttonicocategorycarouselthirteenthstkaveh',
          [
            'label' => esc_html__( 'آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::ICONS,
            'skin' => 'inline',
            'condition' => [
              'showbuttoncategorycarouselthirteenthstkaveh' => 'yes',
            ],
            'exclude_inline_options' => [ 'svg' ],
            'default' => [
              'value' => 'icon-eye-2',
            ],
          ]
        ); 
        $this->add_control(
          'buttonlinkcategorycarouselthirteenthstkaveh',
          [
            'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
              'showbuttoncategorycarouselthirteenthstkaveh' => 'yes',
            ],
            'default' => '#',
    
          ]
        );
       $this->end_controls_section();
       $this->start_controls_section(
        'content21categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
        'img1categorycarouselkaveh',
        [
          'label' => esc_html__( 'تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
          ],
        ]
      );
      $repeater->add_control(
      'title1categorycarouselthirteenthstkaveh',
      [
        'label' => esc_html__( 'عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'محصولات آیفون',

      ]
    );
    $repeater->add_control(
      'tagheading1categorycarouselthirteenthstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'title2categorycarouselthirteenthstkaveh',
      [
        'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Apple Iphone',

      ]
    );
    $repeater->add_control(
      'tagheading2categorycarouselthirteenthstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H4',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'linkcategorycarouselthirteenthstkaveh',
      [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
      ]
    );
    $this->add_control(
      'listcategorycarouselthirteenthstkaveh',
      [
        'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'title1categorycarouselthirteenthstkaveh' => esc_html__( 'عنوان', 'kaveh-core' ),
            'title2categorycarouselthirteenthstkaveh' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
            'linkcategorycarouselthirteenthstkaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );
    $this->add_control(
      'imgbgcategorycarouselthirteenthstkaveh',
      [
        'label' => esc_html__( 'تصویر پس زمینه باکس ها ', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'selectors' => [
          '{{WRAPPER}} .best-category-four-item .image' => 'background: url({{URL}})',
      ], 
      ]
    );
    
       $this->end_controls_section();
       $this->start_controls_section(
        'content3categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'productcolumncategorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در دسکتاپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 8,
          'step' => 1,
          'default' => 4,
      
        ]
      );
      $this->add_control(
        'productcolumn2categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در تبلت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 3,
      
        ]
      );
      $this->add_control(
        'productcolumn3categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در موبایل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 1,
      
        ]
      );
       $this->end_controls_section();
       $this->start_controls_section(
        'stylet_categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showticategorycarouselthirteenthstkaveh' => 'yes',
          ],
        ]
      );
      $this->add_control(
        'catbeforet1widthcategorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'عرض تصویر قبل عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-six .right::before' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catbeforet1heightcategorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر قبل عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-six .right::before' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'textcolort0categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-six-sup-title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletyt0_categorycarouselthirteenthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-six-sup-title',
        ]
      );
      $this->add_control(
        'textcolortbolcategorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-six-title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'textcolortcategorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-six-title span' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletyt_categorycarouselthirteenthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-six-title',
        ]
      );
      $this->add_control(
        'textcolortpcategorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ توضیحات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-six p' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletytp_categorycarouselthirteenthstkaveh',
          'label' => esc_html__( 'تایپوگرافی توضیحات', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-six p',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'stylebut_categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showbuttoncategorycarouselthirteenthstkaveh' => 'yes',
          ],
        ]
      );
      $this->add_control(
        'iconsize2categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ] ,
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-six .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletyp_categorycarouselthirteenthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-six .btn',
        ]
      );
      $this->add_control(
        'hrer3categorycarouselthirteenthstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      ); 
      $this->start_controls_tabs(
        'style_tabs2categorycarouselthirteenthstkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tab2categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'iconcolor2categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-six .btn i' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'textcolor2categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-six .btn' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonbg1categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-six .btn' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonradius2categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-six .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border2categorycarouselthirteenthstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-six .btn',
        ]
      );
      $this->add_control(
        'buttonborders2categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border2categorycarouselthirteenthstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-six .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tab2categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'iconcolor1hover2categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-six .btn:hover i' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'textcolor1hover2categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-six .btn:hover' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonbghover1categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-six .btn:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonradius1hover2categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-six .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border1hover2categorycarouselthirteenthstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-six .btn:hover',
        ]
      );
      $this->add_control(
        'buttonborders1hover2categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border1hover2categorycarouselthirteenthstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-six .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_control(
        'hrer2cart2kaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow2categorycarouselthirteenthstkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-six .btn',
        ]
      );
      $this->add_control(
        'buttonpadding1hover2categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'پدینگ دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-six .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();

      $this->start_controls_section(
        'style2_categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'استایل عنوان دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor1categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .best-category-four-item .detail .title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlety1_categorycarouselthirteenthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی دسته بندی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .best-category-four-item .detail .title',
        ]
      );
      $this->add_control(
        'textcolor21categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .best-category-four-item .detail .title-en' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlety2_categorycarouselthirteenthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی دسته بندی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .best-category-four-item .detail .title-en',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'استایل باکس دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'borderradiustcategorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .best-category-four-item .image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catbox1widthcategorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'عرض باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .best-category-four-item .image' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catbox1height2categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'ارتفاع باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .best-category-four-item .image' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );

      $this->end_controls_section();
      $this->start_controls_section(
        'style3arr_categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'استایل خط چین ها', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'arrowcolor1categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ خط چین ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .best-category-four-item::before' => 'border: 0.5px dashed {{VALUE}}30 !important;',

          ],
        ]
      );
      $this->add_control(
        'borderradiustkhatcategorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .best-category-four-item::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'styleimag_categorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'استایل تصویر دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'catimg1widthcategorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'عرض تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .best-category-four-item .image img' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catimg1heightcategorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .best-category-four-item .image img' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catmrtwidthcategorycarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'فاصله از بالا', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .best-category-four .swiper' => 'padding-top: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();

        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <!-- Start Best Category -->
    <section class="best-category-four">
      <div class="container">
        <!-- Start Heading -->
        <div class="section-heading-six d-flex align-items-sm-center position-relative flex-column flex-sm-row gap-4 gap-sm-0">
        <?php if("yes"===$settings['showticategorycarouselthirteenthstkaveh']){?>
          <div class="right position-relative text-nowrap text-center text-sm-start">
            <<?php echo  esc_attr($settings['tagtifcategorycarouselthirteenthstkaveh']); ?> class="section-heading-six-sup-title mb-0"><?php echo esc_html($settings['wigtifcategorycarouselthirteenthstkaveh']); ?></<?php echo  esc_attr($settings['tagtifcategorycarouselthirteenthstkaveh']); ?>>
            <<?php echo  esc_attr($settings['tagti1categorycarouselthirteenthstkaveh']); ?> class="section-heading-six-title mb-0"> <?php echo esc_html($settings['widgticategorycarouselthirteenthstkaveh']); ?><span> <?php echo esc_html($settings['wigti2categorycarouselthirteenthstkaveh']); ?> </span> </<?php echo  esc_attr($settings['tagti1categorycarouselthirteenthstkaveh']); ?>>
          </div>
          <p class="d-none d-lg-block"> <?php echo esc_html($settings['wigp2categorycarouselthirteenthstkaveh']); ?></p>
          <?php } ?>   
          <?php if("yes"===$settings['showbuttoncategorycarouselthirteenthstkaveh']){?>
          <a href="<?php echo esc_url($settings['buttonlinkcategorycarouselthirteenthstkaveh']); ?>" class="btn btn-dark-2 d-flex align-items-center justify-content-center text-nowrap ms-sm-auto">
           <?php echo esc_html($settings['buttonti2categorycarouselthirteenthstkaveh']); ?>
            <i class="<?php echo  esc_html($settings['buttonicocategorycarouselthirteenthstkaveh']['value']); ?> ms-2"></i>
          </a>
          <?php } ?>
        </div>
        <!-- End Heading -->
      <!-- Start Carousel -->
      <div class="swiper swiper-best-category-four overflow-hidden">
        <div class="swiper-wrapper">
        <?php
        if ( $settings['listcategorycarouselthirteenthstkaveh'] ) {
        foreach (  $settings['listcategorycarouselthirteenthstkaveh'] as $item ) {
        ?>
          <!-- Start Slide -->
          <div class="swiper-slide">
            <div class="best-category-four-item d-flex align-items-end position-relative">
              <a href="<?php echo esc_html($item['linkcategorycarouselthirteenthstkaveh']); ?>" class="stretched-link" aria-label="category"></a>
              <div class="image position-relative">
                <img src="<?php echo esc_url($item['img1categorycarouselkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['img1categorycarouselkaveh'] )); ?>" width="107" height="107"
                  class="position-absolute start-50 translate-middle-x">
              </div>
              <div class="detail">
                <<?php echo  esc_attr($item['tagheading1categorycarouselthirteenthstkaveh']); ?> class="title"> <?php echo  esc_html($item['title1categorycarouselthirteenthstkaveh']); ?></<?php echo  esc_attr($item['tagheading1categorycarouselthirteenthstkaveh']); ?>>
                <<?php echo  esc_attr($item['tagheading2categorycarouselthirteenthstkaveh']); ?> class="title-en mb-0"><?php echo  esc_html($item['title2categorycarouselthirteenthstkaveh']); ?></<?php echo  esc_attr($item['tagheading2categorycarouselthirteenthstkaveh']); ?>>
              </div>
            </div>
          </div>
          <!-- End Slide -->
          <?php 
          }
            }
          ?>
        </div>
      </div>
      <!-- End Carousel -->
      </div>
    </section>
    <!-- End Best Category -->
    <style>
    <?php if("yes"===$settings['showbeforetiacarouselthirteenthstkaveh']){?>
      .section-heading-six .right::before {
        background: url("<?php echo esc_url($settings['imgbeforeticarouselthirteenthstkaveh']['url']); ?>") 0 0 no-repeat;
        -webkit-background-size: contain !important;
        -moz-background-size: contain !important;
        -o-background-size: contain !important;
        background-size: contain !important;
    }
    <?php }else{?>
      .section-heading-six .right::before {
    display: none !important;
    }
    .section-heading-six .right {
        padding-right: 25px;
    }
    <?php
    } ?>
    </style>
    <?php if( \Elementor\Plugin::$instance->editor->is_edit_mode() ): ?>
    <script>
      function init<?php echo $clsid; ?>() {
        // Swiper Best Category Four
        new Swiper(".swiper-best-category-four", {
          grid: {
            fill: "row",
            rows: 2,
          },
          breakpoints: {
            320: {
              slidesPerView: 1.2,
              spaceBetween: 12,
            },
            460: {
              slidesPerView: 1.7,
              spaceBetween: 12,
            },
            576: {
              slidesPerView: 2,
              spaceBetween: 12,
            },
            768: {
              slidesPerView: 3,
              spaceBetween: 12,
            },
            992: {
              slidesPerView: 4,
              spaceBetween: 12,
            },
            1200: {
              slidesPerView: 4,
              spaceBetween: 22,
            },
          },
          on: {
            init: (swiper) => {
              swiper.slides.forEach((item, index) => {
                const thisIndex = index + 1,
                  allSlides = swiper.slides.length / 2;

                if (thisIndex > allSlides) {
                  item.firstElementChild.classList.add("two");
                }
              });
            },
          },
        });
        }
        if (window.Swiper) {
          // Swiper library already loaded, initialize Swiper instance
          init<?php echo $clsid; ?>();
        } else {
          // Swiper library not yet loaded, wait for it to load
          window.addEventListener("load", function() {
            init<?php echo $clsid; ?>();
          });
        }
    </script>
    <?php endif; ?>
    <?php
  }


}
