<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Categorycarouseltenthkaveh extends Widget_Base{

  public function get_name(){
    return 'categorycarouseltenthkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل دسته بندی ها سبک ده', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentcategorycarouseltenthkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );

      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
        'img1categorycarouselkaveh',
        [
          'label' => esc_html__( 'لوگو دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
          ],
        ]
      );
      $repeater->add_control(
      'title1categorycarouseltenthkaveh',
      [
        'label' => esc_html__( 'عنوان بولد', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'خرید قرص',

      ]
    );
    $repeater->add_control(
      'title2categorycarouseltenthkaveh',
      [
        'label' => esc_html__( 'عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'و دارو',

      ]
    );
    $repeater->add_control(
      'tagheading1categorycarouseltenthkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'buttonicocategorycarouseltenthkaveh',
      [
        'label' => esc_html__( 'آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'icon-arrow-left-2',
        ],
      ]
    ); 
    $repeater->add_control(
      'linkcategorycarouseltenthkaveh',
      [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
      ]
    );
    $this->add_control(
      'listcategorycarouseltenthkaveh',
      [
        'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'title1categorycarouseltenthkaveh' => esc_html__( 'خرید قرص', 'kaveh-core' ),
            'title2categorycarouseltenthkaveh' => esc_html__( 'و دارو', 'kaveh-core' ),
            'linkcategorycarouseltenthkaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    );

       $this->end_controls_section();
       $this->start_controls_section(
        'content3categorycarouseltenthkaveh',
        [
          'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'productcolumncategorycarouseltenthkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی ها در دسکتاپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 8,
          'step' => 1,
          'default' => 6,
      
        ]
      );
      $this->add_control(
        'productcolumn2categorycarouseltenthkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی ها در تبلت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 4,
      
        ]
      );
      $this->add_control(
        'productcolumn3categorycarouseltenthkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی ها در موبایل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 2,
      
        ]
      );
       $this->end_controls_section();
      $this->start_controls_section(
        'style2_categorycarouseltenthkaveh',
        [
          'label' => esc_html__( 'استایل عنوان دسته بندی ها', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor1bocategorycarouseltenthkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .best-category-two-item .title b' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'textcolor1categorycarouseltenthkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان دسته بندی ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .best-category-two-item .title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlety1_categorycarouseltenthkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان دسته بندی ها', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .best-category-two-item .title',
        ]
      );
      $this->add_control(
        'iconcolor1categorycarouseltenthkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .best-category-two-item i' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'iconsizcategorycarouseltenthkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .best-category-two-item i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_categorycarouseltenthkaveh',
        [
          'label' => esc_html__( 'استایل باکس دسته بندی ها', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'borderradiustcategorycarouseltenthkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .best-category-two-item::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'boxcolor1categorycarouseltenthkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .best-category-two-item::before' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->start_controls_tabs(
        'style_tabs2categorycarouseltenthkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tab2categorycarouseltenthkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border2categorycarouseltenthkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .best-category-two-item::before',
        ]
      );
      $this->add_control(
        'buttonborders2categorycarouseltenthkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border2categorycarouseltenthkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .best-category-two-item::before' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
        $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow2categorycarouseltenthkaveh',
          'label' => esc_html__( 'سایه باکس', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .best-category-two-item::before',
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tab2categorycarouseltenthkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border1hovercategorycarouseltenthkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .best-category-two-item:hover::before',
        ]
      );
      $this->add_control(
        'buttonborders1hover2categorycarouseltenthkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border1hovercategorycarouseltenthkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .best-category-two-item:hover::before' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow2hovercategorycarouseltenthkaveh',
          'label' => esc_html__( 'سایه باکس', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .best-category-two-item:hover::before',
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->end_controls_section();
      $this->start_controls_section(
        'styleimag_categorycarouseltenthkaveh',
        [
          'label' => esc_html__( 'استایل تصویر دسته بندی ها', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'catimg1widthcategorycarouseltenthkaveh',
        [
          'label' => esc_html__( 'عرض تصویر دسته بندی ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .best-category-two-item img' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catimg1height2categorycarouseltenthkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر دسته بندی ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .best-category-two-item img' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();

        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="best-category-two">
      <div class="container">
        <!-- Start Carousel -->
        <div class="swiper swiper-best-category-two" data-swiper='{"watchSlidesProgress":true,"breakpoints":{"320":{"slidesPerView":<?php echo  esc_html($settings['productcolumn3categorycarouseltenthkaveh']); ?>,"spaceBetween":12},"400":{"slidesPerView":<?php echo  esc_html($settings['productcolumn3categorycarouseltenthkaveh']); ?>,"spaceBetween":12},"576":{"slidesPerView":<?php echo  esc_html($settings['productcolumn2categorycarouseltenthkaveh']); ?>,"spaceBetween":8},"768":{"slidesPerView":<?php echo  esc_html($settings['productcolumn2categorycarouseltenthkaveh']); ?>,"spaceBetween":8},"992":{"slidesPerView":<?php echo  esc_html($settings['productcolumncategorycarouseltenthkaveh']); ?>,"spaceBetween":8},"1200":{"slidesPerView":<?php echo  esc_html($settings['productcolumncategorycarouseltenthkaveh']); ?>,"spaceBetween":8}}}'>
          <div class="swiper-wrapper">
          <?php
            if ( $settings['listcategorycarouseltenthkaveh'] ) {
            foreach (  $settings['listcategorycarouseltenthkaveh'] as $item ) {
            ?>
            <!-- Start Slide -->
            <div class="swiper-slide">
              <div class="best-category-two-item position-relative">
                <a href="<?php echo esc_html($item['linkcategorycarouseltenthkaveh']); ?>" class="stretched-link" aria-label="category"></a>
                <img src="<?php echo esc_url($item['img1categorycarouselkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['img1categorycarouselkaveh'] )); ?>" width="67" height="72" class="position-absolute top-50 start-0 translate-middle-y">
                <<?php echo  esc_attr($item['tagheading1categorycarouseltenthkaveh']); ?> class="title">
                  <b> <?php echo  esc_html($item['title1categorycarouseltenthkaveh']); ?></b> <?php echo  esc_html($item['title2categorycarouseltenthkaveh']); ?>
                </<?php echo  esc_attr($item['tagheading1categorycarouseltenthkaveh']); ?>>
                <i class="<?php echo  esc_attr($item['buttonicocategorycarouseltenthkaveh']['value']); ?> position-absolute"></i>
              </div>
            </div>
            <!-- End Slide -->
            <?php 
            }
              }
            ?>
          </div>
        </div>
        <!-- End Carousel -->
      </div>
    </section>
    <?php do_action('kelementor_inline_scripts'); ?>
    <?php
  }


}
