<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Categorycarouselsixthkaveh extends Widget_Base{

  public function get_name(){
    return 'categorycarouselsixthkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل دسته بندی ها سبک شش', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentcategorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'showbeforetiategorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'نمایش تصویر قبل عنوان؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'imgbeforeticategorycarouselkaveh',
        [
          'label' => esc_html__( 'تصویر قبل عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'condition' => [
            'showbeforetiategorycarouselsixthkaveh' => 'yes',
          ],
        ]
      );
      $this->add_control(
        'showticategorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'نمایش عنوان؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'tagti1categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H2',
          'condition' => [
            'showticategorycarouselsixthkaveh' => 'yes',
          ],
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
      $this->add_control(
        'widgticategorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'عنوان بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'showticategorycarouselsixthkaveh' => 'yes',
          ],
          'default' => 'دسته بندی های',
  
        ]
      );
      $this->add_control(
        'wigti2categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'showticategorycarouselsixthkaveh' => 'yes',
          ],
          'default' => 'پر فروش',
        ]
      );
      $this->add_control(
        'wigp2categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'توضیحات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXTAREA,
          'condition' => [
            'showticategorycarouselsixthkaveh' => 'yes',
          ],
          'default' => 'همواره، قرار گرفتن در شرایطی که برای اولین بار تجربه‌اش می‌کنیم، در ما ایجاد استرس و اضطراب می‌کند؛ بنابراین اگر تلاش کنیم شرایطی را که می‌خواهیم در آن قرار بگیریم، از قبل به',
  
        ]
      );
      $this->add_control(
        'showbuttoncategorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'نمایش دکمه؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
        $this->add_control(
          'buttonticategorycarouselsixthkaveh',
          [
            'label' => esc_html__( 'عنوان بولد دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
              'showbuttoncategorycarouselsixthkaveh' => 'yes',
            ],
            'default' => 'مشاهده محصولات',
    
          ]
        );
        $this->add_control(
          'buttonti2categorycarouselsixthkaveh',
          [
            'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
              'showbuttoncategorycarouselsixthkaveh' => 'yes',
            ],
            'default' => 'تخفیف دار',
    
          ]
        );
        $this->add_control(
          'buttonicocategorycarouselsixthkaveh',
          [
            'label' => esc_html__( 'آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::ICONS,
            'skin' => 'inline',
            'condition' => [
              'showbuttoncategorycarouselsixthkaveh' => 'yes',
            ],
            'exclude_inline_options' => [ 'svg' ],
            'default' => [
              'value' => 'icon-eye-2',
            ],
          ]
        ); 
        $this->add_control(
          'buttonlinkcategorycarouselsixthkaveh',
          [
            'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
              'showbuttoncategorycarouselsixthkaveh' => 'yes',
            ],
            'default' => '#',
    
          ]
        );
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
        'img1categorycarouselkaveh',
        [
          'label' => esc_html__( 'تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
          ],
        ]
      );
      $repeater->add_control(
      'title1categorycarouselsixthkaveh',
      [
        'label' => esc_html__( 'عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'محصولات آیفون',

      ]
    );
    $repeater->add_control(
      'tagheading1categorycarouselsixthkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'title2categorycarouselsixthkaveh',
      [
        'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Apple Iphone',

      ]
    );
    $repeater->add_control(
      'tagheading2categorycarouselsixthkaveh',
      [
        'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H4',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'linkcategorycarouselsixthkaveh',
      [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
      ]
    );
    $repeater->add_control(
      'imgbgcategorycarouselsixthkaveh',
      [
        'label' => esc_html__( 'تصویر پس زمینه ', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::MEDIA,
      ]
    );
    $this->add_control(
      'listcategorycarouselsixthkaveh',
      [
        'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'title1categorycarouselsixthkaveh' => esc_html__( 'عنوان', 'kaveh-core' ),
            'title2categorycarouselsixthkaveh' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
            'linkcategorycarouselsixthkaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );

    
       $this->end_controls_section();
       $this->start_controls_section(
        'content3categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'showarrowcategorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'نمایش فلش ها؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'productcolumncategorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در دسکتاپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 8,
          'step' => 1,
          'default' => 4,
      
        ]
      );
      $this->add_control(
        'productcolumn2categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در تبلت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 3,
      
        ]
      );
      $this->add_control(
        'productcolumn3categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در موبایل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 1,
      
        ]
      );
       $this->end_controls_section();
       $this->start_controls_section(
        'stylet_categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showticategorycarouselsixthkaveh' => 'yes',
          ],
        ]
      );
      $this->add_control(
        'textcolortbolcategorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-three-title b' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'textcolortcategorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-three-title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletyt_categorycarouselsixthkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-three-title',
        ]
      );
      $this->add_control(
        'textcolortpcategorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'رنگ توضیحات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-three p' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletytp_categorycarouselsixthkaveh',
          'label' => esc_html__( 'تایپوگرافی توضیحات', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-three p',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'stylebut_categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showbuttoncategorycarouselsixthkaveh' => 'yes',
          ],
        ]
      );
      $this->add_control(
        'iconsize2categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => 'px',
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-three-link i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletyp_categorycarouselsixthkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-three-link',
        ]
      );
      $this->add_control(
        'iconbgwidth2categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'عرض پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-three-link i' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconbgheight2categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'ارتفاع پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-three-link i' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'buttoniconradius2categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-three-link i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'hrer3categorycarouselsixthkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      ); 
      $this->start_controls_tabs(
        'style_tabs2categorycarouselsixthkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tab2categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'iconcolor2categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-three-link i' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'iconbg1categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-three-link i' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'textcolor2categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-three-link' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonbg1categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-three-link' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonradius2categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-three-link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border2categorycarouselsixthkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-three-link',
        ]
      );
      $this->add_control(
        'buttonborders2categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border2categorycarouselsixthkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-three-link' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tab2categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'iconcolor1hover2categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-three-link:hover i' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'iconbg1hover2categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-three-link:hover i' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'textcolor1hover2categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-three-link:hover' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonbghover1categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-three-link:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonradius1hover2categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-three-link:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border1hover2categorycarouselsixthkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-three-link:hover',
        ]
      );
      $this->add_control(
        'buttonborders1hover2categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border1hover2categorycarouselsixthkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-three-link:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_control(
        'hrer2cart2kaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow2categorycarouselsixthkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-three-link',
        ]
      );
      $this->add_control(
        'buttonpadding1hover2categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'پدینگ دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-three-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();

      $this->start_controls_section(
        'style2_categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'استایل عنوان دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor1categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-category-five-item .content .title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlety1_categorycarouselsixthkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی دسته بندی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-category-five-item .content .title',
        ]
      );
      $this->add_control(
        'textcolor21categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-category-five-item .content .sub-title' => 'background-image: -webkit-linear-gradient(top, rgba(255, 255, 255, 0) 0%, {{VALUE}} 100%);',
            '{{WRAPPER}} .top-category-five-item .content .sub-title' => 'background-image: -moz-linear-gradient(top, rgba(255, 255, 255, 0) 0%, {{VALUE}} 100%);',
            '{{WRAPPER}} .top-category-five-item .content .sub-title' => 'background-image: -o-linear-gradient(top, rgba(255, 255, 255, 0) 0%, {{VALUE}} 100%);',
            '{{WRAPPER}} .top-category-five-item .content .sub-title' => 'background-image: linear-gradient(180deg , rgba(255, 255, 255, 0) 0%, {{VALUE}} 100%);',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlety2_categorycarouselsixthkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی دسته بندی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-category-five-item .content .sub-title',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'استایل باکس دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'boxcolor1categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-category-five-item .content' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'borderradiustcategorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-category-five-item .content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'boxpadding1categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'پدینگ باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-category-five-item .content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3arr_categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'استایل فلش ها', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'arrowcolor1categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'رنگ فلش ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'showarrowcategorycarouselsixthkaveh' => 'yes',
          ],
          'selectors' => [
            '{{WRAPPER}} .swiper-button-next::after' => 'color: {{VALUE}} !important;',
            '{{WRAPPER}} .swiper-button-prev::after' => 'color: {{VALUE}} !important;',

          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'styleimag_categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'استایل تصویر دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'catimg1widthcategorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'عرض تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-category-five-item .image' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catimg1height2categorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-category-five-item .image' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();

        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
<section class="top-category-five my-100">
  <div class="container">
    <!-- Start Heading -->
    <div
      class="section-heading-three position-relative d-flex align-items-lg-center justify-content-lg-between flex-column flex-lg-row">
      <div>
          <?php if("yes"===$settings['showticategorycarouselsixthkaveh']){?>
            <<?php echo  esc_attr($settings['tagti1categorycarouselsixthkaveh']); ?> class="section-heading-three-title"> <b><?php echo esc_html($settings['widgticategorycarouselsixthkaveh']); ?></b> <?php echo esc_html($settings['wigti2categorycarouselsixthkaveh']); ?> </<?php echo  esc_attr($settings['tagti1categorycarouselsixthkaveh']); ?>>
            <p class="mb-0"><?php echo esc_html($settings['wigp2categorycarouselsixthkaveh']); ?></p>
            <?php } ?>   
          </div>
      <?php if("yes"===$settings['showbuttoncategorycarouselsixthkaveh']){?>
      <a href="<?php echo esc_url($settings['buttonlinkcategorycarouselsixthkaveh']); ?>"
        class="section-heading-three-link d-flex align-items-center position-relative text-nowrap mt-4 ms-md-0  mt-lg-0 ms-lg-4 me-lg-0">
        <i class="<?php echo  esc_html($settings['buttonicocategorycarouselsixthkaveh']['value']); ?> d-flex align-items-center justify-content-center"></i>
        <strong><?php echo esc_html($settings['buttonticategorycarouselsixthkaveh']); ?></strong> <?php echo esc_html($settings['buttonti2categorycarouselsixthkaveh']); ?>
      </a>
      <?php } ?>
    </div>
    <!-- End Heading -->
    <div class="position-relative">
    <!-- Start Carousel -->
    <div class="swiper swiper-top-category-five swiper-button-fill" data-swiper='{"watchSlidesProgress":true,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo  esc_html($settings['productcolumn3categorycarouselsixthkaveh']); ?>,"spaceBetween":8},"380":{"slidesPerView":<?php echo  esc_html($settings['productcolumn3categorycarouselsixthkaveh']); ?>,"spaceBetween":12},"576":{"slidesPerView":<?php echo  esc_html($settings['productcolumn2categorycarouselsixthkaveh']); ?>,"spaceBetween":12},"768":{"slidesPerView":<?php echo  esc_html($settings['productcolumn2categorycarouselsixthkaveh']); ?>,"spaceBetween":12},"992":{"slidesPerView":<?php echo  esc_html($settings['productcolumncategorycarouselsixthkaveh']); ?>,"spaceBetween":12},"1200":{"slidesPerView":<?php echo  esc_html($settings['productcolumncategorycarouselsixthkaveh']); ?>,"spaceBetween":20}}}'>
      <div class="swiper-wrapper">
        <?php
        $e=1;
        if ( $settings['listcategorycarouselsixthkaveh'] ) {
        foreach (  $settings['listcategorycarouselsixthkaveh'] as $item ) {
        ?>
        <!-- Start Slide -->
        <div class="swiper-slide">
          <div class="top-category-five-item position-relative">
            <a href="<?php echo esc_html($item['linkcategorycarouselsixthkaveh']); ?>" class="stretched-link" aria-label="link"></a>
            <div class="image position-absolute top-50 start-0 translate-middle-y">
              <img src="<?php echo esc_url($item['img1categorycarouselkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['img1categorycarouselkaveh'] )); ?>" width="153" height="93">
              <img src="<?php echo esc_url($item['img1categorycarouselkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['img1categorycarouselkaveh'] )); ?>" width="153" height="93"
                class="position-absolute top-0 end-0 w-100 h-100">
            </div>
            <div class="content gar<?php echo $e;?>">
              <<?php echo  esc_attr($item['tagheading1categorycarouselsixthkaveh']); ?> class="title"><?php echo  esc_html($item['title1categorycarouselsixthkaveh']); ?></<?php echo  esc_attr($item['tagheading1categorycarouselsixthkaveh']); ?>>
              <<?php echo  esc_attr($item['tagheading2categorycarouselsixthkaveh']); ?> class="sub-title"><?php echo  esc_html($item['title2categorycarouselsixthkaveh']); ?></<?php echo  esc_attr($item['tagheading2categorycarouselsixthkaveh']); ?>>
            </div>
          </div>
        </div>
        <!-- End Slide -->
        <style>
          .top-category-five-item <?php echo '.gar'. $e ?>.content {
          background: url("<?php echo esc_url($item['imgbgcategorycarouselsixthkaveh']['url']); ?>") 0 0 no-repeat;
          background-size: cover !important;
          }
        </style>
        <?php 
        $e++;
        }
          }
        ?>
      </div>
      <?php if("yes"===$settings['showarrowcategorycarouselsixthkaveh']){?>
      <div class="swiper-button-next"></div>
      <div class="swiper-button-prev"></div>
      <?php } ?>
    </div>
    <!-- End Carousel -->
  </div>
  </div>
  <style>
 <?php if("yes"===$settings['showbeforetiategorycarouselsixthkaveh']){?>
.section-heading-three::before {
    background: url("<?php echo esc_url($settings['imgbeforeticategorycarouselkaveh']['url']); ?>") 0 0 no-repeat;
    -webkit-background-size: contain !important;
    -moz-background-size: contain !important;
    -o-background-size: contain !important;
    background-size: contain !important;
}
<?php }else{?>
  .section-heading-three::before {
display: none !important;
}
.section-heading-three {
    padding-right: 25px;
}
<?php
} ?>
  </style>
</section>
<?php do_action('kelementor_inline_scripts'); ?>
    <?php
  }


}
