<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Categorycarouselseventhkaveh extends Widget_Base{

  public function get_name(){
    return 'categorycarouselseventhkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل دسته بندی ها سبک هفت', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentcategorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
        'img1categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
          ],
        ]
      );
      $repeater->add_control(
      'title1categorycarouselseventhkaveh',
      [
        'label' => esc_html__( 'عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'محصولات آیفون',

      ]
    );
    $repeater->add_control(
      'tagheading1categorycarouselseventhkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'title2categorycarouselseventhkaveh',
      [
        'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Apple Iphone',

      ]
    );
    $repeater->add_control(
      'linkcategorycarouselseventhkaveh',
      [
        'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
      ]
    );
    $this->add_control(
      'listcategorycarouselseventhkaveh',
      [
        'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'title1categorycarouselseventhkaveh' => esc_html__( 'عنوان', 'kaveh-core' ),
            'title2categorycarouselseventhkaveh' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
            'linkcategorycarouselseventhkaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    );
    $this->add_control(
      'imgbgcategorycarouselseventhkaveh',
      [
        'label' => esc_html__( 'تصویر پس زمینه ', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'selectors' => [
          '{{WRAPPER}} .top-category-products-item .image::before' =>
              'background: url({{URL}}) center center no-repeat',
      ],
      ]
    );
    
       $this->end_controls_section();
       $this->start_controls_section(
        'content3categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'showarrowcategorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'نمایش فلش ها؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'productcolumncategorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در دسکتاپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 8,
          'step' => 1,
          'default' => 5,
      
        ]
      );
      $this->add_control(
        'productcolumn2categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در تبلت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 3,
      
        ]
      );
      $this->add_control(
        'productcolumn3categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در موبایل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 2,
      
        ]
      );
       $this->end_controls_section();
       $this->start_controls_section(
        'style2_categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'استایل عنوان دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor1categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-category-products-item .title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'textcolorhover1categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'رنگ هاور عنوان دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-category-products-item:hover .title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlety1_categorycarouselseventhkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی دسته بندی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-category-products-item .title',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'stylebut_categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );

      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletyp_categorycarouselseventhkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-category-products-item .btn',
        ]
      );
      $this->add_control(
        'iconbg1categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'رنگ نقطه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-category-products-item .btn span::before' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'hrer3categorycarouselseventhkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      ); 
      $this->start_controls_tabs(
        'style_tabs2categorycarouselseventhkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tab2categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textcolor2categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-category-products-item .btn' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonbg1categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-category-products-item .btn' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonradius2categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-category-products-item .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border2categorycarouselseventhkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-category-products-item .btn',
        ]
      );
      $this->add_control(
        'buttonborders2categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border2categorycarouselseventhkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-category-products-item .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tab2categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textcolor1hover2categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-category-products-item .btn:hover' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonbghover1categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-category-products-item .btn:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonradius1hover2categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-category-products-item .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border1hover2categorycarouselseventhkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-category-products-item .btn:hover',
        ]
      );
      $this->add_control(
        'buttonborders1hover2categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border1hover2categorycarouselseventhkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-category-products-item .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_control(
        'hrer2cart2kaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow2categorycarouselseventhkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-category-products-item .btn',
        ]
      );
      $this->add_control(
        'buttonpadding1hover2categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'پدینگ دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-category-products-item .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();

      $this->start_controls_section(
        'style3_categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'استایل باکس دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'boxcolor1categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-category-products-item .image::before' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'boxcolorhoover1categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'رنگ هاور پس زمینه باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-category-products-item:hover .image::before' => 'background-color: {{VALUE}}',
            '{{WRAPPER}} .top-category-products-item:hover .image::after' => 'background-color: {{VALUE}}',

          ],
        ]
      );
      $this->add_control(
        'borderradiustcategorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-category-products-item .image::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3arr_categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'استایل فلش ها', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'arrowcolor1categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'رنگ فلش ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'showarrowcategorycarouselseventhkaveh' => 'yes',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-category-products .swiper-button-next::after' => 'color: {{VALUE}} !important;',
            '{{WRAPPER}} .top-category-products .swiper-button-prev::after' => 'color: {{VALUE}} !important;',

          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'styleimag_categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'استایل تصویر دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'catimg1widthcategorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'عرض تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-category-products-item .image .img img' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catimg1height2categorycarouselseventhkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-category-products-item .image .img img' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();

        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="top-category-products my-100">
  <div class="container">
    <!-- Start Carousel -->
    <div class="swiper swiper-top-category-products position-relative" data-swiper='{"watchSlidesProgress":true,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3categorycarouselseventhkaveh']); ?>,"spaceBetween":20},"500":{"slidesPerView":<?php echo esc_html($settings['productcolumn2categorycarouselseventhkaveh']); ?>,"spaceBetween":20},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2categorycarouselseventhkaveh']); ?>,"spaceBetween":20},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumncategorycarouselseventhkaveh']); ?>,"spaceBetween":20},"1200":{"slidesPerView":<?php echo esc_html($settings['productcolumncategorycarouselseventhkaveh']); ?>,"spaceBetween":30}}}'>
      <div class="swiper-wrapper">
        <?php
        if ( $settings['listcategorycarouselseventhkaveh'] ) {
        foreach (  $settings['listcategorycarouselseventhkaveh'] as $item ) {
        ?>
        <!-- Start Slide -->
        <div class="swiper-slide">
          <div class="top-category-products-item position-relative mx-auto w-100">
            <div class="image position-relative mx-auto">
              <span class="shape position-absolute top-0 end-50"></span>
              <span class="shape-2 position-absolute"></span>
              <div class="img position-relative mx-auto">
              <img src="<?php echo esc_url($item['img1categorycarouselseventhkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['img1categorycarouselseventhkaveh'] )); ?>" width="113" height="153"
                class="d-block mx-auto">
              <img src="<?php echo esc_url($item['img1categorycarouselseventhkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['img1categorycarouselseventhkaveh'] )); ?>" width="113" height="153"
                class="position-absolute top-0 end-0 w-100 h-100">
              </div>
            </div>
            <<?php echo  esc_attr($item['tagheading1categorycarouselseventhkaveh']); ?> class="title text-center text-truncate"><?php echo  esc_html($item['title1categorycarouselseventhkaveh']); ?></<?php echo  esc_attr($item['tagheading1categorycarouselseventhkaveh']); ?>>
            <a href="<?php echo esc_html($item['linkcategorycarouselseventhkaveh']); ?>" class="btn position-relative d-block mx-auto">
              <span><?php echo  esc_html($item['title2categorycarouselseventhkaveh']); ?></span>
            </a>
          </div>
        </div>
        <!-- End Slide -->
        <?php 
        }
          }
        ?>
      </div>
      <?php if("yes"===$settings['showarrowcategorycarouselseventhkaveh']){?>
      <div class="swiper-button-next"></div>
      <div class="swiper-button-prev"></div>
      <?php } ?>
    </div>
    <!-- End Carousel -->
  </div>
</section>
  <style>
.top-category-products-item .image::before {
    -webkit-background-size: cover !important;
    -moz-background-size: cover !important;
    -o-background-size: cover !important;
    background-size: cover !important;
}
.top-category-products-item .image .img img {
  object-fit: contain;
}
  </style>
    <?php do_action('kelementor_inline_scripts'); ?>
    <?php
  }


}
