<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
  exit; // Exit if accessed directly

class Categorycarouselseventeenthkaveh extends Widget_Base
{

  public function get_name()
  {
    return 'categorycarouselseventeenthkaveh';
  }

  public function get_title()
  {
    return esc_html__('کاروسل دسته بندی ها سبک هفدهم', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['kavehelements'];
  }

  protected function register_controls()
  {
    $this->start_controls_section(
      'contentproductscarouselseventeenthkaveh',
      [
        'label' => esc_html__('عنوان المان', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'titleproductscarouselseventeenthkaveh',
      [
        'label' => esc_html__('عنوان اصلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('پرفروش ترین محصولات', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'title2productscarouselseventeenthkaveh',
      [
        'label' => esc_html__('عنوان نازک', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('پوشاک', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'titleboldproductscarouselseventeenthkaveh',
      [
        'label' => esc_html__('عنوان بولد', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('ورزشی', 'kaveh-core'),

      ]
    );

    $this->add_control(
      'tagheadingproductscarouselseventeenthkaveh',
      [
        'label' => esc_html__('عنوان اصلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H3',
        'options' => [
          'H1' => esc_html__('H1', 'kaveh-core'),
          'H2' => esc_html__('H2', 'kaveh-core'),
          'H3' => esc_html__('H3', 'kaveh-core'),
          'H4' => esc_html__('H4', 'kaveh-core'),
          'H5' => esc_html__('H5', 'kaveh-core'),
          'H6' => esc_html__('H6', 'kaveh-core'),
          'p' => esc_html__('p', 'kaveh-core'),
          'div' => esc_html__('div', 'kaveh-core'),
        ],
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'content2categorycarouselseventeenthkaveh',
      [
        'label' => esc_html__('آیتم های دسته بندی کاروسل', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $repeater = new \Elementor\Repeater();

    $repeater->add_control(
      'img1categorycarouselseventeenthkaveh',
      [
        'label' => esc_html__('تصویر دسته بندی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
          'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $repeater->add_control(
      'title1categorycarouselseventeenthkaveh',
      [
        'label' => esc_html__('عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'محصولات آیفون',

      ]
    );
    $repeater->add_control(
      'tagheading1categorycarouselseventeenthkaveh',
      [
        'label' => esc_html__('تگ عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'options' => [
          'H1' => esc_html__('H1', 'kaveh-core'),
          'H2' => esc_html__('H2', 'kaveh-core'),
          'H3' => esc_html__('H3', 'kaveh-core'),
          'H4' => esc_html__('H4', 'kaveh-core'),
          'H5' => esc_html__('H5', 'kaveh-core'),
          'H6' => esc_html__('H6', 'kaveh-core'),
          'p' => esc_html__('p', 'kaveh-core'),
          'div' => esc_html__('div', 'kaveh-core'),
          'span' => esc_html__('span', 'kaveh-core'),
        ],
      ]
    );
    $repeater->add_control(
      'linkcategorycarouselseventeenthkaveh',
      [
        'label' => esc_html__('لینک دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
      ]
    );

    $this->add_control(
      'listcategorycarouselseventeenthkaveh',
      [
        'label' => esc_html__('دسته بندی ها', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'title1categorycarouselseventeenthkaveh' => esc_html__('عنوان', 'kaveh-core'),
            'title2categorycarouselseventeenthkaveh' => esc_html__('عنوان دکمه', 'kaveh-core'),
            'linkcategorycarouselseventeenthkaveh' => esc_html__('#', 'kaveh-core'),
          ],
        ]
      ]
    );
    $this->end_controls_section();


    $this->start_controls_section(
      'content3categorycarouselseventeenthkaveh',
      [
        'label' => esc_html__('تنظیمات کاروسل', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'productcolumncategorycarouselseventeenthkaveh',
      [
        'label' => esc_html__('تعداد ستون دسته بندی در دسکتاپ', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 8,
        'step' => 1,
        'default' => 7,

      ]
    );
    $this->add_control(
      'productcolumn2categorycarouselseventeenthkaveh',
      [
        'label' => esc_html__('تعداد ستون دسته بندی در تبلت', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 5,
        'step' => 1,
        'default' => 3,

      ]
    );
    $this->add_control(
      'productcolumn3categorycarouselseventeenthkaveh',
      [
        'label' => esc_html__('تعداد ستون دسته بندی در موبایل', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 5,
        'step' => 1,
        'default' => 2,

      ]
    );

    $this->end_controls_section();

    $this->start_controls_section(
      'style2_categorycarouselseventeenthkaveh',
      [
        'label' => esc_html__('استایل عنوان دسته بندی', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'textcolor1categorycarouselseventeenthkaveh',
      [
        'label' => esc_html__('رنگ عنوان دسته بندی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .category-specials-two-heading .title-en' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'titlety1_categorycarouselseventeenthkaveh',
        'label' => esc_html__('تایپوگرافی عنوان اصلی دسته بندی', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .category-specials-two-heading .title-en',
      ]
    );
    $this->add_control(
      'textcolorbot1categorycarouselseventeenthkaveh',
      [
        'label' => esc_html__('رنگ زیر عنوان دسته بندی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .category-specials-two-heading .title_bottom' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'titlety2_categorycarouselseventeenthkaveh',
        'label' => esc_html__('تایپوگرافی زیر عنوان دسته بندی', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .category-specials-two-heading .title_bottom',
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'slider__style',
      [
        'label' => esc_html__('استایل اسلایدر', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'slider__image__Width',
      [
        'label' => esc_html__('عرض تصویر آیتم', 'textdomain'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 1000,
            'step' => 5,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 117,
        ],
        'selectors' => [
          '{{WRAPPER}} .category-specials-two-item img' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'slider__image__height',
      [
        'label' => esc_html__('طول تصویر آیتم', 'textdomain'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 1000,
            'step' => 5,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 117,
        ],
        'selectors' => [
          '{{WRAPPER}} .category-specials-two-item img' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    // $this->add_group_control(
		// 	\Elementor\Group_Control_Background::get_type(),
		// 	[
		// 		'name' => 'slider__bg',
		// 		'types' => [ 'classic', 'gradient', 'video' ],
		// 		'selector' => '{{WRAPPER}} .category-specials-two-item::before',
		// 	]
		// );

    $this->add_control(
      'slider__bg',
      [
        'label' => esc_html__('رنگ پس زمینه آیتم', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'description' => 'به جای رنگ های عمومی از کد رنگی استفاده کنید',
        'selectors' => [
          '{{WRAPPER}} .category-specials-two-item::before' => 
          'background: linear-gradient(180deg, {{VALUE}} 0%, rgba(182, 157, 116, 0) 61.46%, rgba(182, 157, 116, 0) 100%) !important;',
        ],
      ]
    );
    
    $this->end_controls_section();

  }

  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>



    <section class="category-specials-two position-relative">
      <div class="container">

        <div class="category-specials-two-heading text-center">
          <<?php echo esc_attr($settings['tagheadingproductscarouselseventeenthkaveh']); ?> class="title-en">
            <?php echo esc_html($settings['titleproductscarouselseventeenthkaveh']); ?>
          </<?php echo esc_attr($settings['tagheadingproductscarouselseventeenthkaveh']); ?>>
          <div class="title title_bottom">
            <?php echo esc_html($settings['title2productscarouselseventeenthkaveh']); ?> <b>
              <?php echo esc_html($settings['titleboldproductscarouselseventeenthkaveh']); ?>
            </b>
          </div>
        </div>

        <div class="swiper swiper-category-specials-two overflow-hidden" data-swiper='{"watchSlidesProgress":true,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3categorycarouselseventeenthkaveh']); ?>,"spaceBetween":20},"500":{"slidesPerView":<?php echo esc_html($settings['productcolumn2categorycarouselseventeenthkaveh']); ?>,"spaceBetween":20},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2categorycarouselseventeenthkaveh']); ?>,"spaceBetween":20},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumncategorycarouselseventeenthkaveh']); ?>,"spaceBetween":20},"1200":{"slidesPerView":<?php echo esc_html($settings['productcolumncategorycarouselseventeenthkaveh']); ?>,"spaceBetween":30}}}'>
          <div class="swiper-wrapper">
            <?php
            if ($settings['listcategorycarouselseventeenthkaveh']) {
              foreach ($settings['listcategorycarouselseventeenthkaveh'] as $item) {
                ?>
                <!-- Start Slide -->
                <div class="swiper-slide">
                  <div class="category-specials-two-item position-relative">
                    <a href="<?php echo esc_html($item['linkcategorycarouselseventeenthkaveh']); ?>" class="stretched-link"
                      aria-label="category"></a>
                    <img src="<?php echo esc_url($item['img1categorycarouselseventeenthkaveh']['url']); ?>" alt="category"
                      width="117" height="117" class="d-block mx-auto">
                    <<?php echo esc_attr($item['tagheading1categorycarouselseventeenthkaveh']); ?> class="title text-center
                      text-white mt-2 mb-0 position-relative">
                      <?php echo esc_html($item['title1categorycarouselseventeenthkaveh']); ?>
                    </<?php echo esc_attr($item['tagheading1categorycarouselseventeenthkaveh']); ?>>
                  </div>
                </div>
                <!-- End Slide -->
                <?php
              }
            }
            ?>

          </div>
        </div>
        <!-- End Carousel -->
      </div>
    </section>
    <!-- End Category Specials -->
    <?php do_action('kelementor_inline_scripts'); ?>       


    <?php
  }

}