<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Categorycarouselkaveh extends Widget_Base{

  public function get_name(){
    return 'categorycarouselkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل دسته بندی ها', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentcategorycarouselkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'catstcategorycarouselkaveh',
        [
          'label' => esc_html__( 'استایل دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => '1style',
          'options' => [
            '1style'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
            '2style'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ), 
          ],
        ]
        );
        $this->add_control(
          'showtitlecategorycarouselkaveh',
          [
            'label' => esc_html__( 'نمایش عنوان؟', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'yes' => esc_html__( 'بله', 'kaveh-core' ),
            'no' => esc_html__( 'خیر', 'kaveh-core' ),
            'return_value' => 'yes',
            'default' => 'yes',
            'condition' => [
              'catstcategorycarouselkaveh' => '2style',
            ],
          ]
        );
        $this->add_control(
          'tcategorycarouselkaveh',
          [
              'label' => esc_html__( 'عنوان', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'دسته بندی های محصولات', 'kaveh-core' ),
              'condition' => [
                'catstcategorycarouselkaveh' => '2style',
                'showtitlecategorycarouselkaveh' => 'yes',
              ],
      
          ]
      );
      $this->add_control(
        'tagheading1categorycarouselkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H6',
          'condition' => [
            'catstcategorycarouselkaveh' => '2style',
            'showtitlecategorycarouselkaveh' => 'yes',
          ],
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
      'title1categorycarouselkaveh',
      [
        'label' => esc_html__( 'عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'دسته بندی',

      ]
    );
    $repeater->add_control(
      'tagheadingcategorycarouselkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H6',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'iconcategorycarouselkaveh',
      [
        'label' => esc_html__( 'آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'icon-footbal',
        ],
      ]
    ); 
    $repeater->add_control(
      'linkcategorycarouselkaveh',
      [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
      ]
    );
    $this->add_control(
      'listcategorycarouselkaveh',
      [
        'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'title1categorycarouselkaveh' => esc_html__( 'عنوان', 'kaveh-core' ),
            'linkcategorycarouselkaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );
    $this->add_control(
      'imgbgcategorycarouselkaveh',
      [
        'label' => esc_html__( 'تصویر پس زمینه هاور', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'selectors' => [
          '{{WRAPPER}} .category-products .top-category-item::after' =>
              'background-image: url({{URL}})',
      ],
        'condition' => [
          'catstcategorycarouselkaveh' => '2style',
        ],
      ]
    );
    
       $this->end_controls_section();
       $this->start_controls_section(
        'content3categorycarouselkaveh',
        [
          'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'productcolumncategorycarouselkaveh',
        [
          'label' => esc_html__( 'تعداد ستون محصولات در دسکتاپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 8,
          'step' => 1,
          'default' => 8,
      
        ]
      );
      $this->add_control(
        'productcolumn2categorycarouselkaveh',
        [
          'label' => esc_html__( 'تعداد ستون محصولات در تبلت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 4,
      
        ]
      );
      $this->add_control(
        'productcolumn3categorycarouselkaveh',
        [
          'label' => esc_html__( 'تعداد ستون محصولات در موبایل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 2,
      
        ]
      );
       $this->end_controls_section();
       $this->start_controls_section(
        'style3_categorycarouselkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'catstcategorycarouselkaveh' => '2style',
          ],
        ]
      );
      $this->add_control(
        'title3categorycarouselkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .category-products-title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title3_categorycarouselkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .category-products-title',
        ]
      );
      $this->add_control(
        'bgtitlecategorycarouselkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .category-products-title' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'paddingtcategorycarouselkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .category-products-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'radiustcategorycarouselkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .category-products-title:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
       $this->start_controls_section(
        'style_categorycarouselkaveh',
        [
          'label' => esc_html__( 'استایل آیکون', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'iconsizecategorycarouselkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 31,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-category-item i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->start_controls_tabs(
        'styleiconcolorcategorycarouselkaveh'
      );
      
      $this->start_controls_tab(
        'style_normalcategorycarouselkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'iconclcategorycarouselkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-category-item i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'iconbgcategorycarouselkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-category-item i' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'radiusiconcategorycarouselkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-category-item i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'bordercategorycarouselkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-category-item i',
        ]
      );
      $this->add_control(
        'buttonborderscategorycarouselkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'bordercategorycarouselkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-category-item i' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hovercategorycarouselkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'iconclhovercategorycarouselkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-category-item i:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'iconbghovercategorycarouselkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-category-item i:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'radiusiconhovercategorycarouselkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-category-item i:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhovercategorycarouselkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-category-item i:hover',
        ]
      );
      $this->add_control(
        'buttonbordershovercategorycarouselkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhovercategorycarouselkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-category-item i:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_control(
        'hr1categorycarouselkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'paddingcategorycarouselkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-category-item i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style2_categorycarouselkaveh',
        [
          'label' => esc_html__( 'استایل عنوان دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor2categorycarouselkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-category-item h1, .top-category-item h2, .top-category-item h3, .top-category-item h4, .top-category-item h5, .top-category-item h6, .top-category-item p, .top-category-item div' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_categorycarouselkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان دسته بندی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-category-item h1, .top-category-item h2, .top-category-item h3, .top-category-item h4, .top-category-item h5, .top-category-item h6, .top-category-item p, .top-category-item div',
        ]
      );
      $this->add_control(
        'mttitlecategorycarouselkaveh',
        [
          'label' => esc_html__( 'فاصله از بالا', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 5,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 22,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-category-item h1, .top-category-item h2, .top-category-item h3, .top-category-item h4, .top-category-item h5, .top-category-item h6, .top-category-item p, .top-category-item div' => 'margin-top: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();

        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
     <?php if('1style'===$settings['catstcategorycarouselkaveh']){ ?>
     <div class="top-category">
      <div class="container position-relative">
        <div class="top-category-wrapper position-relative">
          <div class="swiper swiper-top-category overflow-hidden" data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"loop":true,"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3categorycarouselkaveh']); ?>,"spaceBetween":4},"500":{"slidesPerView":<?php echo esc_html($settings['productcolumn3categorycarouselkaveh']); ?>,"spaceBetween":14},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2categorycarouselkaveh']); ?>,"spaceBetween":14},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumncategorycarouselkaveh']); ?>,"spaceBetween":20},"1200":{"slidesPerView":<?php echo esc_html($settings['productcolumncategorycarouselkaveh']); ?>,"spaceBetween":31}}}'>
            <div class="swiper-wrapper">
            <?php
              if ( $settings['listcategorycarouselkaveh'] ) {
              foreach (  $settings['listcategorycarouselkaveh'] as $item ) {
              ?>
              <div class="swiper-slide">
                <a href="<?php echo  esc_html($item['linkcategorycarouselkaveh']); ?>" class="top-category-item">
                  <i class="<?php echo  esc_html($item['iconcategorycarouselkaveh']['value']); ?>"></i>
                  <<?php echo  esc_attr($item['tagheadingcategorycarouselkaveh']); ?>><?php echo  esc_html($item['title1categorycarouselkaveh']); ?></<?php echo  esc_attr($item['tagheadingcategorycarouselkaveh']); ?>>
                </a>
              </div>
              <?php 
            }
              }
            ?>
            </div>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
          </div>
        </div>
      </div>
    </div>
    <?php }elseif('2style'===$settings['catstcategorycarouselkaveh']){?>
      <section class="category-products">
      <div class="container position-relative">
      <?php if("yes"===$settings['showtitlecategorycarouselkaveh']){?>
        <<?php echo  esc_attr($settings['tagheading1categorycarouselkaveh']); ?> class="category-products-title mx-auto"><?php echo  esc_html($settings['tcategorycarouselkaveh']); ?></<?php echo  esc_attr($settings['tagheading1categorycarouselkaveh']); ?>>
        <?php } ?>
        <div class="swiper swiper-top-category overflow-hidden" data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"loop":true,"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3categorycarouselkaveh']); ?>,"spaceBetween":4},"500":{"slidesPerView":<?php echo esc_html($settings['productcolumn3categorycarouselkaveh']); ?>,"spaceBetween":14},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2categorycarouselkaveh']); ?>,"spaceBetween":14},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumncategorycarouselkaveh']); ?>,"spaceBetween":20},"1200":{"slidesPerView":<?php echo esc_html($settings['productcolumncategorycarouselkaveh']); ?>,"spaceBetween":31}}}'>
          <div class="swiper-wrapper">
          <?php
              if ( $settings['listcategorycarouselkaveh'] ) {
              foreach (  $settings['listcategorycarouselkaveh'] as $item ) {
              ?>
            <div class="swiper-slide">
              <a href="<?php echo  esc_html($item['linkcategorycarouselkaveh']); ?>" class="top-category-item">
                <i class="icon-footbal"></i>
                <<?php echo  esc_attr($item['tagheadingcategorycarouselkaveh']); ?>> <?php echo  esc_html($item['title1categorycarouselkaveh']); ?> </<?php echo  esc_attr($item['tagheadingcategorycarouselkaveh']); ?>>
              </a>
            </div>
            <?php 
            }
              }
            ?>
          </div>
          <div class="swiper-button-next"></div>
          <div class="swiper-button-prev"></div>
        </div>
      </div>
    </section>
<style>
  <?php echo '.elementor-element-' . $clsid . ''; ?> .category-products .top-category-item::after {
    background-size: cover;
}
</style>
    <?php }?>
    <?php do_action('kelementor_inline_scripts'); ?>
    <?php
  }


}
