<?php


use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Categorycarouselfourteenthstkaveh extends Widget_Base{

  public function get_name(){
    return 'categorycarouselfourteenthstkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل دسته بندی ها سبک چهارده', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
       $this->start_controls_section(
        'content21categorycarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
        'img1categorycarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
          ],
        ]
      );
      $repeater->add_control(
      'title1categorycarouselfourteenthstkaveh',
      [
        'label' => esc_html__( 'عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'محصولات آیفون',

      ]
    );
    $repeater->add_control(
      'tagheading1categorycarouselfourteenthstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'title2categorycarouselfourteenthstkaveh',
      [
        'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Apple Iphone',

      ]
    );
    $repeater->add_control(
      'tagheading2categorycarouselfourteenthstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H4',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'buttonicocategorycarouselfourteenthstkaveh',
      [
        'label' => esc_html__( 'آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'icon-arrow-left',
        ],
      ]
    ); 
    $repeater->add_control(
      'linkcategorycarouselfourteenthstkaveh',
      [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
      ]
    );
    $this->add_control(
      'listcategorycarouselfourteenthstkaveh',
      [
        'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'title1categorycarouselfourteenthstkaveh' => esc_html__( 'عنوان', 'kaveh-core' ),
            'title2categorycarouselfourteenthstkaveh' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
            'linkcategorycarouselfourteenthstkaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );
    $this->add_control(
      'imgbg1categorycarouselfourteenthstkaveh',
      [
        'label' => esc_html__( 'تصویر پس زمینه دسته بندی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'selectors' => [
          '{{WRAPPER}} .top-category-products-two-item::before' => 'background: url({{URL}}) 0 0 no-repeat',
      ], 
      ]
    );
       $this->end_controls_section();
       $this->start_controls_section(
        'content3categorycarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'showarrowcategorycarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'نمایش فلش ها؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
        );
      $this->add_control(
        'productcolumncategorycarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در دسکتاپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 4,
          'step' => 1,
          'default' => 3,
      
        ]
      );
      $this->add_control(
        'productcolumn2categorycarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در تبلت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 4,
          'step' => 1,
          'default' => 2,
      
        ]
      );
      $this->add_control(
        'productcolumn3categorycarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در موبایل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 1,
      
        ]
      );
       $this->end_controls_section();
      $this->start_controls_section(
        'style2_categorycarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'استایل عنوان دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor1categorycarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-category-products-two-item .content .title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlety1_categorycarouselfourteenthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی دسته بندی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-category-products-two-item .content .title',
        ]
      );
      $this->add_control(
        'textcolor21categorycarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-category-products-two-item .content .title-en' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlety2_categorycarouselfourteenthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی دسته بندی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-category-products-two-item .content .title-en',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_categorycarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'استایل باکس دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'borderradiustcategorycarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-category-products-two-item .content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'buttonpadding1hover2categorycarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'پدینگ باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-category-products-two-item .content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catbox1widthcategorycarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'فاصله باکس از راست', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-category-products-two-item .content' => 'margin-right: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'bordercolor1categorycarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ حاشیه باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-category-products-two-item .content' => 'border: 1px solid {{VALUE}} !important;',

          ],
        ]
      );
      $this->add_control(
        'iconsize2categorycarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ] ,
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-category-products-two-item .content i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconcolor2categorycarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-category-products-two-item .content i' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'arrowscolor2categorycarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ فلش ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'showarrowcategorycarouselfourteenthstkaveh' => 'yes',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-category-products-two .swiper-button-next::after' => 'color: {{VALUE}}',
            '{{WRAPPER}} .top-category-products-two .swiper-button-prev::after' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'styleimag_categorycarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'استایل تصویر دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'catimg1heightcategorycarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 180,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .imagefourteencat' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catimg1widthcategorycarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'عرض تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .imagefourteencat' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catimgbg1widthcategorycarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'بیشترین ارتفاع تصویر پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 140,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-category-products-two-item::before' => 'width: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .top-category-products-two-item::before' => 'height: {{SIZE}}{{UNIT}};',

          ],
        ]
      );
      $this->end_controls_section();

        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="top-category-products-two">
      <div class="container">
        <div class="position-relative">
          <!-- Start Carousel -->
          <div class="swiper swiper-top-category-products-two" data-swiper='{"watchSlidesProgress":true,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo  esc_html($settings['productcolumn3categorycarouselfourteenthstkaveh']); ?>,"spaceBetween":8},"500":{"slidesPerView":<?php echo  esc_html($settings['productcolumn2categorycarouselfourteenthstkaveh']); ?>,"spaceBetween":12},"992":{"slidesPerView":<?php echo  esc_html($settings['productcolumncategorycarouselfourteenthstkaveh']); ?>,"spaceBetween":12},"1200":{"slidesPerView":<?php echo  esc_html($settings['productcolumncategorycarouselfourteenthstkaveh']); ?>,"spaceBetween":20}}}'>
            <div class="swiper-wrapper">
              <?php
              if ( $settings['listcategorycarouselfourteenthstkaveh'] ) {
              foreach (  $settings['listcategorycarouselfourteenthstkaveh'] as $item ) {
              ?>
              <!-- Start Slide -->
              <div class="swiper-slide">
                <div class="top-category-products-two-item position-relative">
                  <a href="<?php echo esc_html($item['linkcategorycarouselfourteenthstkaveh']); ?>" class="stretched-link" aria-label="category"></a>
                  <div class="image position-absolute top-50 translate-middle-y">
                    <img class="imagefourteencat" src="<?php echo esc_url($item['img1categorycarouselfourteenthstkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['img1categorycarouselfourteenthstkaveh'] )); ?>" width="166" height="88"
                      class="w-100 h-100">
                    <img src="<?php echo esc_url($item['img1categorycarouselfourteenthstkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['img1categorycarouselfourteenthstkaveh'] )); ?>" width="166" height="88"
                      class="w-100 h-100 position-absolute top-0 end-0">
                  </div>
                  <div class="content d-flex align-items-center justify-content-between">
                    <div>
                      <<?php echo  esc_attr($item['tagheading1categorycarouselfourteenthstkaveh']); ?> class="title"> <?php echo  esc_html($item['title1categorycarouselfourteenthstkaveh']); ?></<?php echo  esc_attr($item['tagheading1categorycarouselfourteenthstkaveh']); ?>>
                      <<?php echo  esc_attr($item['tagheading2categorycarouselfourteenthstkaveh']); ?> class="title-en"> <?php echo  esc_html($item['title2categorycarouselfourteenthstkaveh']); ?> </<?php echo  esc_attr($item['tagheading2categorycarouselfourteenthstkaveh']); ?>>
                    </div>
                    <i class="<?php echo  esc_html($item['buttonicocategorycarouselfourteenthstkaveh']['value']); ?> ms-2"></i>
                  </div>
                </div>
              </div>
              <!-- End Slide -->
              <?php 
            }
              }
            ?>
            </div>
            <?php if("yes"===$settings['showarrowcategorycarouselfourteenthstkaveh']){?>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
            <?php } ?>
          </div>
          <!-- End Carousel -->
        </div>
      </div>
    </section>
    <style>
    .top-category-products-two-item::before {
    -webkit-background-size: contain !important;
    -moz-background-size: contain !important;
    -o-background-size: contain !important;
    background-size: contain !important;
}
.imagefourteencat{
  object-fit:contain !important;
  max-height: 140px;
  max-width: 140px;

}
    </style>
    <?php do_action('kelementor_inline_scripts'); ?>
    <?php
  }


}
