<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Categorycarouselfifthkaveh extends Widget_Base{

  public function get_name(){
    return 'categorycarouselfifthkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل دسته بندی ها سبک پنج', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentcategorycarouselfifthkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'catstcategorycarouselfifthkaveh',
        [
          'label' => esc_html__( 'استایل دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => '1style',
          'options' => [
            '1style'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
            '2style'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ), 
          ],
        ]
        );
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
        'img1categorycarouselkaveh',
        [
          'label' => esc_html__( 'تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
          ],
        ]
      );
      $repeater->add_control(
      'title1categorycarouselfifthkaveh',
      [
        'label' => esc_html__( 'عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'محصولات آیفون',

      ]
    );
    $repeater->add_control(
      'tagheading1categorycarouselfifthkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'title2categorycarouselfifthkaveh',
      [
        'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Apple Iphone',

      ]
    );
    $repeater->add_control(
      'tagheading2categorycarouselfifthkaveh',
      [
        'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H4',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'linkcategorycarouselfifthkaveh',
      [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
      ]
    );
    $this->add_control(
      'listcategorycarouselfifthkaveh',
      [
        'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'title1categorycarouselfifthkaveh' => esc_html__( 'عنوان', 'kaveh-core' ),
            'title2categorycarouselfifthkaveh' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
            'linkcategorycarouselfifthkaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );
    $this->add_control(
      'imgbgcategorycarouselfifthkaveh',
      [
        'label' => esc_html__( 'تصویر پس زمینه هاور', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'selectors' => [
          '{{WRAPPER}} .category-products .top-category-item::after' =>
              'background-image: url({{URL}})',
      ],
        'condition' => [
          'catstcategorycarouselfifthkaveh' => '2style',
        ],
      ]
    );
    
       $this->end_controls_section();
       $this->start_controls_section(
        'content3categorycarouselfifthkaveh',
        [
          'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'showarrowcategorycarouselfifthkaveh',
        [
          'label' => esc_html__( 'نمایش فلش ها؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'productcolumncategorycarouselfifthkaveh',
        [
          'label' => esc_html__( 'تعداد ستون محصولات در دسکتاپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 8,
          'step' => 1,
          'default' => 6,
      
        ]
      );
      $this->add_control(
        'productcolumn2categorycarouselfifthkaveh',
        [
          'label' => esc_html__( 'تعداد ستون محصولات در تبلت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 4,
      
        ]
      );
      $this->add_control(
        'productcolumn3categorycarouselfifthkaveh',
        [
          'label' => esc_html__( 'تعداد ستون محصولات در موبایل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 2,
      
        ]
      );
       $this->end_controls_section();

      $this->start_controls_section(
        'style2_categorycarouselfifthkaveh',
        [
          'label' => esc_html__( 'استایل عنوان دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor1categorycarouselfifthkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .category-products-six-item .content .name' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlety1_categorycarouselfifthkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان دسته بندی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .category-products-six-item .content .name',
        ]
      );
      $this->add_control(
        'textcolor2categorycarouselfifthkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .category-products-six-item .content .name-en' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlety2_categorycarouselfifthkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان دسته بندی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .category-products-six-item .content .name-en',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_categorycarouselfifthkaveh',
        [
          'label' => esc_html__( 'استایل باکس دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'boxcolor1categorycarouselfifthkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .category-products-six-item .content::before' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'borderradiustcategorycarouselfifthkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .category-products-six-item .content::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'arrowcolor1categorycarouselfifthkaveh',
        [
          'label' => esc_html__( 'رنگ فلش ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'showarrowcategorycarouselfifthkaveh' => 'yes',
          ],
          'selectors' => [
            '{{WRAPPER}} .category-products-six .swiper-button-next::after' => 'color: {{VALUE}}',
            '{{WRAPPER}} .category-products-six .swiper-button-prev::after' => 'color: {{VALUE}}',

          ],
        ]
      );
      $this->end_controls_section();

        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
     <?php if('1style'===$settings['catstcategorycarouselfifthkaveh']){ ?>
    <section class="category-products-six">
      <div class="container position-relative">
        <!-- Start Carousel -->
        <div class="swiper swiper-category-products-six overflow-hidden" data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo  esc_html($settings['productcolumn3categorycarouselfifthkaveh']); ?>,"spaceBetween":12},"576":{"slidesPerView":<?php echo  esc_html($settings['productcolumn2categorycarouselfifthkaveh']); ?>,"spaceBetween":20},"768":{"slidesPerView":<?php echo  esc_html($settings['productcolumn2categorycarouselfifthkaveh']); ?>,"spaceBetween":20},"992":{"slidesPerView":<?php echo  esc_html($settings['productcolumncategorycarouselfifthkaveh']); ?>,"spaceBetween":20},"1200":{"slidesPerView":<?php echo  esc_html($settings['productcolumncategorycarouselfifthkaveh']); ?>,"spaceBetween":31}}}'>
          <div class="swiper-wrapper">
          <?php
              if ( $settings['listcategorycarouselfifthkaveh'] ) {
              foreach (  $settings['listcategorycarouselfifthkaveh'] as $item ) {
              ?>
            <!-- Start Slide -->
            <div class="swiper-slide">
              <div class="category-products-six-item position-relative">
                <a href="<?php echo  esc_html($item['linkcategorycarouselfifthkaveh']); ?>" class="stretched-link" aria-label="category"></a>
                <img src="<?php echo esc_url($item['img1categorycarouselkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['img1categorycarouselkaveh'] )); ?>" width="104" height="104"
                  class="d-block mx-auto">
                <div class="content position-relative text-center">
                  <<?php echo  esc_attr($item['tagheading1categorycarouselfifthkaveh']); ?> class="name text-truncate"><?php echo  esc_html($item['title1categorycarouselfifthkaveh']); ?></<?php echo  esc_attr($item['tagheading1categorycarouselfifthkaveh']); ?>>
                  <<?php echo  esc_attr($item['tagheading2categorycarouselfifthkaveh']); ?> class="name-en text-truncate"><?php echo  esc_html($item['title2categorycarouselfifthkaveh']); ?></<?php echo  esc_attr($item['tagheading2categorycarouselfifthkaveh']); ?>>
                </div>
              </div>
            </div>
            <!-- End Slide -->
            <?php 
            }
              }
            ?>
          </div>
          <?php if("yes"===$settings['showarrowcategorycarouselfifthkaveh']){?>
          <div class="swiper-button-next"></div>
          <div class="swiper-button-prev"></div>
          <?php } ?>
        </div>
        <!-- End Carousel -->
      </div>
    </section>
    <?php }elseif('2style'===$settings['catstcategorycarouselfifthkaveh']){?>
    <?php }?>
    <?php do_action('kelementor_inline_scripts'); ?>
    <?php
  }


}
