<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Categorycarouseleighthkaveh extends Widget_Base{

  public function get_name(){
    return 'categorycarouseleighthkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل دسته بندی ها سبک هشت', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentcategorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'showticategorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'نمایش عنوان؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'showbeforetiategorycarouselsixthkaveh',
        [
          'label' => esc_html__( 'نمایش تصویر قبل عنوان؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'condition' => [
            'showticategorycarouseleighthkaveh' => 'yes',
          ],
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'imgbeforeticategorycarouselkaveh',
        [
          'label' => esc_html__( 'تصویر قبل عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'condition' => [
            'showbeforetiategorycarouselsixthkaveh' => 'yes',
            'showticategorycarouseleighthkaveh' => 'yes',
          ],
        ]
      );
      $this->add_control(
        'tagti1categorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H2',
          'condition' => [
            'showticategorycarouseleighthkaveh' => 'yes',
          ],
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
      $this->add_control(
        'widgticategorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'عنوان بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'showticategorycarouseleighthkaveh' => 'yes',
          ],
          'default' => 'دسته بندی های',
  
        ]
      );
      $this->add_control(
        'wigti2categorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'showticategorycarouseleighthkaveh' => 'yes',
          ],
          'default' => 'پر فروش',
        ]
      );
      $this->add_control(
        'wigp2categorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'توضیحات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXTAREA,
          'condition' => [
            'showticategorycarouseleighthkaveh' => 'yes',
          ],
          'default' => 'همواره، قرار گرفتن در شرایطی که برای اولین بار تجربه‌اش می‌کنیم، در ما ایجاد استرس و اضطراب می‌کند؛ بنابراین اگر تلاش کنیم شرایطی را که می‌خواهیم در آن قرار بگیریم، از قبل به',
  
        ]
      );
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
        'img1categorycarouselkaveh',
        [
          'label' => esc_html__( 'تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
          ],
        ]
      );
      $repeater->add_control(
        'title2categorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => 'Apple Iphone',
  
        ]
      );
      $repeater->add_control(
        'tagheading2categorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H4',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
      $repeater->add_control(
      'title1categorycarouseleighthkaveh',
      [
        'label' => esc_html__( 'عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'محصولات آیفون',

      ]
    );
    $repeater->add_control(
      'tagheading1categorycarouseleighthkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'linkcategorycarouseleighthkaveh',
      [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
      ]
    );
    $repeater->add_control(
      'bgcolortbolcategorycarouseleighthkaveh',
      [
        'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
      ]
    );
    $this->add_control(
      'listcategorycarouseleighthkaveh',
      [
        'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'title1categorycarouseleighthkaveh' => esc_html__( 'عنوان', 'kaveh-core' ),
            'title2categorycarouseleighthkaveh' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
            'linkcategorycarouseleighthkaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );

    
       $this->end_controls_section();
       $this->start_controls_section(
        'content3categorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'showarrowcategorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'نمایش فلش ها؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'productcolumncategorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در دسکتاپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 8,
          'step' => 1,
          'default' => 4,
      
        ]
      );
      $this->add_control(
        'productcolumn2categorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در تبلت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 3,
      
        ]
      );
      $this->add_control(
        'productcolumn3categorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'تعداد ستون دسته بندی در موبایل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 1,
      
        ]
      );
       $this->end_controls_section();
       $this->start_controls_section(
        'stylet_categorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showticategorycarouseleighthkaveh' => 'yes',
          ],
        ]
      );
      $this->add_control(
        'textcolortbolcategorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-five-title b' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'textcolortcategorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-five-title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletyt_categorycarouseleighthkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-five-title',
        ]
      );
      $this->add_control(
        'textcolortpcategorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'رنگ توضیحات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-five p' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletytp_categorycarouseleighthkaveh',
          'label' => esc_html__( 'تایپوگرافی توضیحات', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-five p',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style2_categorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'استایل عنوان دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor21categorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .our-characters-item .sup-title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlety2_categorycarouseleighthkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی دسته بندی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .our-characters-item .sup-title',
        ]
      );
      $this->add_control(
        'textcolor1categorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .our-characters-item .title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlety1_categorycarouseleighthkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی دسته بندی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .our-characters-item .title',
        ]
      );
      $this->add_control(
        'mgtop1categorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'فاصله عنوان از بالا', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'selectors' => [ 
            '{{WRAPPER}} .our-characters-item .sup-title' => 'margin-top: {{SIZE}}{{UNIT}};',

          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_categorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'استایل باکس دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'borderradiustcategorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [ 
            '{{WRAPPER}} .our-characters-item::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} .our-characters-item::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

          ],
        ]
      );

      $this->end_controls_section();
      $this->start_controls_section(
        'style3arr_categorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'استایل فلش ها', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'arrowcolor1categorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'رنگ فلش ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'showarrowcategorycarouseleighthkaveh' => 'yes',
          ],
          'selectors' => [
            '{{WRAPPER}} .swiper-button-fill .swiper-button-next::after' => 'color: {{VALUE}} !important;',
            '{{WRAPPER}}  .swiper-button-fill .swiper-button-prev::after' => 'color: {{VALUE}} !important;',

          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'styleimag_categorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'استایل تصویر دسته بندی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'catimg1widthcategorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'عرض تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .our-characters-item img' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catimg1height2categorycarouseleighthkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .our-characters-item img' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();

        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
<section class="our-characters my-100">
      <div class="container">
      <?php if("yes"===$settings['showticategorycarouseleighthkaveh']){?>
        <!-- Start Heading -->
        <div class="section-heading-five position-relative">
          <<?php echo  esc_attr($settings['tagti1categorycarouseleighthkaveh']); ?> class="section-heading-five-title">
            <b> <?php echo esc_html($settings['widgticategorycarouseleighthkaveh']); ?></b>
            <?php echo esc_html($settings['wigti2categorycarouseleighthkaveh']); ?>
          </<?php echo  esc_attr($settings['tagti1categorycarouseleighthkaveh']); ?>>
          <p class="mb-0"><?php echo esc_html($settings['wigp2categorycarouseleighthkaveh']); ?></p>
        </div>
        <!-- End Heading -->
        <?php } ?>   
        <div class="position-relative">
          <!-- Start Carousel -->
          <div class="swiper swiper-our-characters swiper-button-fill" data-swiper='{"watchSlidesProgress":true,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo  esc_html($settings['productcolumn3categorycarouseleighthkaveh']); ?>,"spaceBetween":20},"400":{"slidesPerView":<?php echo  esc_html($settings['productcolumn3categorycarouseleighthkaveh']); ?>,"spaceBetween":20},"576":{"slidesPerView":<?php echo  esc_html($settings['productcolumn2categorycarouseleighthkaveh']); ?>,"spaceBetween":20},"768":{"slidesPerView":<?php echo  esc_html($settings['productcolumn2categorycarouseleighthkaveh']); ?>,"spaceBetween":20},"992":{"slidesPerView":<?php echo  esc_html($settings['productcolumncategorycarouseleighthkaveh']); ?>,"spaceBetween":30}}}'>
            <div class="swiper-wrapper">
              <?php
              $e=1;
              if ( $settings['listcategorycarouseleighthkaveh'] ) {
              foreach (  $settings['listcategorycarouseleighthkaveh'] as $item ) {
              ?>
              <!-- Start Slide -->
              <div class="swiper-slide">
                <div class="our-characters-item position-relative text-center rg<?php echo $e;?>">
                  <a href="<?php echo esc_html($item['linkcategorycarouseleighthkaveh']); ?>" class="stretched-link" aria-label="our characters"></a>
                  <img src="<?php echo esc_url($item['img1categorycarouselkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['img1categorycarouselkaveh'] )); ?>" width="200" height="200" class="d-block mx-auto">
                  <<?php echo  esc_attr($item['tagheading2categorycarouseleighthkaveh']); ?> class="sup-title"><?php echo  esc_html($item['title2categorycarouseleighthkaveh']); ?></<?php echo  esc_attr($item['tagheading2categorycarouseleighthkaveh']); ?>>
                  <<?php echo  esc_attr($item['tagheading1categorycarouseleighthkaveh']); ?> class="title mb-0"><?php echo  esc_html($item['title1categorycarouseleighthkaveh']); ?></<?php echo  esc_attr($item['tagheading1categorycarouseleighthkaveh']); ?>>
                </div>
              </div>
              <!-- End Slide -->
              <style>
              <?php echo '.rg'. $e ?>.our-characters-item::before{
              background-image: -webkit-linear-gradient(top, <?php echo esc_attr($item['bgcolortbolcategorycarouseleighthkaveh']); ?> -71.81%, rgba(71, 79, 99, 0) 68.19%);
              background-image: -moz-linear-gradient(top, <?php echo esc_attr($item['bgcolortbolcategorycarouseleighthkaveh']); ?> -71.81%, rgba(71, 79, 99, 0) 68.19%);
              background-image: -o-linear-gradient(top, <?php echo esc_attr($item['bgcolortbolcategorycarouseleighthkaveh']); ?> -71.81%, rgba(71, 79, 99, 0) 68.19%);
              background-image: linear-gradient(180deg, <?php echo esc_attr($item['bgcolortbolcategorycarouseleighthkaveh']); ?> -71.81%, rgba(71, 79, 99, 0) 68.19%);
              } 
              </style>
              <?php 
              $e++;
              }
                }
              ?>
            </div>
            <?php if("yes"===$settings['showarrowcategorycarouseleighthkaveh']){?>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
            <?php } ?>
          </div>
          <!-- End Carousel -->
        </div>
      </div>
    </section>
  <style>
 <?php if("yes"===$settings['showbeforetiategorycarouselsixthkaveh']){?>
.section-heading-five::before, .section-heading-five::after {
    background: url("<?php echo esc_url($settings['imgbeforeticategorycarouselkaveh']['url']); ?>") 0 0 no-repeat;
    -webkit-background-size: contain !important;
    -moz-background-size: contain !important;
    -o-background-size: contain !important;
    background-size: contain !important;
}
<?php }else{?>
  .section-heading-five::before, .section-heading-five::after {
display: none !important;
}
.section-heading-five {
    padding-right: 25px;
}
<?php
} ?>
@media only screen and (max-width: 575px){
.best-category-item img {
    width: 123px !important;
}
}
  </style>
  <?php do_action('kelementor_inline_scripts'); ?>
    <?php
  }


}
