<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Cat__carousel__nineteenth extends Widget_Base
{

    public function get_name()
    {
        return 'Cat__carousel__nineteenth';
    }

    public function get_title()
    {
        return esc_html__('کاروسل دسته بندی ها سبک نوزدهم', 'kaveh-core');
    }

    public function get_icon()
    {
        return 'eicon-archive-posts';
    }

    public function get_categories()
    {
        return ['kavehelements'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'Cat__main__details',
            [
                'label' => esc_html__('اطلاعات بخش', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'section__icon',
            [
              'label' => esc_html__( 'آیکون عنوان', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::ICONS,
              'skin' => 'inline',
              'exclude_inline_options' => [ 'svg' ],
              'default' => [
                'value' => 'icon-filter-2',
              ],
            ]
          );
        $this->add_control(
            'section__title',
            [
                'label' => esc_html__('عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('متن مورد نظر شما', 'kaveh-core'),

            ]
        );
        $this->add_control(
            'section__subtitle',
            [
                'label' => esc_html__('زیر عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('متن مورد نظر شما', 'kaveh-core'),

            ]
        );
        $this->add_control(
            'section__details',
            [
                'label' => esc_html__('متن زیر عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('متن مورد نظر شما', 'kaveh-core'),

            ]
        );
        $this->add_control(
            'more__link',
            [
                'label' => esc_html__('نمایش دکمه بیشتر؟', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'yes' => esc_html__('بله', 'kaveh-core'),
                'no' => esc_html__('خیر', 'kaveh-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'more__link__btn',
            [
                'label' => esc_html__('دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('مشاهده همه', 'kaveh-core'),
                'condition' => [
                    'more__link' => 'yes',
                ],

            ]
        );
        $this->add_control(
            'more__link__btn__url',
            [
                'label' => esc_html__('لینک دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('#', 'kaveh-core'),
                'condition' => [
                    'more__link' => 'yes',
                ],

            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'Cat__item',
            [
                'label' => esc_html__('آیتم های دسته بندی', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'Cat__loop__image',
            [
                'label' => esc_html__('تصویر دسته بندی', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater->add_control(
            'Cat__loop__title',
            [
                'label' => esc_html__('عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'محصولات آیفون',

            ]
        );
        $repeater->add_control(
            'Cat__loop__title__tag',
            [
                'label' => esc_html__('تگ عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'H2',
                'options' => [
                    'H1' => esc_html__('H1', 'kaveh-core'),
                    'H2' => esc_html__('H2', 'kaveh-core'),
                    'H3' => esc_html__('H3', 'kaveh-core'),
                    'H4' => esc_html__('H4', 'kaveh-core'),
                    'H5' => esc_html__('H5', 'kaveh-core'),
                    'H6' => esc_html__('H6', 'kaveh-core'),
                    'p' => esc_html__('p', 'kaveh-core'),
                    'div' => esc_html__('div', 'kaveh-core'),
                    'span' => esc_html__('span', 'kaveh-core'),
                ],
            ]
        );
        $repeater->add_control(
            'Cat__loop__link',
            [
                'label' => esc_html__('لینک دکمه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '#',
            ]
        );
        $this->add_control(
            'Cat__loop',
            [
                'label' => esc_html__('دسته بندی ها', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'Cat__loop__title' => esc_html__('عنوان', 'kaveh-core'),
                        'Cat__loop__btn__title' => esc_html__('عنوان دکمه', 'kaveh-core'),
                        'Cat__loop__link' => esc_html__('#', 'kaveh-core'),
                    ],
                ]
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'Cat__item__setting',
            [
                'label' => esc_html__('تنظیمات کاروسل', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'carousel__desktop__number',
            [
                'label' => esc_html__('تعداد ستون دسته بندی در دسکتاپ', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 8,
                'step' => 1,
                'default' => 7,

            ]
        );
        $this->add_control(
            'carousel__tablet__number',
            [
                'label' => esc_html__('تعداد ستون دسته بندی در تبلت', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 5,
                'step' => 1,
                'default' => 3,

            ]
        );
        $this->add_control(
            'carousel__mobile__number',
            [
                'label' => esc_html__('تعداد ستون دسته بندی در موبایل', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 5,
                'step' => 1,
                'default' => 2,

            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section__style',
            [
                'label' => esc_html__('استایل بخش', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'slider__bg',
            [
                'label' => esc_html__('رنگ پس زمینه اصلی', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'رنگ سکشن لندیگ',
                'selectors' => [
                    '{{WRAPPER}} .category-specials::before' =>
                        'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'style',
            [
                'label' => esc_html__('استایل', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'slider__bg',
            [
                'label' => esc_html__('رنگ پس زمینه آیتم', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'رنگ سکشن لندیگ',
                'selectors' => [
                    '{{WRAPPER}} .category-specials::before' =>
                        'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon__color',
            [
                'label' => esc_html__('رنگ آیکون', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category-specials-heading-right i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'main__title__style',
                'label' => esc_html__('تایپوگرافی زیر عنوان', 'kaveh-core'),
                'selector' => '{{WRAPPER}} .category-specials-heading-right .detail',
            ]
        );
        $this->add_control(
            'main__title__color',
            [
                'label' => esc_html__('رنگ زیر عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category-specials-heading-right .detail' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle__style',
                'label' => esc_html__('تایپوگرافی عنوان', 'kaveh-core'),
                'selector' => '{{WRAPPER}} .category-specials-heading-right .detail b',
            ]
        );
        $this->add_control(
            'subtitle__color',
            [
                'label' => esc_html__('رنگ عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category-specials-heading-right .detail b' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_control(
            'main__title__color',
            [
                'label' => esc_html__('رنگ آیکون عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .landing-seventeen .title' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'section__details__style',
                'label' => esc_html__('تایپوگرافی متن', 'kaveh-core'),
                'selector' => '{{WRAPPER}} .category-specials p',
            ]
        );
        $this->add_control(
            'section__details__color',
            [
                'label' => esc_html__('رنگ عنوان متن', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category-specials p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $clsid = $this->get_id();
        ?>
        <!-- Start Category Specials -->
        <section class="category-specials position-relative">
            <div class="container position-relative">
                <!-- Start Heading -->
                <div
                    class="category-specials-heading d-flex align-items-sm-center justify-content-sm-between flex-column flex-sm-row gap-4 gap-sm-0">
                    <div class="category-specials-heading-right d-flex align-items-center">
                        <i class="d-flex align-items-center justify-content-center rounded-circle <?php echo  esc_html($settings['section__icon']['value']); ?>"></i>
                        <div class="detail">
                            <?php echo esc_html($settings['section__title']); ?>
                            <b class="d-block">
                                <?php echo esc_html($settings['section__subtitle']); ?>
                            </b>
                        </div>
                    </div>
                    <?php if ("yes" === $settings['more__link']) { ?>
                        <a href="<?php echo esc_url($settings['more__link__btn__url']); ?>"
                        class="btn btn-gradient-white d-flex align-items-center">
                            <?php echo esc_html($settings['more__link__btn']); ?>
                            <i class="icon-angle-circle-top-left"></i>
                        </a>
                    <?php } ?>
                </div>
                <!-- End Heading -->
                <p>
                    <?php echo esc_html($settings['section__details']); ?>
                </p>
                <!-- Start Carousel -->
                <div class="swiper swiper-category-specials" data-swiper='{
                    "navigation": {
                        "nextEl": ".swiper-button-next",
                        "prevEl": ".swiper-button-prev"
                    },
                    "watchSlidesProgress": true,
                    "breakpoints": {
                        "320": {
                        "slidesPerView": <?php echo esc_html($settings['carousel__mobile__number']); ?>,
                        "spaceBetween": 14
                        },
                        "576": {
                        "slidesPerView": <?php echo esc_html($settings['carousel__tablet__number']); ?>,
                        "spaceBetween": 20
                        },
                        "768": {
                        "slidesPerView": <?php echo esc_html($settings['carousel__desktop__number']); ?>,
                        "spaceBetween": 31
                        }
                    }
                    }'>
                    <div class="swiper-wrapper">
                        <?php
                        if ($settings['Cat__loop']) {
                            foreach ($settings['Cat__loop'] as $item) {
                                ?>
                                <!-- Start Slide -->
                                <div class="swiper-slide">
                                    <div class="category-specials-item position-relative">
                                        <a href="<?php echo esc_html($item['Cat__loop__link']); ?>" class="stretched-link"
                                            aria-label="category specials"></a>
                                        <div class="image position-relative mx-auto">
                                            <div class="img">
                                                <img src="<?php echo esc_url($item['Cat__loop__image']['url']); ?>" alt="image"
                                                    width="282" height="357" class="w-100 h-100 d-block">
                                            </div>
                                        </div>
                                        <<?php echo esc_attr($item['Cat__loop__title__tag']); ?> class="title text-center mb-0">
                                            <?php echo esc_html($item['Cat__loop__title']); ?>
                                        </<?php echo esc_attr($item['Cat__loop__title__tag']); ?>>
                                    </div>
                                </div>
                                <!-- End Slide -->
                                <?php
                            }
                        }
                        ?>
                    </div>
                    <!-- Start Button -->
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                    <!-- End Button -->
                </div>
                <!-- End Carousel -->
            </div>
        </section>
        <!-- End Category Specials -->
        <?php do_action('kelementor_inline_scripts'); ?>

        <?php
    }

}