<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
  exit; // Exit if accessed directly

class Cat__carousel__eighteenth extends Widget_Base
{

  public function get_name()
  {
    return 'Cat__carousel__eighteenth';
  }

  public function get_title()
  {
    return esc_html__('کاروسل دسته بندی ها سبک هجدهم', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['kavehelements'];
  }

  protected function register_controls()
  {
    $this->start_controls_section(
      'Cat__item',
      [
        'label' => esc_html__('آیتم های دسته بندی', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $repeater = new \Elementor\Repeater();
    $repeater->add_control(
      'Cat__loop__image',
      [
        'label' => esc_html__('تصویر دسته بندی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
          'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $repeater->add_control(
      'Cat__loop__title',
      [
        'label' => esc_html__('عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'محصولات آیفون',

      ]
    );
    $repeater->add_control(
      'Cat__loop__title__tag',
      [
        'label' => esc_html__('تگ عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'options' => [
          'H1' => esc_html__('H1', 'kaveh-core'),
          'H2' => esc_html__('H2', 'kaveh-core'),
          'H3' => esc_html__('H3', 'kaveh-core'),
          'H4' => esc_html__('H4', 'kaveh-core'),
          'H5' => esc_html__('H5', 'kaveh-core'),
          'H6' => esc_html__('H6', 'kaveh-core'),
          'p' => esc_html__('p', 'kaveh-core'),
          'div' => esc_html__('div', 'kaveh-core'),
          'span' => esc_html__('span', 'kaveh-core'),
        ],
      ]
    );
    $repeater->add_control(
      'Cat__loop__subtitle',
      [
        'label' => esc_html__('زیر عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'محصولات آیفون',

      ]
    );
    $repeater->add_control(
      'Cat__loop__link',
      [
        'label' => esc_html__('لینک دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
      ]
    );

    $this->add_control(
      'Cat__loop',
      [
        'label' => esc_html__('دسته بندی ها', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'Cat__loop__title' => esc_html__('عنوان', 'kaveh-core'),
            'Cat__loop__subtitle' => esc_html__('عنوان', 'kaveh-core'),
            'Cat__loop__btn__title' => esc_html__('عنوان دکمه', 'kaveh-core'),
            'Cat__loop__link' => esc_html__('#', 'kaveh-core'),
          ],
        ]
      ]
    );

    $this->end_controls_section();

    $this->start_controls_section(
      'slider__style',
      [
        'label' => esc_html__('استایل اسلایدر', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'slider__image__Width',
      [
        'label' => esc_html__('عرض تصویر آیتم', 'textdomain'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 1000,
            'step' => 5,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 100,
        ],
        'selectors' => [
          '{{WRAPPER}} .category-specials-three-item img' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'slider__image__height',
      [
        'label' => esc_html__('طول تصویر آیتم', 'textdomain'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 1000,
            'step' => 5,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 100,
        ],
        'selectors' => [
          '{{WRAPPER}} .category-specials-three-item img' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();
    $this->start_controls_section(
      'content3categorycarouselseventeenthkaveh',
      [
        'label' => esc_html__('تنظیمات کاروسل', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'carousel__desktop__number',
      [
        'label' => esc_html__('تعداد ستون دسته بندی در دسکتاپ', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 8,
        'step' => 1,
        'default' => 7,

      ]
    );
    $this->add_control(
      'carousel__tablet__number',
      [
        'label' => esc_html__('تعداد ستون دسته بندی در تبلت', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 5,
        'step' => 1,
        'default' => 3,

      ]
    );
    $this->add_control(
      'carousel__mobile__number',
      [
        'label' => esc_html__('تعداد ستون دسته بندی در موبایل', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 5,
        'step' => 1,
        'default' => 2,

      ]
    );

    $this->end_controls_section();

  }

  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>


<section class="category-specials-three overflow-hidden">
      <div class="container">
        <!-- Start Carousel -->
        <div class="swiper swiper-category-specials-three overflow-hidden" data-swiper='{"watchSlidesProgress":true,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['carousel__mobile__number']); ?>,"spaceBetween":20},"500":{"slidesPerView":<?php echo esc_html($settings['carousel__tablet__number']); ?>,"spaceBetween":20},"768":{"slidesPerView":<?php echo esc_html($settings['carousel__tablet__number']); ?>,"spaceBetween":20},"992":{"slidesPerView":<?php echo esc_html($settings['carousel__desktop__number']); ?>,"spaceBetween":20},"1200":{"slidesPerView":<?php echo esc_html($settings['carousel__desktop__number']); ?>,"spaceBetween":30}}}'>
          <div class="swiper-wrapper">
          <?php
            if ($settings['Cat__loop']) {
              foreach ($settings['Cat__loop'] as $item) {
                ?>
            <!-- Start Slide -->
            <div class="swiper-slide">
              <div class="category-specials-three-item position-relative">
                <a href="<?php echo esc_html($item['Cat__loop__link']); ?>" class="stretched-link" aria-label="category"></a>
                <img src="<?php echo esc_url($item['Cat__loop__image']['url']); ?>" alt="category" width="101" height="101" class="d-block mx-auto">
                <<?php echo esc_attr($item['Cat__loop__title__tag']); ?> class="title text-center text-white mb-0">
                <?php echo esc_html($item['Cat__loop__title']); ?> 
                  <strong class="d-block"> <?php echo esc_html($item['Cat__loop__subtitle']); ?>  </strong>
                </<?php echo esc_attr($item['Cat__loop__title__tag']); ?>>
              </div>
            </div>
            <!-- End Slide -->
            <?php
              }
            }
            ?>
          </div>
        </div>
        <!-- End Carousel -->
      </div>
    </section>
    <?php do_action('kelementor_inline_scripts'); ?>       

    <?php
  }

}