<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Cartkaveh extends Widget_Base{

  public function get_name(){
    return 'cartkaveh';
  }

  public function get_title(){
    return esc_html__( 'المان سبد خرید', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }
 
  public function get_categories(){
    return ['headerfooterkavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentcartkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'styleboxcartkaveh',
        [
          'label' => esc_html__( 'طرح بندی المان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'one',
          'options' => [
            'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
            'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),
            'three'  => esc_html__( 'طرح بندی سوم', 'kaveh-core' ),
            'four'  => esc_html__( 'طرح بندی چهارم', 'kaveh-core' ),
            'five'  => esc_html__( 'طرح بندی پنجم', 'kaveh-core' ),
          ],
        ]
        ); 
        $this->add_control(
          'imgbgcartkaveh',
          [
            'label' => esc_html__( 'تصویر پس زمینه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .nav-header-cart > a' =>
            'background: url({{URL}})',
              ],
            'condition' => [
              'styleboxcartkaveh' =>'two',
            ],
          ]
        );
        
      $this->add_control(
        'title2cartkaveh',
        [
            'label' => esc_html__( 'متن دکمه سبد خرید', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'سبد خرید', 'kaveh-core' ),
            'condition' => [
              'styleboxcartkaveh' =>['three','four','five'],
            ],
        ]
    ); 
    $this->add_control(
      'iconecartkaveh',
      [
        'label' => esc_html__( 'آیکون سبد خرید', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'icon icon-cart-3',
        ],
      ]
    );
    $this->add_control(
      'styleulboxcartkaveh',
      [
        'label' => esc_html__( 'جهت باز شدن سبد', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'right',
        'options' => [
          'right'  => esc_html__( 'راست', 'kaveh-core' ),
          'left'  => esc_html__( 'چپ', 'kaveh-core' ),
        ],
      ]
      );
      $this->add_control(
        'text_aligncartkaveh',
        [
          'label' => esc_html__( 'چیدمان آیکون ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::CHOOSE,
          'options' => [
            'left' => [
              'title' => esc_html__( 'چپ چین', 'kaveh-core' ),
              'icon' => 'eicon-text-align-left',
            ],
            'center' => [
              'title' => esc_html__( 'وسط چین', 'kaveh-core' ),
              'icon' => 'eicon-text-align-center',
            ],
            'right' => [
              'title' => esc_html__( 'راست چین', 'kaveh-core' ),
              'icon' => 'eicon-text-align-right',
            ],
          ],
          'toggle' => true,
        ]
      );
       $this->end_controls_section();
       $this->start_controls_section(
        'style_cartkaveh',
        [
          'label' => esc_html__( 'استایل', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'iconsize1cartkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxcartkaveh' =>'one',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .nav-header-cart > .btn' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconbgwidth1cartkaveh',
        [
          'label' => esc_html__( 'عرض پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxcartkaveh' =>'one',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .nav-header-cart > .btn' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconbgheight1cartkaveh',
        [
          'label' => esc_html__( 'ارتفاع پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxcartkaveh' =>'one',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .nav-header-cart > .btn' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'hrer2cartkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
          'condition' => [
            'styleboxcartkaveh' =>'one',
          ],
        ]
      ); 
      $this->add_control(
        'ticacolor1cartkaveh',
        [
          'label' => esc_html__( 'رنگ شمارنده سبد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'one',
          ],
          'selectors' => [
            '{{WRAPPER}} .nav-header-cart > .btn span' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'ticarttype1cartkaveh',
          'label' => esc_html__( 'تایپوگرافی شمارنده سبد', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'one',
          ],
          'selector' => '{{WRAPPER}} .nav-header-cart > .btn span',
        ]
      );
      $this->add_control(
        'tibgcolor1cartkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه شمارنده سبد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'one',
          ],
          'selectors' => [
            '{{WRAPPER}} .nav-header-cart > .btn span' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'iconbgcawidth1cartkaveh',
        [
          'label' => esc_html__( 'عرض پس زمینه شمارنده سبد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxcartkaveh' =>'one',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .nav-header-cart > .btn span' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconbgheightca1cartkaveh',
        [
          'label' => esc_html__( 'ارتفاع پس زمینه شمارنده سبد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxcartkaveh' =>'one',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .nav-header-cart > .btn span' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->start_controls_tabs(
        'style_tabs1cartkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tab1cartkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'one',
          ],
        ]
      );
      $this->add_control(
        'iconcolor1cartkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'one',
          ],
          'selectors' => [
            '{{WRAPPER}} .nav-header-cart > .btn' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'iconbg1cartkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'one',
          ],
          'selectors' => [
            '{{WRAPPER}} .nav-header-cart > .btn' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonradius1cartkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxcartkaveh' =>'one',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .nav-header-cart > .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border1cartkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'one',
          ],
          'selector' => '{{WRAPPER}} .nav-header-cart > .btn',
        ]
      );
      $this->add_control(
        'buttonborders1cartkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border5cartkaveh!' => '',
            'styleboxcartkaveh' =>'one',
          ],
          'selectors' => [
            '{{WRAPPER}} .nav-header-cart > .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabcartkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'one',
          ],
        ]
      );
      $this->add_control(
        'iconcolor1hovercartkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'one',
          ],
          'selectors' => [
            '{{WRAPPER}} .nav-header-cart > .btn:hover' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'iconbg1hovercartkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'one',
          ],
          'selectors' => [
            '{{WRAPPER}} .nav-header-cart > .btn:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonradius1hovercartkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxcartkaveh' =>'one',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .nav-header-cart > .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border1hovercartkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'one',
          ],
          'selector' => '{{WRAPPER}} .nav-header-cart > .btn:hover',
        ]
      );
      $this->add_control(
        'buttonborders1hovercartkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border5cartkaveh!' => '',
            'styleboxcartkaveh' =>'one',
          ],
          'selectors' => [
            '{{WRAPPER}} .nav-header-cart > .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_control(
        'hrer1cartkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
          'condition' => [
            'styleboxcartkaveh' =>'one',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow1cartkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'one',
          ],
          'selector' => '{{WRAPPER}} .nav-header-cart > .btn',
        ]
      );
      $this->add_control(
        'iconsize2cartkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxcartkaveh' =>'two',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .nav-header-cart > a' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconbgwidth2cartkaveh',
        [
          'label' => esc_html__( 'عرض پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxcartkaveh' =>'two',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .nav-header-cart > a' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconbgheight2cartkaveh',
        [
          'label' => esc_html__( 'ارتفاع پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxcartkaveh' =>'two',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .nav-header-cart > a' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'hrer3cartkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
          'condition' => [
            'styleboxcartkaveh' =>'two',
          ],
        ]
      ); 
      $this->add_control(
        'ticacolor2cartkaveh',
        [
          'label' => esc_html__( 'رنگ شمارنده سبد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'two',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .nav-header-cart > a span' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'ticarttype2cartkaveh',
          'label' => esc_html__( 'تایپوگرافی شمارنده سبد', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'two',
          ],
          'selector' => '{{WRAPPER}} .top-header-fourteen .nav-header-cart > a span',
        ]
      );
      $this->add_control(
        'tibgcolor2cartkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه شمارنده سبد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'two',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .nav-header-cart > a span' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'iconbgcawidth2cartkaveh',
        [
          'label' => esc_html__( 'عرض پس زمینه شمارنده سبد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxcartkaveh' =>'two',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .nav-header-cart > a span' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      ); 
      $this->add_control(
        'iconbgheightca2cartkaveh',
        [
          'label' => esc_html__( 'ارتفاع پس زمینه شمارنده سبد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxcartkaveh' =>'two',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .nav-header-cart > a span' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->start_controls_tabs(
        'style_tabs2cartkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tab2cartkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'two',
          ],
        ]
      );
      $this->add_control(
        'iconcolor2cartkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'two',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .nav-header-cart > a' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'iconbg2cartkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'two',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .nav-header-cart > a' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonradius2cartkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxcartkaveh' =>'two',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .nav-header-cart > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border2cartkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'two',
          ],
          'selector' => '{{WRAPPER}} .top-header-fourteen .nav-header-cart > a',
        ]
      );
      $this->add_control(
        'buttonborders2cartkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border2cartkaveh!' => '',
            'styleboxcartkaveh' =>'two',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .nav-header-cart > a' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tab2cartkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'two',
          ],
        ]
      );
      $this->add_control(
        'iconcolor1hover2cartkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'two',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .nav-header-cart > a:hover' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'iconbg1hover2cartkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'two',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .nav-header-cart > a:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonradius1hover2cartkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxcartkaveh' =>'two',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .nav-header-cart > a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border1hover2cartkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'two',
          ],
          'selector' => '{{WRAPPER}} .top-header-fourteen .nav-header-cart > a:hover',
        ]
      );
      $this->add_control(
        'buttonborders1hover2cartkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border1hover2cartkaveh!' => '',
            'styleboxcartkaveh' =>'two',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .nav-header-cart > a:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_control(
        'hrer2cart2kaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
          'condition' => [
            'styleboxcartkaveh' =>'two',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow2cartkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'two',
          ],
          'selector' => '{{WRAPPER}} .top-header-fourteen .nav-header-cart > a',
        ]
      );
      $this->add_control(
        'iconsize3cartkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxcartkaveh' =>'three',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-sixteen .nav-header-cart > a i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconbgwidth3cartkaveh',
        [
          'label' => esc_html__( 'عرض دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxcartkaveh' =>'three',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-sixteen .nav-header-cart > a' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconbgheight3cartkaveh',
        [
          'label' => esc_html__( 'ارتفاع دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxcartkaveh' =>'three',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 500,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-sixteen .nav-header-cart > a' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'hrer41cartkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
          'condition' => [
            'styleboxcartkaveh' =>'three',
          ],
        ]
      ); 
      $this->add_control(
        'titl3color3cartkaveh',
        [
          'label' => esc_html__( 'رنگ متن دکمه سبد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-sixteen .nav-header-cart > a span:not(.counter)' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titl3type3cartkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه سبد', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'three',
          ],
          'selector' => '{{WRAPPER}} .top-header-sixteen .nav-header-cart > a span:not(.counter)',
        ]
      );
      $this->add_control(
        'hrer52cartkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
          'condition' => [
            'styleboxcartkaveh' =>'three',
          ],
        ]
      ); 
      $this->add_control(
        'ticacolor3cartkaveh',
        [
          'label' => esc_html__( 'رنگ شمارنده سبد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-sixteen .nav-header-cart > a span.counter' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'ticarttype3cartkaveh',
          'label' => esc_html__( 'تایپوگرافی شمارنده سبد', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'three',
          ],
          'selector' => '{{WRAPPER}} .top-header-sixteen .nav-header-cart > a span.counter',
        ]
      );
      $this->add_control(
        'tibgcolor3cartkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه شمارنده سبد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-sixteen .nav-header-cart > a span.counter' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'iconbgcawidth3cartkaveh',
        [
          'label' => esc_html__( 'عرض پس زمینه شمارنده سبد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxcartkaveh' =>'three',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-sixteen .nav-header-cart > a span.counter' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconbgheightca3cartkaveh',
        [
          'label' => esc_html__( 'ارتفاع پس زمینه شمارنده سبد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxcartkaveh' =>'three',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-sixteen .nav-header-cart > a span.counter' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->start_controls_tabs(
        'style_tabs3cartkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tab3cartkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'three',
          ],
        ]
      );
      $this->add_control(
        'iconcolor3cartkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-sixteen .nav-header-cart > a i' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'iconbg3cartkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-sixteen .nav-header-cart > a' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonradius3cartkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxcartkaveh' =>'three',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-sixteen .nav-header-cart > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border3cartkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'three',
          ],
          'selector' => '{{WRAPPER}} .top-header-sixteen .nav-header-cart > a',
        ]
      );
      $this->add_control(
        'buttonborders3cartkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border3cartkaveh!' => '',
            'styleboxcartkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-sixteen .nav-header-cart > a' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tab3cartkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'three',
          ],
        ]
      );
      $this->add_control(
        'iconcolor1hover3cartkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-sixteen .nav-header-cart > a:hover i' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'iconbg1hover3cartkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-sixteen .nav-header-cart > a:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonradius1hover3cartkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxcartkaveh' =>'three',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-sixteen .nav-header-cart > a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border1hover3cartkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'three',
          ],
          'selector' => '{{WRAPPER}} .top-header-sixteen .nav-header-cart > a:hover',
        ]
      );
      $this->add_control(
        'buttonborders1hover3cartkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border5cartkaveh!' => '',
            'styleboxcartkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-sixteen .nav-header-cart > a:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_control(
        'hrer7cartkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
          'condition' => [
            'styleboxcartkaveh' =>'three',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow3cartkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'three',
          ],
          'selector' => '{{WRAPPER}} .top-header-sixteen .nav-header-cart > a',
        ]
      );
      $this->add_control(
        'iconsize4cartkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .header-cart > .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconbgwidth4cartkaveh',
        [
          'label' => esc_html__( 'عرض پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .header-cart > .btn i' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconbgheight4cartkaveh',
        [
          'label' => esc_html__( 'ارتفاع پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .header-cart > .btn i' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconbgradius4cartkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .header-cart > .btn i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'tiextcacolor4cartkaveh',
        [
          'label' => esc_html__( 'رنگ متن', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-cart > .btn' => 'color: {{VALUE}} !important',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'tiextcarttype4cartkaveh',
          'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
          'selector' => '{{WRAPPER}} .header-cart > .btn',
        ]
      );
      $this->add_control(
        'hrer42cartkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
        ]
      ); 
      $this->add_control(
        'ticacolor4cartkaveh',
        [
          'label' => esc_html__( 'رنگ شمارنده سبد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-cart > .btn span' => 'color: {{VALUE}} !important',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'ticarttype4cartkaveh',
          'label' => esc_html__( 'تایپوگرافی شمارنده سبد', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
          'selector' => '{{WRAPPER}} .header-cart > .btn span',
        ]
      );
      $this->add_control(
        'tibgcolor4cartkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه شمارنده سبد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-cart > .btn span' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'iconbgcawidth4cartkaveh',
        [
          'label' => esc_html__( 'عرض پس زمینه شمارنده سبد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .header-cart > .btn span' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconbgheightca4cartkaveh',
        [
          'label' => esc_html__( 'ارتفاع پس زمینه شمارنده سبد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .header-cart > .btn span' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconbgradiusca4cartkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده شمارنده سبد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .header-cart > .btn span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->start_controls_tabs(
        'style_tabs4cartkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tab4cartkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
        ]
      );
      $this->add_control(
        'iconcolor4cartkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-cart > .btn i' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'iconbg4cartkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-cart > .btn i' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'iconbgbut4cartkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-cart > .btn' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonradius4cartkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .nav-header-cart > .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border4cartkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
          'selector' => '{{WRAPPER}} .nav-header-cart > .btn',
        ]
      );
      $this->add_control(
        'buttonborders4cartkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border4cartkaveh!' => '',
            'styleboxcartkaveh' =>'four',
          ],
          'selectors' => [
            '{{WRAPPER}} .nav-header-cart > .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tab4cartkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
        ]
      );
      $this->add_control(
        'iconcolor1hover4cartkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-cart > .btn:hover i' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'iconbg1hover4cartkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-cart > .btn:hover i' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'iconbgbut1hover4cartkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-cart > .btn:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonradius1hover4cartkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .nav-header-cart > .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border1hover4cartkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
          'selector' => '{{WRAPPER}} .nav-header-cart > .btn:hover',
        ]
      );
      $this->add_control(
        'buttonborders1hover4cartkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border4cartkaveh!' => '',
            'styleboxcartkaveh' =>'four',
          ],
          'selectors' => [
            '{{WRAPPER}} .nav-header-cart > .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_control(
        'hrer4cartkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'boxiconbg_shadow4cartkaveh',
          'label' => esc_html__( 'سایه پس زمینه آیکون', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
          'selector' => '{{WRAPPER}} .header-cart > .btn i',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow4cartkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'four',
          ],
          'selector' => '{{WRAPPER}} .nav-header-cart > .btn',
        ]
      );
      $this->add_control(
        'iconsize5cartkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxcartkaveh' =>'five',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .header-three-cart > .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
        $this->add_control(
        'iconbefore5cartkaveh',
        [
          'label' => esc_html__( 'رنگ خط زیر آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-three-cart > .btn::after' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'tiextcacolor5cartkaveh',
        [
          'label' => esc_html__( 'رنگ متن', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .nav-header-cart > .btn' => 'color: {{VALUE}} !important',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'tiextcarttype5cartkaveh',
          'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'five',
          ],
          'selector' => '{{WRAPPER}} .nav-header-cart > .btn',
        ]
      );
      $this->add_control(
        'hrer5cartkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
          'condition' => [
            'styleboxcartkaveh' =>'five',
          ],
        ]
      ); 
      $this->add_control(
        'ticacolor5cartkaveh',
        [
          'label' => esc_html__( 'رنگ شمارنده سبد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-three-cart > .btn span' => 'color: {{VALUE}} !important',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'ticarttype5cartkaveh',
          'label' => esc_html__( 'تایپوگرافی شمارنده سبد', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'five',
          ],
          'selector' => '{{WRAPPER}} .header-three-cart > .btn span',
        ]
      );
      $this->add_control(
        'tibgcolor5cartkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه شمارنده سبد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-three-cart > .btn span' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'iconbgcawidth5cartkaveh',
        [
          'label' => esc_html__( 'عرض پس زمینه شمارنده سبد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxcartkaveh' =>'five',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .header-three-cart > .btn span' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconbgheightca5cartkaveh',
        [
          'label' => esc_html__( 'ارتفاع پس زمینه شمارنده سبد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxcartkaveh' =>'five',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .header-three-cart > .btn span' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconbgradiusca5cartkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده شمارنده سبد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxcartkaveh' =>'five',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .header-three-cart > .btn span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->start_controls_tabs(
        'style_tabs5cartkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tab5cartkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'five',
          ],
        ]
      );
      $this->add_control(
        'iconcolor5cartkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-three-cart > .btn i' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'iconbgbut5cartkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-three-cart > .btn' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonradius5cartkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxcartkaveh' =>'five',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .header-three-cart > .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border5cartkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'five',
          ],
          'selector' => '{{WRAPPER}} .header-three-cart > .btn',
        ]
      );
      $this->add_control(
        'buttonborders5cartkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border5cartkaveh!' => '',
            'styleboxcartkaveh' =>'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-three-cart > .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tab5cartkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'five',
          ],
        ]
      );
      $this->add_control(
        'iconcolor1hover5cartkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-three-cart > .btn:hover i' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'iconbgbut1hover5cartkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcartkaveh' =>'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-three-cart > .btn:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonradius1hover5cartkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxcartkaveh' =>'five',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .header-three-cart > .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border1hover5cartkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'five',
          ],
          'selector' => '{{WRAPPER}} .header-three-cart > .btn:hover',
        ]
      );
      $this->add_control(
        'buttonborders1hover5cartkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border5cartkaveh!' => '',
            'styleboxcartkaveh' =>'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-three-cart > .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_control(
        'hrer51cartkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
          'condition' => [
            'styleboxcartkaveh' =>'five',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow5cartkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'condition' => [
            'styleboxcartkaveh' =>'five',
          ],
          'selector' => '{{WRAPPER}} .header-three-cart > .btn',
        ]
      );
      $this->end_controls_section();
          
        }


  protected function render(){

    

    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    $options = get_option( 'kaveh_frame' );
  
?>
    <?php if('one'===$settings['styleboxcartkaveh']){ ?>
      <div class="nav-header-cart d-flex <?php if("right"===$settings['text_aligncartkaveh']){?>justify-content-start<?php }elseif("center"===$settings['text_aligncartkaveh']){?>justify-content-center<?php }elseif("left"===$settings['text_aligncartkaveh']){?>justify-content-end<?php } ?>">
          <a <?php if ( wp_is_mobile() ) : ?>data-open-cart="true"<?php endif; ?> href="#"
            class="nav-header-cart btn btn-success position-relative d-flex align-items-center justify-content-center">
            <i class="<?php echo  esc_attr($settings['iconecartkaveh']['value']); ?>"></i>
            <span class="cart-aj-span"> <?php echo WC()->cart->get_cart_contents_count(); ?> </span>
          </a>
           <?php if($options['kaveh_pr_cart_drop_select'] === 'value-1'): ?>
          <div class="nav-header-cart-dropdown <?php if('left'===$settings['styleulboxcartkaveh']){ ?>left-side<?php } ?>">
          <ul class="tot-aj-cc">
            <?php
            if ( WC()->cart->get_cart_contents_count() == 0 ) {
              ?>
              <div class="align-items-center">
              <img class="mx-auto w-50 d-block text-center position-relative mn-r" src="<?php echo get_template_directory_uri() . '/assets/images/emptybag.png'; ?>" alt="">
              <h6 class="text-center position-relative mn-r">هیچ محصولی در سبد نیست</h6>
              </div>
              <?php
            }
            ?>
            <?php
            foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
              $product = $cart_item['data'];
              $product_id = $cart_item['product_id'];
              $variation_id = $cart_item['variation_id'];
              $quantity = $cart_item['quantity'];
              $price = WC()->cart->get_product_price( $product );
              $subtotal = WC()->cart->get_product_subtotal( $product, $cart_item['quantity'] );
              $link = $product->get_permalink( $cart_item );
              // Anything related to $product, check $product tutorial
              $attributes = $product->get_attributes();

              $meta = wc_get_formatted_cart_item_data( $cart_item );
              $sale_price= $product->get_sale_price();
              $normal_price= $product->get_regular_price();
            ?>

            <li class="position-relative">
            <a href="<?php echo wc_get_cart_remove_url( $cart_item_key ); ?>" type="button" class="delete position-absolute text-center rounded-pill fw-light remove" aria-label="حذف این آیتم" data-product_id="<?php echo $product_id; ?>"> حذف </a>
                <img src="<?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), 'thumbnail' ); echo $image[0]; ?>" alt="product" />
                  <div class="detail">
                      <h2>
                        <a href="#"> <?php echo $product->get_name(); ?> </a>
                      </h2>
                      <?php if ( !$product->is_type( 'variable' ) ) { ?>
                      <?php if(!empty($sale_price) ) { ?>
                        <div class="offer">
                        <?php echo number_format($normal_price, 0, '.', ','); ?>
                        </div>
                        <div class="price">
                        <?php echo number_format($sale_price, 0, '.', ','); ?>
                          <span> تومان </span>
                        </div> 
                        <?php }else{
                          ?>
                         <div class="price">
                        <?php if (!empty($normal_price)) {
    echo number_format($normal_price, 0, '.', ',');
} ?>
                          <span> تومان </span>
                        </div> 
                          <?php
                        }
                        ?>
                        <?php }else{ 
                          $price_v = $product->get_price_html(); 
                          echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v);
                        } ?>
                  </div>
            </li>
            <?php 
            }
            ?>
            </ul>
              <div class="bottom d-flex align-items-center justify-content-between">
                
                <div class="total-price">
                
                  <div class="title">
                    مبلغ قابل پرداخت
                  </div>
                  <div class="price tot-aj">
                    <?php echo WC()->cart->subtotal; ?>
                    <span> تومان </span>
                  </div>
                </div>
                <a href="<?php echo wc_get_cart_url(); ?>" class="btn btn-danger rounded-pill seecart ms-5"> مشاهده سبد خرید</a>
                <a href="<?php echo esc_url( wc_get_checkout_url() ); ?>" class="btn btn-danger rounded-pill"> ثبت سفارش </a>
              </div>
          </div>
          <?php elseif($options['kaveh_pr_cart_drop_select'] === 'value-2'): ?>
            
    <div class="nav-header-cart-dropdown-two <?php if('left'===$settings['styleulboxcartkaveh']){ ?>left-side<?php } ?> position-absolute">
      <div class="nav-header-cart-dropdown-two-heading d-flex align-items-center justify-content-between">
        <div class="count-products rounded-pill text-center">
          <b> <?php echo WC()->cart->get_cart_contents_count(); ?> </b>
          محصول
        </div>
        <a href="<?php echo wc_get_cart_url(); ?>">
          مشاهده‌ی سبد خرید
          <i class="icon-angle-left"></i>
        </a>
      </div>
      <div class="nav-header-cart-dropdown-two-products">
      <?php
      if ( WC()->cart->get_cart_contents_count() == 0 ) {
      ?>
      <div class="align-items-center">
          <img class="mx-auto w-50 d-block text-center position-relative mn-r" src="<?php echo get_template_directory_uri() . '/assets/images/emptybag.png'; ?>" alt="">
          <h6 class="text-center position-relative mn-r">هیچ محصولی در سبد نیست</h6>
          </div>
      <?php
      }
      else{
      ?>
         <?php
          foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
          $product = $cart_item['data'];
          $product_id = $cart_item['product_id'];
          $variation_id = $cart_item['variation_id'];
          $quantity = $cart_item['quantity'];
          $price = WC()->cart->get_product_price( $product );
          $subtotal = WC()->cart->get_product_subtotal( $product, $cart_item['quantity'] );
          $link = $product->get_permalink( $cart_item );
          // Anything related to $product, check $product tutorial
          $attributes = $product->get_attributes();
          $meta = wc_get_formatted_cart_item_data( $cart_item );
          $sale_price= $product->get_sale_price();
          $normal_price= $product->get_regular_price();
          $product_variation = wc_get_product( $variation_id );
          if(!empty($product_variation)):
          $v_pname = $product_variation->get_attribute_summary();
          endif;
          ?>   
         <div class="nav-header-cart-dropdown-two-products-item position-relative">
         <?php
								echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
									'woocommerce_cart_item_remove_link',
									sprintf(
                    '<a href="%s" class="delete position-absolute top-0 start-0 fw-light" aria-label="%s" data-product_id="%s" data-product_sku="%s" data-cart-item-key="%s" > حذف </a>',
										esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
										esc_html__( 'Remove this item', 'woocommerce' ),
										esc_attr( $product_id ),
										esc_attr( $product->get_sku() ),
										esc_attr( $cart_item_key )
									),
									$cart_item_key
								);
							?>
            <div class="info d-flex align-items-center">
              <img src="<?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), 'thumbnail' ); echo $image[0]; ?>" alt="<?php echo $product->get_name(); ?>" />
              <div class="detail">
                <h2 class="overflow-hidden">
                  <a href="<?php echo $link; ?>"> <?php echo $product->get_name(); ?> </a>
                </h2>
                <div class="counter d-flex align-items-center">
                <button class="changeinp" type="button" onclick="this.parentNode.querySelector('input[type=number]').stepDown()"> - </button>
                            <?php
                            if ( $product->is_sold_individually() ) {
                            $product_quantity = sprintf( '1 <input type="hidden" name="cart[%s][qty]" value="1" />', $cart_item_key );
                            } else {
                            $product_quantity = woocommerce_quantity_input(
                                array(
                                'input_name'   => "cart[{$cart_item_key}][qty]",
                                'input_value'  => $cart_item['quantity'],
                                'max_value'    => $product->get_max_purchase_quantity(),
                                'min_value'    => '0',
                                'product_name' => $product->get_name(),
                                ),
                                $product,
                                false
                            );
                            }

                            echo apply_filters( 'woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item ); // PHPCS: XSS ok.
                            ?>
                        <button class="changeinp" type="button" onclick="this.parentNode.querySelector('input[type=number]').stepUp()"> + </button>
                </div>
              </div>
            </div>
            <div class="color-price d-flex align-items-center">
            <div class="price d-flex align-items-center fw-light">
              <?php if ( !$product->is_type( 'variable' ) ) { ?>
                            <?php if(!empty($sale_price) ) { ?>
                            <del> <?php if (!empty($normal_price)) {
    echo number_format($normal_price, 0, '.', ',');
} ?> </del>
                            <span> <?php echo number_format($sale_price, 0, '.', ','); ?> </span>
                            <?php echo get_woocommerce_currency_symbol(); ?>
                            <?php }else{
                              ?>
                            <span> <?php if (!empty($normal_price)) {
    echo number_format($normal_price, 0, '.', ',');
} ?> </span>
                            <?php echo get_woocommerce_currency_symbol(); ?>
                              <?php
                            } ?>
                          <?php }else{
                            $price_v = $product->get_price_html(); 
                            echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v);
                          } ?>
              </div>
            </div>
        </div>
        <?php
        }
        ?> 

      <?php
      }
      ?>
       
      </div>
      <div class="total-price d-flex align-items-center justify-content-between position-relative">
        <span> جمع کل سبد خرید </span>
        <div>
        <?php $ctotal =  WC()->cart->subtotal; ?>
        <?php echo number_format($ctotal, 0, '.', ','); ?>
        <span class="fw-light"> <?php echo get_woocommerce_currency_symbol(); ?> </span>
        </div>
      </div>
      <a href="<?php echo esc_url( wc_get_checkout_url() ); ?>" class="btn btn-success-2 w-100 d-block fw-bold position-relative"> <?php esc_html_e( 'Proceed to checkout', 'woocommerce' ); ?> </a>
    </div>
          <?php endif; ?>
          
      </div>
    <?php }elseif('two'===$settings['styleboxcartkaveh']){ ?>
      <div class="top-header-fourteen">
        <div class="nav-header-cart">
          <a <?php if ( wp_is_mobile() ) : ?>data-open-cart="true"<?php endif; ?> href="#" class="top-header-four-cart btn btn-success p-0 position-relative">
            <i class="<?php echo  esc_attr($settings['iconecartkaveh']['value']); ?>"></i>
            <span class="cart-aj-span"> <?php echo WC()->cart->get_cart_contents_count(); ?> </span>
          </a>
          
          <?php if($options['kaveh_pr_cart_drop_select'] === 'value-1'): ?>
    <div class="nav-header-cart-dropdown <?php if('left'===$settings['styleulboxcartkaveh']){ ?>left-side<?php } ?>">
          <ul class="tot-aj-cc">
          <?php
            if ( WC()->cart->get_cart_contents_count() == 0 ) {
              ?>
             <div class="align-items-center">
              <img class="mx-auto w-50 d-block text-center position-relative mn-r" src="<?php echo get_template_directory_uri() . '/assets/images/emptybag.png'; ?>" alt="">
              <h6 class="text-center position-relative mn-r">هیچ محصولی در سبد نیست</h6>
              </div>
              <?php
            }
            ?>
            <?php
            foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
              $product = $cart_item['data'];
              $product_id = $cart_item['product_id'];
              $variation_id = $cart_item['variation_id'];
              $quantity = $cart_item['quantity'];
              $price = WC()->cart->get_product_price( $product );
              $subtotal = WC()->cart->get_product_subtotal( $product, $cart_item['quantity'] );
              $link = $product->get_permalink( $cart_item );
              // Anything related to $product, check $product tutorial
              $attributes = $product->get_attributes();

              $meta = wc_get_formatted_cart_item_data( $cart_item );
              $sale_price= $product->get_sale_price();
              $normal_price= $product->get_regular_price();
            ?>

            <li class="position-relative">
            <a href="<?php echo wc_get_cart_remove_url( $cart_item_key ); ?>" type="button" class="delete position-absolute text-center rounded-pill fw-light remove" aria-label="حذف این آیتم" data-product_id="<?php echo $product_id; ?>"> حذف </a>
                <img src="<?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), 'thumbnail' ); echo $image[0]; ?>" alt="product" />
                  <div class="detail">
                      <h2>
                        <a href="#"> <?php echo $product->get_name(); ?> </a>
                      </h2>
                      <?php if ( !$product->is_type( 'variable' ) ) { ?>
                      <?php if(!empty($sale_price) ) { ?>
                        <div class="offer">
                        <?php echo number_format($normal_price, 0, '.', ','); ?>
                        </div>
                        <div class="price">
                        <?php echo number_format($sale_price, 0, '.', ','); ?>
                          <span> تومان </span>
                        </div>
                        <?php }else{
                          ?>
                          <div class="price">
                        <?php if (!empty($normal_price)) {
    echo number_format($normal_price, 0, '.', ',');
} ?>
                          <span> تومان </span>
                        </div>
                          <?php
                        } ?>
                        
                        <?php }else{ 
                          $price_v = $product->get_price_html(); 
                          echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v);
                        } ?>
                  </div>
            </li>
            <?php 
            }
            ?>
            </ul>
              <div class="bottom d-flex align-items-center justify-content-between">
                <div class="total-price">
                  <div class="title">
                    مبلغ قابل پرداخت
                  </div>
                  <div class="price tot-aj">
                    <?php echo WC()->cart->subtotal; ?>
                    <span> تومان </span>
                  </div>
                </div>
                <a href="<?php echo wc_get_cart_url(); ?>" class="btn btn-danger rounded-pill seecart ms-5"> مشاهده سبد خرید</a>
                <a href="<?php echo esc_url( wc_get_checkout_url() ); ?>" class="btn btn-danger rounded-pill"> ثبت سفارش </a>
              </div>
            </div>
<?php elseif($options['kaveh_pr_cart_drop_select'] === 'value-2'): ?>

    <div class="nav-header-cart-dropdown-two <?php if('left'===$settings['styleulboxcartkaveh']){ ?>left-side<?php } ?> position-absolute">
      <div class="nav-header-cart-dropdown-two-heading d-flex align-items-center justify-content-between">
        <div class="count-products rounded-pill text-center">
          <b> <?php echo WC()->cart->get_cart_contents_count(); ?> </b>
          محصول
        </div>
        <a href="<?php echo wc_get_cart_url(); ?>">
          مشاهده‌ی سبد خرید
          <i class="icon-angle-left"></i>
        </a>
      </div>
      <div class="nav-header-cart-dropdown-two-products">
      <?php
      if ( WC()->cart->get_cart_contents_count() == 0 ) {
      ?>
      <div class="align-items-center">
          <img class="mx-auto w-50 d-block text-center position-relative mn-r" src="<?php echo get_template_directory_uri() . '/assets/images/emptybag.png'; ?>" alt="">
          <h6 class="text-center position-relative mn-r">هیچ محصولی در سبد نیست</h6>
          </div>
      <?php
      }
      else{
      ?>
         <?php
          foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
          $product = $cart_item['data'];
          $product_id = $cart_item['product_id'];
          $variation_id = $cart_item['variation_id'];
          $quantity = $cart_item['quantity'];
          $price = WC()->cart->get_product_price( $product );
          $subtotal = WC()->cart->get_product_subtotal( $product, $cart_item['quantity'] );
          $link = $product->get_permalink( $cart_item );
          // Anything related to $product, check $product tutorial
          $attributes = $product->get_attributes();
          $meta = wc_get_formatted_cart_item_data( $cart_item );
          $sale_price= $product->get_sale_price();
          $normal_price= $product->get_regular_price();
          $product_variation = wc_get_product( $variation_id );
          if(!empty($product_variation)):
          $v_pname = $product_variation->get_attribute_summary();
          endif;
          ?>   
         <div class="nav-header-cart-dropdown-two-products-item position-relative">
         <?php
								echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
									'woocommerce_cart_item_remove_link',
									sprintf(
                    '<a href="%s" class="delete position-absolute top-0 start-0 fw-light" aria-label="%s" data-product_id="%s" data-product_sku="%s" data-cart-item-key="%s" > حذف </a>',
										esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
										esc_html__( 'Remove this item', 'woocommerce' ),
										esc_attr( $product_id ),
										esc_attr( $product->get_sku() ),
										esc_attr( $cart_item_key )
									),
									$cart_item_key
								);
							?>
            <div class="info d-flex align-items-center">
              <img src="<?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), 'thumbnail' ); echo $image[0]; ?>" alt="<?php echo $product->get_name(); ?>" />
              <div class="detail">
                <h2 class="overflow-hidden">
                  <a href="<?php echo $link; ?>"> <?php echo $product->get_name(); ?> </a>
                </h2>
                <div class="counter d-flex align-items-center">
                <button class="changeinp" type="button" onclick="this.parentNode.querySelector('input[type=number]').stepDown()"> - </button>
                            <?php
                            if ( $product->is_sold_individually() ) {
                            $product_quantity = sprintf( '1 <input type="hidden" name="cart[%s][qty]" value="1" />', $cart_item_key );
                            } else {
                            $product_quantity = woocommerce_quantity_input(
                                array(
                                'input_name'   => "cart[{$cart_item_key}][qty]",
                                'input_value'  => $cart_item['quantity'],
                                'max_value'    => $product->get_max_purchase_quantity(),
                                'min_value'    => '0',
                                'product_name' => $product->get_name(),
                                ),
                                $product,
                                false
                            );
                            }

                            echo apply_filters( 'woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item ); // PHPCS: XSS ok.
                            ?>
                        <button class="changeinp" type="button" onclick="this.parentNode.querySelector('input[type=number]').stepUp()"> + </button>
                </div>
              </div>
            </div>
            <div class="color-price d-flex align-items-center">
              
            <div class="price d-flex align-items-center fw-light">
              <?php if ( !$product->is_type( 'variable' ) ) { ?>
                            <?php if(!empty($sale_price) ) { ?>
                            <del> <?php if (!empty($normal_price)) {
    echo number_format($normal_price, 0, '.', ',');
} ?> </del>
                            <span> <?php echo number_format($sale_price, 0, '.', ','); ?> </span>
                            <?php echo get_woocommerce_currency_symbol(); ?>
                            <?php }else{
                              ?>
                            <span> <?php if (!empty($normal_price)) {
    echo number_format($normal_price, 0, '.', ',');
} ?> </span>
                            <?php echo get_woocommerce_currency_symbol(); ?>
                              <?php
                            } ?>
                          <?php }else{
                            $price_v = $product->get_price_html(); 
                            echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v);
                          } ?>
              </div>
            </div>
        </div>
        <?php
        }
        ?> 

      <?php
      }
      ?>
       
      </div>
      <div class="total-price d-flex align-items-center justify-content-between position-relative">
        <span> جمع کل سبد خرید </span>
        <div>
        <?php $ctotal =  WC()->cart->subtotal; ?>
        <?php echo number_format($ctotal, 0, '.', ','); ?>
        <span class="fw-light"> <?php echo get_woocommerce_currency_symbol(); ?> </span>
        </div>
      </div>
      <a href="<?php echo esc_url( wc_get_checkout_url() ); ?>" class="btn btn-success-2 w-100 d-block fw-bold position-relative"> <?php esc_html_e( 'Proceed to checkout', 'woocommerce' ); ?> </a>
    </div>
<?php endif; ?>


        </div>
      </div>
      <style>
        <?php echo '.elementor-element-' . $clsid . ''; ?> .top-header-fourteen .nav-header-cart > a {
        -webkit-background-size: cover;
        -moz-background-size: cover;
        -o-background-size: cover;
        background-size: cover;
        object-fit: cover;
        background-color: #212341;
        }
      </style>
    <?php }elseif('five'===$settings['styleboxcartkaveh']){ ?>

          <!-- Start Cart -->
          <div class="nav-header-cart header-three-cart ms-auto ms-lg-0 <?php if("right"===$settings['text_aligncartkaveh']){?>float-start<?php }elseif("center"===$settings['text_aligncartkaveh']){?>mx-auto<?php }elseif("left"===$settings['text_aligncartkaveh']){?>float-end<?php } ?>">
          <a <?php if ( wp_is_mobile() ) : ?>data-open-cart="true"<?php endif; ?> href="#" class="btn btn-success position-relative d-flex align-items-center justify-content-center">
            <i class="<?php echo  esc_attr($settings['iconecartkaveh']['value']); ?> me-sm-2"></i>
            <b class="d-none d-sm-block"> <?php echo  esc_html($settings['title2cartkaveh']); ?> </b>
            <span
              class="d-none d-sm-flex align-items-sm-center justify-content-sm-center position-relative top-0 start-0 bottom-0 end-0">
              <?php echo WC()->cart->get_cart_contents_count(); ?> </span>
          </a>
          <?php if($options['kaveh_pr_cart_drop_select'] === 'value-1'): ?>
              <div class="nav-header-cart-dropdown <?php if('left'===$settings['styleulboxcartkaveh']){ ?>left-side<?php } ?>">
                    <ul class="tot-aj-cc">
                    <?php
                      if ( WC()->cart->get_cart_contents_count() == 0 ) {
                        ?>
                          <div class="align-items-center">
                          <img class="mx-auto w-50 d-block text-center position-relative mn-r" src="<?php echo get_template_directory_uri() . '/assets/images/emptybag.png'; ?>" alt="">
                          <h6 class="text-center position-relative mn-r">هیچ محصولی در سبد نیست</h6>
                          </div>
                        <?php
                      }
                      ?>
                          <?php
                          foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                            $product = $cart_item['data'];
                            $product_id = $cart_item['product_id'];
                            $variation_id = $cart_item['variation_id'];
                            $quantity = $cart_item['quantity'];
                            $price = WC()->cart->get_product_price( $product );
                            $subtotal = WC()->cart->get_product_subtotal( $product, $cart_item['quantity'] );
                            $link = $product->get_permalink( $cart_item );
                            // Anything related to $product, check $product tutorial
                            $attributes = $product->get_attributes();

                            $meta = wc_get_formatted_cart_item_data( $cart_item );
                            $sale_price= $product->get_sale_price();
                            $normal_price= $product->get_regular_price();
                          ?>

                          <li class="position-relative">
                          <a href="<?php echo wc_get_cart_remove_url( $cart_item_key ); ?>" type="button" class="delete position-absolute text-center rounded-pill fw-light remove" aria-label="حذف این آیتم" data-product_id="<?php echo $product_id; ?>"> حذف </a>
                              <img src="<?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), 'thumbnail' ); echo $image[0]; ?>" alt="product" />
                                <div class="detail">
                                    <h2>
                                      <a href="#"> <?php echo $product->get_name(); ?> </a>
                                    </h2>
                                    <?php if ( !$product->is_type( 'variable' ) ) { ?>
                                    <?php if(!empty($sale_price) ) { ?>
                                      <div class="offer">
                                      <?php echo number_format($normal_price, 0, '.', ','); ?>
                                      </div>
                                      <div class="price">
                                      <?php echo number_format($sale_price, 0, '.', ','); ?>
                                        <span> تومان </span>
                                      </div> 
                                      <?php }else{
                                        ?>
                                        <div class="price">
                                      <?php echo number_format($normal_price, 0, '.', ','); ?>
                                        <span> تومان </span>
                                      </div> 
                                        <?php
                                      } ?>
                                      
                                      <?php }else{ 
                                        $price_v = $product->get_price_html(); 
                                        echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v);
                                      } ?>
                                </div>
                          </li>
                          <?php 
                          }
                          ?>
                          </ul>
                        <div class="bottom d-flex align-items-center justify-content-between">
                          <div class="total-price">
                            <div class="title">
                              مبلغ قابل پرداخت
                            </div>
                            <div class="price tot-aj">
                              <?php echo WC()->cart->subtotal; ?>
                              <span> تومان </span>
                            </div>
                          </div>
                          <a href="<?php echo wc_get_cart_url(); ?>" class="btn btn-danger rounded-pill seecart ms-5"> مشاهده سبد خرید</a>
                          <a href="<?php echo esc_url( wc_get_checkout_url() ); ?>" class="btn btn-danger rounded-pill"> ثبت سفارش </a>
                        </div>
                      </div>
          <?php elseif($options['kaveh_pr_cart_drop_select'] === 'value-2'): ?>

              <div class="nav-header-cart-dropdown-two <?php if('left'===$settings['styleulboxcartkaveh']){ ?>left-side<?php } ?> position-absolute">
                <div class="nav-header-cart-dropdown-two-heading d-flex align-items-center justify-content-between">
                  <div class="count-products rounded-pill text-center">
                    <b> <?php echo WC()->cart->get_cart_contents_count(); ?> </b>
                    محصول
                  </div>
                  <a href="<?php echo wc_get_cart_url(); ?>">
                    مشاهده‌ی سبد خرید
                    <i class="icon-angle-left"></i>
                  </a>
                </div>
                <div class="nav-header-cart-dropdown-two-products">
                <?php
                if ( WC()->cart->get_cart_contents_count() == 0 ) {
                ?>
                <div class="align-items-center">
                    <img class="mx-auto w-50 d-block text-center position-relative mn-r" src="<?php echo get_template_directory_uri() . '/assets/images/emptybag.png'; ?>" alt="">
                    <h6 class="text-center position-relative mn-r">هیچ محصولی در سبد نیست</h6>
                    </div>
                <?php
                }
                else{
                ?>
                  <?php
                    foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                    $product = $cart_item['data'];
                    $product_id = $cart_item['product_id'];
                    $variation_id = $cart_item['variation_id'];
                    $quantity = $cart_item['quantity'];
                    $price = WC()->cart->get_product_price( $product );
                    $subtotal = WC()->cart->get_product_subtotal( $product, $cart_item['quantity'] );
                    $link = $product->get_permalink( $cart_item );
                    // Anything related to $product, check $product tutorial
                    $attributes = $product->get_attributes();
                    $meta = wc_get_formatted_cart_item_data( $cart_item );
                    $sale_price= $product->get_sale_price();
                    $normal_price= $product->get_regular_price();
                    $product_variation = wc_get_product( $variation_id );
                    if(!empty($product_variation)):
                    $v_pname = $product_variation->get_attribute_summary();
                    endif;
                    ?>   
                  <div class="nav-header-cart-dropdown-two-products-item position-relative">
                  <?php
                          echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                            'woocommerce_cart_item_remove_link',
                            sprintf(
                              '<a href="%s" class="delete position-absolute top-0 start-0 fw-light" aria-label="%s" data-product_id="%s" data-product_sku="%s" data-cart-item-key="%s" > حذف </a>',
                              esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
                              esc_html__( 'Remove this item', 'woocommerce' ),
                              esc_attr( $product_id ),
                              esc_attr( $product->get_sku() ),
                              esc_attr( $cart_item_key )
                            ),
                            $cart_item_key
                          );
                        ?>
                      <div class="info d-flex align-items-center">
                        <img src="<?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), 'thumbnail' ); echo $image[0]; ?>" alt="<?php echo $product->get_name(); ?>" />
                        <div class="detail">
                          <h2 class="overflow-hidden">
                            <a href="<?php echo $link; ?>"> <?php echo $product->get_name(); ?> </a>
                          </h2>
                          <div class="counter d-flex align-items-center">
                          <button class="changeinp" type="button" onclick="this.parentNode.querySelector('input[type=number]').stepDown()"> - </button>
                                      <?php
                                      if ( $product->is_sold_individually() ) {
                                      $product_quantity = sprintf( '1 <input type="hidden" name="cart[%s][qty]" value="1" />', $cart_item_key );
                                      } else {
                                      $product_quantity = woocommerce_quantity_input(
                                          array(
                                          'input_name'   => "cart[{$cart_item_key}][qty]",
                                          'input_value'  => $cart_item['quantity'],
                                          'max_value'    => $product->get_max_purchase_quantity(),
                                          'min_value'    => '0',
                                          'product_name' => $product->get_name(),
                                          ),
                                          $product,
                                          false
                                      );
                                      }

                                      echo apply_filters( 'woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item ); // PHPCS: XSS ok.
                                      ?>
                                  <button class="changeinp" type="button" onclick="this.parentNode.querySelector('input[type=number]').stepUp()"> + </button>
                          </div>
                        </div>
                      </div>
                      <div class="color-price d-flex align-items-center">
                      
                      <div class="price d-flex align-items-center fw-light">
                        <?php if ( !$product->is_type( 'variable' ) ) { ?>
                                      <?php if(!empty($sale_price) ) { ?>
                                      <del> <?php echo number_format($normal_price, 0, '.', ',');; ?> </del>
                                      <span> <?php echo number_format($sale_price, 0, '.', ','); ?> </span>
                                      <?php echo get_woocommerce_currency_symbol(); ?>
                                      <?php }else{
                                        ?>
                                      <span> <?php echo number_format($normal_price, 0, '.', ','); ?> </span>
                                      <?php echo get_woocommerce_currency_symbol(); ?>
                                        <?php
                                      } ?>
                                    <?php }else{
                                      $price_v = $product->get_price_html(); 
                                      echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v);
                                    } ?>
                        </div>
                      </div>
                  </div>
                  <?php
                  }
                  ?> 

                <?php
                }
                ?>
                
                </div>
                <div class="total-price d-flex align-items-center justify-content-between position-relative">
                  <span> جمع کل سبد خرید </span>
                  <div>
                  <?php $ctotal =  WC()->cart->subtotal; ?>
                  <?php echo number_format($ctotal, 0, '.', ','); ?>
                  <span class="fw-light"> <?php echo get_woocommerce_currency_symbol(); ?> </span>
                  </div>
                </div>
                <a href="<?php echo esc_url( wc_get_checkout_url() ); ?>" class="btn btn-success-2 w-100 d-block fw-bold position-relative"> <?php esc_html_e( 'Proceed to checkout', 'woocommerce' ); ?> </a>
              </div>
          <?php endif; ?>
        </div>
        <!-- End Cart -->

    <?php }elseif('four'===$settings['styleboxcartkaveh']){ ?>
      <!-- Start Cart -->
      <div class="nav-header-cart header-cart d-none d-md-block <?php if("right"===$settings['text_aligncartkaveh']){?>float-start<?php }elseif("center"===$settings['text_aligncartkaveh']){?>float-none<?php }elseif("left"===$settings['text_aligncartkaveh']){?>float-end<?php } ?>">
          <a <?php if ( wp_is_mobile() ) : ?>data-open-cart="true"<?php endif; ?> href="#"
            class="btn btn-success position-relative d-flex align-items-center justify-content-center">
            <i class="<?php echo  esc_attr($settings['iconecartkaveh']['value']); ?> d-flex align-items-center justify-content-center"></i>
            <?php echo  esc_html($settings['title2cartkaveh']); ?>
            <span class="position-relative top-0 start-0 d-flex align-items-center justify-content-center ms-4">
            <div class="mob_cart_tot"> <?php echo WC()->cart->get_cart_contents_count(); ?> </div>
              </span>
          </a>
          <?php if($options['kaveh_pr_cart_drop_select'] === 'value-1'): ?>
              <div class="nav-header-cart-dropdown <?php if('left'===$settings['styleulboxcartkaveh']){ ?>left-side<?php } ?>">
                    <ul class="tot-aj-cc">
                    <?php
                      if ( WC()->cart->get_cart_contents_count() == 0 ) {
                        ?>
                          <div class="align-items-center">
                          <img class="mx-auto w-50 d-block text-center position-relative mn-r" src="<?php echo get_template_directory_uri() . '/assets/images/emptybag.png'; ?>" alt="">
                          <h6 class="text-center position-relative mn-r">هیچ محصولی در سبد نیست</h6>
                          </div>
                        <?php
                      }
                      ?>
                          <?php
                          foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                            $product = $cart_item['data'];
                            $product_id = $cart_item['product_id'];
                            $variation_id = $cart_item['variation_id'];
                            $quantity = $cart_item['quantity'];
                            $price = WC()->cart->get_product_price( $product );
                            $subtotal = WC()->cart->get_product_subtotal( $product, $cart_item['quantity'] );
                            $link = $product->get_permalink( $cart_item );
                            // Anything related to $product, check $product tutorial
                            $attributes = $product->get_attributes();

                            $meta = wc_get_formatted_cart_item_data( $cart_item );
                            $sale_price= $product->get_sale_price();
                            $normal_price= $product->get_regular_price();
                          ?>

                          <li class="position-relative">
                          <a href="<?php echo wc_get_cart_remove_url( $cart_item_key ); ?>" type="button" class="delete position-absolute text-center rounded-pill fw-light remove" aria-label="حذف این آیتم" data-product_id="<?php echo $product_id; ?>"> حذف </a>
                              <img src="<?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), 'thumbnail' ); echo $image[0]; ?>" alt="product" />
                                <div class="detail">
                                    <h2>
                                      <a href="#"> <?php echo $product->get_name(); ?> </a>
                                    </h2>
                                    <?php if ( !$product->is_type( 'variable' ) ) { ?>
                                    <?php if(!empty($sale_price) ) { ?>
                                      <div class="offer">
                                      <?php echo number_format($normal_price, 0, '.', ','); ?>
                                      </div>
                                      <div class="price">
                                      <?php echo number_format($sale_price, 0, '.', ','); ?>
                                        <span> تومان </span>
                                      </div> 
                                      <?php }else{
                                        ?>
                                        <div class="price">
                                      <?php echo number_format($normal_price, 0, '.', ','); ?>
                                        <span> تومان </span>
                                      </div> 
                                        <?php
                                      } ?>
                                      
                                      <?php }else{ 
                                        $price_v = $product->get_price_html(); 
                                        echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v);
                                      } ?>
                                </div>
                          </li>
                          <?php 
                          }
                          ?>
                          </ul>
                        <div class="bottom d-flex align-items-center justify-content-between">
                          <div class="total-price">
                            <div class="title">
                              مبلغ قابل پرداخت
                            </div>
                            <div class="price tot-aj">
                              <?php echo WC()->cart->subtotal; ?>
                              <span> تومان </span>
                            </div>
                          </div>
                          <a href="<?php echo wc_get_cart_url(); ?>" class="btn btn-danger rounded-pill seecart ms-5"> مشاهده سبد خرید</a>
                          <a href="<?php echo esc_url( wc_get_checkout_url() ); ?>" class="btn btn-danger rounded-pill"> ثبت سفارش </a>
                        </div>
                      </div>
          <?php elseif($options['kaveh_pr_cart_drop_select'] === 'value-2'): ?>

              <div class="nav-header-cart-dropdown-two <?php if('left'===$settings['styleulboxcartkaveh']){ ?>left-side<?php } ?> position-absolute">
                <div class="nav-header-cart-dropdown-two-heading d-flex align-items-center justify-content-between">
                  <div class="count-products rounded-pill text-center">
                    <b> <?php echo WC()->cart->get_cart_contents_count(); ?> </b>
                    محصول
                  </div>
                  <a href="<?php echo wc_get_cart_url(); ?>">
                    مشاهده‌ی سبد خرید
                    <i class="icon-angle-left"></i>
                  </a>
                </div>
                <div class="nav-header-cart-dropdown-two-products">
                <?php
                if ( WC()->cart->get_cart_contents_count() == 0 ) {
                ?>
                <div class="align-items-center">
                    <img class="mx-auto w-50 d-block text-center position-relative mn-r" src="<?php echo get_template_directory_uri() . '/assets/images/emptybag.png'; ?>" alt="">
                    <h6 class="text-center position-relative mn-r">هیچ محصولی در سبد نیست</h6>
                    </div>
                <?php
                }
                else{
                ?>
                  <?php
                    foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                    $product = $cart_item['data'];
                    $product_id = $cart_item['product_id'];
                    $variation_id = $cart_item['variation_id'];
                    $quantity = $cart_item['quantity'];
                    $price = WC()->cart->get_product_price( $product );
                    $subtotal = WC()->cart->get_product_subtotal( $product, $cart_item['quantity'] );
                    $link = $product->get_permalink( $cart_item );
                    // Anything related to $product, check $product tutorial
                    $attributes = $product->get_attributes();
                    $meta = wc_get_formatted_cart_item_data( $cart_item );
                    $sale_price= $product->get_sale_price();
                    $normal_price= $product->get_regular_price();
                    $product_variation = wc_get_product( $variation_id );
                    if(!empty($product_variation)):
                    $v_pname = $product_variation->get_attribute_summary();
                    endif;
                    ?>   
                  <div class="nav-header-cart-dropdown-two-products-item position-relative">
                  <?php
                          echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                            'woocommerce_cart_item_remove_link',
                            sprintf(
                              '<a href="%s" class="delete position-absolute top-0 start-0 fw-light" aria-label="%s" data-product_id="%s" data-product_sku="%s" data-cart-item-key="%s" > حذف </a>',
                              esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
                              esc_html__( 'Remove this item', 'woocommerce' ),
                              esc_attr( $product_id ),
                              esc_attr( $product->get_sku() ),
                              esc_attr( $cart_item_key )
                            ),
                            $cart_item_key
                          );
                        ?>
                      <div class="info d-flex align-items-center">
                        <img src="<?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), 'thumbnail' ); echo $image[0]; ?>" alt="<?php echo $product->get_name(); ?>" />
                        <div class="detail">
                          <h2 class="overflow-hidden">
                            <a href="<?php echo $link; ?>"> <?php echo $product->get_name(); ?> </a>
                          </h2>
                          <div class="counter d-flex align-items-center">
                          <button class="changeinp" type="button" onclick="this.parentNode.querySelector('input[type=number]').stepDown()"> - </button>
                                      <?php
                                      if ( $product->is_sold_individually() ) {
                                      $product_quantity = sprintf( '1 <input type="hidden" name="cart[%s][qty]" value="1" />', $cart_item_key );
                                      } else {
                                      $product_quantity = woocommerce_quantity_input(
                                          array(
                                          'input_name'   => "cart[{$cart_item_key}][qty]",
                                          'input_value'  => $cart_item['quantity'],
                                          'max_value'    => $product->get_max_purchase_quantity(),
                                          'min_value'    => '0',
                                          'product_name' => $product->get_name(),
                                          ),
                                          $product,
                                          false
                                      );
                                      }

                                      echo apply_filters( 'woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item ); // PHPCS: XSS ok.
                                      ?>
                                  <button class="changeinp" type="button" onclick="this.parentNode.querySelector('input[type=number]').stepUp()"> + </button>
                          </div>
                        </div>
                      </div>
                      <div class="color-price d-flex align-items-center">
                      
                      <div class="price d-flex align-items-center fw-light">
                        <?php if ( !$product->is_type( 'variable' ) ) { ?>
                                      <?php if(!empty($sale_price) ) { ?>
                                      <del> <?php echo number_format($normal_price, 0, '.', ',');; ?> </del>
                                      <span> <?php echo number_format($sale_price, 0, '.', ','); ?> </span>
                                      <?php echo get_woocommerce_currency_symbol(); ?>
                                      <?php }else{
                                        ?>
                                      <span> <?php echo number_format($normal_price, 0, '.', ','); ?> </span>
                                      <?php echo get_woocommerce_currency_symbol(); ?>
                                        <?php
                                      } ?>
                                    <?php }else{
                                      $price_v = $product->get_price_html(); 
                                      echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v);
                                    } ?>
                        </div>
                      </div>
                  </div>
                  <?php
                  }
                  ?> 

                <?php
                }
                ?>
                
                </div>
                <div class="total-price d-flex align-items-center justify-content-between position-relative">
                  <span> جمع کل سبد خرید </span>
                  <div>
                  <?php $ctotal =  WC()->cart->subtotal; ?>
                  <?php echo number_format($ctotal, 0, '.', ','); ?>
                  <span class="fw-light"> <?php echo get_woocommerce_currency_symbol(); ?> </span>
                  </div>
                </div>
                <a href="<?php echo esc_url( wc_get_checkout_url() ); ?>" class="btn btn-success-2 w-100 d-block fw-bold position-relative"> <?php esc_html_e( 'Proceed to checkout', 'woocommerce' ); ?> </a>
              </div>
          <?php endif; ?>
        </div>
        <!-- End Cart -->
      <style>
          .header-cart {
          padding-right: 0;
          border-right: none;
          margin-left: 0;
          }
      </style>
    <?php }elseif('three'===$settings['styleboxcartkaveh']){ ?>
      <div class="top-header-sixteen">
        <div class="nav-header-cart">
          <a <?php if ( wp_is_mobile() ) : ?>data-open-cart="true"<?php endif; ?> href="#" class="top-header-four-cart btn btn-success position-relative justify-content-center">
            <i class="<?php echo  esc_attr($settings['iconecartkaveh']['value']); ?>"></i>
            <span class="d-none d-sm-block"><?php echo  esc_html($settings['title2cartkaveh']); ?></span>
            <span class="cart-aj-span counter"> <?php echo WC()->cart->get_cart_contents_count(); ?> </span>
          </a>
          <?php if($options['kaveh_pr_cart_drop_select'] === 'value-1'): ?>
              <div class="nav-header-cart-dropdown <?php if('left'===$settings['styleulboxcartkaveh']){ ?>left-side<?php } ?>">
                    <ul class="tot-aj-cc">
                    <?php
                      if ( WC()->cart->get_cart_contents_count() == 0 ) {
                        ?>
                          <div class="align-items-center">
                          <img class="mx-auto w-50 d-block text-center position-relative mn-r" src="<?php echo get_template_directory_uri() . '/assets/images/emptybag.png'; ?>" alt="">
                          <h6 class="text-center position-relative mn-r">هیچ محصولی در سبد نیست</h6>
                          </div>
                        <?php
                      }
                      ?>
                          <?php
                          foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                            $product = $cart_item['data'];
                            $product_id = $cart_item['product_id'];
                            $variation_id = $cart_item['variation_id'];
                            $quantity = $cart_item['quantity'];
                            $price = WC()->cart->get_product_price( $product );
                            $subtotal = WC()->cart->get_product_subtotal( $product, $cart_item['quantity'] );
                            $link = $product->get_permalink( $cart_item );
                            // Anything related to $product, check $product tutorial
                            $attributes = $product->get_attributes();

                            $meta = wc_get_formatted_cart_item_data( $cart_item );
                            $sale_price= $product->get_sale_price();
                            $normal_price= $product->get_regular_price();
                          ?>

                          <li class="position-relative">
                          <a href="<?php echo wc_get_cart_remove_url( $cart_item_key ); ?>" type="button" class="delete position-absolute text-center rounded-pill fw-light remove" aria-label="حذف این آیتم" data-product_id="<?php echo $product_id; ?>"> حذف </a>
                              <img src="<?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), 'thumbnail' ); echo $image[0]; ?>" alt="product" />
                                <div class="detail">
                                    <h2>
                                      <a href="#"> <?php echo $product->get_name(); ?> </a>
                                    </h2>
                                    <?php if ( !$product->is_type( 'variable' ) ) { ?>
                                    <?php if(!empty($sale_price) ) { ?>
                                      <div class="offer">
                                      <?php echo number_format($normal_price, 0, '.', ','); ?>
                                      </div>
                                      <div class="price">
                                      <?php echo number_format($sale_price, 0, '.', ','); ?>
                                        <span> تومان </span>
                                      </div> 
                                      <?php }else{
                                        ?>
                                        <div class="price">
                                      <?php echo number_format($normal_price, 0, '.', ','); ?>
                                        <span> تومان </span>
                                      </div> 
                                        <?php
                                      } ?>
                                      
                                      <?php }else{ 
                                        $price_v = $product->get_price_html(); 
                                        echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v);
                                      } ?>
                                </div>
                          </li>
                          <?php 
                          }
                          ?>
                          </ul>
                        <div class="bottom d-flex align-items-center justify-content-between">
                          <div class="total-price">
                            <div class="title">
                              مبلغ قابل پرداخت
                            </div>
                            <div class="price tot-aj">
                              <?php echo WC()->cart->subtotal; ?>
                              <span> تومان </span>
                            </div>
                          </div>
                          <a href="<?php echo wc_get_cart_url(); ?>" class="btn btn-danger rounded-pill seecart ms-5"> مشاهده سبد خرید</a>
                          <a href="<?php echo esc_url( wc_get_checkout_url() ); ?>" class="btn btn-danger rounded-pill"> ثبت سفارش </a>
                        </div>
                      </div>
          <?php elseif($options['kaveh_pr_cart_drop_select'] === 'value-2'): ?>

              <div class="nav-header-cart-dropdown-two <?php if('left'===$settings['styleulboxcartkaveh']){ ?>left-side<?php } ?> position-absolute">
                <div class="nav-header-cart-dropdown-two-heading d-flex align-items-center justify-content-between">
                  <div class="count-products rounded-pill text-center">
                    <b> <?php echo WC()->cart->get_cart_contents_count(); ?> </b>
                    محصول
                  </div>
                  <a href="<?php echo wc_get_cart_url(); ?>">
                    مشاهده‌ی سبد خرید
                    <i class="icon-angle-left"></i>
                  </a>
                </div>
                <div class="nav-header-cart-dropdown-two-products">
                <?php
                if ( WC()->cart->get_cart_contents_count() == 0 ) {
                ?>
                <div class="align-items-center">
                    <img class="mx-auto w-50 d-block text-center position-relative mn-r" src="<?php echo get_template_directory_uri() . '/assets/images/emptybag.png'; ?>" alt="">
                    <h6 class="text-center position-relative mn-r">هیچ محصولی در سبد نیست</h6>
                    </div>
                <?php
                }
                else{
                ?>
                  <?php
                    foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                    $product = $cart_item['data'];
                    $product_id = $cart_item['product_id'];
                    $variation_id = $cart_item['variation_id'];
                    $quantity = $cart_item['quantity'];
                    $price = WC()->cart->get_product_price( $product );
                    $subtotal = WC()->cart->get_product_subtotal( $product, $cart_item['quantity'] );
                    $link = $product->get_permalink( $cart_item );
                    // Anything related to $product, check $product tutorial
                    $attributes = $product->get_attributes();
                    $meta = wc_get_formatted_cart_item_data( $cart_item );
                    $sale_price= $product->get_sale_price();
                    $normal_price= $product->get_regular_price();
                    $product_variation = wc_get_product( $variation_id );
                    if(!empty($product_variation)):
                    $v_pname = $product_variation->get_attribute_summary();
                    endif;
                    ?>   
                  <div class="nav-header-cart-dropdown-two-products-item position-relative">
                  <?php
                          echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                            'woocommerce_cart_item_remove_link',
                            sprintf(
                              '<a href="%s" class="delete position-absolute top-0 start-0 fw-light" aria-label="%s" data-product_id="%s" data-product_sku="%s" data-cart-item-key="%s" > حذف </a>',
                              esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
                              esc_html__( 'Remove this item', 'woocommerce' ),
                              esc_attr( $product_id ),
                              esc_attr( $product->get_sku() ),
                              esc_attr( $cart_item_key )
                            ),
                            $cart_item_key
                          );
                        ?>
                      <div class="info d-flex align-items-center">
                        <img src="<?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), 'thumbnail' ); echo $image[0]; ?>" alt="<?php echo $product->get_name(); ?>" />
                        <div class="detail">
                          <h2 class="overflow-hidden">
                            <a href="<?php echo $link; ?>"> <?php echo $product->get_name(); ?> </a>
                          </h2>
                          <div class="counter d-flex align-items-center">
                          <button class="changeinp" type="button" onclick="this.parentNode.querySelector('input[type=number]').stepDown()"> - </button>
                                      <?php
                                      if ( $product->is_sold_individually() ) {
                                      $product_quantity = sprintf( '1 <input type="hidden" name="cart[%s][qty]" value="1" />', $cart_item_key );
                                      } else {
                                      $product_quantity = woocommerce_quantity_input(
                                          array(
                                          'input_name'   => "cart[{$cart_item_key}][qty]",
                                          'input_value'  => $cart_item['quantity'],
                                          'max_value'    => $product->get_max_purchase_quantity(),
                                          'min_value'    => '0',
                                          'product_name' => $product->get_name(),
                                          ),
                                          $product,
                                          false
                                      );
                                      }

                                      echo apply_filters( 'woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item ); // PHPCS: XSS ok.
                                      ?>
                                  <button class="changeinp" type="button" onclick="this.parentNode.querySelector('input[type=number]').stepUp()"> + </button>
                          </div>
                        </div>
                      </div>
                      <div class="color-price d-flex align-items-center">
                      
                      <div class="price d-flex align-items-center fw-light">
                        <?php if ( !$product->is_type( 'variable' ) ) { ?>
                                      <?php if(!empty($sale_price) ) { ?>
                                      <del> <?php echo number_format($normal_price, 0, '.', ',');; ?> </del>
                                      <span> <?php echo number_format($sale_price, 0, '.', ','); ?> </span>
                                      <?php echo get_woocommerce_currency_symbol(); ?>
                                      <?php }else{
                                        ?>
                                      <span> <?php echo number_format($normal_price, 0, '.', ','); ?> </span>
                                      <?php echo get_woocommerce_currency_symbol(); ?>
                                        <?php
                                      } ?>
                                    <?php }else{
                                      $price_v = $product->get_price_html(); 
                                      echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v);
                                    } ?>
                        </div>
                      </div>
                  </div>
                  <?php
                  }
                  ?> 

                <?php
                }
                ?>
                
                </div>
                <div class="total-price d-flex align-items-center justify-content-between position-relative">
                  <span> جمع کل سبد خرید </span>
                  <div>
                  <?php $ctotal =  WC()->cart->subtotal; ?>
                  <?php echo number_format($ctotal, 0, '.', ','); ?>
                  <span class="fw-light"> <?php echo get_woocommerce_currency_symbol(); ?> </span>
                  </div>
                </div>
                <a href="<?php echo esc_url( wc_get_checkout_url() ); ?>" class="btn btn-success-2 w-100 d-block fw-bold position-relative"> <?php esc_html_e( 'Proceed to checkout', 'woocommerce' ); ?> </a>
              </div>
          <?php endif; ?>

        </div>
      </div>

    <?php } ?>
    <style>
           .nav-header-cart-dropdown-two.left-side {
          right: 0;
          left: auto;
          }
          .header-cart {
          margin-left: 0;
          }
    </style>
    <?php
  }


}
