<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
  exit; // Exit if accessed directly


class ButtonSidebarkaveh extends Widget_Base
{

  public function get_name()
  {
    return 'buttonsidebarkaveh';
  }

  public function get_title()
  {
    return esc_html__(' دکمه بازشونده سایدبار ', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['headerfooterkavehelements'];
  }

  protected function register_controls()
  {

    $this->start_controls_section(
      'contentsocialkaveh',
      [
        'label' => esc_html__('محتوای المان', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
			'widget_title',
			[
				'label' => esc_html__( 'عنوان دکمه فیلتر', 'kaveh-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'فیلتر', 'kaveh-core' ),
			]
		);


    $this->end_controls_section();

  }


  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    
    <button type="button" class="btn <?php if((is_archive() || is_author() || is_category() || is_home() || is_single() || is_tag()) && 'post' == get_post_type()): ?>manblog<?php endif; ?> category-btn-filter mb-4 d-lg-none">
      <i class="icon-filter"></i>
      <?php esc_html_e($settings['widget_title'], 'kavehTheme'); ?>
    </button>
    

    <?php
  }


}
