<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Brandsthirdstkaveh extends Widget_Base{

  public function get_name(){
    return 'brandsthirdstkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل برند ها سبک سه', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentbrandsthirdstkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $repeater = new \Elementor\Repeater();

      $repeater->add_control(
        'brandlogobrandsthirdstkaveh',
        [
          'label' => esc_html__( 'تصویر برند', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
          ],
        ]
        );
        $repeater->add_control(
          'colorbggrbrandsthirdstkaveh',
          [
            'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
          ]
        );
        $repeater->add_control(
          'boldtitlebrandsthirdstkaveh',
          [
              'label' => esc_html__( 'بخش بولد عنوان اصلی', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'برند', 'kaveh-core' ),
      
          ]
      );
      $repeater->add_control(
        'titlebrandsthirdstkaveh',
        [
            'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'اپل', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'tagheadingbrandsthirdstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'parabrandsthirdstkaveh',
      [
          'label' => esc_html__( 'توضیح کوتاه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'برای مشاهده محصولات این برند محبوب کلیک کنید', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'icon1brandsthirdstkaveh',
    [
      'label' => esc_html__( 'آیکون', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::ICONS,
      'skin' => 'inline',
      'exclude_inline_options' => [ 'svg' ],
      'default' => [
        'value' => 'icon-eye-2',
      ],
    ]
  ); 
  $repeater->add_control(
    'buttonbrandsthirdstkaveh',
    [
        'label' => esc_html__( 'متن دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( 'مشاهده بیشتر', 'kaveh-core' ),

    ]
);
        $repeater->add_control(
          'linkbrandsthirdstkaveh',
          [
              'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( '#', 'kaveh-core' ),
      
          ]
      );
      $repeater->add_control(
        'colorticogrbrandsthirdstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون و متن دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,

        ]
      );
      $repeater->add_control(
        'colorbgbutrbrandsthirdstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
        ]
      );
    $this->add_control(
      'listbrandsthirdstkaveh',
      [
        'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'linkbrandsthirdstkaveh' => esc_html__( '#', 'kaveh-core' ),
            
          ],
      ]
      ]
    
    );
       $this->end_controls_section();
       $this->start_controls_section(
        'content2brandsthirdstkaveh',
        [
          'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'productcolumnbrandsthirdstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون محصولات در دسکتاپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 8,
          'step' => 1,
          'default' => 4,
      
        ]
      ); 
      $this->add_control(
        'productcolumn2brandsthirdstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون محصولات در تبلت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 2,
      
        ]
      );
      $this->add_control(
        'productcolumn3brandsthirdstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون محصولات در موبایل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 1,
      
        ]
      );
      $this->end_controls_section();
       $this->start_controls_section(
        'style_brandsthirdstkaveh',
        [
          'label' => esc_html__( 'استایل باکس', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'buttonradiusbrandsthirdstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-brands-item .image::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} .top-brands-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

          ],
        ]
      );
      $this->add_control(
        'colorbrandsbgcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-brands-item' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'colorsepratorcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ جدا کننده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-brands-item .content p::before' => 'background-color: {{VALUE}}',
            '{{WRAPPER}} .top-brands-item .content p::after' => 'background-color: {{VALUE}}',

          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style2_brandsthirdstkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );

      $this->add_control(
        'textcolor1brandsthirdstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-brands-item .content .brandth' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlety1_brandsthirdstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-brands-item .content .brandth',
        ]
      );
      $this->add_control(
        'pcolor2brandsthirdstkaveh',
        [
          'label' => esc_html__( 'رنگ توضیح', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-brands-item .content p' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'py1_brandsthirdstkaveh',
          'label' => esc_html__( 'تایپوگرافی توضیح', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-brands-item .content p',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_brandsthirdstkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'widthbuttonradiustcategorycarouselfifthkaveh',
        [
          'label' => esc_html__( 'عرض دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 50,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-brands-item .content a' => 'max-width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'heightbuttonradiustcategorycarouselfifthkaveh',
        [
          'label' => esc_html__( 'ارتفاع دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 10,
              'max' => 150,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-brands-item .content a' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'buttonty1_brandsthirdstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-brands-item .content a',
        ]
      );
      $this->add_control(
        'borderbuttonradiustcategorycarouselfifthkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-brands-item .content a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();


        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
   <section class="top-brands">
      <div class="container">
        <!-- Start Carousel -->
        <div class="swiper swiper-top-brands overflow-hidden" data-swiper='{"breakpoints":{"320":{"slidesPerView":<?php echo  esc_html($settings['productcolumn3brandsthirdstkaveh']); ?>,"spaceBetween":12},"500":{"slidesPerView":<?php echo  esc_html($settings['productcolumn2brandsthirdstkaveh']); ?>,"spaceBetween":12},"768":{"slidesPerView":<?php echo  esc_html($settings['productcolumn2brandsthirdstkaveh']); ?>,"spaceBetween":12},"992":{"slidesPerView":<?php echo  esc_html($settings['productcolumnbrandsthirdstkaveh']); ?>,"spaceBetween":20},"1200":{"slidesPerView":<?php echo  esc_html($settings['productcolumnbrandsthirdstkaveh']); ?>,"spaceBetween":32}}}'>
          <div class="swiper-wrapper">
          <?php
          $l=1;
                if ( $settings['listbrandsthirdstkaveh'] ) {
                foreach (  $settings['listbrandsthirdstkaveh'] as $item ) {
                ?>
            <!-- Start Slide -->
            <div class="swiper-slide">
              <div class="top-brands-item">
                <div class="image position-relative rang<?php echo $l ?>">
                  <img src="<?php echo esc_url($item['brandlogobrandsthirdstkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['brandlogobrandsthirdstkaveh'] )); ?>" width="114" height="114"
                    class="d-block mx-auto">
                </div>
                <div class="content rg<?php echo $l ?> w-100 mx-auto">
                  <<?php echo  esc_html($item['tagheadingbrandsthirdstkaveh']); ?> class="title text-center brandth">
                    <span><?php echo  esc_html($item['boldtitlebrandsthirdstkaveh']); ?></span>
                    <?php echo  esc_html($item['titlebrandsthirdstkaveh']); ?>
                  </<?php echo  esc_html($item['tagheadingbrandsthirdstkaveh']); ?>>
                  <p class="text-center position-relative"> <?php echo  esc_html($item['parabrandsthirdstkaveh']); ?></p>
                  <a href="<?php echo  esc_url($item['linkbrandsthirdstkaveh']); ?>" class="d-flex align-items-center justify-content-center w-100 mx-auto">
                    <i class="<?php echo  esc_html($item['icon1brandsthirdstkaveh']['value']); ?>"></i>
                    <?php echo  esc_html($item['buttonbrandsthirdstkaveh']); ?>
                  </a>
                </div>
              </div>
            </div>
            <!-- End Slide -->
            <style>
          .top-brands-item <?php echo '.rang'. $l ?>.image::before{
          background: -webkit-linear-gradient(top, <?php echo  esc_attr($item['colorbggrbrandsthirdstkaveh']); ?> 0%, rgba(235, 237, 240, 0) 100%);
          background: -moz-linear-gradient(top, <?php echo  esc_attr($item['colorbggrbrandsthirdstkaveh']); ?> 0%, rgba(235, 237, 240, 0) 100%);
          background: -o-linear-gradient(top, <?php echo  esc_attr($item['colorbggrbrandsthirdstkaveh']); ?> 0%, rgba(235, 237, 240, 0) 100%);
          background: linear-gradient(180deg, <?php echo  esc_attr($item['colorbggrbrandsthirdstkaveh']); ?> 0%, rgba(235, 237, 240, 0) 100%);
          }
          
          .top-brands-item <?php echo '.rg'. $l ?>.content a {
          background-color: <?php echo  esc_attr($item['colorbgbutrbrandsthirdstkaveh']); ?>;
          color: <?php echo  esc_attr($item['colorticogrbrandsthirdstkaveh']); ?>;
          }
            </style>
            <?php
            $l++;
            }
            }
            ?>
          </div>
        </div>
        <!-- End Carousel -->
      </div>
    </section>
<style>

</style>
<?php do_action('kelementor_inline_scripts'); ?>
    <?php
  }


}
