<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Brandssixthstkaveh extends Widget_Base{

  public function get_name(){
    return 'brandssixthstkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل برند ها سبک پنج', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentbrandssixthstkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $repeater = new \Elementor\Repeater();

      $repeater->add_control(
        'brandlogobrandssixthstkaveh',
        [
          'label' => esc_html__( 'تصویر برند', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
          ],
        ]
        );
        $repeater->add_control(
          'linkbrandssixthstkaveh',
          [
              'label' => esc_html__( 'لینک برند', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( '#', 'kaveh-core' ),
      
          ]
      );
    $this->add_control(
      'listbrandssixthstkaveh',
      [
        'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'linkbrandssixthstkaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );
       $this->end_controls_section();
       $this->start_controls_section(
        'content2brandssixthstkaveh',
        [
          'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'productcolumnbrandssixthstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون محصولات در دسکتاپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 8,
          'step' => 0.5,
          'default' => 8,
      
        ]
      ); 
      $this->add_control(
        'productcolumn2brandssixthstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون محصولات در تبلت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 0.5,
          'default' => 4,
      
        ]
      );
      $this->add_control(
        'productcolumn3brandssixthstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون محصولات در موبایل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 0.5,
          'default' => 2.5,
      
        ]
      );
      $this->end_controls_section();

       $this->start_controls_section(
        'style_brandssixthstkaveh',
        [
          'label' => esc_html__( 'استایل', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'heightbuttonradiustbrandssixthstkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 10,
              'max' => 150,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .brands-nic img' => 'max-height: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .brands-nic img' => 'height: {{SIZE}}{{UNIT}};',

          ],
        ]
      );
      $this->add_control(
        'colorbrandsbgbrandssixthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .brands-nic' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonradiusbrandssixthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .brands-nic' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="brands-nic py-5">
      <div class="container">
        <!-- Start Carousel -->
        <div class="swiper swiper-brands-nic overflow-hidden" data-swiper='{"loop":true,"autoplay":{"delay":-1},"speed":5000,"freeMode":true,"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3brandssixthstkaveh']); ?>,"spaceBetween":12},"400":{"slidesPerView":<?php echo esc_html($settings['productcolumn3brandssixthstkaveh']); ?>,"spaceBetween":12},"576":{"slidesPerView":<?php echo esc_html($settings['productcolumn2brandssixthstkaveh']); ?>,"spaceBetween":12},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2brandssixthstkaveh']); ?>,"spaceBetween":12},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumnbrandssixthstkaveh']); ?>,"spaceBetween":12}}}'>
          <div class="swiper-wrapper">
              <?php
              if ( $settings['listbrandssixthstkaveh'] ) {
              foreach (  $settings['listbrandssixthstkaveh'] as $item ) {
              ?>
            <!-- Start Slide -->
            <div class="swiper-slide">
              <a href="<?php echo  esc_html($item['linkbrandssixthstkaveh']); ?>" class="d-block">
                <img src="<?php echo esc_url($item['brandlogobrandssixthstkaveh']['url']); ?>" alt="" width="153" height="33"
                  class="d-block mx-auto">
              </a>
            </div>
            <!-- End Slide -->
            <?php 
                   }
                  }
                  ?>
          </div>
        </div>
        <!-- End Carousel -->
      </div>
    </section>
<style>
  .brands-nic img {
    object-fit: contain;
}
</style>
<?php do_action('kelementor_inline_scripts'); ?>
    <?php
  }


}
