<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Brandsseventhstkaveh extends Widget_Base{

  public function get_name(){
    return 'brandsseventhstkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل برند ها سبک هفت', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentbrandsseventhstkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
        $this->add_control(
          'titlebrandsseventhstkaveh',
          [
              'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'فروشگاه کاوه', 'kaveh-core' ),   
          ]
      );
    $this->add_control(
      'tagheading1brandsseventhstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان اصلی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
  

      $repeater = new \Elementor\Repeater();

      $repeater->add_control(
        'brandlogobrandsseventhstkaveh',
        [
          'label' => esc_html__( 'تصویر برند', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
          ],
        ]
        );
        $repeater->add_control(
          'linkbrandsseventhstkaveh',
          [
              'label' => esc_html__( 'لینک برند', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( '#', 'kaveh-core' ),
      
          ]
      );
    $this->add_control(
      'listbrandsseventhstkaveh',
      [
        'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'linkbrandsseventhstkaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );
    $this->add_control(
      'buttonti2brandsseventhstkavehh',
      [
          'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'مشاهده همه', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'buttontilink2brandsseventhstkavehh',
    [
        'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( '#', 'kaveh-core' ),

    ]
);
       $this->end_controls_section();
       $this->start_controls_section(
        'content2brandsseventhstkaveh',
        [
          'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'productcolumnbrandsseventhstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون محصولات در دسکتاپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 10,
          'step' => 0.5,
          'default' => 8,
      
        ]
      ); 
      $this->add_control(
        'productcolumn2brandsseventhstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون محصولات در تبلت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 0.5,
          'default' => 3,
      
        ]
      );
      $this->add_control(
        'productcolumn3brandsseventhstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون محصولات در موبایل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 0.5,
          'default' => 2,
      
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style0_brandsseventhstkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor1brandsseventhstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-brands-bani-title' => 'color: {{VALUE}} !important',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlety1_brandsseventhstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-brands-bani-title',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'stylec_brandsseventhstkaveh',
        [
          'label' => esc_html__( 'استایل برند ها', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'catimg1widthbrandsseventhstkaveh',
        [
          'label' => esc_html__( 'عرض تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 500,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-brands-bani .swiper img' => 'width: {{SIZE}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_control(
        'catimg1height2brandsseventhstkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 500,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-brands-bani .swiper img' => 'height: {{SIZE}}{{UNIT}}!important;',
          ],
        ]
      );
      $this->add_control(
        'imgradiusbrandsseventhstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-brands-bani .swiper img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );



      $this->end_controls_section();
      $this->start_controls_section(
        'styleb_brandsseventhstkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_brandsseventhstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .btn-more-bani',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowbrandsseventhstkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .btn-more-bani',
        ]
      );
      $this->start_controls_tabs(
        'style_tabsbrandsseventhstkaveh'
      );
    
      $this->start_controls_tab(
        'style_normal_tabbrandsseventhstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorbrandsseventhstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorbrandsseventhstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiusbrandsseventhstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderbrandsseventhstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .btn-more-bani',
        ]
      );
      $this->add_control(
        'buttonbordersbrandsseventhstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderbrandsseventhstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabbrandsseventhstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhoverbrandsseventhstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhoverbrandsseventhstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushoverbrandsseventhstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhoverbrandsseventhstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .btn-more-bani:hover',
        ]
      );
      $this->add_control(
        'buttonbordershoverbrandsseventhstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhoverbrandsseventhstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowbrandsseventhstkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .btn-more-bani',
        ]
      );
      $this->add_control(
        'hr2brandsseventhstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingbrandsseventhstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style5_brandsseventhstkaveh',
        [
          'label' => esc_html__( 'استایل جهت های کاروسل', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'iconsizenchbbrandsseventhstkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .swiper-bani .swiper-button-next::after' => 'font-size: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .swiper-bani .swiper-button-prev::after' => 'font-size: {{SIZE}}{{UNIT}};',

          ],
        ]
      );
      $this->start_controls_tabs(
        'style_tabsarrowbrandsseventhstkaveh'
      );
    
      $this->start_controls_tab(
        'style_normal_tabarrowbrandsseventhstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbutton1colorarrowbrandsseventhstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .swiper-bani .swiper-button-next::after' => 'color: {{VALUE}}',
            '{{WRAPPER}} .swiper-bani .swiper-button-prev::after' => 'color: {{VALUE}}',

          ],
        ]
      ); 
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabarrowbrandsseventhstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbutton1hovercolorarrowbrandsseventhstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .swiper-bani .swiper-button-next:hover::after' => 'color: {{VALUE}}',
            '{{WRAPPER}} .swiper-bani .swiper-button-prev:hover::after' => 'color: {{VALUE}}',
           ],
        ]
      ); 
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->end_controls_section();
       $this->start_controls_section(
        'style_brandsseventhstkaveh',
        [
          'label' => esc_html__( 'استایل باکس', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );

      $this->add_control(
        'colorbrandsbgbrandsseventhstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-brands-bani' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'boxpaddingbrandsseventhstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-brands-bani' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="top-brands-bani">
      <div class="container">
        <<?php echo  esc_attr($settings['tagheading1brandsseventhstkaveh']); ?> class="top-brands-bani-title text-center"> <?php echo  esc_attr($settings['titlebrandsseventhstkaveh']); ?></<?php echo  esc_attr($settings['tagheading1brandsseventhstkaveh']); ?>>
        <div class="position-relative">
          <!-- Start Carousel -->
          <div class="swiper swiper-top-brands-bani overflow-hidden swiper-bani" data-swiper='{"loop":true,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"autoplay":{"delay":3000,"disableOnInteraction":false},"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3brandsseventhstkaveh']); ?>,"spaceBetween":12},"400":{"slidesPerView":<?php echo esc_html($settings['productcolumn3brandsseventhstkaveh']); ?>,"spaceBetween":12},"500":{"slidesPerView":<?php echo esc_html($settings['productcolumn2brandsseventhstkaveh']); ?>,"spaceBetween":12},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2brandsseventhstkaveh']); ?>,"spaceBetween":12},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumnbrandsseventhstkaveh']); ?>,"spaceBetween":20}}}'>
            <div class="swiper-wrapper">
            <?php
                if ( $settings['listbrandsseventhstkaveh'] ) {
                foreach (  $settings['listbrandsseventhstkaveh'] as $item ) {
                ?>
              <!-- Start Slide -->
              <div class="swiper-slide">
                <a href="<?php echo  esc_html($item['linkbrandsseventhstkaveh']); ?>" class="d-block">
                  <img src="<?php echo esc_url($item['brandlogobrandsseventhstkaveh']['url']); ?>" alt="" width="141" height="72"
                    class="w-100 d-block">
                </a>
              </div>
              <!-- End Slide -->
              <?php 
                   }
                  }
                  ?>
            </div>
            <!-- Start Button -->
            <div class="swiper-button-next end-0 d-none d-sm-flex"></div>
            <div class="swiper-button-prev start-0 d-none d-sm-flex"></div>
            <!-- End Button -->
          </div>
          <!-- End Carousel -->
        </div>
        <a href="<?php echo  esc_html($settings['buttontilink2brandsseventhstkavehh']); ?>"
          class="btn btn-outline-dark-4 btn-more-bani d-flex align-items-center justify-content-center mx-auto w-100 mt-5 rounded-pill">
          <?php echo  esc_attr($settings['buttonti2brandsseventhstkavehh']); ?></a>
      </div>
    </section>
<style>
  .top-brands-bani .swiper img {
    object-fit: contain;
}
</style>
<?php do_action('kelementor_inline_scripts'); ?>
    <?php
  }


}
