<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Brandsfourthstkaveh extends Widget_Base{

  public function get_name(){
    return 'brandsfourthstkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل برندها سبک چهار', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentbrandsfourthstkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );

      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
        'img1categorycarouselkaveh',
        [
          'label' => esc_html__( 'لوگو برند', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
          ],
        ]
      );
      $repeater->add_control(
      'title1brandsfourthstkaveh',
      [
        'label' => esc_html__( 'عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'محصولات آیفون',

      ]
    );
    $repeater->add_control(
      'tagheading1brandsfourthstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'buttonicobrandsfourthstkaveh',
      [
        'label' => esc_html__( 'آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'icon-arrow-left-2',
        ],
      ]
    ); 
    $repeater->add_control(
      'linkbrandsfourthstkaveh',
      [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
      ]
    );
    $this->add_control(
      'listbrandsfourthstkaveh',
      [
        'label' => esc_html__( 'برندها ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'title1brandsfourthstkaveh' => esc_html__( 'عنوان', 'kaveh-core' ),
            'linkbrandsfourthstkaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );

    
       $this->end_controls_section();
       $this->start_controls_section(
        'content3brandsfourthstkaveh',
        [
          'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'productcolumnbrandsfourthstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون برندها در دسکتاپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 8,
          'step' => 1,
          'default' => 4,
      
        ]
      );
      $this->add_control(
        'productcolumn2brandsfourthstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون برندها در تبلت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 3,
      
        ]
      );
      $this->add_control(
        'productcolumn3brandsfourthstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون برندها در موبایل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 1,
      
        ]
      );
       $this->end_controls_section();
      $this->start_controls_section(
        'style2_brandsfourthstkaveh',
        [
          'label' => esc_html__( 'استایل عنوان برندها', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor1brandsfourthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان برندها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .best-brands-item .title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlety1_brandsfourthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان برندها', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .best-brands-item .title',
        ]
      );
      $this->add_control(
        'iconcolor1brandsfourthstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .best-brands-item .title i' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'iconsize2brandsfourthstkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => 'px',
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .best-brands-item .title i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_brandsfourthstkaveh',
        [
          'label' => esc_html__( 'استایل باکس برندها', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'borderradiustbrandsfourthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .best-brands-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'boxcolor1brandsfourthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .best-brands-item' => 'background-color: {{VALUE}}',
          ],
        ]
      );

      $this->add_control(
        'buttonpadding1hover2brandsfourthstkaveh',
        [
          'label' => esc_html__( 'پدینگ برندها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .best-brands-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catbk1height2brandsfourthstkaveh',
        [
          'label' => esc_html__( 'ارتفاع باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 400,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .best-brands-item' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->start_controls_tabs(
        'style_tabs2brandsfourthstkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tab2brandsfourthstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border2brandsfourthstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .best-brands-item',
        ]
      );
      $this->add_control(
        'buttonborders2brandsfourthstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border2brandsfourthstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .best-brands-item' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tab2brandsfourthstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border1hover2brandsfourthstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .best-brands-item:hover',
        ]
      );
      $this->add_control(
        'buttonborders1hover2brandsfourthstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border1hover2brandsfourthstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .best-brands-item:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->end_controls_section();
      $this->start_controls_section(
        'styleimag_brandsfourthstkaveh',
        [
          'label' => esc_html__( 'استایل تصویر برندها', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'catimg1widthbrandsfourthstkaveh',
        [
          'label' => esc_html__( 'عرض تصویر برندها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .best-brands-item img' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catimg1height2brandsfourthstkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر برندها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .best-brands-item img' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();

        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="best-brands">
      <div class="container">
        <!-- Start Carousel -->
        <div class="swiper swiper-best-brands" data-swiper='{"watchSlidesProgress":true,"breakpoints":{"320":{"slidesPerView":<?php echo  esc_html($settings['productcolumn3brandsfourthstkaveh']); ?>,"spaceBetween":12},"576":{"slidesPerView":<?php echo  esc_html($settings['productcolumn2brandsfourthstkaveh']); ?>,"spaceBetween":12},"768":{"slidesPerView":<?php echo  esc_html($settings['productcolumn2brandsfourthstkaveh']); ?>,"spaceBetween":12},"992":{"slidesPerView":<?php echo  esc_html($settings['productcolumnbrandsfourthstkaveh']); ?>,"spaceBetween":20},"1200":{"slidesPerView":<?php echo  esc_html($settings['productcolumnbrandsfourthstkaveh']); ?>,"spaceBetween":29}}}'>
          <div class="swiper-wrapper">
            <?php
            if ( $settings['listbrandsfourthstkaveh'] ) {
            foreach (  $settings['listbrandsfourthstkaveh'] as $item ) {
            ?>
            <!-- Start Slide -->
            <div class="swiper-slide">
              <div class="best-brands-item position-relative">
                <a href="<?php echo esc_html($item['linkbrandsfourthstkaveh']); ?>" class="stretched-link" aria-label="brand"></a>
                <img src="<?php echo esc_url($item['img1categorycarouselkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['img1categorycarouselkaveh'] )); ?>" width="171" height="32" class="d-block mx-auto">
                <<?php echo  esc_attr($item['tagheading1brandsfourthstkaveh']); ?> class="title d-flex align-items-center justify-content-center mb-0">
                  <?php echo  esc_html($item['title1brandsfourthstkaveh']); ?>
                  <i class="<?php echo  esc_html($item['buttonicobrandsfourthstkaveh']['value']); ?> ms-3"></i>
                </<?php echo  esc_attr($item['tagheading1brandsfourthstkaveh']); ?>>
              </div>
            </div>
            <!-- End Slide -->
            <?php 
            }
              }
            ?>
          </div>
        </div>
        <!-- End Carousel -->
      </div>
    </section>
    <?php do_action('kelementor_inline_scripts'); ?>

    <?php
  }


}
