<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
  exit; // Exit if accessed directly


class Brandsfifthstkaveh extends Widget_Base
{

  public function get_name()
  {
    return 'brandsfifthstkaveh';
  }

  public function get_title()
  {
    return esc_html__('کاروسل برند ها سبک پنج', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['kavehelements'];
  }

  protected function register_controls()
  {

    $this->start_controls_section(
      'contentbrandsfifthstkaveh',
      [
        'label' => esc_html__('محتوای المان', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'titlebrandsfifthstkaveh',
      [
        'label' => esc_html__('عنوان اصلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('فروشگاه کاوه', 'kaveh-core'),
      ]
    );
    $this->add_control(
      'tagheading1brandsfifthstkaveh',
      [
        'label' => esc_html__('تگ عنوان اصلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'options' => [
          'H1' => esc_html__('H1', 'kaveh-core'),
          'H2' => esc_html__('H2', 'kaveh-core'),
          'H3' => esc_html__('H3', 'kaveh-core'),
          'H4' => esc_html__('H4', 'kaveh-core'),
          'H5' => esc_html__('H5', 'kaveh-core'),
          'H6' => esc_html__('H6', 'kaveh-core'),
          'p' => esc_html__('p', 'kaveh-core'),
          'div' => esc_html__('div', 'kaveh-core'),
          'span' => esc_html__('span', 'kaveh-core'),
        ],
      ]
    );
    $this->add_control(
      'ztitlebrandsfifthstkaveh',
      [
        'label' => esc_html__('توضیحات', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('بیش از ۵۰۰۰ محصول در حوضه بیوتی', 'kaveh-core'),
      ]
    );
    $repeater = new \Elementor\Repeater();

    $repeater->add_control(
      'brandlogobrandsfifthstkaveh',
      [
        'label' => esc_html__('تصویر برند', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
      ]
    );
    $repeater->add_control(
      'linkbrandsfifthstkaveh',
      [
        'label' => esc_html__('لینک برند', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'listbrandsfifthstkaveh',
      [
        'label' => esc_html__('دسته بندی ها', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'linkbrandsfifthstkaveh' => esc_html__('#', 'kaveh-core'),
          ],
        ]
      ]

    );
    $this->add_control(
      'backnvchjbrandsfifthstkaveh',
      [
        'label' => esc_html__('تصویر پس زمینه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'selectors' => [
          '{{WRAPPER}} .brands-six-wrapper::before' => 'background: url({{URL}}) center center no-repeat',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'content2brandsfifthstkaveh',
      [
        'label' => esc_html__('تنظیمات کاروسل', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'productcolumnbrandsfifthstkaveh',
      [
        'label' => esc_html__('تعداد ستون محصولات در دسکتاپ', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 8,
        'step' => 0.5,
        'default' => 5,

      ]
    );
    $this->add_control(
      'productcolumn2brandsfifthstkaveh',
      [
        'label' => esc_html__('تعداد ستون محصولات در تبلت', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 5,
        'step' => 0.5,
        'default' => 3,

      ]
    );
    $this->add_control(
      'productcolumn3brandsfifthstkaveh',
      [
        'label' => esc_html__('تعداد ستون محصولات در موبایل', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 5,
        'step' => 0.5,
        'default' => 2.5,

      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style0_brandsfifthstkaveh',
      [
        'label' => esc_html__('استایل عنوان', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'textcolor1brandsfifthstkaveh',
      [
        'label' => esc_html__('رنگ عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .brands-six-title .title' => 'color: {{VALUE}} !important',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'titlety1_brandsfifthstkaveh',
        'label' => esc_html__('تایپوگرافی عنوان', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .brands-six-title .title',
      ]
    );
    $this->add_control(
      'textcolor2brandsfifthstkaveh',
      [
        'label' => esc_html__('رنگ عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .brands-six-title .sub-title' => 'color: {{VALUE}} !important',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'titlety2_brandsfifthstkaveh',
        'label' => esc_html__('تایپوگرافی عنوان', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .brands-six-title .sub-title',
      ]
    );
    $this->add_control(
      'textcolorbefore2brandsfifthstkaveh',
      [
        'label' => esc_html__('رنگ شیپ', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .brands-six-title .title::before' => 'background-image: -webkit-linear-gradient(183.92deg, {{VALUE}} -15.34%, rgba(234, 238, 244, 0) 88.82%)',
          '{{WRAPPER}} .brands-six-title .title::before' => 'background-image: -moz-linear-gradient(183.92deg, {{VALUE}} -15.34%, rgba(234, 238, 244, 0) 88.82%)',
          '{{WRAPPER}} .brands-six-title .title::before' => 'background-image: -o-linear-gradient(183.92deg, {{VALUE}} -15.34%, rgba(234, 238, 244, 0) 88.82%)',
          '{{WRAPPER}} .brands-six-title .title::before' => 'background-image: linear-gradient(266.08deg, {{VALUE}} -15.34%, rgba(234, 238, 244, 0) 88.82%)',

        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style_brandsfifthstkaveh',
      [
        'label' => esc_html__('استایل باکس', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'buttonradiusbrandsfifthstkaveh',
      [
        'label' => esc_html__('گوشه خمیده باکس', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .brands-six-wrapper::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'colorbrandsbgbrandsfifthstkaveh',
      [
        'label' => esc_html__('رنگ پس زمینه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .brands-six-wrapper::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'boxpaddingbrandsfifthstkaveh',
      [
        'label' => esc_html__('فاصله داخلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .brands-six-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }


  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="brands-six">
      <div class="container">
        <div
          class="brands-six-wrapper position-relative d-flex align-items-sm-center flex-column flex-sm-row gap-4 gap-sm-0">
          <!-- Start Title -->
          <div class="brands-six-title w-100 position-relative">
            <<?php echo esc_attr($settings['tagheading1brandsfifthstkaveh']); ?> class="title mb-1 position-relative
              text-white"> <?php echo esc_attr($settings['titlebrandsfifthstkaveh']); ?></<?php echo esc_attr($settings['tagheading1brandsfifthstkaveh']); ?>>
            <div class="sub-title mb-0"> <?php echo esc_attr($settings['ztitlebrandsfifthstkaveh']); ?></div>
          </div>
          <!-- End Title -->
          <div class="brands-six-carousel w-100 position-relative">
            <!-- Start Carousel -->

            <div class="swiper swiper-brands-six"
              data-swiper='{"watchSlidesProgress":true,"breakpoints":{"320":{"slidesPerView":2,"spaceBetween":12},"400":{"slidesPerView":3,"spaceBetween":12},"576":{"slidesPerView":2,"spaceBetween":12},"768":{"slidesPerView":3,"spaceBetween":20},"992":{"slidesPerView":4,"spaceBetween":32},"1200":{"slidesPerView":4,"spaceBetween":64}}}'>
              <div class="swiper-wrapper">
                <?php
                if ($settings['listbrandsfifthstkaveh']) {
                  foreach ($settings['listbrandsfifthstkaveh'] as $item) {
                    ?>
                    <!-- Start Slide -->
                    <div class="swiper-slide h-auto">
                      <a href="<?php echo esc_html($item['linkbrandsfifthstkaveh']); ?>"
                        class="brand-six-item d-flex align-items-center h-100">
                        <img src="<?php echo esc_url($item['brandlogobrandsfifthstkaveh']['url']); ?>"
                          alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt($item['brandlogobrandsfifthstkaveh'])); ?>"
                          width="109" height="26" class="d-block">
                      </a>
                    </div>
                    <!-- End Slide -->
                    <?php
                  }
                }
                ?>
              </div>
            </div>
            <!-- End Carousel -->
          </div>
        </div>
      </div>
    </section>
    <?php do_action('kelementor_inline_scripts'); ?>

    <?php
  }


}
