<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Brandscarouselsecondstkaveh extends Widget_Base{

  public function get_name(){
    return 'brandscarouselsecondstkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل برند ها سبک دو', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentbrandscarouselsecondstkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
        $this->add_control(
          'titlebrandscarouselsecondstkaveh',
          [
              'label' => esc_html__( 'عنوان', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'برندها', 'kaveh-core' ),
              'condition' => [
                'stylebrandscarouselsecondstkaveh' => 'two',
              ],
      
          ]
      );
      $repeater = new \Elementor\Repeater();

      $repeater->add_control(
        'brandlogobrandscarouselsecondstkaveh',
        [
          'label' => esc_html__( 'تصویر برند', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
        ]
        );
        $repeater->add_control(
          'linkbrandscarouselsecondstkaveh',
          [
              'label' => esc_html__( 'لینک برند', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( '#', 'kaveh-core' ),
      
          ]
      );
    $this->add_control(
      'listbrandscarouselsecondstkaveh',
      [
        'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'linkbrandscarouselsecondstkaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );
       $this->end_controls_section();
       $this->start_controls_section(
        'content2brandscarouselsecondstkaveh',
        [
          'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'productcolumnbrandscarouselsecondstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون محصولات در دسکتاپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 8,
          'step' => 0.5,
          'default' => 5,
      
        ]
      ); 
      $this->add_control(
        'productcolumn2brandscarouselsecondstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون محصولات در تبلت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 0.5,
          'default' => 3,
      
        ]
      );
      $this->add_control(
        'productcolumn3brandscarouselsecondstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون محصولات در موبایل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 0.5,
          'default' => 2.5,
      
        ]
      );
      $this->end_controls_section();
       $this->start_controls_section(
        'style_brandscarouselsecondstkaveh',
        [
          'label' => esc_html__( 'استایل باکس', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'buttonradiusbrandscarouselsecondstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .brands-four .brands-wrapper::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} .brands-four .brands-wrapper::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

          ],
        ]
      );
      $this->add_control(
        'colorbrandsbgcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .brands-four .brands-wrapper::before' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style2_brandscarouselsecondstkaveh',
        [
          'label' => esc_html__( 'استایل برندها', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'widthbrandscarouselsecondstkaveh',
        [
          'label' => esc_html__( 'عرض تصویر برند', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .brands-four .brands-item img' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();

        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <div class="brands brands-four">
      <div class="container">
        <div class="brands-wrapper position-relative">
          <div class="swiper swiper-brands overflow-hidden" data-swiper='{"loop":true,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo  esc_html($settings['productcolumn3brandscarouselsecondstkaveh']); ?>,"spaceBetween":4},"576":{"slidesPerView":<?php echo  esc_html($settings['productcolumn2brandscarouselsecondstkaveh']); ?>,"spaceBetween":8},"768":{"slidesPerView":<?php echo  esc_html($settings['productcolumn2brandscarouselsecondstkaveh']); ?>,"spaceBetween":12},"992":{"slidesPerView":<?php echo  esc_html($settings['productcolumnbrandscarouselsecondstkaveh']); ?>,"spaceBetween":12}}}'>
            <div class="swiper-wrapper">
            <?php
                if ( $settings['listbrandscarouselsecondstkaveh'] ) {
                foreach (  $settings['listbrandscarouselsecondstkaveh'] as $item ) {
                ?>
              <div class="swiper-slide">
                <a href="<?php echo  esc_html($item['linkbrandscarouselsecondstkaveh']); ?>" class="brands-item d-block">
                  <img src="<?php echo esc_url($item['brandlogobrandscarouselsecondstkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['brandlogobrandscarouselsecondstkaveh'] )); ?>" />
                </a>
              </div>
              <?php 
            }
            }
            ?>
            </div>
            <div class="swiper-button-next d-none"></div>
            <div class="swiper-button-prev d-none"></div>
          </div>
        </div>
      </div>
    </div>
    <?php do_action('kelementor_inline_scripts'); ?>
    <?php
    if(empty($settings['borderbrandscarouselsecondstkaveh'])){ ?>
 <style>
  <?php echo '.elementor-element-' . $clsid . ''; ?> .brands-wrapper{
    border-width:0 !important;
  }
 </style>
    <?php
        }
        ?>
    <?php
  }


}
