<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Brandscarouselkaveh extends Widget_Base{

  public function get_name(){
    return 'brandscarouselkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل برند ها', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentbrandscarouselkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'stylebrandscarouselkaveh',
        [
          'label' => esc_html__( 'طرح بندی برند ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'one',
          'options' => [
            'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
            'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),    
          ],
        ]
        );
        $this->add_control(
          'arrowbrandscarouselkaveh',
          [
            'label' => esc_html__( 'نمایش فلش ها؟', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'yes' => esc_html__( 'بله', 'kaveh-core' ),
            'no' => esc_html__( 'خیر', 'kaveh-core' ),
            'return_value' => 'yes',
            'default' => 'no',
            'condition' => [
              'stylebrandscarouselkaveh' => 'one',
            ],
          ]
        ); 
        $this->add_control(
          'titlebrandscarouselkaveh',
          [
              'label' => esc_html__( 'عنوان', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'برندها', 'kaveh-core' ),
              'condition' => [
                'stylebrandscarouselkaveh' => 'two',
              ],
      
          ]
      );
      $this->add_control(
        'tagheadingbrandscarouselkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'condition' => [
            'stylebrandscarouselkaveh' => 'two',
          ],
          'default' => 'H4',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
          ],
        ]
      );
      $repeater = new \Elementor\Repeater();

      $repeater->add_control(
        'brandlogobrandscarouselkaveh',
        [
          'label' => esc_html__( 'تصویر برند', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
        ]
        );
        $repeater->add_control(
          'linkbrandscarouselkaveh',
          [
              'label' => esc_html__( 'لینک برند', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( '#', 'kaveh-core' ),
      
          ]
      );
    $this->add_control(
      'listbrandscarouselkaveh',
      [
        'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'linkbrandscarouselkaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );
       $this->end_controls_section();
       $this->start_controls_section(
        'content3brandscarouselkaveh',
        [
          'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'productcolumnbrandscarouselkaveh',
        [
          'label' => esc_html__( 'تعداد ستون برند ها در دسکتاپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 7,
          'step' => 1,
          'default' => 4,
      
        ]
      );
      $this->add_control(
        'productcolumn2brandscarouselkaveh',
        [
          'label' => esc_html__( 'تعداد ستون برند ها در تبلت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 3,
      
        ]
      );
      $this->add_control(
        'productcolumn3brandscarouselkaveh',
        [
          'label' => esc_html__( 'تعداد ستون برند ها در موبایل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 1,
      
        ]
      );
             $this->end_controls_section();
       $this->start_controls_section(
        'style2_tbrandscarouselkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'condition' => [
            'stylebrandscarouselkaveh' => 'two',
          ],
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      ); 
      $this->add_control(
        'title1stbrandscarouselkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .brands-two .brands-wrapper .title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title1_brandscarouselkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .brands-two .brands-wrapper .title',
        ]
      ); 

      $this->end_controls_section();

       $this->start_controls_section(
        'style_brandscarouselkaveh',
        [
          'label' => esc_html__( 'استایل', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'buttonpaddingbordersbrandscarouselkaveh',
        [
          'label' => esc_html__( 'پدینگ جعبه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .brands-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_control(
        'buttonradiusbrandscarouselkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .brands-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderbrandscarouselkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .brands-wrapper',
        ]
      );
      $this->add_control(
        'buttonbordersbrandscarouselkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderbrandscarouselkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .brands-wrapper' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowbrandscarouselkaveh',
          'label' => esc_html__( 'سایه جعبه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .brands-wrapper',
        ]
      );
      $this->end_controls_section();

        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
      <?php if('one'===$settings['stylebrandscarouselkaveh']){ ?>
      <div class="brands">
        <div class="container">
        <div class="brands-wrapper position-relative">
            <div class="swiper swiper-brands overflow-hidden" data-swiper='{"loop":true,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo  esc_attr($settings['productcolumn3brandscarouselkaveh']); ?>,"spaceBetween":4},"576":{"slidesPerView":<?php echo  esc_attr($settings['productcolumn2brandscarouselkaveh']); ?>,"spaceBetween":8},"768":{"slidesPerView":<?php echo  esc_attr($settings['productcolumn2brandscarouselkaveh']); ?>,"spaceBetween":12},"992":{"slidesPerView":<?php echo  esc_attr($settings['productcolumnbrandscarouselkaveh']); ?>,"spaceBetween":12}}}'>
            <div class="swiper-wrapper">
                <?php
                if ( $settings['listbrandscarouselkaveh'] ) {
                foreach (  $settings['listbrandscarouselkaveh'] as $item ) {
                ?>
                <div class="swiper-slide">
                <a href="<?php echo  esc_html($item['linkbrandscarouselkaveh']); ?>" class="brands-item d-block">
                    <img src="<?php echo esc_url($item['brandlogobrandscarouselkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['brandlogobrandscarouselkaveh'] )); ?>" />
                </a>
                </div>
                <?php 
            }
            }
            ?>
            </div>
            <?php if("yes"===$settings['arrowbrandscarouselkaveh']){?>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
            <?php } ?>
            </div>
        </div>
        </div>
    </div>
    <?php }elseif('two'===$settings['stylebrandscarouselkaveh']){ ?>
     <div class="brands brands-two">
      <div class="container">
        <div class="brands-wrapper position-relative">
          <<?php echo  esc_attr($settings['tagheadingbrandscarouselkaveh']); ?> class="title"> <?php echo  esc_html($settings['titlebrandscarouselkaveh']); ?> </<?php echo  esc_attr($settings['tagheadingbrandscarouselkaveh']); ?>>
          <div class="swiper swiper-brands overflow-hidden" data-swiper='{"loop":true,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo  esc_attr($settings['productcolumn3brandscarouselkaveh']); ?>,"spaceBetween":4},"576":{"slidesPerView":<?php echo  esc_attr($settings['productcolumn2brandscarouselkaveh']); ?>,"spaceBetween":8},"768":{"slidesPerView":<?php echo  esc_attr($settings['productcolumn2brandscarouselkaveh']); ?>,"spaceBetween":12},"992":{"slidesPerView":<?php echo  esc_attr($settings['productcolumnbrandscarouselkaveh']); ?>,"spaceBetween":12}}}'>
            <div class="swiper-wrapper">
            <?php
                if ( $settings['listbrandscarouselkaveh'] ) {
                foreach (  $settings['listbrandscarouselkaveh'] as $item ) {
                ?>
              <div class="swiper-slide">
                <a href="<?php echo  esc_url($item['linkbrandscarouselkaveh']); ?>" class="brands-item d-block">
                  <img src="<?php echo esc_url($item['brandlogobrandscarouselkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['brandlogobrandscarouselkaveh'] )); ?>" />
                </a>
              </div>
              <?php 
            }
            }
            ?>
            </div>
            <div class="swiper-button-next d-none"></div>
            <div class="swiper-button-prev d-none"></div>
          </div>
        </div>
      </div>
    </div>
      <?php } ?>
   
<?php do_action('kelementor_inline_scripts'); ?>
    <?php
    if(empty($settings['borderbrandscarouselkaveh'])){ ?>
 <style>
  <?php echo '.elementor-element-' . $clsid . ''; ?> .brands-wrapper{
    border-width:0;
  }
 </style>
    <?php
        }
        ?>
    <?php
  }


}
