<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
  exit; // Exit if accessed directly


class Bloglistkaveh extends Widget_Base
{

  public function get_name()
  {
    return 'bloglistkaveh';
  }

  public function get_title()
  {
    return esc_html__('المان بلاگ لیست', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['kavehelements'];
  }

  protected function register_controls()
  {

    $this->start_controls_section(
      'contentbloglistkaveh',
      [
        'label' => esc_html__('محتوای المان', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $optionsblog = array();
    $categories = get_categories(
      array(
        'hide_empty' => false,
      )
    );
    foreach ($categories as $key => $category) {
      $optionsblog[$category->term_id] = $category->name;
    }
    $this->add_control(
      'catblogenfhess',
      [
        'label' => esc_html__('انتخاب دسته بندی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'multiple' => true,
        'options' => $optionsblog,
      ]
    );

    $this->add_control(
      'productnumberbloglistkaveh',
      [
        'label' => esc_html__('تعداد محصولات نمایش داده شده', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 20,
        'step' => 1,
        'default' => 5,
      ]
    );
    $this->end_controls_section();
  }


  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>

    <ul class="footer-three-articles">
      <?php

      // Define your custom query arguments
      $query_args = array(
        'post_type' => 'post',
        'posts_per_page' => $settings['productnumberbloglistkaveh'],
        'order' => 'desc',
        'orderby' => 'date',
        'tax_query' => array(
          array(
            'taxonomy' => 'category',
            'field' => 'term_id',
            'terms' => $settings['catblogenfhess'],
          ),
        ),
      );
      // Get the cached query results
      $cached_query = KavehCustomQuery::get_cached_query($query_args);
      if ($cached_query->have_posts()):
        while ($cached_query->have_posts()):
          $cached_query->the_post();
          ?>
          <li class="d-flex align-items-center">
            <img src="<?php if (get_the_post_thumbnail_url()): ?>
                    <?php the_post_thumbnail_url('full'); ?>
                    <?php else: ?>
                    <?php echo wc_placeholder_img_src(); ?>
                    <?php endif; ?>" alt="<?php echo wp_trim_words(get_the_title(), 6) ?>" class="d-block w-100" />
            <div class="detail w-100">
              <h2 class="mb-0 text-nowrap overflow-hidden">
                <a href="<?php the_permalink(); ?>"><?php echo wp_trim_words(get_the_title(), 6) ?></a>
              </h2>
              <span class="d-block text-nowrap overflow-hidden"><?php echo wp_trim_words(get_the_excerpt(), 7) ?></span>
            </div>
          </li>
          <?php
        endwhile;
        wp_reset_postdata();
      else:
        echo 'No posts found.';
      endif;
      ?>
    </ul>
    <?php
  }


}
