<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
  exit; // Exit if accessed directly


class Blogkaveh extends Widget_Base
{

  public function get_name()
  {
    return 'blogkaveh';
  }

  public function get_title()
  {
    return esc_html__('المان بلاگ شبکه ای', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['kavehelements'];
  }

  protected function register_controls()
  {

    $this->start_controls_section(
      'contentblogkaveh',
      [
        'label' => esc_html__('محتوای المان', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'styleblogkaveh',
      [
        'label' => esc_html__('طرح بندی بلاگ', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'one',
        'options' => [
          'one' => esc_html__('طرح بندی اول', 'kaveh-core'),
          'two' => esc_html__('طرح بندی دوم', 'kaveh-core'),
          'three' => esc_html__('طرح بندی سوم', 'kaveh-core'),
          'four' => esc_html__('طرح بندی چهار', 'kaveh-core'),
          'five' => esc_html__('طرح بندی پنج', 'kaveh-core'),
          'seven' => esc_html__('طرح بندی شش', 'kaveh-core'),
          'eight' => esc_html__('طرح بندی هفت', 'kaveh-core'),
          'nine' => esc_html__('طرح بندی هشت', 'kaveh-core'),

        ],
      ]
    );
    $this->add_control(
      'title1blogkaveh',
      [
        'label' => esc_html__('قبل از عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('جدیدترین', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'title2blogkaveh',
      [
        'label' => esc_html__('عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('مقالات', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'title3blogkaveh',
      [
        'label' => esc_html__('بعد از عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('آموزشی', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'tagheadingblogkaveh',
      [
        'label' => esc_html__('تگ عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'options' => [
          'H1' => esc_html__('H1', 'kaveh-core'),
          'H2' => esc_html__('H2', 'kaveh-core'),
          'H3' => esc_html__('H3', 'kaveh-core'),
          'H4' => esc_html__('H4', 'kaveh-core'),
          'H5' => esc_html__('H5', 'kaveh-core'),
          'H6' => esc_html__('H6', 'kaveh-core'),
          'p' => esc_html__('p', 'kaveh-core'),
          'div' => esc_html__('div', 'kaveh-core'),
          'span' => esc_html__('span', 'kaveh-core'),
        ],
      ]
    );
    $this->add_control(
      'moreblogkaveh',
      [
        'label' => esc_html__('نمایش دکمه بیشتر؟', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'yes' => esc_html__('بله', 'kaveh-core'),
        'no' => esc_html__('خیر', 'kaveh-core'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'buttonblogkaveh',
      [
        'label' => esc_html__('دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('بیشتر بخوانید', 'kaveh-core'),
        'condition' => [
          'moreblogkaveh' => 'yes',
        ],

      ]
    );
    $this->add_control(
      'buttonlinkblogkaveh',
      [
        'label' => esc_html__('لینک دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),
        'condition' => [
          'moreblogkaveh' => 'yes',
        ],

      ]
    );
    $optionsblog = array();
    $categories = get_categories(
      array(
        'hide_empty' => false,
      )
    );
    foreach ($categories as $key => $category) {
      $optionsblog[$category->term_id] = $category->name;
    }
    $this->add_control(
      'catblogkaveh',
      [
        'label' => esc_html__('انتخاب دسته بندی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'multiple' => true,
        'options' => $optionsblog,
      ]
    );

    $this->add_control(
      'productnumberblogkaveh',
      [
        'label' => esc_html__('تعداد محصولات نمایش داده شده', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 20,
        'step' => 1,
        'default' => 5,
      ]
    );
    $this->add_control(
      'postcolblogkaveh',
      [
        'label' => esc_html__('تعداد ستون', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '2',
        'options' => [
          '1' => esc_html__('1', 'kaveh-core'),
          '2' => esc_html__('2', 'kaveh-core'),
          '3' => esc_html__('3', 'kaveh-core'),
          '4' => esc_html__('4', 'kaveh-core'),
        ],
      ]
    );

    $this->end_controls_section();
    $this->start_controls_section(
      'style1_blogkaveh',
      [
        'label' => esc_html__('استایل عنوان', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'title3stblogkaveh',
      [
        'label' => esc_html__('رنگ عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .new-article .heading .title mark' => 'color: {{VALUE}}',
          '{{WRAPPER}} .new-article .heading .title' => 'color: {{VALUE}}',

        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title3_blogkaveh',
        'label' => esc_html__('تایپوگرافی عنوان', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .new-article .heading .title',
      ]
    );

    $this->add_control(
      'title32stblogkaveh',
      [
        'label' => esc_html__('رنگ بخش مارک شده', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .new-article .heading .title mark' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style2_blogkaveh',
      [
        'label' => esc_html__('استایل دکمه', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        'condition' => [
          'moreblogkaveh' => 'yes',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'button_blogkaveh',
        'label' => esc_html__('تایپوگرافی متن دکمه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .new-article .heading a',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Text_Shadow::get_type(),
      [
        'name' => 'text_shadowblogkaveh',
        'label' => esc_html__('سایه متن', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .new-article .heading a',
      ]
    );
    $this->start_controls_tabs(
      'style_tabsblogkaveh'
    );

    $this->start_controls_tab(
      'style_normal_tabblogkaveh',
      [
        'label' => esc_html__('عادی', 'kaveh-core'),
      ]
    );
    $this->add_control(
      'textbuttoncolorblogkaveh',
      [
        'label' => esc_html__('رنگ نوشته دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .new-article .heading a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttoncolorblogkaveh',
      [
        'label' => esc_html__('رنگ پس زمینه دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .new-article .heading a' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttonradiusblogkaveh',
      [
        'label' => esc_html__('گوشه خمیده دکمه بیشتر', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .new-article .heading a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'borderblogkaveh',
        'label' => esc_html__('حاشیه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .new-article .heading a',
      ]
    );
    $this->add_control(
      'buttonbordersblogkaveh',
      [
        'label' => esc_html__('عرض حاشیه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'condition' => [
          'borderblogkaveh!' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .new-article .heading a' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_hove_tabblogkaveh',
      [
        'label' => esc_html__('هاور', 'kaveh-core'),
      ]
    );
    $this->add_control(
      'textbuttoncolorhoverblogkaveh',
      [
        'label' => esc_html__('رنگ نوشته دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .new-article .heading a:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttoncolorhoverblogkaveh',
      [
        'label' => esc_html__('رنگ پس زمینه دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .new-article .heading a:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttonradiushoverblogkaveh',
      [
        'label' => esc_html__('گوشه خمیده دکمه بیشتر', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .new-article .heading a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'borderhoverblogkaveh',
        'label' => esc_html__('حاشیه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .new-article .heading a:hover',
      ]
    );
    $this->add_control(
      'buttonbordershoverblogkaveh',
      [
        'label' => esc_html__('عرض حاشیه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'condition' => [
          'borderhoverblogkaveh!' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .new-article .heading a:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'box_shadowblogkavehh',
        'label' => esc_html__('سایه دکمه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .new-article .heading a',
      ]
    );
    $this->add_control(
      'hr1blogkaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $this->add_control(
      'buttonpaddingblogkaveh',
      [
        'label' => esc_html__('فاصله داخلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .new-article .heading a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }


  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>

    <div class="new-article">
      <div class="container">
        <!-- Start Heading -->
        <div class="heading text-center">
          <<?php echo esc_attr($settings['tagheadingblogkaveh']); ?> class="title position-relative">
            <?php echo esc_html($settings['title1blogkaveh']); ?>
            <?php if (!empty($settings['title2blogkaveh'])) { ?>
              <mark> <?php echo esc_html($settings['title2blogkaveh']); ?> </mark>
            <?php } ?>
            <?php echo esc_html($settings['title3blogkaveh']); ?>
          </<?php echo esc_attr($settings['tagheadingblogkaveh']); ?>>
          <?php if ("yes" === $settings['moreblogkaveh']) { ?>
            <a href="<?php echo esc_html($settings['buttonlinkblogkaveh']); ?>">
              <?php echo esc_html($settings['buttonblogkaveh']); ?> </a>
          <?php } ?>
        </div>
        <!-- End Heading -->
        <!-- Start Articles -->
        <div class="row">
          <?php
          // Define your custom query arguments
          $query_args = array(
            'post_type' => 'post',
            'posts_per_page' => $settings['productnumberblogkaveh'],
            'order' => 'desc',
            'orderby' => 'date',
            'tax_query' => array(
              array(
                'taxonomy' => 'category',
                'field' => 'term_id',
                'terms' => $settings['catblogkaveh'],
              ),
            ),
          );
          // Get the cached query results
          $cached_query = KavehCustomQuery::get_cached_query($query_args);
          if ($cached_query->have_posts()):
            while ($cached_query->have_posts()):
              $cached_query->the_post();
              ?>
              <div
                class="<?php if ('1' === $settings['postcolblogkaveh']) { ?>col-lg-12<?php } elseif ('2' === $settings['postcolblogkaveh']) { ?>col-lg-6<?php } elseif ('3' === $settings['postcolblogkaveh']) { ?>col-lg-4<?php } elseif ('4' === $settings['postcolblogkaveh']) { ?>col-lg-3<?php } ?> pb-3 mb-lg-0">
                <?php $styleblogcarousel = $settings['styleblogkaveh']; ?>
                <?php get_template_part("template-part/blog-cart-$styleblogcarousel"); ?>
              </div>
              <?php
            endwhile;
            wp_reset_postdata();
          else:
            echo 'No posts found.';
          endif;
          ?>

        </div>
        <!-- End Articles -->
      </div>
    </div>
    <?php
  }


}
