<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Blogdigikalagridkaveh extends Widget_Base{

  public function get_name(){
    return 'blogdigikalagridkaveh';
  }

  public function get_title(){
    return esc_html__( 'المان بلاگ شبکه ای دیجی کالا', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentblogdigikalagridkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'title2blogdigikalagridkaveh',
        [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'مقالات', 'kaveh-core' ),
    
        ]
    );
  $this->add_control(
    'tagheadingblogdigikalagridkaveh',
    [
      'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'H2',
      'options' => [
        'H1'  => esc_html__( 'H1', 'kaveh-core' ),
        'H2' => esc_html__( 'H2', 'kaveh-core' ),
        'H3' => esc_html__( 'H3', 'kaveh-core' ),
        'H4' => esc_html__( 'H4', 'kaveh-core' ),
        'H5' => esc_html__( 'H5', 'kaveh-core' ),
        'H6' => esc_html__( 'H6', 'kaveh-core' ),
        'p' => esc_html__( 'p', 'kaveh-core' ),
        'div' => esc_html__( 'div', 'kaveh-core' ),
        'span' => esc_html__( 'span', 'kaveh-core' ),
      ],
    ]
  );
      $this->add_control(
        'moreblogdigikalagridkaveh',
        [
          'label' => esc_html__( 'نمایش دکمه بیشتر؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'buttonblogdigikalagridkaveh',
        [
            'label' => esc_html__( 'دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'بیشتر بخوانید', 'kaveh-core' ),
            'condition' => [
              'moreblogdigikalagridkaveh' => 'yes',
            ],
    
        ]
    );
    $this->add_control(
      'buttonlinkblogdigikalagridkaveh',
      [
          'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
          'condition' => [
            'moreblogdigikalagridkaveh' => 'yes',
          ],
  
      ]
  );
  $optionsblog = array();
  $categories = get_categories(array(
    'hide_empty' => false,
  )
  ); 
  foreach ( $categories as $key => $category ) {
      $optionsblog[$category->term_id] = $category->name;
  }
  $this->add_control(
      'catblogdigikalagridkaveh',
      [
        'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT2, 
        'multiple' => true,
        'options' => $optionsblog,
      ]
  );
  
$this->add_control(
  'productnumberblogdigikalagridkaveh',
  [
    'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 20,
    'step' => 1,
    'default' => 5,
  ]
);
$this->add_control(
  'postcolblogdigikalagridkaveh',
  [
    'label' => esc_html__( 'تعداد ستون', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SELECT,
    'default' => '4',
    'options' => [
      '1'  => esc_html__( '1', 'kaveh-core' ),
      '2' => esc_html__( '2', 'kaveh-core' ),
      '3' => esc_html__( '3', 'kaveh-core' ),
      '4' => esc_html__( '4', 'kaveh-core' ),
    ],
  ]
);

       $this->end_controls_section();
       $this->start_controls_section(
        'style1_blogdigikalagridkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'title3stblogdigikalagridkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .digi-articles-heading-title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title3_blogdigikalagridkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .digi-articles-heading-title',
        ]
      );

      $this->end_controls_section();
      $this->start_controls_section(
        'style2_blogdigikalagridkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'moreblogdigikalagridkaveh' => 'yes',
          ],
        ]
      );

      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_blogdigikalagridkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .digi-articles-heading-link',
        ]
      );
      $this->add_control(
        'iconsizenchbblogdigikalagridkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .digi-articles-heading-link i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowblogdigikalagridkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .digi-articles-heading-link',
        ]
      );
      $this->start_controls_tabs(
        'style_tabsblogdigikalagridkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tabblogdigikalagridkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorblogdigikalagridkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .digi-articles-heading-link' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorblogdigikalagridkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .digi-articles-heading-link' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiusblogdigikalagridkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .digi-articles-heading-link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderblogdigikalagridkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .digi-articles-heading-link',
        ]
      );
      $this->add_control(
        'buttonbordersblogdigikalagridkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderblogdigikalagridkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .digi-articles-heading-link' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabblogdigikalagridkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhoverblogdigikalagridkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .digi-articles-heading-link:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhoverblogdigikalagridkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .digi-articles-heading-link:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushoverblogdigikalagridkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .digi-articles-heading-link:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhoverblogdigikalagridkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .digi-articles-heading-link:hover',
        ]
      );
      $this->add_control(
        'buttonbordershoverblogdigikalagridkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhoverblogdigikalagridkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .digi-articles-heading-link:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowblogdigikalagridkavehh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .digi-articles-heading-link',
        ]
      );
      $this->add_control(
        'hr1blogdigikalagridkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingblogdigikalagridkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .digi-articles-heading-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="digi-articles">
      <div class="container">
        <!-- Start Heading -->
        <div class="digi-articles-heading d-flex align-items-center justify-content-between">
          <<?php echo  esc_attr($settings['tagheadingblogdigikalagridkaveh']); ?> class="digi-articles-heading-title mb-0 fw-bold"> <?php echo  esc_html($settings['title2blogdigikalagridkaveh']); ?></<?php echo  esc_attr($settings['tagheadingblogdigikalagridkaveh']); ?>>
          <?php if("yes"===$settings['moreblogdigikalagridkaveh']){?>
          <a href="<?php echo  esc_html($settings['buttonlinkblogdigikalagridkaveh']); ?>" class="digi-articles-heading-link fw-bold">
          <?php echo  esc_html($settings['buttonblogdigikalagridkaveh']); ?>
            <i class="icon-angle-left ms-1"></i>
          </a>
          <?php } ?>
        </div>
        <!-- End Heading -->
        <div class="row">
          <?php
          // Define your custom query arguments
          $query_args = array(
            'post_type' => 'post',
            'posts_per_page' => $settings['productnumberblogdigikalagridkaveh'],
            'order' => 'desc',
            'orderby' => 'date',
            'tax_query' => array(
            array(
                'taxonomy' => 'category',
                'field'    => 'term_id',
                'terms'    => $settings['catblogdigikalagridkaveh'],
                ),
            ),
          );
          // Get the cached query results
          $cached_query = KavehCustomQuery::get_cached_query($query_args);
          if ($cached_query->have_posts()) :
              while ($cached_query->have_posts()) : $cached_query->the_post();
              ?>
            <div class="<?php if('1'===$settings['postcolblogdigikalagridkaveh']){ ?>col-lg-12<?php }elseif('2'===$settings['postcolblogdigikalagridkaveh']){?>col-lg-6<?php }elseif('3'===$settings['postcolblogdigikalagridkaveh']){?>col-lg-4<?php }elseif('4'===$settings['postcolblogdigikalagridkaveh']){?>col-lg-3<?php } ?>">
              <div class="digi-articles-item position-relative bg-white rounded-3 overflow-hidden">
                <a href="<?php the_permalink(); ?>" class="stretched-link" aria-label="<?php the_title(); ?>"></a>
                <img src="<?php if(get_the_post_thumbnail_url()): ?>
                <?php the_post_thumbnail_url('full'); ?>
                <?php else: ?>
                <?php echo wc_placeholder_img_src(); ?>
                <?php endif; ?>" alt="<?php the_title(); ?>" width="315" height="196"
                                class="w-100 d-block">
                <h2 class="title mb-3 px-3 overflow-hidden fw-normal"> <?php the_title(); ?></h2>
              </div>
            </div>
              <?php
              endwhile;
              wp_reset_postdata();
          else :
              echo 'No posts found.';
          endif;
          ?>
        </div>
      </div>
    </section>
    <?php
  }


}
