<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Blogcarouselstkaveh extends Widget_Base{

  public function get_name(){
    return 'blogcarouselstkaveh';
  }

  public function get_title(){
    return esc_html__( 'المان کاروسل بلاگ سبک سه', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentblogcarouselstkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
  
      $this->add_control(
        'title2blogcarouselstkaveh',
        [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'مقالات', 'kaveh-core' ),
    
        ]
    );
  $this->add_control(
    'tagheadingblogcarouselstkaveh',
    [
      'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'H2',
      'options' => [
        'H1'  => esc_html__( 'H1', 'kaveh-core' ),
        'H2' => esc_html__( 'H2', 'kaveh-core' ),
        'H3' => esc_html__( 'H3', 'kaveh-core' ),
        'H4' => esc_html__( 'H4', 'kaveh-core' ),
        'H5' => esc_html__( 'H5', 'kaveh-core' ),
        'H6' => esc_html__( 'H6', 'kaveh-core' ),
        'p' => esc_html__( 'p', 'kaveh-core' ),
        'div' => esc_html__( 'div', 'kaveh-core' ),
        'span' => esc_html__( 'span', 'kaveh-core' ),
      ],
    ]
  );
      $this->add_control(
        'moreblogcarouselstkaveh',
        [
          'label' => esc_html__( 'نمایش دکمه بیشتر؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'buttonblogcarouselstkaveh',
        [
            'label' => esc_html__( 'دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'بیشتر بخوانید', 'kaveh-core' ),
            'condition' => [
              'moreblogcarouselstkaveh' => 'yes',
            ],
    
        ]
    );
    $this->add_control(
      'buttonlinkblogcarouselstkaveh',
      [
          'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
          'condition' => [
            'moreblogcarouselstkaveh' => 'yes',
          ],
  
      ]
  );
  $this->end_controls_section();
  $this->start_controls_section(
    'content2blogcarouselstkaveh',
    [
      'label' => esc_html__( 'محتوای بلاگ', 'kaveh-core' ),
              'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
  );



  $optionsblog = array();
  $categories = get_categories(array(
    'hide_empty' => false,
  )
  ); 
  foreach ( $categories as $key => $category ) {
      $optionsblog[$category->term_id] = $category->name;
  }
  $this->add_control(
      'catblogcarouselstkaveh',
      [
        'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT2, 
        'multiple' => true,
        'options' => $optionsblog,
      ]
  );
  $this->end_controls_section();
  $this->start_controls_section(
    'content3blogcarouselstkaveh',
    [
      'label' => esc_html__( 'تنظیمات نمایش', 'kaveh-core' ),
              'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
  );
$this->add_control(
  'productnumberblogcarouselstkaveh',
  [
    'label' => esc_html__( 'تعداد نوشته نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 20,
    'step' => 1,
    'default' => 5,
  ]
);
$this->add_control(
  'productcolumnblogcarouselstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون نوشته در دسکتاپ', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 4,

  ]
);
$this->add_control(
  'productcolumn2blogcarouselstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون نوشته در تبلت', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 3,

  ]
);
$this->add_control(
  'productcolumn3blogcarouselstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون نوشته در موبایل', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 1,

  ]
);
       $this->end_controls_section();
       $this->start_controls_section(
        'style1_blogcarouselstkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'title3stblogcarouselstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .last-articles-bani-title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title3_blogcarouselstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .last-articles-bani-title',
        ]
      );

      $this->end_controls_section();
      $this->start_controls_section(
        'style2_blogcarouselstkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'moreblogcarouselstkaveh' => 'yes',
          ],
        ]
      );

      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_blogcarouselstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .btn-more-bani',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowblogcarouselstkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .btn-more-bani',
        ]
      );
      $this->start_controls_tabs(
        'style_tabsblogcarouselstkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tabblogcarouselstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorblogcarouselstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorblogcarouselstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiusblogcarouselstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderblogcarouselstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .btn-more-bani',
        ]
      );
      $this->add_control(
        'buttonbordersblogcarouselstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderblogcarouselstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabblogcarouselstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhoverblogcarouselstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhoverblogcarouselstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushoverblogcarouselstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhoverblogcarouselstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .btn-more-bani:hover',
        ]
      );
      $this->add_control(
        'buttonbordershoverblogcarouselstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhoverblogcarouselstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowblogcarouselstkavehh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .btn-more-bani',
        ]
      );
      $this->add_control(
        'hr1blogcarouselstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingblogcarouselstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style5_blogcarouselstkaveh',
        [
          'label' => esc_html__( 'استایل جهت های کاروسل', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'iconsizenchbblogcarouselstkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .swiper-bani .swiper-button-next::after' => 'font-size: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .swiper-bani .swiper-button-prev::after' => 'font-size: {{SIZE}}{{UNIT}};',

          ],
        ]
      );
      $this->start_controls_tabs(
        'style_tabsarrowblogcarouselstkaveh'
      );
    
      $this->start_controls_tab(
        'style_normal_tabarrowblogcarouselstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbutton1colorarrowblogcarouselstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .swiper-bani .swiper-button-next::after' => 'color: {{VALUE}}',
            '{{WRAPPER}} .swiper-bani .swiper-button-prev::after' => 'color: {{VALUE}}',

          ],
        ]
      ); 
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabarrowblogcarouselstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbutton1hovercolorarrowblogcarouselstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .swiper-bani .swiper-button-next:hover::after' => 'color: {{VALUE}}',
            '{{WRAPPER}} .swiper-bani .swiper-button-prev:hover::after' => 'color: {{VALUE}}',
           ],
        ]
      ); 
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->end_controls_section();
          
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="last-articles-bani">
      <div class="container">
        <<?php echo  esc_attr($settings['tagheadingblogcarouselstkaveh']); ?> class="last-articles-bani-title text-center mb-3"> <?php echo  esc_html($settings['title2blogcarouselstkaveh']); ?></<?php echo  esc_attr($settings['tagheadingblogcarouselstkaveh']); ?>>
        <div class="position-relative">
          <!-- Start Carousel -->
          <div class="swiper swiper-last-articles-bani overflow-hidden swiper-bani" data-swiper='{"loop":true,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3blogcarouselstkaveh']); ?>,"spaceBetween":12},"576":{"slidesPerView":<?php echo esc_html($settings['productcolumn2blogcarouselstkaveh']); ?>,"spaceBetween":12},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2blogcarouselstkaveh']); ?>,"spaceBetween":12},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumnblogcarouselstkaveh']); ?>,"spaceBetween":20}}}'>
            <div class="swiper-wrapper">
            <?php
                // Define your custom query arguments
                $query_args = array(
                  'post_type' => 'post',
                  'posts_per_page' => $settings['productnumberblogcarouselstkaveh'],
                  'order' => 'desc',
                  'orderby' => 'date',
                  'tax_query' => array(
                  array(
                      'taxonomy' => 'category',
                      'field'    => 'term_id',
                      'terms'    => $settings['catblogcarouselstkaveh'],
                      ),
                  ),
                );
                // Get the cached query results
                $cached_query = KavehCustomQuery::get_cached_query($query_args);
                if ($cached_query->have_posts()) :
                    while ($cached_query->have_posts()) : $cached_query->the_post();
                    ?>
                      <!-- Start Slide -->
                      <div class="swiper-slide">
                        <div class="article-bani">
                          <a href="<?php the_permalink(); ?>" class="d-block">
                            <img src="<?php if(get_the_post_thumbnail_url()): ?>
                            <?php the_post_thumbnail_url('full'); ?>
                            <?php else: ?>
                            <?php echo wc_placeholder_img_src(); ?>
                            <?php endif; ?>" alt="<?php the_title(); ?>" width="330" height="220" class="d-block w-100">
                          </a>
                          <h2 class="title mb-0">
                            <a href="<?php the_permalink(); ?>" class="d-block text-truncate"><?php the_title(); ?></a>
                          </h2>
                        </div>
                      </div>
                      <!-- End Slide -->
                    <?php
                    endwhile;
                    wp_reset_postdata();
                else :
                    echo 'No posts found.';
                endif;
              ?>
            </div>
            <!-- Start Button -->
            <div class="swiper-button-next end-0 d-none d-sm-flex"></div>
            <div class="swiper-button-prev start-0 d-none d-sm-flex"></div>
            <!-- End Button -->
          </div>
          <!-- End Carousel -->
        </div>
        <?php if("yes"===$settings['moreblogcarouselstkaveh']){?>
        <a href="<?php echo  esc_html($settings['buttonlinkblogcarouselstkaveh']); ?>"
          class="btn btn-outline-dark-4 btn-more-bani d-flex align-items-center justify-content-center mx-auto w-100 mt-5 rounded-pill">
          <?php echo  esc_html($settings['buttonblogcarouselstkaveh']); ?></a>
          <?php } ?>
      </div>
    </section>
    <style>
      .article-bani img{
    object-fit: cover;
    height: 300px;
    }      
    </style>
    <?php do_action('kelementor_inline_scripts'); ?>
    <?php
  }


}
