<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Blogcarouselsecondstkaveh extends Widget_Base{

  public function get_name(){
    return 'blogcarouselsecondstkaveh';
  }

  public function get_title(){
    return esc_html__( 'المان کاروسل بلاگ سبک دو', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentblogcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'عناوین', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
   
      $this->add_control(
          'title1blogcarouselsecondstkaveh',
          [
              'label' => esc_html__( 'عنوان', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'جدیدترین', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'tagheading1blogcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H3',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
      $this->add_control(
        'title2blogcarouselsecondstkaveh',
        [
            'label' => esc_html__( 'عنوان مارک شده', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'مقالات', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'tagheading2blogcarouselsecondstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان مارک شده', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H3',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $this->add_control(
      'title3blogcarouselsecondstkaveh',
      [
          'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'آموزشی', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'linktitle3blogcarouselsecondstkaveh',
    [
        'label' => esc_html__( 'لیتک عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( '#', 'kaveh-core' ),

    ]
);
      $this->add_control(
        'moreblogcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'نمایش دکمه بیشتر؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'buttonblogcarouselsecondstkaveh',
        [
            'label' => esc_html__( 'دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'بیشتر بخوانید', 'kaveh-core' ),
            'condition' => [
              'moreblogcarouselsecondstkaveh' => 'yes',
            ],
    
        ]
    );
    $this->add_control(
      'buttonlinkblogcarouselsecondstkaveh',
      [
          'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
          'condition' => [
            'moreblogcarouselsecondstkaveh' => 'yes',
          ],
  
      ]
  );
 
  $this->end_controls_section();

  $this->start_controls_section(
    'content3blogcarouselsecondstkaveh',
    [
      'label' => esc_html__( 'تنظیمات بلاگ', 'kaveh-core' ),
              'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
  );
  $optionsblog = array();
  $categories = get_categories(array(
    'hide_empty' => false,
  )
  ); 
  foreach ( $categories as $key => $category ) {
      $optionsblog[$category->term_id] = $category->name;
  }
  $this->add_control(
      'catblogenfhess',
      [
        'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT2, 
        'multiple' => true,
        'options' => $optionsblog,
      ]
  );
  
$this->add_control(
  'productnumberblogcarouselsecondstkaveh',
  [
    'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 20,
    'step' => 1,
    'default' => 5,
  ]
);
       $this->end_controls_section();
       $this->start_controls_section(
        'content4blogcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'تصویر', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'bgimgblogcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'تصویر پس زمینه کارت محصولات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'selectors' => [
            '{{WRAPPER}} .article-six figure::after' =>
                'background-image: url({{URL}})',
        ],
        ]
        );

      $this->end_controls_section();

       $this->start_controls_section(
        'style1_blogcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'titlestblogcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-articles-blog .right .sup-title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_blogcarouselsecondstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-articles-blog .right .sup-title',
        ]
      );
      
      $this->add_control(
        'title2stblogcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ بخش مارک شده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-articles-blog .right .title::before' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'title3stblogcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ متن بخش مارک شده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-articles-blog .right .title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletypo2_blogcarouselsecondstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن بخش مارک شده', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-articles-blog .right .title',
        ]
      );
      $this->add_control(
        'title31stblogcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان دوم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-articles-blog .right .read-more' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title3_blogcarouselsecondstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان دوم', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-articles-blog .right .read-more',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style2_blogcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'moreblogcarouselsecondstkaveh' => 'yes',
          ],
        ]
      );
      
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_blogcarouselsecondstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-articles-blog .right .btn',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowblogcarouselsecondstkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-articles-blog .right .btn',
        ]
      );
      $this->start_controls_tabs(
        'style_tabsblogcarouselsecondstkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tabblogcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorblogcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-articles-blog .right .btn' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorblogcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-articles-blog .right .btn' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiusblogcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .new-articles-blog .right .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderblogcarouselsecondstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-articles-blog .right .btn',
        ]
      );
      $this->add_control(
        'buttonbordersblogcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderblogcarouselsecondstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .new-articles-blog .right .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabblogcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhoverblogcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-articles-blog .right .btn:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhoverblogcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-articles-blog .right .btn:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushoverblogcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .new-articles-blog .right .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhoverblogcarouselsecondstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-articles-blog .right .btn:hover',
        ]
      );
      $this->add_control(
        'buttonbordershoverblogcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhoverblogcarouselsecondstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .new-articles-blog .right .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowblogcarouselsecondstkavehh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-articles-blog .right .btn',
        ]
      );
      $this->add_control(
        'hr1blogcarouselsecondstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingblogcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .new-articles-blog .right .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_blogcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'استایل باکس', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'moreblogcarouselsecondstkaveh' => 'yes',
          ],
        ]
      );
      $this->add_control(
        'bgcolorblogcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-articles-blog' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'titlepostcolorblogcarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان پست ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .article-six h2 a' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->end_controls_section();

        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <div class="new-articles-blog">
      <div class="container">
        <div class="new-article-blog-wrapper d-flex position-relative flex-column flex-lg-row">
          <!-- Start Title -->
          <div class="right text-white mb-4 mb-lg-0">
            <<?php echo  esc_attr($settings['tagheading1blogcarouselsecondstkaveh']); ?> class="sup-title"><?php echo  esc_html($settings['title1blogcarouselsecondstkaveh']); ?></<?php echo  esc_attr($settings['tagheading1blogcarouselsecondstkaveh']); ?>>
            <<?php echo  esc_attr($settings['tagheading2blogcarouselsecondstkaveh']); ?> class="title position-relative"><?php echo  esc_html($settings['title2blogcarouselsecondstkaveh']); ?></<?php echo  esc_attr($settings['tagheading2blogcarouselsecondstkaveh']); ?>>
            <a href="<?php echo  esc_url($settings['linktitle3blogcarouselsecondstkaveh']); ?>" class="read-more"><?php echo  esc_html($settings['title3blogcarouselsecondstkaveh']); ?></a>
            <?php if("yes"===$settings['moreblogcarouselsecondstkaveh']){?>
            <a href="<?php echo  esc_html($settings['buttonlinkblogcarouselsecondstkaveh']); ?>"><div class="btn btn-light d-block"> <?php echo  esc_html($settings['buttonblogcarouselsecondstkaveh']); ?></div></a>
            <?php } ?>
          </div>
          <!-- End Title -->
          <!-- Start Items -->
          <div class="left">
            <div class="swiper swiper-new-articles-blog overflow-hidden" data-swiper='{"loop":true,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":1,"spaceBetween":4},"576":{"slidesPerView":2,"spaceBetween":8},"768":{"slidesPerView":2,"spaceBetween":12},"992":{"slidesPerView":2,"spaceBetween":30}}}'>
            <div class="swiper-wrapper">
                <?php
                // Define your custom query arguments
                $query_args = array(
                  'post_type' => 'post',
                  'posts_per_page' => $settings['productnumberblogcarouselsecondstkaveh'],
                  'order' => 'desc',
                  'orderby' => 'date',
                  'tax_query' => array(
                  array(
                      'taxonomy' => 'category',
                      'field'    => 'term_id',
                      'terms'    => $settings['catblogenfhess'],
                      ),
                  ),
                );
                // Get the cached query results
                $cached_query = KavehCustomQuery::get_cached_query($query_args);
                if ($cached_query->have_posts()) :
                    while ($cached_query->have_posts()) : $cached_query->the_post();
                    ?>
                    <div class="swiper-slide">
                        <?php get_template_part("template-part/blog-cart-six"); ?>
                    </div>
                    <?php
                    endwhile;
                    wp_reset_postdata();
                else :
                    echo 'No posts found.';
                endif;
                ?>
            </div>
              <div class="swiper-button-next"></div>
              <div class="swiper-button-prev"></div>
            </div>
          </div>
          <!-- End Items -->
        </div>
      </div>
    </div> 
    <style>
        <?php echo '.elementor-element-' . $clsid . ''; ?> .article-six figure::after {
            -webkit-background-size: cover !important;
            -moz-background-size: cover !important;
            -o-background-size: cover !important;
            background-size: cover !important;
            object-fit: cover !important;
        }
    </style>
    <?php do_action('kelementor_inline_scripts'); ?>

    <?php
  }


}
