<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Blogcarouselkaveh extends Widget_Base{

  public function get_name(){
    return 'blogcarouselkaveh';
  }

  public function get_title(){
    return esc_html__( 'المان کاروسل بلاگ', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentblogcarouselkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
  
      $this->add_control(
          'title1blogcarouselkaveh',
          [
              'label' => esc_html__( 'قبل از عنوان', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'جدیدترین', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'title2blogcarouselkaveh',
        [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'مقالات', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'title3blogcarouselkaveh',
      [
          'label' => esc_html__( 'بعد از عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'آموزشی', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'tagheadingblogcarouselkaveh',
    [
      'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'H2',
      'options' => [
        'H1'  => esc_html__( 'H1', 'kaveh-core' ),
        'H2' => esc_html__( 'H2', 'kaveh-core' ),
        'H3' => esc_html__( 'H3', 'kaveh-core' ),
        'H4' => esc_html__( 'H4', 'kaveh-core' ),
        'H5' => esc_html__( 'H5', 'kaveh-core' ),
        'H6' => esc_html__( 'H6', 'kaveh-core' ),
        'p' => esc_html__( 'p', 'kaveh-core' ),
        'div' => esc_html__( 'div', 'kaveh-core' ),
        'span' => esc_html__( 'span', 'kaveh-core' ),
      ],
    ]
  );
      $this->add_control(
        'moreblogcarouselkaveh',
        [
          'label' => esc_html__( 'نمایش دکمه بیشتر؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'buttonblogcarouselkaveh',
        [
            'label' => esc_html__( 'دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'بیشتر بخوانید', 'kaveh-core' ),
            'condition' => [
              'moreblogcarouselkaveh' => 'yes',
            ],
    
        ]
    );
    $this->add_control(
      'buttonlinkblogcarouselkaveh',
      [
          'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
          'condition' => [
            'moreblogcarouselkaveh' => 'yes',
          ],
  
      ]
  );
  $this->end_controls_section();
  $this->start_controls_section(
    'content2blogcarouselkaveh',
    [
      'label' => esc_html__( 'محتوای بلاگ', 'kaveh-core' ),
              'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
  );

  $this->add_control(
    'styleblogcarouselkaveh',
    [
      'label' => esc_html__( 'طرح بندی بلاگ', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'two',
      'options' => [
        'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
        'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),
        'three'  => esc_html__( 'طرح بندی سوم', 'kaveh-core' ),
        'four'  => esc_html__( 'طرح بندی چهار', 'kaveh-core' ),
        'five'  => esc_html__( 'طرح بندی پنج', 'kaveh-core' ),
        'seven'  => esc_html__( 'طرح بندی شش', 'kaveh-core' ),
        'eight'  => esc_html__( 'طرح بندی هفت', 'kaveh-core' ),
        'nine'  => esc_html__( 'طرح بندی هشت', 'kaveh-core' ),

      ],
    ]
    );


  $optionsblog = array();
  $categories = get_categories(array(
    'hide_empty' => false,
  )
  ); 
  foreach ( $categories as $key => $category ) {
      $optionsblog[$category->term_id] = $category->name;
  }
  $this->add_control(
      'catblogcarouselkaveh',
      [
        'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT2, 
        'multiple' => true,
        'options' => $optionsblog,
      ]
  );
  $this->end_controls_section();
  $this->start_controls_section(
    'content3blogcarouselkaveh',
    [
      'label' => esc_html__( 'تنظیمات نمایش', 'kaveh-core' ),
              'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
  );
$this->add_control(
  'productnumberblogcarouselkaveh',
  [
    'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 20,
    'step' => 1,
    'default' => 5,
  ]
);
$this->add_control(
  'productcolumnblogcarouselkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در دسکتاپ', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 3,

  ]
);
$this->add_control(
  'productcolumn2blogcarouselkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در تبلت', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 3,

  ]
);
$this->add_control(
  'productcolumn3blogcarouselkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در موبایل', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 1,

  ]
);
       $this->end_controls_section();
       $this->start_controls_section(
        'style1_blogcarouselkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'title3stblogcarouselkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-article .heading .title' => 'color: {{VALUE}}',
            '{{WRAPPER}} .new-article .heading .title mark' => 'color: {{VALUE}}',

          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title3_blogcarouselkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-article .heading .title',
        ]
      );

      $this->add_control(
        'title32stblogcarouselkaveh',
        [
          'label' => esc_html__( 'رنگ بخش مارک شده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-article .heading .title mark' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style2_blogcarouselkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'moreblogcarouselkaveh' => 'yes',
          ],
        ]
      );

      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_blogcarouselkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-article .heading a',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowblogcarouselkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-article .heading a',
        ]
      );
      $this->start_controls_tabs(
        'style_tabsblogcarouselkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tabblogcarouselkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorblogcarouselkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-article .heading a' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorblogcarouselkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-article .heading a' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiusblogcarouselkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .new-article .heading a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderblogcarouselkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-article .heading a',
        ]
      );
      $this->add_control(
        'buttonbordersblogcarouselkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderblogcarouselkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .new-article .heading a' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabblogcarouselkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhoverblogcarouselkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-article .heading a:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhoverblogcarouselkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-article .heading a:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushoverblogcarouselkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .new-article .heading a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhoverblogcarouselkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-article .heading a:hover',
        ]
      );
      $this->add_control(
        'buttonbordershoverblogcarouselkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhoverblogcarouselkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .new-article .heading a:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowblogcarouselkavehh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-article .heading a',
        ]
      );
      $this->add_control(
        'hr1blogcarouselkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingblogcarouselkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .new-article .heading a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
          
        }

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>

<div class="new-article">
      <div class="container">
        <!-- Start Heading -->
        <div class="heading text-center">
          <<?php echo  esc_attr($settings['tagheadingblogcarouselkaveh']); ?> class="title position-relative">
          <?php echo  esc_html($settings['title1blogcarouselkaveh']); ?>
            <mark> <?php echo  esc_html($settings['title2blogcarouselkaveh']); ?> </mark>
            <?php echo  esc_html($settings['title3blogcarouselkaveh']); ?>
          </<?php echo  esc_attr($settings['tagheadingblogcarouselkaveh']); ?>>
          <?php if("yes"===$settings['moreblogcarouselkaveh']){?>
          <a href="<?php echo  esc_html($settings['buttonlinkblogcarouselkaveh']); ?>"> <?php echo  esc_html($settings['buttonblogcarouselkaveh']); ?> </a>
          <?php } ?>
        </div>
        <!-- End Heading -->
        <!-- Start Articles -->
        <div class="swiper swiper-articles-two overflow-hidden <?php if('seven'===$settings['styleblogcarouselkaveh']){ ?>swiper-articles-eleven<?php }elseif('eight'===$settings['styleblogcarouselkaveh']){ ?>swiper-new-article-eight<?php } ?>" data-swiper='{"breakpoints":{"320":{"slidesPerView":<?php echo  esc_html($settings['productcolumn3blogcarouselkaveh']); ?>,"spaceBetween":4},"576":{"slidesPerView":<?php echo  esc_html($settings['productcolumn2blogcarouselkaveh']); ?>,"spaceBetween":8},"768":{"slidesPerView":<?php echo  esc_html($settings['productcolumn2blogcarouselkaveh']); ?>,"spaceBetween":20},"992":{"slidesPerView":<?php echo  esc_html($settings['productcolumnblogcarouselkaveh']); ?>,"spaceBetween":30}}}'>
    <div class="swiper-wrapper">
        <?php
        // Define your custom query arguments
        $query_args = array(
          'post_type' => 'post',
          'posts_per_page' => $settings['productnumberblogcarouselkaveh'],
          'order' => 'desc',
          'orderby' => 'date',
          'tax_query' => array(
          array(
              'taxonomy' => 'category',
              'field'    => 'term_id',
              'terms'    => $settings['catblogcarouselkaveh'],
              ),
          ),
        );
        // Get the cached query results
        $cached_query = KavehCustomQuery::get_cached_query($query_args);
        ?>
        <?php 
        if ($cached_query->have_posts()) :
          while ($cached_query->have_posts()) : $cached_query->the_post();
              ?>
              <div class="swiper-slide">
                <?php $styleblogcarousel=$settings['styleblogcarouselkaveh']; ?>
                <?php get_template_part("template-part/blog-cart-$styleblogcarousel"); ?>
              </div>
              <?php
          endwhile;
          wp_reset_postdata();
      else :
          echo 'No posts found.';
      endif;
        ?>

    </div>
  </div>
  <?php do_action('kelementor_inline_scripts'); ?>
    <?php
  }


}
