<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
  exit; // Exit if accessed directly


class BlogArchiveSidebar extends Widget_Base
{

  public function get_name()
  {
    return 'blogarchivesidebar';
  }

  public function get_title()
  {
    return esc_html__('المان سایدبار صفحه وبلاگ', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['blogarchiveelements'];
  }

  protected function register_controls()
  {

    $this->start_controls_section(
      'contentsocialkaveh',
      [
        'label' => esc_html__('محتوای المان', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );



    $this->end_controls_section();

  }


  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();

    ?>
    <aside class="category-sidebar">
      <div class="category-sidebar-backdrop"></div>
      <div class="category-sidebar-content">
        <?php get_sidebar('blog') ?>
    </aside>
    <!-- End Pagination -->
    <?php
  }


}

