<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
  exit; // Exit if accessed directly


class BlogArchivekaveh extends Widget_Base
{

  public function get_name()
  {
    return 'blogarchivekaveh';
  }

  public function get_title()
  {
    return esc_html__('المان آرشیو صفحه وبلاگ', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['blogarchiveelements'];
  }

  protected function register_controls()
  {

    $this->start_controls_section(
      'contentsocialkaveh',
      [
        'label' => esc_html__('محتوای المان', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
        'numberofcoloums',
        [
            'label' => esc_html__( 'تعداد ستون ها', 'textdomain' ),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'min' => 1,
            'max' => 4,
            'step' => 1,
            'default' => 2,
        ]
    );


    $this->end_controls_section();

  }


  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    $options = get_option('kaveh_frame');
    if (!empty($options['kaveh_bl_cart_select'])) {
    $mkblogcart = $options['kaveh_bl_cart_select'];
    }
    $columns = $settings['numberofcoloums'];
    $bootstrap_class = 'col-lg-' . ( 12 / $columns );
    ?>
        <div class="row">
      <?php
      if (have_posts()) {
        while (have_posts()) {
          the_post();
          if (!empty($options['kaveh_bl_cart_select'])) {
            ?>
            <div class="<?php echo $bootstrap_class; ?> mb-4">
              <?php
              switch ($mkblogcart):
                case "value-1":
                  get_template_part("template-part/blog-cart-one");
                  break;
                case "value-2":
                  get_template_part("template-part/blog-cart-two");
                  break;
                case "value-3":
                  get_template_part("template-part/blog-cart-three");
                  break;
                case "value-4":
                  get_template_part("template-part/blog-cart-four");
                  break;
                case "value-5":
                  get_template_part("template-part/blog-cart-five");
                  break;
                case "value-6":
                  get_template_part("template-part/blog-cart-six");
                  break;
                case "value-7":
                  get_template_part("template-part/blog-cart-seven");
                  break;
                case "value-8":
                  get_template_part("template-part/blog-cart-eight");
                  break;
                case "value-9":
                  get_template_part("template-part/blog-cart-nine");
                  break;
              endswitch;
              ?>
            </div>
          <?php }
        } // end while
      } // end if
      ?>
    </div>
    <!-- End Articles -->
    <!-- Start Pagination -->
    <?php
    $args = array(
        'mid_size'  => 2,
        'prev_text' => __('Previous', 'kavehTheme'),
        'next_text' => __('Next', 'kavehTheme'),
        'screen_reader_text' => __('Posts navigation', 'kavehTheme'),
    );

    echo '<ul class="pagination justify-content-center mt-5 mb-5">';
    the_posts_pagination($args);
    echo '</ul>';
    ?>
    <!-- End Pagination -->
    <?php
  }


}
