<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
  exit; // Exit if accessed directly


class Amazingoffersecondstkaveh extends Widget_Base
{

  public function get_name()
  {
    return 'amazingoffersecondstkaveh';
  }

  public function get_title()
  {
    return esc_html__('پیشنهاد شگفت انگیز طرح دو', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['kavehelements'];
  }

  protected function register_controls()
  {

    $this->start_controls_section(
      'contentamazingoffersecondstkaveh',
      [
        'label' => esc_html__('محتوای المان', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'styleboxamazingoffersecondstkaveh',
      [
        'label' => esc_html__('طرح بندی المان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'one',
        'options' => [
          'one' => esc_html__('طرح بندی اول', 'kaveh-core'),
          'two' => esc_html__('طرح بندی دوم', 'kaveh-core'),
          'three' => esc_html__('طرح بندی سوم', 'kaveh-core'),

        ],
      ]
    );
    $this->add_control(
      'titleamazingoffersecondstkaveh',
      [
        'label' => esc_html__('عنوان بولد', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('پیشنهاد', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'title2amazingoffersecondstkaveh',
      [
        'label' => esc_html__('عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('شگفت انگیز', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'tagheading1amazingoffersecondstkaveh',
      [
        'label' => esc_html__('تگ عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H3',
        'options' => [
          'H1' => esc_html__('H1', 'kaveh-core'),
          'H2' => esc_html__('H2', 'kaveh-core'),
          'H3' => esc_html__('H3', 'kaveh-core'),
          'H4' => esc_html__('H4', 'kaveh-core'),
          'H5' => esc_html__('H5', 'kaveh-core'),
          'H6' => esc_html__('H6', 'kaveh-core'),
          'p' => esc_html__('p', 'kaveh-core'),
          'div' => esc_html__('div', 'kaveh-core'),
          'span' => esc_html__('span', 'kaveh-core'),
        ],
      ]
    );
    $this->add_control(
      'subtitleamazingoffersecondstkaveh',
      [
        'label' => esc_html__('زیرعنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__(' محصولات تخفیف دار', 'kaveh-core'),
        'condition' => [
          'styleboxamazingoffersecondstkaveh!' => 'three',
        ],

      ]
    );
    $this->add_control(
      'tagheading2amazingoffersecondstkaveh',
      [
        'label' => esc_html__('تگ زیر عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H6',
        'condition' => [
          'styleboxamazingoffersecondstkaveh!' => 'three',
        ],
        'options' => [
          'H1' => esc_html__('H1', 'kaveh-core'),
          'H2' => esc_html__('H2', 'kaveh-core'),
          'H3' => esc_html__('H3', 'kaveh-core'),
          'H4' => esc_html__('H4', 'kaveh-core'),
          'H5' => esc_html__('H5', 'kaveh-core'),
          'H6' => esc_html__('H6', 'kaveh-core'),
          'p' => esc_html__('p', 'kaveh-core'),
          'div' => esc_html__('div', 'kaveh-core'),
          'span' => esc_html__('span', 'kaveh-core'),
        ],
      ]
    );
    $this->add_control(
      'moreamazingoffersecondstkaveh',
      [
        'label' => esc_html__('نمایش دکمه بیشتر؟', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'yes' => esc_html__('بله', 'kaveh-core'),
        'no' => esc_html__('خیر', 'kaveh-core'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'buttonamazingoffersecondstkaveh',
      [
        'label' => esc_html__('دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('مشاهده همه', 'kaveh-core'),
        'condition' => [
          'moreamazingoffersecondstkaveh' => 'yes',
        ],

      ]
    );
    $this->add_control(
      'buttonlinkamazingoffersecondstkaveh',
      [
        'label' => esc_html__('لینک دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),
        'condition' => [
          'moreamazingoffersecondstkaveh' => 'yes',
        ],

      ]
    );
    $this->add_control(
      'showcircleamazingoffersecondstkaveh',
      [
        'label' => esc_html__('نمایش دایره بالای باکس؟', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'yes' => esc_html__('بله', 'kaveh-core'),
        'no' => esc_html__('خیر', 'kaveh-core'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'imgtopamazingoffersecondstkaveh',
      [
        'label' => esc_html__('تصویر بالای باکس', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-eight-wrapper .left::after' =>
            'background-image: url({{URL}})',
        ],
        'condition' => [
          'styleboxamazingoffersecondstkaveh' => 'three',
        ],
      ]
    );
    $this->add_control(
      'imgbg2amazingoffersecondsstkaveh',
      [
        'label' => esc_html__('تصویر پس زمینه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-eight-wrapper::before' =>
            'background-image: url({{URL}})',
        ],
        'condition' => [
          'styleboxamazingoffersecondstkaveh' => 'three',
        ],
      ]
    );
    $this->add_control(
      'imgbg3amazingoffersecondstkaveh',
      [
        'label' => esc_html__('تصویر پس زمینه محصول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-eight-wrapper .left .swiper::after' =>
            'background-image: url({{URL}})',
        ],
        'condition' => [
          'styleboxamazingoffersecondstkaveh' => 'three',
        ],
      ]
    );
    $optionsst2 = array();
    $orderby = 'name';
    $order = 'asc';
    $hide_empty = false;
    $cat_args = array(
      'orderby' => $orderby,
      'order' => $order,
      'hide_empty' => $hide_empty,
    );

    $product_categories = get_terms('product_cat', $cat_args);

    foreach ($product_categories as $key => $category) {
      $optionsst2[$category->term_id] = $category->name;
    }
    $this->add_control(
      'catamazingoffersecondstkaveh',
      [
        'label' => esc_html__('انتخاب دسته بندی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'multiple' => true,
        'options' => $optionsst2,
      ]
    );
    $this->add_control(
      'imgbg1amazingoffersecondstkaveh',
      [
        'label' => esc_html__('تصویر بک گراند', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-two .container::after' =>
            'background-image: url({{URL}})',
        ],
        'condition' => [
          'styleboxamazingoffersecondstkaveh' => 'one',
        ],
      ]
    );

    $this->add_control(
      'imgbg2amazingoffersecondstkaveh',
      [
        'label' => esc_html__('تصویر بک گراند', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-five .container::after' =>
            'background-image: url({{URL}})',
        ],
        'condition' => [
          'styleboxamazingoffersecondstkaveh' => 'two',
        ],
      ]
    );

    $this->add_control(
      'productnumberamazingoffersecondstkaveh',
      [
        'label' => esc_html__('تعداد محصولات نمایش داده شده', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 20,
        'step' => 1,
        'default' => 5,
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style_amazingoffersecondstkaveh',
      [
        'label' => esc_html__('استایل عناوین', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'textcolorboldamazingoffersecondstkaveh',
      [
        'label' => esc_html__('رنگ بخش بولد عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'styleboxamazingoffersecondstkaveh!' => 'three',
        ],
        'selectors' => [
          '{{WRAPPER}} .section-heading-title b' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'textcolor2amazingoffersecondstkaveh',
      [
        'label' => esc_html__('رنگ عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'styleboxamazingoffersecondstkaveh!' => 'three',
        ],
        'selectors' => [
          '{{WRAPPER}} .section-heading-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'textcolorbold2amazingoffersecondstkaveh',
      [
        'label' => esc_html__('رنگ بخش بولد عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'styleboxamazingoffersecondstkaveh' => 'three',
        ],
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-eight-wrapper .right .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'textcolor22amazingoffersecondstkaveh',
      [
        'label' => esc_html__('رنگ عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'styleboxamazingoffersecondstkaveh' => 'three',
        ],
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-eight-wrapper .right .title span' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title2_amazingoffersecondstkaveh',
        'label' => esc_html__('تایپوگرافی عنوان', 'kaveh-core'),
        'condition' => [
          'styleboxamazingoffersecondstkaveh' => 'three',
        ],
        'selector' => '{{WRAPPER}} .amazing-offer-eight-wrapper .right .title,{{WRAPPER}} .amazing-offer-eight-wrapper .right .title span',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title_amazingoffersecondstkaveh',
        'label' => esc_html__('تایپوگرافی عنوان', 'kaveh-core'),
        'condition' => [
          'styleboxamazingoffersecondstkaveh!' => 'three',
        ],
        'selector' => '{{WRAPPER}} .section-heading-title',
      ]
    );
    $this->add_control(
      'textcolor3amazingoffersecondstkaveh',
      [
        'label' => esc_html__('رنگ زیر عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'styleboxamazingoffersecondstkaveh!' => 'three',
        ],
        'selectors' => [
          '{{WRAPPER}} .section-heading-sub-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title21_amazingoffersecondstkaveh',
        'label' => esc_html__('تایپوگرافی زیر عنوان', 'kaveh-core'),
        'condition' => [
          'styleboxamazingoffersecondstkaveh!' => 'three',
        ],
        'selector' => '{{WRAPPER}} .section-heading-sub-title',
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style2_amazingoffersecondstkaveh',
      [
        'label' => esc_html__('استایل دکمه', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        'condition' => [
          'moreamazingoffersecondstkaveh' => 'yes',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'button_amazingoffersecondstkaveh',
        'label' => esc_html__('تایپوگرافی متن دکمه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .section-heading-link',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Text_Shadow::get_type(),
      [
        'name' => 'text_shadowamazingoffersecondstkaveh',
        'label' => esc_html__('سایه متن', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .section-heading-link',
      ]
    );
    $this->start_controls_tabs(
      'style_tabsamazingoffersecondstkaveh'
    );

    $this->start_controls_tab(
      'style_normal_tabamazingoffersecondstkaveh',
      [
        'label' => esc_html__('عادی', 'kaveh-core'),
      ]
    );
    $this->add_control(
      'textbuttoncoloramazingoffersecondstkaveh',
      [
        'label' => esc_html__('رنگ نوشته دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .section-heading-link' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttoncoloramazingoffersecondstkaveh',
      [
        'label' => esc_html__('رنگ پس زمینه دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .section-heading-link' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttonradiusamazingoffersecondstkaveh',
      [
        'label' => esc_html__('گوشه خمیده دکمه بیشتر', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .section-heading-link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'borderamazingoffersecondstkaveh',
        'label' => esc_html__('حاشیه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .section-heading-link',
      ]
    );
    $this->add_control(
      'buttonbordersamazingoffersecondstkaveh',
      [
        'label' => esc_html__('عرض حاشیه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'condition' => [
          'borderamazingoffersecondstkaveh!' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .section-heading-link' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_hove_tabamazingoffersecondstkaveh',
      [
        'label' => esc_html__('هاور', 'kaveh-core'),
      ]
    );
    $this->add_control(
      'textbuttoncolorhoveramazingoffersecondstkaveh',
      [
        'label' => esc_html__('رنگ نوشته دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .section-heading-link:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttoncolorhoveramazingoffersecondstkaveh',
      [
        'label' => esc_html__('رنگ پس زمینه دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .section-heading-link:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttonradiushoveramazingoffersecondstkaveh',
      [
        'label' => esc_html__('گوشه خمیده دکمه بیشتر', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .section-heading-link:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'borderhoveramazingoffersecondstkaveh',
        'label' => esc_html__('حاشیه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .section-heading-link:hover',
      ]
    );
    $this->add_control(
      'buttonbordershoveramazingoffersecondstkaveh',
      [
        'label' => esc_html__('عرض حاشیه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'condition' => [
          'borderhoveramazingoffersecondstkaveh!' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .section-heading-link:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'box_shadowamazingoffersecondstkavehh',
        'label' => esc_html__('سایه دکمه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .section-heading-link',
      ]
    );
    $this->add_control(
      'hr1amazingoffersecondstkaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $this->add_control(
      'buttonpaddingamazingoffersecondstkaveh',
      [
        'label' => esc_html__('فاصله داخلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .section-heading-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style4_amazingoffersecondstkaveh',
      [
        'label' => esc_html__('استایل پس زمینه', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'bgcol1amazingoffersecondstkaveh',
      [
        'label' => esc_html__('رنگ پس زمینه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'styleboxamazingoffersecondstkaveh' => 'one',
        ],
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-two .container::before' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'imagetop1amazingoffersecondstkaveh',
      [
        'label' => esc_html__('فاصله از بالا', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'condition' => [
          'styleboxamazingoffersecondstkaveh' => 'one',
        ],
        'size_units' => ['px', '%'],
        'range' => [
          'px' => [
            'min' => -2000,
            'max' => 2000,
            'step' => 5,
          ],
          '%' => [
            'min' => -100,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-two .container::before' => 'top: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'bgcoloramazingoffersecondstkaveh',
      [
        'label' => esc_html__('رنگ پس زمینه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'styleboxamazingoffersecondstkaveh' => 'two',
        ],
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-five .container::after' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'imagewidthamazingoffersecondstkaveh',
      [
        'label' => esc_html__('عرض پس زمینه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'condition' => [
          'styleboxamazingoffersecondstkaveh' => 'two',
        ],
        'size_units' => ['px', '%'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 2000,
            'step' => 5,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-five .container::after' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'imageheightamazingoffersecondstkaveh',
      [
        'label' => esc_html__('ارتفاع پس زمینه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'condition' => [
          'styleboxamazingoffersecondstkaveh' => 'two',
        ],
        'size_units' => ['px', '%'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 2000,
            'step' => 5,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-five .container::after' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'imagetop2amazingoffersecondstkaveh',
      [
        'label' => esc_html__('فاصله از بالا', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'condition' => [
          'styleboxamazingoffersecondstkaveh' => 'two',
        ],
        'size_units' => ['px', '%'],
        'range' => [
          'px' => [
            'min' => -2000,
            'max' => 2000,
            'step' => 5,
          ],
          '%' => [
            'min' => -100,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-five .container::after' => 'top: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'bgcolorg1amazingoffersecondstkaveh',
      [
        'label' => esc_html__('رنگ اول پس زمینه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'styleboxamazingoffersecondstkaveh' => 'three',
        ],
      ]
    );
    $this->add_control(
      'bgcolorg2amazingoffersecondstkaveh',
      [
        'label' => esc_html__('رنگ دوم پس زمینه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'styleboxamazingoffersecondstkaveh' => 'three',
        ],
      ]
    );
    $this->add_control(
      'radiusamazingoffersecondstkaveh',
      [
        'label' => esc_html__('گوشه خمیده باکس', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'condition' => [
          'styleboxamazingoffersecondstkaveh' => 'three',
        ],
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-eight-wrapper::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style5_amazingoffersecondstkaveh',
      [
        'label' => esc_html__('استایل تصویر بالای باکس', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        'condition' => [
          'styleboxamazingoffersecondstkaveh' => 'three',
        ],
      ]
    );
    $this->add_control(
      'imagewidth3amazingoffersecondstkaveh',
      [
        'label' => esc_html__('عرض تصویر', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'condition' => [
          'styleboxamazingoffersecondstkaveh' => 'three',
        ],
        'size_units' => ['px', '%'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 2000,
            'step' => 5,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-eight-wrapper .left::after' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'imageheight3amazingoffersecondstkaveh',
      [
        'label' => esc_html__('ارتفاع تصویر', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'condition' => [
          'styleboxamazingoffersecondstkaveh' => 'three',
        ],
        'size_units' => ['px', '%'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 2000,
            'step' => 5,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-eight-wrapper .left::after' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'hr11amazingoffersecondstkaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $this->add_control(
      'imagetop3amazingoffersecondstkaveh',
      [
        'label' => esc_html__('فاصله از بالا', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'condition' => [
          'styleboxamazingoffersecondstkaveh' => 'three',
        ],
        'size_units' => ['px', '%'],
        'range' => [
          'px' => [
            'min' => -2000,
            'max' => 2000,
            'step' => 5,
          ],
          '%' => [
            'min' => -100,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-eight-wrapper .left::after' => 'top: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'imageright3amazingoffersecondstkaveh',
      [
        'label' => esc_html__('فاصله از راست', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'condition' => [
          'styleboxamazingoffersecondstkaveh' => 'three',
        ],
        'size_units' => ['px', '%'],
        'range' => [
          'px' => [
            'min' => -2000,
            'max' => 2000,
            'step' => 5,
          ],
          '%' => [
            'min' => -100,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-eight-wrapper .left::after' => 'right: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style6_amazingoffersecondstkaveh',
      [
        'label' => esc_html__('استایل محصولات', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'bgcolorshapeamazingoffersecondstkaveh',
      [
        'label' => esc_html__('رنگ پس زمینه شیپ', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'styleboxamazingoffersecondstkaveh' => 'three',
        ],
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-eight-wrapper .left .swiper::after' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'bgcolortimeramazingoffersecondstkaveh',
      [
        'label' => esc_html__('رنگ پس زمینه تایمر', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-eight-wrapper .right .timear li span' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();

  }


  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <?php if ('one' === $settings['styleboxamazingoffersecondstkaveh']) { ?>
      <section class="amazing-offer-two">
        <div class="container position-relative">
          <!-- Start Heading -->
          <div class="section-heading d-flex align-items-sm-center justify-content-sm-between flex-column flex-sm-row">
            <div class="detail position-relative">
              <<?php echo esc_attr($settings['tagheading1amazingoffersecondstkaveh']); ?> class="section-heading-title"> <b>
                  <?php echo esc_html($settings['titleamazingoffersecondstkaveh']); ?> </b>
                <?php echo esc_html($settings['title2amazingoffersecondstkaveh']); ?> </<?php echo esc_attr($settings['tagheading1amazingoffersecondstkaveh']); ?>>
              <<?php echo esc_attr($settings['tagheading2amazingoffersecondstkaveh']); ?> class="section-heading-sub-title">
                <?php echo esc_html($settings['subtitleamazingoffersecondstkaveh']); ?> </<?php echo esc_attr($settings['tagheading2amazingoffersecondstkaveh']); ?>>
            </div>
            <?php if ("yes" === $settings['moreamazingoffersecondstkaveh']) { ?>
              <a href="<?php echo esc_url($settings['buttonlinkamazingoffersecondstkaveh']); ?>"
                class="section-heading-link btn btn-outline-light">
                <?php echo esc_html($settings['buttonamazingoffersecondstkaveh']); ?> </a>
            <?php } ?>
          </div>
          <!-- End Heading -->
          <!-- Start Products -->
          <div class="swiper swiper-amazing-offer-two overflow-hidden"
            data-swiper='{"loop":true,"slidesPerView":1,"spaceBetween":0,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"autoplay":{"delay":5000,"disableOnInteraction":false,"pauseOnMouseEnter":true},"effect":"fade","fadeEffect":{"crossFade":true}}'>
            <div class="swiper-wrapper">
              <?php

              // WP_Query args
              $q_pce_query_args = array(
                'post_type' => array('product'),
                'post_status' => array('publish'),
                'posts_per_page' => $settings['productnumberamazingoffersecondstkaveh'],
                'order' => 'DESC',
                'orderby' => 'date',
                'meta_query' => array(
                  array(
                    'key' => '_stock_status',
                    'value' => 'outofstock',
                    'compare' => '!=',
                  ),
                ),
                'post__in' => array_merge(array(0), wc_get_product_ids_on_sale())
              );

              // Check if the category variable is empty
              if (!empty($settings['catamazingoffersecondstkaveh'])) {
                $q_pce_query_args['tax_query'] = array(
                  array(
                    'taxonomy' => 'product_cat',
                    'field' => 'tag_ID',
                    'terms' => $settings['catamazingoffersecondstkaveh'],
                  ),
                );
              }

              // The Query
              $pce_query = new \WP_Query($q_pce_query_args);


              // The Loop
              if ($pce_query->have_posts()) {
                while ($pce_query->have_posts()) {
                  $pce_query->the_post();
                  global $product;
                  $product = wc_get_product();
                  $product_id = $product->get_id();
                  $product_type = $product->get_type();
                  $sale_price_dates_from = $sale_price_dates_to = '';
                  $sale_price = $product->get_sale_price();
                  $normal_price = $product->get_regular_price();
                  $pr_id = get_the_ID();
                  $stocka = $product->get_stock_status(); ?>
                  <div class="swiper-slide">
                    <div class="amazing-offer-two-item position-relative d-flex align-items-lg-center flex-column flex-lg-row">
                      <a href="<?php the_permalink(); ?>"></a>
                      <img src="<?php the_post_thumbnail_url(); ?>" alt="product" />
                      <div class="detail">
                        <h2> <?php the_title(); ?> </h2>
                        <ul class="info">
                          <?php
                          $product_attributes = array();

                          // Display weight and dimensions before attribute list.
                          $display_dimensions = apply_filters('wc_product_enable_dimensions_display', $product->has_weight() || $product->has_dimensions());

                          if ($display_dimensions && $product->has_weight()) {
                            $product_attributes['weight'] = array(
                              'label' => __('Weight', 'woocommerce'),
                              'value' => wc_format_weight($product->get_weight()),
                            );
                          }

                          if ($display_dimensions && $product->has_dimensions()) {
                            $product_attributes['dimensions'] = array(
                              'label' => __('Dimensions', 'woocommerce'),
                              'value' => wc_format_dimensions($product->get_dimensions(false)),
                            );
                          }

                          // Add product attributes to list.
                          $attributes = array_filter($product->get_attributes(), 'wc_attributes_array_filter_visible');

                          foreach ($attributes as $attribute) {
                            $values = array();

                            if ($attribute->is_taxonomy()) {
                              $attribute_taxonomy = $attribute->get_taxonomy_object();
                              $attribute_values = wc_get_product_terms($product->get_id(), $attribute->get_name(), array('fields' => 'all'));

                              foreach ($attribute_values as $attribute_value) {
                                $value_name = esc_html($attribute_value->name);

                                if ($attribute_taxonomy->attribute_public) {
                                  $values[] = '<a href="' . esc_url(get_term_link($attribute_value->term_id, $attribute->get_name())) . '" rel="tag">' . $value_name . '</a>';
                                } else {
                                  $values[] = $value_name;
                                }
                              }
                            } else {
                              $values = $attribute->get_options();

                              foreach ($values as &$value) {
                                $value = make_clickable(esc_html($value));
                              }
                            }

                            $product_attributes['attribute_' . sanitize_title_with_dashes($attribute->get_name())] = array(
                              'label' => wc_attribute_label($attribute->get_name()),
                              'value' => apply_filters('woocommerce_attribute', wpautop(wptexturize(implode(', ', $values))), $attribute, $values),
                            );
                          }

                          ?>
                          <?php $countme = 0; ?>
                          <?php foreach ($product_attributes as $product_attribute_key => $product_attribute): ?>
                            <?php if ($countme < 4): ?>
                              <li> <?php echo $product_attribute['label']; ?> :
                                <?php echo str_replace('p>', 'span>', $product_attribute['value']); ?> </li>
                              <?php $countme += 1; ?>
                            <?php endif; ?>
                          <?php endforeach; ?>
                        </ul>
                        <div class="d-flex align-items-center">
                          <div class="offer d-flex align-items-center position-relative">
                              <?php if ("instock" == $stocka) { ?>
                                <?php if (!$product->is_type('variable')) { ?>
                                  <del class="rounded-pill"> <?php if (!empty($normal_price)) {
                                    echo number_format($normal_price, 0, '.', ',');
                                  } ?> </del>
                                <?php } else {
                                  echo $product->get_price_html();
                                }
                              }
                             ?>
                            <?php
                            if (!empty($normal_price)) {
                              if ("instock" == $stocka) {
                                if (!empty($sale_price)) { ?>
                                  <span class="rounded-pill">
                                    % <?php
                                    $percentage = round((($product->get_regular_price() - $product->get_sale_price()) / $product->get_regular_price()) * 100);
                                    echo $percentage;
                                    ?>
                                  </span>
                                <?php }
                              }
                            } ?>
                          </div>
                          <?php if (!empty($sale_price)) { ?>
                            <?php if ("instock" == $stocka) { ?>
                              <?php if (!$product->is_type('variable')) { ?>
                                <div class="price d-flex align-items-center">
                                  <?php echo number_format($sale_price, 0, '.', ','); ?>
                                  <span class="fw-light"> <?php echo get_woocommerce_currency_symbol(); ?></span>
                                </div>
                              <?php } else {
                                echo $product->get_price_html();
                              }
                              ?>
                            <?php }
                          } ?>
                        </div>
                        <?php

                        if ($date_from = get_post_meta($product_id, '_sale_price_dates_from', true)) {
                          $sale_price_dates_from = date('Y-m-d 00:00:00', $date_from);
                        }
                        if ($date_to = get_post_meta($product_id, '_sale_price_dates_to', true)) {
                          $sale_price_dates_to = date('Y-m-d 23:59:59', $date_to);
                        }
                        $deal_start_date = $sale_price_dates_from;
                        $deal_start_time = strtotime($deal_start_date);
                        $deal_end_date = $sale_price_dates_to;
                        $deal_end_time = strtotime($deal_end_date, current_time('timestamp'));
                        //$current_date = current_time( 'Y-m-d H:i:s', true );
                        $current_time = strtotime('NOW', current_time('timestamp'));
                        $time_diff = ($deal_end_time - $current_time); ?>
                        <?php if ("instock" == $stocka) { ?>
                          <?php if (!empty($deal_end_date)) { ?>
                            <ul class="timer position-absolute d-flex align-items-center" data-time="<?php echo $deal_end_date; ?>">
                              <li class="fw-light text-center">
                                <span class="second rounded-circle text-white d-block"> 00 </span>
                                ثانیه
                              </li>
                              <li class="fw-light text-center">
                                <span class="minute rounded-circle text-white d-block"> 00 </span>
                                دقیقه
                              </li>
                              <li class="fw-light text-center">
                                <span class="hour rounded-circle text-white d-block"> 00 </span>
                                ساعت
                              </li>
                              <li class="fw-light text-center">
                                <span class="day rounded-circle text-white d-block"> 00 </span>
                                روز
                              </li>
                            </ul>
                          <?php }
                        }
                        ?>
                      </div>
                    </div>
                  </div>
                <?php }
              } else {
                // There are no posts
              }

              // Reset Original Post Data
              wp_reset_postdata();



              ?>
            </div>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
          </div>
          <!-- End Products -->
        </div>
      </section>
      <style>
        <?php echo '.elementor-element-' . $clsid . ''; ?>
        .amazing-offer-two .container::after {
          background-size: cover;
          background-repeat: no-repeat;
        }
      </style>
    <?php } elseif ('two' === $settings['styleboxamazingoffersecondstkaveh']) { ?>
      <section class="amazing-offer-five mt-5 mt-lg-0">
        <div class="container position-relative">
          <div class="amazing-offer-five-wrapper">
            <!-- Start Heading -->
            <div class="section-heading d-flex align-items-sm-center justify-content-sm-between flex-column flex-sm-row">
              <div class="detail position-relative">
                <<?php echo esc_attr($settings['tagheading1amazingoffersecondstkaveh']); ?> class="section-heading-title"> <b>
                    <?php echo esc_html($settings['titleamazingoffersecondstkaveh']); ?> </b>
                  <?php echo esc_html($settings['title2amazingoffersecondstkaveh']); ?> </<?php echo esc_attr($settings['tagheading1amazingoffersecondstkaveh']); ?>>
                <<?php echo esc_attr($settings['tagheading2amazingoffersecondstkaveh']); ?> class="section-heading-sub-title">
                  <?php echo esc_html($settings['subtitleamazingoffersecondstkaveh']); ?> </<?php echo esc_attr($settings['tagheading2amazingoffersecondstkaveh']); ?>>
              </div>
              <?php if ("yes" === $settings['moreamazingoffersecondstkaveh']) { ?>
                <a href="<?php echo esc_url($settings['buttonlinkamazingoffersecondstkaveh']); ?>"
                  class="section-heading-link btn btn-outline-light">
                  <?php echo esc_html($settings['buttonamazingoffersecondstkaveh']); ?> </a>
              <?php } ?>
            </div>
            <!-- End Heading -->
            <!-- Start Products -->
            <div class="amazing-offer-five-slider position-relative">
              <div class="swiper swiper-amazing-offer-two bg-white"
                data-swiper='{"loop":true,"slidesPerView":1,"spaceBetween":0,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"autoplay":{"delay":5000,"disableOnInteraction":false,"pauseOnMouseEnter":true},"effect":"fade","fadeEffect":{"crossFade":true}}'>
                <div class="swiper-wrapper">
                  <?php

                  // WP_Query args
                  $q_pce_query_args = array(
                    'post_type' => array('product'),
                    'post_status' => array('publish'),
                    'posts_per_page' => $settings['productnumberamazingoffersecondstkaveh'],
                    'order' => 'DESC',
                    'orderby' => 'date',
                    'tax_query' => array(
                      array(
                        "taxonomy" => "product_cat",
                        "field" => "tag_ID",
                        "terms" => $settings['catamazingoffersecondstkaveh'],
                      ),
                    ),
                    'meta_query' => array(
                      array(
                        'key' => '_stock_status',
                        'value' => 'outofstock',
                        'compare' => '!=',
                      ),
                    ),
                    'post__in' => array_merge(array(0), wc_get_product_ids_on_sale())

                  );

                  // The Query
                  $pce_query = new \WP_Query($q_pce_query_args);

                  // The Loop
                  if ($pce_query->have_posts()) {
                    while ($pce_query->have_posts()) {
                      $pce_query->the_post();
                      global $product;
                      $product = wc_get_product();
                      $product_id = $product->get_id();
                      $product_type = $product->get_type();
                      $sale_price_dates_from = $sale_price_dates_to = '';
                      $sale_price = $product->get_sale_price();
                      $normal_price = $product->get_regular_price();
                      $pr_id = get_the_ID();
                      $stocka = $product->get_stock_status();
                      ?>
                      <div class="swiper-slide">
                        <div
                          class="amazing-offer-two-item position-relative d-flex align-items-lg-center flex-column flex-lg-row">
                          <a href="<?php the_permalink(); ?>"></a>
                          <img src="<?php the_post_thumbnail_url(); ?>" alt="product" />
                          <div class="detail">
                            <h2> <?php the_title(); ?> </h2>
                            <ul class="info">
                              <?php
                              $product_attributes = array();

                              // Display weight and dimensions before attribute list.
                              $display_dimensions = apply_filters('wc_product_enable_dimensions_display', $product->has_weight() || $product->has_dimensions());

                              if ($display_dimensions && $product->has_weight()) {
                                $product_attributes['weight'] = array(
                                  'label' => __('Weight', 'woocommerce'),
                                  'value' => wc_format_weight($product->get_weight()),
                                );
                              }

                              if ($display_dimensions && $product->has_dimensions()) {
                                $product_attributes['dimensions'] = array(
                                  'label' => __('Dimensions', 'woocommerce'),
                                  'value' => wc_format_dimensions($product->get_dimensions(false)),
                                );
                              }

                              // Add product attributes to list.
                              $attributes = array_filter($product->get_attributes(), 'wc_attributes_array_filter_visible');

                              foreach ($attributes as $attribute) {
                                $values = array();

                                if ($attribute->is_taxonomy()) {
                                  $attribute_taxonomy = $attribute->get_taxonomy_object();
                                  $attribute_values = wc_get_product_terms($product->get_id(), $attribute->get_name(), array('fields' => 'all'));

                                  foreach ($attribute_values as $attribute_value) {
                                    $value_name = esc_html($attribute_value->name);

                                    if ($attribute_taxonomy->attribute_public) {
                                      $values[] = '<a href="' . esc_url(get_term_link($attribute_value->term_id, $attribute->get_name())) . '" rel="tag">' . $value_name . '</a>';
                                    } else {
                                      $values[] = $value_name;
                                    }
                                  }
                                } else {
                                  $values = $attribute->get_options();

                                  foreach ($values as &$value) {
                                    $value = make_clickable(esc_html($value));
                                  }
                                }

                                $product_attributes['attribute_' . sanitize_title_with_dashes($attribute->get_name())] = array(
                                  'label' => wc_attribute_label($attribute->get_name()),
                                  'value' => apply_filters('woocommerce_attribute', wpautop(wptexturize(implode(', ', $values))), $attribute, $values),
                                );
                              }

                              ?>
                              <?php $countme = 0; ?>
                              <?php foreach ($product_attributes as $product_attribute_key => $product_attribute): ?>
                                <?php if ($countme < 4): ?>
                                  <li> <?php echo $product_attribute['label']; ?> :
                                    <?php echo str_replace('p>', 'span>', $product_attribute['value']); ?> </li>
                                  <?php $countme += 1; ?>
                                <?php endif; ?>
                              <?php endforeach; ?>
                            </ul>
                            <div class="d-flex align-items-center">
                              <div class="offer d-flex align-items-center position-relative">
                                  <?php if ("instock" == $stocka) { ?>
                                    <?php if (!$product->is_type('variable')) { ?>
                                      <del class="rounded-pill"> <?php if (!empty($normal_price)) {
                                        echo number_format($normal_price, 0, '.', ',');
                                      } ?> </del>
                                    <?php } else {
                                      echo $product->get_price_html();
                                    }
                                  }
                                 ?>
                                <?php
                                if (!empty($normal_price)) {
                                  if ("instock" == $stocka) {
                                    if (!empty($sale_price)) { ?>
                                      <span class="rounded-pill">
                                        % <?php
                                        $percentage = round((($product->get_regular_price() - $product->get_sale_price()) / $product->get_regular_price()) * 100);
                                        echo $percentage;
                                        ?>
                                      </span>
                                    <?php }
                                  }
                                } ?>
                              </div>
                              <?php if (!empty($sale_price)) { ?>
                                <?php if ("instock" == $stocka) { ?>
                                  <?php if (!$product->is_type('variable')) { ?>
                                    <div class="price d-flex align-items-center">
                                      <?php echo number_format($sale_price, 0, '.', ','); ?>
                                      <span class="fw-light"> <?php echo get_woocommerce_currency_symbol(); ?></span>
                                    </div>
                                  <?php } else {
                                    echo $product->get_price_html();
                                  }
                                  ?>
                                <?php }
                              } ?>
                            </div>
                            <?php
                            if ($date_from = get_post_meta($product_id, '_sale_price_dates_from', true)) {
                              $sale_price_dates_from = date('Y-m-d 00:00:00', $date_from);
                            }
                            if ($date_to = get_post_meta($product_id, '_sale_price_dates_to', true)) {
                              $sale_price_dates_to = date('Y-m-d 23:59:59', $date_to);
                            }
                            $deal_start_date = $sale_price_dates_from;
                            $deal_start_time = strtotime($deal_start_date);
                            $deal_end_date = $sale_price_dates_to;
                            $deal_end_time = strtotime($deal_end_date, current_time('timestamp'));
                            //$current_date = current_time( 'Y-m-d H:i:s', true );
                            $current_time = strtotime('NOW', current_time('timestamp'));
                            $time_diff = ($deal_end_time - $current_time); ?>
                            <?php if (!empty($deal_end_date)) { ?>
                              <ul class="timer position-absolute d-flex align-items-center"
                                data-time="<?php echo $deal_end_date; ?>">
                                <li class="fw-light text-center">
                                  <span class="second rounded-circle text-white d-block"> 00 </span>
                                  ثانیه
                                </li>
                                <li class="fw-light text-center">
                                  <span class="minute rounded-circle text-white d-block"> 00 </span>
                                  دقیقه
                                </li>
                                <li class="fw-light text-center">
                                  <span class="hour rounded-circle text-white d-block"> 00 </span>
                                  ساعت
                                </li>
                                <li class="fw-light text-center">
                                  <span class="day rounded-circle text-white d-block"> 00 </span>
                                  روز
                                </li>
                              </ul>
                            <?php } else {
                            } ?>

                          </div>
                        </div>
                      </div>
                    <?php }
                  } else {
                    // There are no posts
                  }

                  // Reset Original Post Data
                  wp_reset_postdata();



                  ?>
                </div>
                <div class="swiper-button-next"></div>
                <div class="swiper-button-prev"></div>
              </div>
            </div>
            <!-- End Products -->
          </div>
        </div>
      </section>
      <style>
        <?php echo '.elementor-element-' . $clsid . ''; ?>
        .amazing-offer-five .container::after {
          background-size: cover;
        }
      </style>
    <?php } elseif ('three' === $settings['styleboxamazingoffersecondstkaveh']) { ?>
      <section class="amazing-offer-eight">
        <div class="container">
          <div class="amazing-offer-eight-wrapper d-flex align-items-start position-relative flex-column flex-lg-row">
            <div class="right position-relative">
              <<?php echo esc_attr($settings['tagheading1amazingoffersecondstkaveh']); ?> class="title">
                <?php echo esc_html($settings['titleamazingoffersecondstkaveh']); ?>
                <span class="d-block fw-light"><?php echo esc_html($settings['title2amazingoffersecondstkaveh']); ?></span>
              </<?php echo esc_attr($settings['tagheading1amazingoffersecondstkaveh']); ?>>
              <?php if ("yes" === $settings['moreamazingoffersecondstkaveh']) { ?>
                <a href="<?php echo esc_url($settings['buttonlinkamazingoffersecondstkaveh']); ?>"
                  class="section-heading-link btn btn-outline-dark"><?php echo esc_html($settings['buttonamazingoffersecondstkaveh']); ?></a>
              <?php } ?>
            </div>
            <div class="left position-relative">
              <div class="swiper swiper-amazing-offer-two"
                data-swiper='{"loop":true,"slidesPerView":1,"spaceBetween":0,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"autoplay":{"delay":5000,"disableOnInteraction":false,"pauseOnMouseEnter":true},"effect":"fade","fadeEffect":{"crossFade":true}}'>
                <div class="swiper-wrapper">
                  <?php

                  // WP_Query args
                  $q_pce_query_args = array(
                    'post_type' => array('product'),
                    'post_status' => array('publish'),
                    'posts_per_page' => $settings['productnumberamazingoffersecondstkaveh'],
                    'order' => 'DESC',
                    'orderby' => 'date',
                    'tax_query' => array(
                      array(
                        "taxonomy" => "product_cat",
                        "field" => "tag_ID",
                        "terms" => $settings['catamazingoffersecondstkaveh'],
                      ),
                    ),
                    'meta_query' => array(
                      array(
                        'key' => '_stock_status',
                        'value' => 'outofstock',
                        'compare' => '!=',
                      ),
                    ),
                    'post__in' => array_merge(array(0), wc_get_product_ids_on_sale())

                  );

                  // The Query
                  $pce_query = new \WP_Query($q_pce_query_args);

                  // The Loop
                  if ($pce_query->have_posts()) {
                    while ($pce_query->have_posts()) {
                      $pce_query->the_post();
                      global $product;
                      $product = wc_get_product();
                      $product_id = $product->get_id();
                      $product_type = $product->get_type();
                      $sale_price_dates_from = $sale_price_dates_to = '';
                      $sale_price = $product->get_sale_price();
                      $normal_price = $product->get_regular_price();
                      $pr_id = get_the_ID();
                      $stocka = $product->get_stock_status(); ?>
                      <!-- Start Product -->
                      <div class="swiper-slide">
                        <div class="amazing-offer-eight-item d-flex position-relative flex-column flex-md-row">
                          <?php
                          if ($date_from = get_post_meta($product_id, '_sale_price_dates_from', true)) {
                            $sale_price_dates_from = date('Y-m-d 00:00:00', $date_from);
                          }
                          if ($date_to = get_post_meta($product_id, '_sale_price_dates_to', true)) {
                            $sale_price_dates_to = date('Y-m-d 23:59:59', $date_to);
                          }
                          $deal_start_date = $sale_price_dates_from;
                          $deal_start_time = strtotime($deal_start_date);
                          $deal_end_date = $sale_price_dates_to;
                          $deal_end_time = strtotime($deal_end_date, current_time('timestamp'));
                          //$current_date = current_time( 'Y-m-d H:i:s', true );
                          $current_time = strtotime('NOW', current_time('timestamp'));
                          $time_diff = ($deal_end_time - $current_time); ?>
                          <?php if (!empty($deal_end_date)) { ?>
                            <ul class="timear d-flex d-lg-block align-items-center" data-time="<?php echo $deal_end_date; ?>">
                              <li>
                                <span class="day"> 00 </span>
                                روز
                              </li>
                              <li>
                                <span class="hour"> 00 </span>
                                ساعت
                              </li>
                              <li>
                                <span class="minute"> 00 </span>
                                دقیقه
                              </li>
                              <li>
                                <span class="second"> 00 </span>
                                ثانیه
                              </li>
                            </ul>
                          <?php } else {
                          } ?>
                          <a href="<?php the_permalink(); ?>" class="stretched-link"></a>
                          <div class="image position-relative mb-4 mb-md-0">
                            <img src="<?php the_post_thumbnail_url(); ?>" alt="product" />
                            <img src="<?php the_post_thumbnail_url(); ?>" alt="product" class="position-absolute top-0 start-0" />
                          </div>
                          <div class="detail">
                            <h2 class="overflow-hidden">
                              <span class="d-block"><?php the_title(); ?></span>
                            </h2>
                            <ul>
                              <?php
                              $product_attributes = array();

                              // Display weight and dimensions before attribute list.
                              $display_dimensions = apply_filters('wc_product_enable_dimensions_display', $product->has_weight() || $product->has_dimensions());

                              if ($display_dimensions && $product->has_weight()) {
                                $product_attributes['weight'] = array(
                                  'label' => __('Weight', 'woocommerce'),
                                  'value' => wc_format_weight($product->get_weight()),
                                );
                              }

                              if ($display_dimensions && $product->has_dimensions()) {
                                $product_attributes['dimensions'] = array(
                                  'label' => __('Dimensions', 'woocommerce'),
                                  'value' => wc_format_dimensions($product->get_dimensions(false)),
                                );
                              }

                              // Add product attributes to list.
                              $attributes = array_filter($product->get_attributes(), 'wc_attributes_array_filter_visible');

                              foreach ($attributes as $attribute) {
                                $values = array();

                                if ($attribute->is_taxonomy()) {
                                  $attribute_taxonomy = $attribute->get_taxonomy_object();
                                  $attribute_values = wc_get_product_terms($product->get_id(), $attribute->get_name(), array('fields' => 'all'));

                                  foreach ($attribute_values as $attribute_value) {
                                    $value_name = esc_html($attribute_value->name);

                                    if ($attribute_taxonomy->attribute_public) {
                                      $values[] = '<a href="' . esc_url(get_term_link($attribute_value->term_id, $attribute->get_name())) . '" rel="tag">' . $value_name . '</a>';
                                    } else {
                                      $values[] = $value_name;
                                    }
                                  }
                                } else {
                                  $values = $attribute->get_options();

                                  foreach ($values as &$value) {
                                    $value = make_clickable(esc_html($value));
                                  }
                                }

                                $product_attributes['attribute_' . sanitize_title_with_dashes($attribute->get_name())] = array(
                                  'label' => wc_attribute_label($attribute->get_name()),
                                  'value' => apply_filters('woocommerce_attribute', wpautop(wptexturize(implode(', ', $values))), $attribute, $values),
                                );
                              }

                              ?>
                              <?php $countme = 0; ?>
                              <?php foreach ($product_attributes as $product_attribute_key => $product_attribute): ?>
                                <?php if ($countme < 4): ?>
                                  <li> <?php echo $product_attribute['label']; ?> :
                                    <?php echo str_replace('p>', 'span>', $product_attribute['value']); ?> </li>
                                  <?php $countme += 1; ?>
                                <?php endif; ?>
                              <?php endforeach; ?>
                            </ul>
                            <div class="price d-flex align-items-center">
                              <div class="offer d-flex align-items-center">
                                  <?php if ("instock" == $stocka) { ?>
                                    <?php if (!$product->is_type('variable')) { ?>
                                      <del class="rounded-pill"> <?php if (!empty($normal_price)) {
                                        echo number_format($normal_price, 0, '.', ',');
                                      } ?> </del>
                                    <?php } else {
                                      echo $product->get_price_html();
                                    }
                                  }
                                  if ("instock" == $stocka) {
                                    if (!empty($sale_price)) { ?>
                                      <span class="rounded-pill">
                                        % <?php
                                        $percentage = round((($product->get_regular_price() - $product->get_sale_price()) / $product->get_regular_price()) * 100);
                                        echo $percentage;
                                        ?>
                                      </span>
                                    <?php }
                                  }
                                ?>
                              </div>
                              <?php if (!empty($sale_price)) { ?>
                                <?php if ("instock" == $stocka) { ?>
                                  <?php if (!$product->is_type('variable')) { ?>
                                    <div class="price d-flex align-items-center">
                                      <span><?php echo number_format($sale_price, 0, '.', ','); ?></span>
                                      <?php echo get_woocommerce_currency_symbol(); ?>
                                    </div>
                                  <?php } else {
                                    echo $product->get_price_html();
                                  }
                                  ?>
                                <?php }
                              } ?>
                            </div>
                            <div class="btns">
                              <a type="submit" name="add-to-cart" value="<?php echo $pr_id ?>"
                                class="btn btn-warning-2 rounded-pill single_add_to_cart_button">
                                +&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;خرید </a>
                            </div>
                          </div>
                        </div>
                      </div>
                      <!-- End Product -->
                    <?php }
                  } else {
                    // There are no posts
                  }

                  // Reset Original Post Data
                  wp_reset_postdata();



                  ?>

                </div>
                <div class="swiper-button-next"></div>
                <div class="swiper-button-prev"></div>
              </div>
            </div>
          </div>
        </div>
      </section>
      <style>
        <?php if ("yes" !== $settings['showcircleamazingoffersecondstkaveh']) { ?>
          <?php echo '.elementor-element-' . $clsid . ''; ?>
          .amazing-offer-eight-wrapper .left .swiper::before {
            background: unset !important;
          }

        <?php } ?>
        <?php echo '.elementor-element-' . $clsid . ''; ?>
        .amazing-offer-eight-wrapper .left::after {
          content: "";
          right: unset;
          z-index: -2;
          background-size: cover;
        }

        @media only screen and (max-width: 1400px) {

          <?php echo '.elementor-element-' . $clsid . ''; ?>
          .amazing-offer-eight-wrapper .left::after {
            background: unset !important;
          }
        }

        @media only screen and (max-width: 1400px) {

          <?php echo '.elementor-element-' . $clsid . ''; ?>
          .amazing-offer-eight-wrapper .left .swiper::before {
            background: unset !important;
          }
        }

        <?php echo '.elementor-element-' . $clsid . ''; ?>
        .amazing-offer-eight-wrapper::before {
          content: "";
          top: 0;
          left: 0;
          width: 100%;
          height: 67%;
          background-image: -webkit-linear-gradient(top, <?php echo esc_html($settings['bgcolorg1amazingoffersecondstkaveh']); ?>,
              <?php echo esc_html($settings['bgcolorg2amazingoffersecondstkaveh']); ?>
            );
          background-image: -moz-linear-gradient(top,
              <?php echo esc_html($settings['bgcolorg1amazingoffersecondstkaveh']); ?>
              ,
              <?php echo esc_html($settings['bgcolorg2amazingoffersecondstkaveh']); ?>
            );
          background-image: -o-linear-gradient(top,
              <?php echo esc_html($settings['bgcolorg1amazingoffersecondstkaveh']); ?>
              ,
              <?php echo esc_html($settings['bgcolorg2amazingoffersecondstkaveh']); ?>
            );
          background-image: linear-gradient(to bottom, <?php echo esc_html($settings['bgcolorg1amazingoffersecondstkaveh']); ?>,
              <?php echo esc_html($settings['bgcolorg2amazingoffersecondstkaveh']); ?>
            );
        }

        .amazing-offer-eight-wrapper::before {
          background-repeat: no-repeat;
          background-size: cover;
        }

        .amazing-offer-eight-wrapper .left .swiper::after {
          background-repeat: no-repeat;
          background-size: cover;
        }
      </style>
    <?php } ?>
    <?php do_action('kelementor_inline_scripts'); ?>
  <?php
  }


}
