<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Amazingoffernineststkaveh extends Widget_Base{

  public function get_name(){
    return 'amazingoffernineststkaveh';
  }

  public function get_title(){
    return esc_html__( 'پیشنهاد شگفت انگیز طرح نهم', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  } 

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentamazingoffernineststkaveh',
        [
          'label' => esc_html__( 'عناوین', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'btitleamazingoffernineststkaveh',
        [
            'label' => esc_html__( 'پیش عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'Amazing offer', 'kaveh-core' ),
    
        ]
    );
      $this->add_control(
          'titleamazingoffernineststkaveh',
          [
              'label' => esc_html__( 'عنوان', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'پیشنهاد', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'title2amazingoffernineststkaveh',
        [
            'label' => esc_html__( 'عنوان دوم', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'شگفت انگیز', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'tagheading1amazingoffernineststkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H3',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
  $this->end_controls_section();
  $this->start_controls_section(
    'content2amazingoffernineststkaveh',
    [
      'label' => esc_html__( 'تنظیمات نمایش', 'kaveh-core' ),
              'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
  );
  $optionsst2 = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);

$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $optionsst2[$category->term_id] = $category->name;
}
$this->add_control(
    'catamazingoffernineststkaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $optionsst2,
    ]
);
$this->add_control(
  'productnumberamazingoffernineststkaveh',
  [
    'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 20,
    'step' => 1,
    'default' => 5,
  ]
);
       $this->end_controls_section();
       $this->start_controls_section(
        'content3amazingoffernineststkaveh',
        [
          'label' => esc_html__( 'تصاویر', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'rightbalamazingoffernineststkaveh',
        [
          'label' => esc_html__( 'پس زمینه تصویر محصول', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-products-item .image::after, .amazing-offer-products-item .image .img::after' =>
                'background-image: url({{URL}})',
        ],
        ]
      );
      
      $this->add_control(
        'leftbalamazingoffernineststkaveh',
        [
          'label' => esc_html__( 'پس زمینه بالای باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-products-item .content .title::before' =>
                'background-image: url({{URL}})',
                '{{WRAPPER}} .amazing-offer-products-item .content .title::after' =>
                'background-image: url({{URL}})',
        ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'content4amazingoffernineststkaveh',
        [
          'label' => esc_html__( 'دکمه سبد خرید', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'carttitleamazingoffernineststkaveh',
        [
            'label' => esc_html__( 'متن دکمه اطلاعات بیشتر', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'افزودن به سبد خرید', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'iconiamazingoffernineststkaveh',
      [
        'label' => esc_html__( 'آیکون دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'icon icon-cart-3',
        ],
      ]
    ); 
      $this->end_controls_section();
       $this->start_controls_section(
        'style_amazingoffernineststkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'btextcolor2amazingoffernineststkaveh',
        [
          'label' => esc_html__( 'رنگ پیش عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-products-right .sup-title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'btitle2_amazingoffernineststkaveh',
          'label' => esc_html__( 'تایپوگرافی پیش عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-products-right .sup-title',
        ]
      );
      $this->add_control(
        'textcolor2amazingoffernineststkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-products-right .title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title2_amazingoffernineststkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-products-right .title',
        ]
      );
      
      $this->add_control(
        'textcolor3amazingoffernineststkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان دوم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-products-right .title span' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title21_amazingoffernineststkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان دوم', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-products-right .title span',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style2_amazingoffernineststkaveh',
        [
          'label' => esc_html__( 'استایل دکمه اطلاعات بیشتر', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_amazingoffernineststkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .btn-amzo9',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowamazingoffernineststkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .btn-amzo9',
        ]
      );
      $this->start_controls_tabs(
        'style_tabsamazingoffernineststkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tabamazingoffernineststkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncoloramazingoffernineststkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .btn-amzo9' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncoloramazingoffernineststkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .btn-amzo9' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiusamazingoffernineststkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .btn-amzo9' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderamazingoffernineststkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .btn-amzo9',
        ]
      );
      $this->add_control(
        'buttonbordersamazingoffernineststkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderamazingoffernineststkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .btn-amzo9' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabamazingoffernineststkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhoveramazingoffernineststkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .btn-amzo9:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhoveramazingoffernineststkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .btn-amzo9:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushoveramazingoffernineststkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .btn-amzo9:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhoveramazingoffernineststkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .btn-amzo9:hover',
        ]
      );
      $this->add_control(
        'buttonbordershoveramazingoffernineststkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhoveramazingoffernineststkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .btn-amzo9:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowamazingoffernineststkavehh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .btn-amzo9',
        ]
      );
      $this->add_control(
        'hr1amazingoffernineststkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingamazingoffernineststkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .btn-amzo9' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_amazingoffernineststkaveh',
        [
          'label' => esc_html__( 'استایل تب ها', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'tabsradiushoveramazingoffernineststkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-products-item-two::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'tabbgcolorcoloramazingoffernineststkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه تب ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-products-item-two::before' => 'background-color: {{VALUE}}',
            '{{WRAPPER}} .amazing-offer-products-item-two::after' => 'border-color: transparent transparent transparent {{VALUE}}',

          ],
        ]
      ); 
      $this->end_controls_section();
      $this->start_controls_section(
        'style4_amazingoffernineststkaveh',
        [
          'label' => esc_html__( 'استایل محصولات', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'timertextclamazingoffernineststkaveh',
        [
          'label' => esc_html__( 'رنگ عدد تایمر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-products-item .timear li span' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'timerbgclamazingoffernineststkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه تایمر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-products-item .timear li span' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'timertitleclamazingoffernineststkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته تایمر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-products-item .timear li' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      
      $this->add_control(
        'buttonradiuscartamazingoffernineststkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده باکس محصولات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-products-item .content::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} .amazing-offer-products-item .content::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

          ],
        ]
      );
      $this->add_control(
        'beforbgprobgclamazingoffernineststkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه باکس تصویر محصول', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-products-item .image::before' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'hr1cartamazingoffernineststkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingcartamazingoffernineststkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی باکس محصولات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-products-item .content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );

      $this->add_control(
        'arrowdotsclamazingoffernineststkaveh',
        [
          'label' => esc_html__( 'رنگ نقطه ها و فلش ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-products .swiper-button-prev::after' => 'color: {{VALUE}}',
            '{{WRAPPER}} .amazing-offer-products .swiper-button-next::after' => 'color: {{VALUE}}',
            '{{WRAPPER}} .amazing-offer-products .swiper-pagination-bullet-active' => 'background-color: {{VALUE}}',


          ],
        ]
      ); 
      $this->end_controls_section();
      $this->start_controls_section(
        'style5_amazingoffernineststkaveh',
        [
          'label' => esc_html__( 'استایل تصاویر', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );

      $this->add_control(
        'catimg1widthamazingoffernineststkaveh',
        [
          'label' => esc_html__( 'عرض تصویر پس زمینه تصویر محصول', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-products-item .image::after' => 'width: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .amazing-offer-products-item .image .img::after' => 'width: {{SIZE}}{{UNIT}};',

          ],
        ]
      );
      $this->add_control(
        'catimg1height2amazingoffernineststkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر پس زمینه تصویر محصول', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-products-item .image::after' => 'height: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .amazing-offer-products-item .image .img::after' => 'height: {{SIZE}}{{UNIT}};',

          ],
        ]
      );
      $this->add_control(
        'rightbgpr1amazingoffernineststkaveh',
        [
          'label' => esc_html__( 'فاصله از راست تصویر پس زمینه تصویر محصول', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => -300,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-products-item .image::after' => 'right: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .amazing-offer-products-item .image .img::after' => 'right: {{SIZE}}{{UNIT}};',          ],
        ]
      );
      $this->add_control(
        'bottombgpr2amazingoffernineststkaveh',
        [
          'label' => esc_html__( 'فاصله از پایین تصویر پس زمینه تصویر محصول', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => -300,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-products-item .image::after' => 'bottom: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .amazing-offer-products-item .image .img::after' => 'bottom: {{SIZE}}{{UNIT}};',          ],
        ]
      );
      $this->add_control(
        'hr12cartamazingoffernineststkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'catimg1width2amazingoffernineststkaveh',
        [
          'label' => esc_html__( 'عرض تصویر بالای باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-products-item .content .title::before' => 'width: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .amazing-offer-products-item .content .title::after' => 'width: {{SIZE}}{{UNIT}};',

          ],
        ]
      );
      $this->add_control(
        'catimg1height22amazingoffernineststkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر بالای باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-products-item .content .title::before' => 'height: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .amazing-offer-products-item .content .title::after' => 'height: {{SIZE}}{{UNIT}};',

          ],
        ]
      );

      $this->add_control(
        'rightbgpr12amazingoffernineststkaveh',
        [
          'label' => esc_html__( 'فاصله از راست تصویر بالای باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => -300,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-products-item .content .title::before' => 'right: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .amazing-offer-products-item .content .title::after' => 'right: {{SIZE}}{{UNIT}};',          ],
        ]
      );
      $this->add_control(
        'bottombgpr22amazingoffernineststkaveh',
        [
          'label' => esc_html__( 'فاصله از بالا تصویر بالای باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => -300,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-products-item .content .title::before' => 'top: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .amazing-offer-products-item .content .title::after' => 'top: {{SIZE}}{{UNIT}};',          ],
        ]
      );
      $this->end_controls_section();

        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
<section class="amazing-offer-products" style="margin: 100px 0 100px;">
<div class="container d-flex flex-column flex-lg-row">
  <!-- Start Title -->
  <div class="amazing-offer-products-right w-100">
    <div class="sup-title"> <?php echo  esc_html($settings['btitleamazingoffernineststkaveh']); ?> </div>
    <<?php echo  esc_attr($settings['tagheading1amazingoffernineststkaveh']); ?> class="title mb-0">
    <?php echo  esc_html($settings['titleamazingoffernineststkaveh']); ?>
      <span class="d-block"><?php echo  esc_html($settings['title2amazingoffernineststkaveh']); ?></span>
    </<?php echo  esc_attr($settings['tagheading1amazingoffernineststkaveh']); ?>>
  </div>
  <!-- End Title -->
  <!-- Start Products -->
  <div class="amazing-offer-products-left w-100 position-relative">
    <!-- Start Carousel Products -->
    <div class="swiper swiper-amazing-offer-products">
      <div class="swiper-wrapper">
      <?php 
                  
                 // WP_Query args
                  $q_pce_query_args = array(
                    'post_type' => array('product'),
'post_status' => array('publish'),
                    'posts_per_page' => $settings['productnumberamazingoffernineststkaveh'],
                    'order' => 'DESC',
                    'orderby' => 'date',
                    'meta_query' => array(
                        array(
                            'key' => '_stock_status',
                            'value' => 'outofstock',
                            'compare' => '!=',
                        ),
                    ),
                    'post__in' => array_merge(array(0), wc_get_product_ids_on_sale())
                  );

                  // Check if the category variable is empty
                  if (!empty($settings['catamazingoffernineststkaveh'])) {
                    $q_pce_query_args['tax_query'] = array(
                        array(
                            'taxonomy' => 'product_cat',
                            'field' => 'tag_ID',
                            'terms' => $settings['catamazingoffernineststkaveh'],
                        ),
                    );
                  }

                  // The Query
                  $pce_query = new \WP_Query($q_pce_query_args);

                  
                  // The Loop
                  if ( $pce_query->have_posts() ) {
                    while ( $pce_query->have_posts() ) {
                      $pce_query->the_post(); ?>
        <!-- Start Slide -->
        <div class="swiper-slide">
          <div class="amazing-offer-products-item position-relative d-flex flex-column flex-md-row">
              <?php
              global $product;
              $product = wc_get_product();
              $product_id = $product->get_id();
              $product_type = $product->get_type();
              $sale_price_dates_from = $sale_price_dates_to = '';
              $sale_price= $product->get_sale_price();
              $normal_price= $product->get_regular_price();
              $pr_id = get_the_ID();
              $stocka=$product->get_stock_status();

              if ($date_from = get_post_meta($product_id, '_sale_price_dates_from', true)){
                  $sale_price_dates_from = date('Y-m-d 00:00:00', $date_from);
              }
              if ($date_to = get_post_meta($product_id, '_sale_price_dates_to', true)){
                  $sale_price_dates_to = date('Y-m-d 23:59:59', $date_to);
              }
              $deal_start_date = $sale_price_dates_from;
              $deal_start_time = strtotime($deal_start_date);
              $deal_end_date = $sale_price_dates_to;
              $deal_end_time = strtotime($deal_end_date, current_time('timestamp'));
              //$current_date = current_time( 'Y-m-d H:i:s', true );
              $current_time = strtotime('NOW', current_time('timestamp'));
              $time_diff = ($deal_end_time - $current_time); ?>
            <?php if (!empty($deal_end_date)){ ?>
            <ul class="timear position-absolute strat-0" data-time="<?php  echo $deal_end_date; ?>">
            <li class="text-center">
                <span
                  class="day d-flex align-items-center justify-content-center rounded-circle fw-bold">
                  00 </span>
                روز
              </li>
              <li class="text-center">
                <span
                  class="hour d-flex align-items-center justify-content-center rounded-circle fw-bold">
                  00 </span>
                ساعت
              </li>
              <li class="text-center">
                <span
                  class="minute d-flex align-items-center justify-content-center rounded-circle fw-bold">
                  00 </span>
                دقیقه
              </li>
              <li class="text-center">
                <span
                  class="second d-flex align-items-center justify-content-center rounded-circle fw-bold">
                  00 </span>
                ثانیه
              </li>
            </ul>
            <?php }else{} ?>
            <a href="<?php the_permalink(); ?>" class="stretched-link" aria-label="product"></a>
            <div class="image position-relative">
              <div class="img">
                <img src="<?php the_post_thumbnail_url(); ?>" alt="product" width="159" height="277"
                  class="d-block mx-auto">
              </div>
            </div>
            <div class="content position-relative w-100">
              <h2 class="title mb-0"> <?php the_title(); ?></h2>
              <ul>
              <?php
                    $product_attributes = array();

                  // Display weight and dimensions before attribute list.
                  $display_dimensions = apply_filters( 'wc_product_enable_dimensions_display', $product->has_weight() || $product->has_dimensions() );

                  if ( $display_dimensions && $product->has_weight() ) {
                    $product_attributes['weight'] = array(
                      'label' => __( 'Weight', 'woocommerce' ),
                      'value' => wc_format_weight( $product->get_weight() ),
                    );
                  }

                  if ( $display_dimensions && $product->has_dimensions() ) {
                    $product_attributes['dimensions'] = array(
                      'label' => __( 'Dimensions', 'woocommerce' ),
                      'value' => wc_format_dimensions( $product->get_dimensions( false ) ),
                    );
                  }

                  // Add product attributes to list.
                  $attributes = array_filter( $product->get_attributes(), 'wc_attributes_array_filter_visible' );

                  foreach ( $attributes as $attribute ) {
                    $values = array();

                    if ( $attribute->is_taxonomy() ) {
                      $attribute_taxonomy = $attribute->get_taxonomy_object();
                      $attribute_values   = wc_get_product_terms( $product->get_id(), $attribute->get_name(), array( 'fields' => 'all' ) );

                      foreach ( $attribute_values as $attribute_value ) {
                        $value_name = esc_html( $attribute_value->name );

                        if ( $attribute_taxonomy->attribute_public ) {
                          $values[] = '<a href="' . esc_url( get_term_link( $attribute_value->term_id, $attribute->get_name() ) ) . '" rel="tag">' . $value_name . '</a>';
                        } else {
                          $values[] = $value_name;
                        }
                      }
                    } else {
                      $values = $attribute->get_options();

                      foreach ( $values as &$value ) {
                        $value = make_clickable( esc_html( $value ) );
                      }
                    }

                    $product_attributes[ 'attribute_' . sanitize_title_with_dashes( $attribute->get_name() ) ] = array(
                      'label' => wc_attribute_label( $attribute->get_name() ),
                      'value' => apply_filters( 'woocommerce_attribute', wpautop( wptexturize( implode( ', ', $values ) ) ), $attribute, $values ),
                    );
                  }

                  ?>
                <?php $countme=0; ?>	
                <?php foreach ( $product_attributes as $product_attribute_key => $product_attribute ) : ?>
                <?php if($countme < 2): ?>	
                <li> <?php echo $product_attribute['label']; ?> : <?php echo str_replace( 'p>' , 'span>' , $product_attribute['value'] ); ?> </li>
                <?php $countme += 1; ?>
                <?php endif; ?>
                <?php endforeach; ?>
              </ul>
              <div class="d-flex align-items-sm-center flex-column flex-sm-row gap-4 gap-sm-0">
                <div class="price">
                    <?php if ( !$product->is_type( 'variable' ) ) { ?>
                  <del class="d-block"> <?php echo $normal_price; ?> </del>
                  <span class="d-inline-block me-1"><?php echo $sale_price; ?> </span>
                  <?php echo get_woocommerce_currency_symbol(); ?>
                  <?php }else{ 
                      $price_v = $product->get_price_html(); 
                      echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v);
                    } 
                     ?>
                </div>
                <a href="<?php the_permalink(); ?>" class="btn btn-outline-light-2 d-flex align-items-center position-relative ms-sm-4 btn-amzo9">
                  <i class="<?php echo  esc_attr($settings['iconiamazingoffernineststkaveh']['value']); ?> me-2"></i>
                  <b class="me-1"> اطلاعات </b> بیشتر
                  <i class="icon-angle-left"></i>
                </a>
              </div>
            </div>
          </div>
        </div>
        <!-- End Slide -->
        <?php // There are no posts
                  }
                    }
                  // Reset Original Post Data
                  wp_reset_postdata();    
                  ?>
      </div>
      <div class="swiper-bottom position-absolute d-flex bottom-0">
        <div class="swiper-button-prev w-auto h-auto position-relative top-0 start-0 bottom-0 end-0 m-0"></div>
        <div class="swiper-pagination w-auto h-auto position-relative top-0 start-0 bottom-0 end-0 m-0 mx-3"></div>
        <div class="swiper-button-next w-auto h-auto position-relative top-0 start-0 bottom-0 end-0 m-0"></div>
      </div>
    </div>
    <!-- End Carousel Products -->
    <!-- Start Carousel Pagination -->
    <div thumbsslider
      class="amazing-offer-products-pagination swiper swiper-amazing-offer-products-pagination position-absolute top-0 end-0 w-100">
      <div class="swiper-wrapper">
      <?php 
                  
                  // WP_Query args
                  $q_pce_query_args = array(
                    'post_type' => array('product'),
'post_status' => array('publish'),
                    'posts_per_page' => $settings['productnumberamazingoffernineststkaveh'],
                    'order' => 'DESC',
                    'orderby' => 'date',
                    'tax_query' => array(
                      array(
                        "taxonomy" => "product_cat",
                        "field"    => "tag_ID",
                        "terms"    => $settings['catamazingoffernineststkaveh'],
                      ),
                    ),
                    'meta_query' => WC()->query->get_meta_query(),
                    'post__in' => array_merge(array(0), wc_get_product_ids_on_sale())
                  
                  );
                  
                  // The Query
                  $pce_query = new \WP_Query($q_pce_query_args);
                  
                  // The Loop
                  if ( $pce_query->have_posts() ) {
                    while ( $pce_query->have_posts() ) {
                      $pce_query->the_post(); ?>
        <!-- Start Slide -->
        <div class="swiper-slide">
          <div class="amazing-offer-products-item-two d-flex align-items-center">
            <img src="<?php the_post_thumbnail_url(); ?>" alt="product" width="74" height="74">
            <div class="title"><?php the_title(); ?></div>
          </div>
        </div>
        <!-- End Slide -->
        <?php // There are no posts
                  }
                    }
                  // Reset Original Post Data
                  wp_reset_postdata();    
                  ?>
      </div>
    </div>
    <!-- End Carousel Pagination -->
  </div>
  <!-- End Products -->
</div>
</section>
<style>
  .amazing-offer-products-item .image .img img {
    width: 190px;
    height: 272px;
    object-fit: contain;
}
.amazing-offer-products-item .image::after, .amazing-offer-products-item .image .img::after {
    -webkit-background-size: contain;
    -moz-background-size: contain;
    -o-background-size: contain;
    background-size: contain;
}
.amazing-offer-products-item .content .title::before, .amazing-offer-products-item .content .title::after {
    -webkit-background-size: contain;
    -moz-background-size: contain;
    -o-background-size: contain;
    background-size: contain;
}
.amazing-offer-products-item-two::before {
    -webkit-background-size: cover !important;
    -moz-background-size: cover !important;
    -o-background-size: cover !important;
    background-size: cover !important;
}
</style>
    <?php if( \Elementor\Plugin::$instance->editor->is_edit_mode() ) : ?>
      <script>
        function init<?php echo $clsid; ?>() {
          // Swiper Amazing Offer Products
          const swiperAmazingOfferProduct = new Swiper(
            ".swiper-amazing-offer-products-pagination",
            {
              direction: direction,
              watchSlidesProgress: true,
              breakpoints: {
                320: {
                  slidesPerView: 1.5,
                  spaceBetween: 0,
                },
                400: {
                  slidesPerView: 2,
                  spaceBetween: 0,
                },
                768: {
                  slidesPerView: 3,
                  spaceBetween: 0,
                },
                992: {
                  slidesPerView: 3,
                  spaceBetween: 0,
                },
              },
              on: {
                init: (swiper) => {
                  if (window.outerWidth > 991) {
                    const height =
                      (swiper.slides[0].firstElementChild.scrollHeight + 32) * 3;

                    swiper.el.style.height = height + "px";
                  }
                },
              },
            }
          );

          new Swiper(".swiper-amazing-offer-products", {
            slidesPerView: 1,
            spaceBetween: 0,
            autoplay: {
              delay: 5000,
            },
            effect: "fade",
            fadeEffect: {
              crossFade: true,
            },
            loop: true,
            thumbs: {
              swiper: swiperAmazingOfferProduct,
            },
            navigation: {
              nextEl: ".swiper-button-next",
              prevEl: ".swiper-button-prev",
            },
            pagination: {
              el: ".swiper-pagination",
              type: "bullets",
              clickable: true,
            },
          });
          }
          if (window.Swiper) {
              // Swiper library already loaded, initialize Swiper instance
              init<?php echo $clsid; ?>();
            } else {
              // Swiper library not yet loaded, wait for it to load
              window.addEventListener("load", function() {
                init<?php echo $clsid; ?>();
              });
            }
      </script>
    <?php endif; ?>
    <?php
  }


}
