<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Amazingoffereightstkaveh extends Widget_Base{

  public function get_name(){
    return 'amazingoffereightstkaveh';
  }

  public function get_title(){
    return esc_html__( 'پیشنهاد شگفت انگیز طرح هشت', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  } 

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentamazingoffereightstkaveh',
        [
          'label' => esc_html__( 'عناوین', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );

      $this->add_control(
          'titleamazingoffereightstkaveh',
          [
              'label' => esc_html__( 'عنوان', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'پیشنهاد', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'title2amazingoffereightstkaveh',
        [
            'label' => esc_html__( 'عنوان دوم', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'شگفت انگیز', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'tagheading1amazingoffereightstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H3',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
      $this->add_control(
        'moreamazingoffereightstkaveh',
        [
          'label' => esc_html__( 'نمایش دکمه بیشتر؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'buttonamazingoffereightstkaveh',
        [
            'label' => esc_html__( 'دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'مشاهده همه', 'kaveh-core' ),
            'condition' => [
              'moreamazingoffereightstkaveh' => 'yes',
            ],
    
        ]
    );
    $this->add_control(
      'buttonlinkamazingoffereightstkaveh',
      [
          'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
          'condition' => [
            'moreamazingoffereightstkaveh' => 'yes',
          ],
  
      ]
  );

  $this->end_controls_section();
  $this->start_controls_section(
    'content2amazingoffereightstkaveh',
    [
      'label' => esc_html__( 'تنظیمات نمایش', 'kaveh-core' ),
              'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
  );
  $optionsst2 = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);

$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $optionsst2[$category->term_id] = $category->name;
}
$this->add_control(
    'catamazingoffereightstkaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $optionsst2,
    ]
);
$this->add_control(
  'productnumberamazingoffereightstkaveh',
  [
    'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 20,
    'step' => 1,
    'default' => 5,
  ]
);
       $this->end_controls_section();
       $this->start_controls_section(
        'content3amazingoffereightstkaveh',
        [
          'label' => esc_html__( 'تصاویر', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'rightbalamazingoffereightstkaveh',
        [
          'label' => esc_html__( 'پس زمینه بال راست', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-wrapper .left::before' =>
                'background-image: url({{URL}})',
        ],
        ]
      );
      
      $this->add_control(
        'leftbalamazingoffereightstkaveh',
        [
          'label' => esc_html__( 'پس زمینه بال چپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-wrapper .right::before' =>
                'background-image: url({{URL}})',
        ],
        ]
      );
      
      $this->end_controls_section();
      $this->start_controls_section(
        'content4amazingoffereightstkaveh',
        [
          'label' => esc_html__( 'دکمه سبد خرید', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'carttitleamazingoffereightstkaveh',
        [
            'label' => esc_html__( 'متن دکمه سبد خرید', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'افزودن به سبد خرید', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'iconiamazingoffereightstkaveh',
      [
        'label' => esc_html__( 'آیکون دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'icon icon-cart-3',
        ],
      ]
    ); 
      $this->end_controls_section();
       $this->start_controls_section(
        'style_amazingoffereightstkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor2amazingoffereightstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-wrapper .right .title b' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title2_amazingoffereightstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-sixteen-wrapper .right .title b',
        ]
      );
      
      $this->add_control(
        'textcolor3amazingoffereightstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان دوم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-wrapper .right .title' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title21_amazingoffereightstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان دوم', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-sixteen-wrapper .right .title',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style2_amazingoffereightstkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'moreamazingoffereightstkaveh' => 'yes',
          ],
        ]
      );
      
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_amazingoffereightstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-sixteen-wrapper .right .btn',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowamazingoffereightstkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-sixteen-wrapper .right .btn',
        ]
      );
      $this->start_controls_tabs(
        'style_tabsamazingoffereightstkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tabamazingoffereightstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncoloramazingoffereightstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-wrapper .right .btn' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncoloramazingoffereightstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-wrapper .right .btn' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiusamazingoffereightstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-wrapper .right .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderamazingoffereightstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-sixteen-wrapper .right .btn',
        ]
      );
      $this->add_control(
        'buttonbordersamazingoffereightstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderamazingoffereightstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-wrapper .right .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabamazingoffereightstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhoveramazingoffereightstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-wrapper .right .btn:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhoveramazingoffereightstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-wrapper .right .btn:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushoveramazingoffereightstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-wrapper .right .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhoveramazingoffereightstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-sixteen-wrapper .right .btn:hover',
        ]
      );
      $this->add_control(
        'buttonbordershoveramazingoffereightstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhoveramazingoffereightstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-wrapper .right .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowamazingoffereightstkavehh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-sixteen-wrapper .right .btn',
        ]
      );
      $this->add_control(
        'hr1amazingoffereightstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingamazingoffereightstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-wrapper .right .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_amazingoffereightstkaveh',
        [
          'label' => esc_html__( 'استایل بال ها', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'rightballbgclamazingoffereightstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه بال راست', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-wrapper .left::before' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'leftballbgclamazingoffereightstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه بال چپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-wrapper .right::before' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->end_controls_section();
      $this->start_controls_section(
        'style4_amazingoffereightstkaveh',
        [
          'label' => esc_html__( 'استایل محصولات', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'timertextclamazingoffereightstkaveh',
        [
          'label' => esc_html__( 'رنگ عدد تایمر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-item .timear li span' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'timerbgclamazingoffereightstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه تایمر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-item .timear li span' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'timertitleclamazingoffereightstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته تایمر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-item .timear li' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'hramazingoffereightstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_cartamazingoffereightstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-sixteen-item .detail .btn',
        ]
      ); 
      $this->add_control(
        'iconsizeazingoffereightstkaveh',
        [
          'label' => esc_html__( 'سایز آیکون دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' =>13,
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-item .detail .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowcartamazingoffereightstkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-sixteen-item .detail .btn',
        ]
      );
      $this->start_controls_tabs(
        'style_tabscartamazingoffereightstkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tabcartamazingoffereightstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorcartamazingoffereightstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-item .detail .btn' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'iconclbuttoncolorcartam',
        [
          'label' => esc_html__( 'رنگ آیکون دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-item .detail .btn i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorcartamazingoffereightstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-item .detail .btn' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiuscartamazingoffereightstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه افزودن به سبد خرید بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-item .detail .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'bordercartamazingoffereightstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-sixteen-item .detail .btn',
        ]
      );
      $this->add_control(
        'buttonborderscartamazingoffereightstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'bordercartamazingoffereightstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-item .detail .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabcartamazingoffereightstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhovercartamazingoffereightstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-item .detail .btn:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'iconclhoverbuttoncolorcartamazingoffereightstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-item .detail .btn i:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhovercartamazingoffereightstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-item .detail .btn:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushovercartamazingoffereightstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه افزودن به سبد خرید بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-item .detail .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhovercartamazingoffereightstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-sixteen-item .detail .btn:hover',
        ]
      );
      $this->add_control(
        'buttonbordershovercartamazingoffereightstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhovercartamazingoffereightstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-item .detail .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowcartamazingoffereightstkaveh',
          'label' => esc_html__( 'سایه دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-sixteen-item .detail .btn',
        ]
      );
      $this->add_control(
        'hr1cartamazingoffereightstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingcartamazingoffereightstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-sixteen-item .detail .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
  }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
  <section class="amazing-offer-sixteen">
      <div class="container">
        <div class="amazing-offer-sixteen-wrapper position-relative d-flex flex-column flex-lg-row">
          <div class="right d-flex d-lg-block align-items-center justify-content-between">
            <<?php echo  esc_attr($settings['tagheading1amazingoffereightstkaveh']); ?> class="title text-nowrap mb-lg-4">
              <b class="d-block"> <?php echo  esc_html($settings['titleamazingoffereightstkaveh']); ?> </b>
              <?php echo  esc_html($settings['title2amazingoffereightstkaveh']); ?>
            </<?php echo  esc_attr($settings['tagheading1amazingoffereightstkaveh']); ?>>
            <?php if("yes"===$settings['moreamazingoffereightstkaveh']){?>
            <a href="<?php echo  esc_url($settings['buttonlinkamazingoffereightstkaveh']); ?>" class="btn btn-outline-dark rounded-pill text-nowrap"><?php echo  esc_html($settings['buttonamazingoffereightstkaveh']); ?></a>
            <?php } ?>
          </div>
          <div class="left">
            <div class="swiper swiper-amazing-offer-two" data-swiper='{"loop":true,"slidesPerView":1,"spaceBetween":0,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"autoplay":{"delay":5000,"disableOnInteraction":false,"pauseOnMouseEnter":true},"effect":"fade","fadeEffect":{"crossFade":true}}'>
              <div class="swiper-wrapper">
              <?php 
                  
                  // WP_Query args
                $q_pce_query_args = array(
                  'post_type' => array('product'),
'post_status' => array('publish'),
                  'posts_per_page' => $settings['productnumberamazingoffereightstkaveh'],
                  'order' => 'DESC',
                  'orderby' => 'date',
                  'meta_query' => array(
                      array(
                          'key' => '_stock_status',
                          'value' => 'outofstock',
                          'compare' => '!=',
                      ),
                  ),
                  'post__in' => array_merge(array(0), wc_get_product_ids_on_sale())
                );

                // Check if the category variable is empty
                if (!empty($settings['catamazingoffereightstkaveh'])) {
                  $q_pce_query_args['tax_query'] = array(
                      array(
                          'taxonomy' => 'product_cat',
                          'field' => 'tag_ID',
                          'terms' => $settings['catamazingoffereightstkaveh'],
                      ),
                  );
                }

                // The Query
                $pce_query = new \WP_Query($q_pce_query_args);

                  
                  // The Loop
                  if ( $pce_query->have_posts() ) {
                    while ( $pce_query->have_posts() ) {
                      $pce_query->the_post(); ?>
                <!-- Start Slide -->
                <div class="swiper-slide">
                  <div class="amazing-offer-sixteen-item position-relative d-flex flex-column flex-lg-row">
                    <a href="<?php the_permalink(); ?>" class="stretched-link"></a>
                    <?php
                        global $product;
                        $product = wc_get_product();
                        $product_id = $product->get_id();
                        $product_type = $product->get_type();
                        $sale_price_dates_from = $sale_price_dates_to = '';
                        $sale_price= $product->get_sale_price();
                        $normal_price= $product->get_regular_price();
                        $pr_id = get_the_ID();
                        $stocka=$product->get_stock_status();

                        if ($date_from = get_post_meta($product_id, '_sale_price_dates_from', true)){
                            $sale_price_dates_from = date('Y-m-d 00:00:00', $date_from);
                        }
                        if ($date_to = get_post_meta($product_id, '_sale_price_dates_to', true)){
                            $sale_price_dates_to = date('Y-m-d 23:59:59', $date_to);
                        }
                        $deal_start_date = $sale_price_dates_from;
                        $deal_start_time = strtotime($deal_start_date);
                        $deal_end_date = $sale_price_dates_to;
                        $deal_end_time = strtotime($deal_end_date, current_time('timestamp'));
                        //$current_date = current_time( 'Y-m-d H:i:s', true );
                        $current_time = strtotime('NOW', current_time('timestamp'));
                        $time_diff = ($deal_end_time - $current_time); ?>
                      <?php if (!empty($deal_end_date)){ ?>
                    <ul class="timear d-flex align-items-center position-absolute top-0 start-0 mb-0"
                      data-time="<?php  echo $deal_end_date; ?>">
                      <li class="fw-light text-center">
                        <span class="second rounded-circle d-flex align-items-center justify-content-center">
                          00 </span>
                        ثانیه
                      </li>
                      <li class="fw-light text-center">
                        <span class="minute rounded-circle d-flex align-items-center justify-content-center">
                          00 </span>
                        دقیقه
                      </li>
                      <li class="fw-light text-center">
                        <span class="hour rounded-circle d-flex align-items-center justify-content-center">
                          00 </span>
                        ساعت
                      </li>
                      <li class="fw-light text-center">
                        <span class="day rounded-circle d-flex align-items-center justify-content-center"> 00
                        </span>
                        روز
                      </li>
                    </ul>
                    <?php }else{} ?>
                    <div class="image position-relative">
                      <img src="<?php the_post_thumbnail_url(); ?>" alt="product" class="d-block" />
                      <img src="<?php the_post_thumbnail_url(); ?>" alt="product" class="d-block" />
                    </div>
                    <div class="detail">
                      <div class="title overflow-hidden">
                        <h2><?php the_title(); ?></h2>
                      </div>
                      <ul>
                      <?php
                    $product_attributes = array();

                  // Display weight and dimensions before attribute list.
                  $display_dimensions = apply_filters( 'wc_product_enable_dimensions_display', $product->has_weight() || $product->has_dimensions() );

                  if ( $display_dimensions && $product->has_weight() ) {
                    $product_attributes['weight'] = array(
                      'label' => __( 'Weight', 'woocommerce' ),
                      'value' => wc_format_weight( $product->get_weight() ),
                    );
                  }

                  if ( $display_dimensions && $product->has_dimensions() ) {
                    $product_attributes['dimensions'] = array(
                      'label' => __( 'Dimensions', 'woocommerce' ),
                      'value' => wc_format_dimensions( $product->get_dimensions( false ) ),
                    );
                  }

                  // Add product attributes to list.
                  $attributes = array_filter( $product->get_attributes(), 'wc_attributes_array_filter_visible' );

                  foreach ( $attributes as $attribute ) {
                    $values = array();

                    if ( $attribute->is_taxonomy() ) {
                      $attribute_taxonomy = $attribute->get_taxonomy_object();
                      $attribute_values   = wc_get_product_terms( $product->get_id(), $attribute->get_name(), array( 'fields' => 'all' ) );

                      foreach ( $attribute_values as $attribute_value ) {
                        $value_name = esc_html( $attribute_value->name );

                        if ( $attribute_taxonomy->attribute_public ) {
                          $values[] = '<a href="' . esc_url( get_term_link( $attribute_value->term_id, $attribute->get_name() ) ) . '" rel="tag">' . $value_name . '</a>';
                        } else {
                          $values[] = $value_name;
                        }
                      }
                    } else {
                      $values = $attribute->get_options();

                      foreach ( $values as &$value ) {
                        $value = make_clickable( esc_html( $value ) );
                      }
                    }

                    $product_attributes[ 'attribute_' . sanitize_title_with_dashes( $attribute->get_name() ) ] = array(
                      'label' => wc_attribute_label( $attribute->get_name() ),
                      'value' => apply_filters( 'woocommerce_attribute', wpautop( wptexturize( implode( ', ', $values ) ) ), $attribute, $values ),
                    );
                  }

                  ?>
                <?php $countme=0; ?>	
                <?php foreach ( $product_attributes as $product_attribute_key => $product_attribute ) : ?>
                <?php if($countme < 2): ?>	
                <li> <?php echo $product_attribute['label']; ?> : <?php echo str_replace( 'p>' , 'span>' , $product_attribute['value'] ); ?> </li>
                <?php $countme += 1; ?>
                <?php endif; ?>
                <?php endforeach; ?>
                      </ul>
                      <div class="offer overflow-hidden">
                      <div class="d-flex align-items-center text-white rounded-pill">
                    <?php if("instock"==$stocka){ ?>
                    <?php if ( !$product->is_type( 'variable' ) ) { ?>
                          <del class="rounded-pill"><?php echo $normal_price; ?></del>
                          <?php }
                          
                        }
    
                      if(!empty($normal_price) ) { 
                      if("instock"==$stocka){ 
                      if(!empty($sale_price) ) { ?>
                      % <?php
                      $percentage = round( ( ( $product->get_regular_price() - $product->get_sale_price() ) / $product->get_regular_price() ) * 100 );
                      echo $percentage;
                       } 
                      }
                     }?> 
                        </div>
                      </div>
                      <?php if(!empty($sale_price) ) { ?>
                    <?php if("instock"==$stocka){ ?>
                    <?php if ( !$product->is_type( 'variable' ) ) { ?>
                      <div class="price fw-light overflow-hidden">
                        <div>
                          <b><?php echo $sale_price; ?> </b>
                          <?php echo get_woocommerce_currency_symbol(); ?>
                        </div>
                      </div>
                      <?php }else{ 
                      $price_v = $product->get_price_html(); 
                      echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v);
                    } 
                     ?>
                    <?php }
                   } ?>
                      <a href="#" type="submit" name="add-to-cart" value="<?php echo $pr_id ?>" class="btn btn-danger-2 position-relative mt-4 single_add_to_cart_button">
                        <i class="<?php echo  esc_attr($settings['iconiamazingoffereightstkaveh']['value']); ?> me-1"></i>
                        <?php echo  esc_html($settings['carttitleamazingoffereightstkaveh']); ?>
                      </a>
                    </div>
                  </div>
                </div>
                <!-- End Slide -->
                <?php   }
                  } else {
                    // There are no posts
                  }

                  // Reset Original Post Data
                  wp_reset_postdata();
                  

                  
                  ?>
              </div>
              <div class="swiper-button-next"></div>
              <div class="swiper-button-prev"></div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <style>
        <?php echo '.elementor-element-' . $clsid . ''; ?> .amazing-offer-sixteen-wrapper .left::before {
        background-size: cover !important;
        object-fit:cover !important;
        }
        <?php echo '.elementor-element-' . $clsid . ''; ?> .amazing-offer-sixteen-wrapper .right::before {
        background-size: cover !important;
        object-fit:cover !important;
        }
    </style>
    <?php do_action('kelementor_inline_scripts'); ?>
    <?php
  }

}
